// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents opening a singleton class (i.e. `class << foo; ... end;`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct SClass {
    /// Expression that is used to get a singleton class
    ///
    /// `Lvar("foo")` for `class << foo; end`
    pub expr: Box<Node>,

    /// Body of the block
    pub body: Option<Box<Node>>,

    /// Location of the `class` keyword
    ///
    /// ```text
    /// class << foo; end
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `<<` operator
    ///
    /// ```text
    /// class << foo; end
    ///       ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// class << foo; end
    ///               ~~~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// class << foo; end
    /// ~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl SClass {
    #[doc(hidden)]
    pub fn get_expr(&self) -> &Box<Node> {
        &self.expr
    }

    #[doc(hidden)]
    pub fn get_expr_mut(&mut self) -> &mut Box<Node> {
        &mut self.expr
    }

    #[doc(hidden)]
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    #[doc(hidden)]
    pub fn get_body_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.body
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Loc {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_expr(&mut self, value: Box<Node>) {
        self.expr = value;
    }

    #[doc(hidden)]
    pub fn set_body(&mut self, value: Option<Box<Node>>) {
        self.body = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Loc) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalSClass {
        let Self { expr, body, keyword_l, operator_l, end_l, expression_l } = self;
        super::InternalSClass { expr, body, keyword_l, operator_l, end_l, expression_l }
    }
}

impl InnerNode for SClass {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.expr);
        result.push_maybe_node_or_nil(&self.body);
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "sclass"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expr.inner_ref().print_with_locs();
        self.body.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.keyword_l.print("keyword");
        self.operator_l.print("operator");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
