// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

use super::internal::InternalRetry;
use crate::blobs::{HasBlob, Blob};

/// Represents `retry` keyword
#[repr(C)]
pub struct Retry {
    pub(crate) blob: Blob<Retry>
}

impl std::fmt::Debug for Retry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Retry")
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Retry {
    fn eq(&self, other: &Self) -> bool {
        self.get_expression_l() == other.get_expression_l()
    }
}

impl Retry {
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__retry__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__retry__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalRetry {
        let internal = unsafe { lib_ruby_parser__external__nodes__retry__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__retry__get_expression_l(blob: *const Blob<Retry>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__retry__set_expression_l(blob: *mut Blob<Retry>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__retry__into_internal(blob: Blob<Retry>) -> InternalRetry;
    fn lib_ruby_parser__external__nodes__retry__drop(blob: *mut Blob<Retry>);
}

impl InnerNode for Retry {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "retry"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}

impl Drop for Retry {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__retry__drop(&mut self.blob) }
    }
}
