// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybePtr as MaybePtr;
use crate::containers::ExternalList as List;
use crate::containers::ExternalMaybeLoc as MaybeLoc;

use super::internal::InternalRescue;
use crate::blobs::{HasBlob, Blob};

/// Represents a `rescue` block
#[repr(C)]
pub struct Rescue {
    pub(crate) blob: Blob<Rescue>
}

impl std::fmt::Debug for Rescue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Rescue")
            .field("body", &self.get_body())
            .field("rescue_bodies", &self.get_rescue_bodies())
            .field("else_", &self.get_else())
            .field("else_l", &self.get_else_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Rescue {
    fn eq(&self, other: &Self) -> bool {
        self.get_body() == other.get_body()
            && self.get_rescue_bodies() == other.get_rescue_bodies()
            && self.get_else() == other.get_else()
            && self.get_else_l() == other.get_else_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Rescue {
    /// Returns `body` field
    pub fn get_body(&self) -> &MaybePtr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rescue__get_body(&self.blob) as *const MaybePtr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: MaybePtr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__rescue__set_body(&mut self.blob, body.into_blob()) }
    }

    /// Returns `rescue_bodies` field
    pub fn get_rescue_bodies(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rescue__get_rescue_bodies(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `rescue_bodies` field
    pub fn set_rescue_bodies(&mut self, rescue_bodies: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__rescue__set_rescue_bodies(&mut self.blob, rescue_bodies.into_blob()) }
    }

    /// Returns `else_` field
    pub fn get_else(&self) -> &MaybePtr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rescue__get_else(&self.blob) as *const MaybePtr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `else_` field
    pub fn set_else(&mut self, else_: MaybePtr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__rescue__set_else(&mut self.blob, else_.into_blob()) }
    }

    /// Returns `else_l` field
    pub fn get_else_l(&self) -> &MaybeLoc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rescue__get_else_l(&self.blob) as *const MaybeLoc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `else_l` field
    pub fn set_else_l(&mut self, else_l: MaybeLoc) {
        unsafe { lib_ruby_parser__external__nodes__rescue__set_else_l(&mut self.blob, else_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rescue__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__rescue__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalRescue {
        let internal = unsafe { lib_ruby_parser__external__nodes__rescue__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__rescue__get_body(blob: *const Blob<Rescue>) -> *mut Blob<MaybePtr<Node>>;
    fn lib_ruby_parser__external__nodes__rescue__set_body(blob: *mut Blob<Rescue>, blob: Blob<MaybePtr<Node>>);
    fn lib_ruby_parser__external__nodes__rescue__get_rescue_bodies(blob: *const Blob<Rescue>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__rescue__set_rescue_bodies(blob: *mut Blob<Rescue>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__rescue__get_else(blob: *const Blob<Rescue>) -> *mut Blob<MaybePtr<Node>>;
    fn lib_ruby_parser__external__nodes__rescue__set_else(blob: *mut Blob<Rescue>, blob: Blob<MaybePtr<Node>>);
    fn lib_ruby_parser__external__nodes__rescue__get_else_l(blob: *const Blob<Rescue>) -> *mut Blob<MaybeLoc>;
    fn lib_ruby_parser__external__nodes__rescue__set_else_l(blob: *mut Blob<Rescue>, blob: Blob<MaybeLoc>);
    fn lib_ruby_parser__external__nodes__rescue__get_expression_l(blob: *const Blob<Rescue>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__rescue__set_expression_l(blob: *mut Blob<Rescue>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__rescue__into_internal(blob: Blob<Rescue>) -> InternalRescue;
    fn lib_ruby_parser__external__nodes__rescue__drop(blob: *mut Blob<Rescue>);
}

impl InnerNode for Rescue {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_body());
        result.push_nodes(self.get_rescue_bodies());
        result.push_maybe_node_or_nil(self.get_else());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "rescue"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_body().as_ref().map(|node| node.inner_ref().print_with_locs());
        for node in self.get_rescue_bodies().iter() {
          node.inner_ref().print_with_locs();
        }
        self.get_else().as_ref().map(|node| node.inner_ref().print_with_locs());
        self.get_else_l().as_ref().map(|loc| loc.print("else"));
        self.get_expression_l().print("expression");
    }
}

impl Drop for Rescue {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__rescue__drop(&mut self.blob) }
    }
}
