// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::containers::ExternalMaybeStringPtr as MaybeStringPtr;

use super::internal::InternalRegOpt;
use crate::blobs::{HasBlob, Blob};

/// Represents flags of the regex literal (i.e. `mix` for `/foo/mix`)
#[repr(C)]
pub struct RegOpt {
    pub(crate) blob: Blob<RegOpt>
}

impl std::fmt::Debug for RegOpt {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("RegOpt")
            .field("options", &self.get_options())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for RegOpt {
    fn eq(&self, other: &Self) -> bool {
        self.get_options() == other.get_options()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl RegOpt {
    /// Returns `options` field
    pub fn get_options(&self) -> &MaybeStringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__reg_opt__get_options(&self.blob) as *const MaybeStringPtr)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `options` field
    pub fn set_options(&mut self, options: MaybeStringPtr) {
        unsafe { lib_ruby_parser__external__nodes__reg_opt__set_options(&mut self.blob, options.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__reg_opt__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__reg_opt__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalRegOpt {
        let internal = unsafe { lib_ruby_parser__external__nodes__reg_opt__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__reg_opt__get_options(blob: *const Blob<RegOpt>) -> *mut Blob<MaybeStringPtr>;
    fn lib_ruby_parser__external__nodes__reg_opt__set_options(blob: *mut Blob<RegOpt>, blob: Blob<MaybeStringPtr>);
    fn lib_ruby_parser__external__nodes__reg_opt__get_expression_l(blob: *const Blob<RegOpt>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__reg_opt__set_expression_l(blob: *mut Blob<RegOpt>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__reg_opt__into_internal(blob: Blob<RegOpt>) -> InternalRegOpt;
    fn lib_ruby_parser__external__nodes__reg_opt__drop(blob: *mut Blob<RegOpt>);
}

impl InnerNode for RegOpt {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_chars(self.get_options());
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "regopt"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}

impl Drop for RegOpt {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__reg_opt__drop(&mut self.blob) }
    }
}
