// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

use super::internal::InternalRedo;
use crate::blobs::{HasBlob, Blob};

/// Represents `redo` keyword
#[repr(C)]
pub struct Redo {
    pub(crate) blob: Blob<Redo>
}

impl std::fmt::Debug for Redo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Redo")
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Redo {
    fn eq(&self, other: &Self) -> bool {
        self.get_expression_l() == other.get_expression_l()
    }
}

impl Redo {
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__redo__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__redo__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalRedo {
        let internal = unsafe { lib_ruby_parser__external__nodes__redo__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__redo__get_expression_l(blob: *const Blob<Redo>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__redo__set_expression_l(blob: *mut Blob<Redo>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__redo__into_internal(blob: Blob<Redo>) -> InternalRedo;
    fn lib_ruby_parser__external__nodes__redo__drop(blob: *mut Blob<Redo>);
}

impl InnerNode for Redo {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "redo"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}

impl Drop for Redo {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__redo__drop(&mut self.blob) }
    }
}
