// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalList as List;
use crate::containers::ExternalMaybeLoc as MaybeLoc;

use super::internal::InternalProcarg0;
use crate::blobs::{HasBlob, Blob};

/// Represents a sole block argument (e.g. `|foo|`)
///
/// Block that takes a single array argument automatically expands it.
/// Adding trailing comma after block argument disables this behavior (and then the only argument is emitted as `Arg`).
#[repr(C)]
pub struct Procarg0 {
    pub(crate) blob: Blob<Procarg0>
}

impl std::fmt::Debug for Procarg0 {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Procarg0")
            .field("args", &self.get_args())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Procarg0 {
    fn eq(&self, other: &Self) -> bool {
        self.get_args() == other.get_args()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_end_l() == other.get_end_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Procarg0 {
    /// Returns `args` field
    pub fn get_args(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__procarg0__get_args(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `args` field
    pub fn set_args(&mut self, args: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__procarg0__set_args(&mut self.blob, args.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &MaybeLoc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__procarg0__get_begin_l(&self.blob) as *const MaybeLoc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: MaybeLoc) {
        unsafe { lib_ruby_parser__external__nodes__procarg0__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &MaybeLoc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__procarg0__get_end_l(&self.blob) as *const MaybeLoc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: MaybeLoc) {
        unsafe { lib_ruby_parser__external__nodes__procarg0__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__procarg0__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__procarg0__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalProcarg0 {
        let internal = unsafe { lib_ruby_parser__external__nodes__procarg0__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__procarg0__get_args(blob: *const Blob<Procarg0>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__procarg0__set_args(blob: *mut Blob<Procarg0>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__procarg0__get_begin_l(blob: *const Blob<Procarg0>) -> *mut Blob<MaybeLoc>;
    fn lib_ruby_parser__external__nodes__procarg0__set_begin_l(blob: *mut Blob<Procarg0>, blob: Blob<MaybeLoc>);
    fn lib_ruby_parser__external__nodes__procarg0__get_end_l(blob: *const Blob<Procarg0>) -> *mut Blob<MaybeLoc>;
    fn lib_ruby_parser__external__nodes__procarg0__set_end_l(blob: *mut Blob<Procarg0>, blob: Blob<MaybeLoc>);
    fn lib_ruby_parser__external__nodes__procarg0__get_expression_l(blob: *const Blob<Procarg0>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__procarg0__set_expression_l(blob: *mut Blob<Procarg0>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__procarg0__into_internal(blob: Blob<Procarg0>) -> InternalProcarg0;
    fn lib_ruby_parser__external__nodes__procarg0__drop(blob: *mut Blob<Procarg0>);
}

impl InnerNode for Procarg0 {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_args());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "procarg0"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_args().iter() {
          node.inner_ref().print_with_locs();
        }
        self.get_begin_l().as_ref().map(|loc| loc.print("begin"));
        self.get_end_l().as_ref().map(|loc| loc.print("end"));
        self.get_expression_l().print("expression");
    }
}

impl Drop for Procarg0 {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__procarg0__drop(&mut self.blob) }
    }
}
