// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalOr;
use crate::blobs::{HasBlob, Blob};

/// Represents `foo || bar` (or `foo or bar`) statement.
#[repr(C)]
pub struct Or {
    pub(crate) blob: Blob<Or>
}

impl std::fmt::Debug for Or {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Or")
            .field("lhs", &self.get_lhs())
            .field("rhs", &self.get_rhs())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Or {
    fn eq(&self, other: &Self) -> bool {
        self.get_lhs() == other.get_lhs()
            && self.get_rhs() == other.get_rhs()
            && self.get_operator_l() == other.get_operator_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Or {
    /// Returns `lhs` field
    pub fn get_lhs(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__or__get_lhs(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `lhs` field
    pub fn set_lhs(&mut self, lhs: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__or__set_lhs(&mut self.blob, lhs.into_blob()) }
    }

    /// Returns `rhs` field
    pub fn get_rhs(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__or__get_rhs(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `rhs` field
    pub fn set_rhs(&mut self, rhs: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__or__set_rhs(&mut self.blob, rhs.into_blob()) }
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__or__get_operator_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__or__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__or__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__or__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalOr {
        let internal = unsafe { lib_ruby_parser__external__nodes__or__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__or__get_lhs(blob: *const Blob<Or>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__or__set_lhs(blob: *mut Blob<Or>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__or__get_rhs(blob: *const Blob<Or>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__or__set_rhs(blob: *mut Blob<Or>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__or__get_operator_l(blob: *const Blob<Or>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__or__set_operator_l(blob: *mut Blob<Or>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__or__get_expression_l(blob: *const Blob<Or>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__or__set_expression_l(blob: *mut Blob<Or>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__or__into_internal(blob: Blob<Or>) -> InternalOr;
    fn lib_ruby_parser__external__nodes__or__drop(blob: *mut Blob<Or>);
}

impl InnerNode for Or {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_lhs());
        result.push_node(self.get_rhs());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "or"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_lhs().inner_ref().print_with_locs();
        self.get_rhs().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Or {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__or__drop(&mut self.blob) }
    }
}
