// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalNthRef;
use crate::blobs::{HasBlob, Blob};

/// Represents numeric global variable (e.g. `$1`)
#[repr(C)]
pub struct NthRef {
    pub(crate) blob: Blob<NthRef>
}

impl std::fmt::Debug for NthRef {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("NthRef")
            .field("name", &self.get_name())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for NthRef {
    fn eq(&self, other: &Self) -> bool {
        self.get_name() == other.get_name()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl NthRef {
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__nth_ref__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__nth_ref__set_name(&mut self.blob, name.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__nth_ref__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__nth_ref__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalNthRef {
        let internal = unsafe { lib_ruby_parser__external__nodes__nth_ref__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__nth_ref__get_name(blob: *const Blob<NthRef>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__nth_ref__set_name(blob: *mut Blob<NthRef>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__nth_ref__get_expression_l(blob: *const Blob<NthRef>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__nth_ref__set_expression_l(blob: *mut Blob<NthRef>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__nth_ref__into_internal(blob: Blob<NthRef>) -> InternalNthRef;
    fn lib_ruby_parser__external__nodes__nth_ref__drop(blob: *mut Blob<NthRef>);
}

impl InnerNode for NthRef {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_raw_str(self.get_name());
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "nth_ref"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}

impl Drop for NthRef {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__nth_ref__drop(&mut self.blob) }
    }
}
