// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

use super::internal::InternalNil;
use crate::blobs::{HasBlob, Blob};

/// Represents `nil` literal
#[repr(C)]
pub struct Nil {
    pub(crate) blob: Blob<Nil>
}

impl std::fmt::Debug for Nil {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Nil")
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Nil {
    fn eq(&self, other: &Self) -> bool {
        self.get_expression_l() == other.get_expression_l()
    }
}

impl Nil {
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__nil__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__nil__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalNil {
        let internal = unsafe { lib_ruby_parser__external__nodes__nil__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__nil__get_expression_l(blob: *const Blob<Nil>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__nil__set_expression_l(blob: *mut Blob<Nil>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__nil__into_internal(blob: Blob<Nil>) -> InternalNil;
    fn lib_ruby_parser__external__nodes__nil__drop(blob: *mut Blob<Nil>);
}

impl InnerNode for Nil {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "nil"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}

impl Drop for Nil {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__nil__drop(&mut self.blob) }
    }
}
