// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents module declaration using `module` keyword
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Module {
    /// Name of the module
    pub name: Box<Node>,

    /// Body of the module
    ///
    /// `None` if module has no body
    pub body: Option<Box<Node>>,

    /// Location of the `module` keyword
    ///
    /// ```text
    /// module M; end
    /// ~~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// module M; end
    ///           ~~~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// module M; end
    /// ~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Module {
    #[doc(hidden)]
    pub fn get_name(&self) -> &Box<Node> {
        &self.name
    }

    #[doc(hidden)]
    pub fn get_name_mut(&mut self) -> &mut Box<Node> {
        &mut self.name
    }

    #[doc(hidden)]
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    #[doc(hidden)]
    pub fn get_body_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.body
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Loc {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_name(&mut self, value: Box<Node>) {
        self.name = value;
    }

    #[doc(hidden)]
    pub fn set_body(&mut self, value: Option<Box<Node>>) {
        self.body = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Loc) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalModule {
        let Self { name, body, keyword_l, end_l, expression_l } = self;
        super::InternalModule { name, body, keyword_l, end_l, expression_l }
    }
}

impl InnerNode for Module {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.name);
        result.push_maybe_node_or_nil(&self.body);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "module"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.name.inner_ref().print_with_locs();
        self.body.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.keyword_l.print("keyword");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
