// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a wildcard pattern used in pattern matching (i.e. `in *foo`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchRest {
    /// Name of the variable name
    ///
    /// `None` if there's no name (i.e. `in *`)
    pub name: Option<Box<Node>>,

    /// Location of the `*` operator
    ///
    /// ```text
    /// case foo; in *bar; end
    ///              ~
    /// ```
    pub operator_l: Loc,

    /// Location of the `*` operator
    ///
    /// ```text
    /// case foo; in *bar; end
    ///              ~~~~
    /// ```
    pub expression_l: Loc,
}

impl MatchRest {
    #[doc(hidden)]
    pub fn get_name(&self) -> &Option<Box<Node>> {
        &self.name
    }

    #[doc(hidden)]
    pub fn get_name_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.name
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_name(&mut self, value: Option<Box<Node>>) {
        self.name = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalMatchRest {
        let Self { name, operator_l, expression_l } = self;
        super::InternalMatchRest { name, operator_l, expression_l }
    }
}

impl InnerNode for MatchRest {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node(&self.name);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_rest"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.name.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
