// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalMatchPattern;
use crate::blobs::{HasBlob, Blob};

/// Represents a one-line pattern matching that can throw an error (i.e. `foo => pattern`)
#[repr(C)]
pub struct MatchPattern {
    pub(crate) blob: Blob<MatchPattern>
}

impl std::fmt::Debug for MatchPattern {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("MatchPattern")
            .field("value", &self.get_value())
            .field("pattern", &self.get_pattern())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for MatchPattern {
    fn eq(&self, other: &Self) -> bool {
        self.get_value() == other.get_value()
            && self.get_pattern() == other.get_pattern()
            && self.get_operator_l() == other.get_operator_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl MatchPattern {
    /// Returns `value` field
    pub fn get_value(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_pattern__get_value(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__match_pattern__set_value(&mut self.blob, value.into_blob()) }
    }

    /// Returns `pattern` field
    pub fn get_pattern(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_pattern__get_pattern(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `pattern` field
    pub fn set_pattern(&mut self, pattern: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__match_pattern__set_pattern(&mut self.blob, pattern.into_blob()) }
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_pattern__get_operator_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__match_pattern__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_pattern__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__match_pattern__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalMatchPattern {
        let internal = unsafe { lib_ruby_parser__external__nodes__match_pattern__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__match_pattern__get_value(blob: *const Blob<MatchPattern>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__match_pattern__set_value(blob: *mut Blob<MatchPattern>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__match_pattern__get_pattern(blob: *const Blob<MatchPattern>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__match_pattern__set_pattern(blob: *mut Blob<MatchPattern>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__match_pattern__get_operator_l(blob: *const Blob<MatchPattern>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__match_pattern__set_operator_l(blob: *mut Blob<MatchPattern>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__match_pattern__get_expression_l(blob: *const Blob<MatchPattern>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__match_pattern__set_expression_l(blob: *mut Blob<MatchPattern>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__match_pattern__into_internal(blob: Blob<MatchPattern>) -> InternalMatchPattern;
    fn lib_ruby_parser__external__nodes__match_pattern__drop(blob: *mut Blob<MatchPattern>);
}

impl InnerNode for MatchPattern {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_value());
        result.push_node(self.get_pattern());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_value().inner_ref().print_with_locs();
        self.get_pattern().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}

impl Drop for MatchPattern {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__match_pattern__drop(&mut self.blob) }
    }
}
