// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents implicit matching using `if /regex/`
///
/// ```text
/// if /.*/
/// puts 'true'
/// else
/// puts 'false'
/// end
/// ```
/// Prints "false".
///
/// Under the hood this construction matches regex against `$_`, so the following works:
/// ```text
/// $_ = 'match_me'
/// if /match_me/
/// puts 'true'
/// else
/// puts 'false'
/// end
/// ```
/// this code prints "true".
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchCurrentLine {
    /// Given regex
    pub re: Box<Node>,

    /// Location of the regex
    ///
    /// ```text
    /// if /re/; end
    ///    ~~~~
    /// ```
    ///
    /// Technically this location is redundant, but keeping it is the only way to
    /// have the same interface for all nodes.
    pub expression_l: Loc,
}

impl MatchCurrentLine {
    #[doc(hidden)]
    pub fn get_re(&self) -> &Box<Node> {
        &self.re
    }

    #[doc(hidden)]
    pub fn get_re_mut(&mut self) -> &mut Box<Node> {
        &mut self.re
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_re(&mut self, value: Box<Node>) {
        self.re = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalMatchCurrentLine {
        let Self { re, expression_l } = self;
        super::InternalMatchCurrentLine { re, expression_l }
    }
}

impl InnerNode for MatchCurrentLine {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.re);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_current_line"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.re.inner_ref().print_with_locs();
        self.expression_l.print("expression");
    }
}
