// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybePtr as MaybePtr;
use crate::containers::ExternalMaybeLoc as MaybeLoc;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalLvasgn;
use crate::blobs::{HasBlob, Blob};

/// Represents local variable assignment (i.e. `foo = 42`)
#[repr(C)]
pub struct Lvasgn {
    pub(crate) blob: Blob<Lvasgn>
}

impl std::fmt::Debug for Lvasgn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Lvasgn")
            .field("name", &self.get_name())
            .field("value", &self.get_value())
            .field("name_l", &self.get_name_l())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Lvasgn {
    fn eq(&self, other: &Self) -> bool {
        self.get_name() == other.get_name()
            && self.get_value() == other.get_value()
            && self.get_name_l() == other.get_name_l()
            && self.get_operator_l() == other.get_operator_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Lvasgn {
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__lvasgn__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__lvasgn__set_name(&mut self.blob, name.into_blob()) }
    }

    /// Returns `value` field
    pub fn get_value(&self) -> &MaybePtr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__lvasgn__get_value(&self.blob) as *const MaybePtr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: MaybePtr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__lvasgn__set_value(&mut self.blob, value.into_blob()) }
    }

    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__lvasgn__get_name_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__lvasgn__set_name_l(&mut self.blob, name_l.into_blob()) }
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &MaybeLoc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__lvasgn__get_operator_l(&self.blob) as *const MaybeLoc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: MaybeLoc) {
        unsafe { lib_ruby_parser__external__nodes__lvasgn__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__lvasgn__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__lvasgn__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalLvasgn {
        let internal = unsafe { lib_ruby_parser__external__nodes__lvasgn__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__lvasgn__get_name(blob: *const Blob<Lvasgn>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__lvasgn__set_name(blob: *mut Blob<Lvasgn>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__lvasgn__get_value(blob: *const Blob<Lvasgn>) -> *mut Blob<MaybePtr<Node>>;
    fn lib_ruby_parser__external__nodes__lvasgn__set_value(blob: *mut Blob<Lvasgn>, blob: Blob<MaybePtr<Node>>);
    fn lib_ruby_parser__external__nodes__lvasgn__get_name_l(blob: *const Blob<Lvasgn>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__lvasgn__set_name_l(blob: *mut Blob<Lvasgn>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__lvasgn__get_operator_l(blob: *const Blob<Lvasgn>) -> *mut Blob<MaybeLoc>;
    fn lib_ruby_parser__external__nodes__lvasgn__set_operator_l(blob: *mut Blob<Lvasgn>, blob: Blob<MaybeLoc>);
    fn lib_ruby_parser__external__nodes__lvasgn__get_expression_l(blob: *const Blob<Lvasgn>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__lvasgn__set_expression_l(blob: *mut Blob<Lvasgn>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__lvasgn__into_internal(blob: Blob<Lvasgn>) -> InternalLvasgn;
    fn lib_ruby_parser__external__nodes__lvasgn__drop(blob: *mut Blob<Lvasgn>);
}

impl InnerNode for Lvasgn {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());
        result.push_maybe_node(self.get_value());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "lvasgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_value().as_ref().map(|node| node.inner_ref().print_with_locs());
        self.get_name_l().print("name");
        self.get_operator_l().as_ref().map(|loc| loc.print("operator"));
        self.get_expression_l().print("expression");
    }
}

impl Drop for Lvasgn {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__lvasgn__drop(&mut self.blob) }
    }
}
