// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalKwsplat;
use crate::blobs::{HasBlob, Blob};

/// Represents a keyword arguments splat (i.e. `**bar` in a call like `foo(**bar)`)
#[repr(C)]
pub struct Kwsplat {
    pub(crate) blob: Blob<Kwsplat>
}

impl std::fmt::Debug for Kwsplat {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Kwsplat")
            .field("value", &self.get_value())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Kwsplat {
    fn eq(&self, other: &Self) -> bool {
        self.get_value() == other.get_value()
            && self.get_operator_l() == other.get_operator_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Kwsplat {
    /// Returns `value` field
    pub fn get_value(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwsplat__get_value(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__kwsplat__set_value(&mut self.blob, value.into_blob()) }
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwsplat__get_operator_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__kwsplat__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwsplat__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__kwsplat__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalKwsplat {
        let internal = unsafe { lib_ruby_parser__external__nodes__kwsplat__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__kwsplat__get_value(blob: *const Blob<Kwsplat>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__kwsplat__set_value(blob: *mut Blob<Kwsplat>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__kwsplat__get_operator_l(blob: *const Blob<Kwsplat>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__kwsplat__set_operator_l(blob: *mut Blob<Kwsplat>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__kwsplat__get_expression_l(blob: *const Blob<Kwsplat>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__kwsplat__set_expression_l(blob: *mut Blob<Kwsplat>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__kwsplat__into_internal(blob: Blob<Kwsplat>) -> InternalKwsplat;
    fn lib_ruby_parser__external__nodes__kwsplat__drop(blob: *mut Blob<Kwsplat>);
}

impl InnerNode for Kwsplat {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_value());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwsplat"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_value().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Kwsplat {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__kwsplat__drop(&mut self.blob) }
    }
}
