// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a keyword rest argument (i.e. `foo` in `def m(**foo); end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Kwrestarg {
    /// Name of the keyword rest argument, `String("foo")` in `def m(**foo); end`.
    ///
    /// `None` if argument has no name (`def m(**); end`)
    pub name: Option<String>,

    /// Location of the `**` operator
    ///
    /// ```text
    /// def m(**foo); end
    ///       ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the argument name
    ///
    /// ```text
    /// def m(**foo); end
    ///         ~~~
    /// ```
    ///
    /// `None` if argument has no name (`def m(**); end`)
    pub name_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// def m(**foo); end
    ///       ~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Kwrestarg {
    #[doc(hidden)]
    pub fn get_name(&self) -> &Option<String> {
        &self.name
    }

    #[doc(hidden)]
    pub fn get_name_mut(&mut self) -> &mut Option<String> {
        &mut self.name
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_name_l(&self) -> &Option<Loc> {
        &self.name_l
    }

    #[doc(hidden)]
    pub fn get_name_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.name_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_name(&mut self, value: Option<String>) {
        self.name = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_name_l(&mut self, value: Option<Loc>) {
        self.name_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalKwrestarg {
        let Self { name, operator_l, name_l, expression_l } = self;
        super::InternalKwrestarg { name, operator_l, name_l, expression_l }
    }
}

impl InnerNode for Kwrestarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_str(&self.name);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwrestarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.operator_l.print("operator");
        self.name_l.as_ref().map(|loc| loc.print("name"));
        self.expression_l.print("expression");
    }
}
