// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

use super::internal::InternalKwnilarg;
use crate::blobs::{HasBlob, Blob};

/// Represents an special argument that rejects all keyword arguments (i.e. `def m(**nil); end`)
#[repr(C)]
pub struct Kwnilarg {
    pub(crate) blob: Blob<Kwnilarg>
}

impl std::fmt::Debug for Kwnilarg {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Kwnilarg")
            .field("name_l", &self.get_name_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Kwnilarg {
    fn eq(&self, other: &Self) -> bool {
        self.get_name_l() == other.get_name_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Kwnilarg {
    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwnilarg__get_name_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__kwnilarg__set_name_l(&mut self.blob, name_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__kwnilarg__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__kwnilarg__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalKwnilarg {
        let internal = unsafe { lib_ruby_parser__external__nodes__kwnilarg__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__kwnilarg__get_name_l(blob: *const Blob<Kwnilarg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__kwnilarg__set_name_l(blob: *mut Blob<Kwnilarg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__kwnilarg__get_expression_l(blob: *const Blob<Kwnilarg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__kwnilarg__set_expression_l(blob: *mut Blob<Kwnilarg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__kwnilarg__into_internal(blob: Blob<Kwnilarg>) -> InternalKwnilarg;
    fn lib_ruby_parser__external__nodes__kwnilarg__drop(blob: *mut Blob<Kwnilarg>);
}

impl InnerNode for Kwnilarg {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwnilarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_name_l().print("name");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Kwnilarg {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__kwnilarg__drop(&mut self.blob) }
    }
}
