// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents an integer literal (i.e. `42`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Int {
    /// String value of the literal, `String("42")` for `42`
    pub value: String,

    /// Location of unary `-` (but not `+`)
    ///
    /// ```text
    /// -42
    /// ~
    /// ```
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// -42
    /// ~~~
    /// ```
    pub expression_l: Loc,
}

impl Int {
    #[doc(hidden)]
    pub fn get_value(&self) -> &String {
        &self.value
    }

    #[doc(hidden)]
    pub fn get_value_mut(&mut self) -> &mut String {
        &mut self.value
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Option<Loc> {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_value(&mut self, value: String) {
        self.value = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Option<Loc>) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalInt {
        let Self { value, operator_l, expression_l } = self;
        super::InternalInt { value, operator_l, expression_l }
    }
}

impl InnerNode for Int {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.value);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "int"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.operator_l.as_ref().map(|loc| loc.print("operator"));
        self.expression_l.print("expression");
    }
}
