// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents assignment using indexing operation (i.e. `foo[1, 2, 3] = bar`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct IndexAsgn {
    /// Receiver of the indexing
    pub recv: Box<Node>,

    /// A list of indexes
    pub indexes: Vec<Node>,

    /// Value that is assigned
    ///
    /// `None` if assignment is a part of the multi-assignment.
    /// In such case `value` belongs to `Masgn` node.
    pub value: Option<Box<Node>>,

    /// Location of open bracket
    ///
    /// ```text
    /// foo[1, 2, 3] = bar
    ///    ~
    /// ```
    pub begin_l: Loc,

    /// Location of closing bracket
    ///
    /// ```text
    /// foo[1, 2, 3] = bar
    ///            ~
    /// ```
    pub end_l: Loc,

    /// Location of the `=` operator
    ///
    /// ```text
    /// foo[1, 2, 3] = bar
    ///              ~
    /// ```
    ///
    /// `None` if assignment is a part of the multi-assignment.
    /// In such case operator `=` belongs to `Masgn` node.
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// foo[1, 2, 3] = bar
    /// ~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl IndexAsgn {
    #[doc(hidden)]
    pub fn get_recv(&self) -> &Box<Node> {
        &self.recv
    }

    #[doc(hidden)]
    pub fn get_recv_mut(&mut self) -> &mut Box<Node> {
        &mut self.recv
    }

    #[doc(hidden)]
    pub fn get_indexes(&self) -> &Vec<Node> {
        &self.indexes
    }

    #[doc(hidden)]
    pub fn get_indexes_mut(&mut self) -> &mut Vec<Node> {
        &mut self.indexes
    }

    #[doc(hidden)]
    pub fn get_value(&self) -> &Option<Box<Node>> {
        &self.value
    }

    #[doc(hidden)]
    pub fn get_value_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.value
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Loc {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Loc {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Option<Loc> {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_recv(&mut self, value: Box<Node>) {
        self.recv = value;
    }

    #[doc(hidden)]
    pub fn set_indexes(&mut self, value: Vec<Node>) {
        self.indexes = value;
    }

    #[doc(hidden)]
    pub fn set_value(&mut self, value: Option<Box<Node>>) {
        self.value = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Loc) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Loc) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Option<Loc>) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalIndexAsgn {
        let Self { recv, indexes, value, begin_l, end_l, operator_l, expression_l } = self;
        super::InternalIndexAsgn { recv, indexes, value, begin_l, end_l, operator_l, expression_l }
    }
}

impl InnerNode for IndexAsgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.recv);
        result.push_nodes(&self.indexes);
        result.push_maybe_node(&self.value);
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "indexasgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.recv.inner_ref().print_with_locs();
        for node in self.indexes.iter() {
          node.inner_ref().print_with_locs();
        }
        self.value.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.operator_l.as_ref().map(|loc| loc.print("operator"));
        self.expression_l.print("expression");
    }
}
