// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybePtr as MaybePtr;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalInPattern;
use crate::blobs::{HasBlob, Blob};

/// Represents an `in pattern` branch of the pattern matching
#[repr(C)]
pub struct InPattern {
    pub(crate) blob: Blob<InPattern>
}

impl std::fmt::Debug for InPattern {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("InPattern")
            .field("pattern", &self.get_pattern())
            .field("guard", &self.get_guard())
            .field("body", &self.get_body())
            .field("keyword_l", &self.get_keyword_l())
            .field("begin_l", &self.get_begin_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for InPattern {
    fn eq(&self, other: &Self) -> bool {
        self.get_pattern() == other.get_pattern()
            && self.get_guard() == other.get_guard()
            && self.get_body() == other.get_body()
            && self.get_keyword_l() == other.get_keyword_l()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl InPattern {
    /// Returns `pattern` field
    pub fn get_pattern(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__in_pattern__get_pattern(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `pattern` field
    pub fn set_pattern(&mut self, pattern: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__in_pattern__set_pattern(&mut self.blob, pattern.into_blob()) }
    }

    /// Returns `guard` field
    pub fn get_guard(&self) -> &MaybePtr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__in_pattern__get_guard(&self.blob) as *const MaybePtr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `guard` field
    pub fn set_guard(&mut self, guard: MaybePtr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__in_pattern__set_guard(&mut self.blob, guard.into_blob()) }
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &MaybePtr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__in_pattern__get_body(&self.blob) as *const MaybePtr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: MaybePtr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__in_pattern__set_body(&mut self.blob, body.into_blob()) }
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__in_pattern__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__in_pattern__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__in_pattern__get_begin_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__in_pattern__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__in_pattern__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__in_pattern__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalInPattern {
        let internal = unsafe { lib_ruby_parser__external__nodes__in_pattern__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__in_pattern__get_pattern(blob: *const Blob<InPattern>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__in_pattern__set_pattern(blob: *mut Blob<InPattern>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__in_pattern__get_guard(blob: *const Blob<InPattern>) -> *mut Blob<MaybePtr<Node>>;
    fn lib_ruby_parser__external__nodes__in_pattern__set_guard(blob: *mut Blob<InPattern>, blob: Blob<MaybePtr<Node>>);
    fn lib_ruby_parser__external__nodes__in_pattern__get_body(blob: *const Blob<InPattern>) -> *mut Blob<MaybePtr<Node>>;
    fn lib_ruby_parser__external__nodes__in_pattern__set_body(blob: *mut Blob<InPattern>, blob: Blob<MaybePtr<Node>>);
    fn lib_ruby_parser__external__nodes__in_pattern__get_keyword_l(blob: *const Blob<InPattern>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__in_pattern__set_keyword_l(blob: *mut Blob<InPattern>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__in_pattern__get_begin_l(blob: *const Blob<InPattern>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__in_pattern__set_begin_l(blob: *mut Blob<InPattern>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__in_pattern__get_expression_l(blob: *const Blob<InPattern>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__in_pattern__set_expression_l(blob: *mut Blob<InPattern>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__in_pattern__into_internal(blob: Blob<InPattern>) -> InternalInPattern;
    fn lib_ruby_parser__external__nodes__in_pattern__drop(blob: *mut Blob<InPattern>);
}

impl InnerNode for InPattern {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_pattern());
        result.push_maybe_node_or_nil(self.get_guard());
        result.push_maybe_node_or_nil(self.get_body());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "in_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_pattern().inner_ref().print_with_locs();
        self.get_guard().as_ref().map(|node| node.inner_ref().print_with_locs());
        self.get_body().as_ref().map(|node| node.inner_ref().print_with_locs());
        self.get_keyword_l().print("keyword");
        self.get_begin_l().print("begin");
        self.get_expression_l().print("expression");
    }
}

impl Drop for InPattern {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__in_pattern__drop(&mut self.blob) }
    }
}
