// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalIfTernary;
use crate::blobs::{HasBlob, Blob};

/// Represents ternary `if` statement (i.e. `cond ? if_true : if_false`)
#[repr(C)]
pub struct IfTernary {
    pub(crate) blob: Blob<IfTernary>
}

impl std::fmt::Debug for IfTernary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("IfTernary")
            .field("cond", &self.get_cond())
            .field("if_true", &self.get_if_true())
            .field("if_false", &self.get_if_false())
            .field("question_l", &self.get_question_l())
            .field("colon_l", &self.get_colon_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for IfTernary {
    fn eq(&self, other: &Self) -> bool {
        self.get_cond() == other.get_cond()
            && self.get_if_true() == other.get_if_true()
            && self.get_if_false() == other.get_if_false()
            && self.get_question_l() == other.get_question_l()
            && self.get_colon_l() == other.get_colon_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl IfTernary {
    /// Returns `cond` field
    pub fn get_cond(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_ternary__get_cond(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `cond` field
    pub fn set_cond(&mut self, cond: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__if_ternary__set_cond(&mut self.blob, cond.into_blob()) }
    }

    /// Returns `if_true` field
    pub fn get_if_true(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_ternary__get_if_true(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `if_true` field
    pub fn set_if_true(&mut self, if_true: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__if_ternary__set_if_true(&mut self.blob, if_true.into_blob()) }
    }

    /// Returns `if_false` field
    pub fn get_if_false(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_ternary__get_if_false(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `if_false` field
    pub fn set_if_false(&mut self, if_false: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__if_ternary__set_if_false(&mut self.blob, if_false.into_blob()) }
    }

    /// Returns `question_l` field
    pub fn get_question_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_ternary__get_question_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `question_l` field
    pub fn set_question_l(&mut self, question_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__if_ternary__set_question_l(&mut self.blob, question_l.into_blob()) }
    }

    /// Returns `colon_l` field
    pub fn get_colon_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_ternary__get_colon_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `colon_l` field
    pub fn set_colon_l(&mut self, colon_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__if_ternary__set_colon_l(&mut self.blob, colon_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_ternary__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__if_ternary__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalIfTernary {
        let internal = unsafe { lib_ruby_parser__external__nodes__if_ternary__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__if_ternary__get_cond(blob: *const Blob<IfTernary>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__if_ternary__set_cond(blob: *mut Blob<IfTernary>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__if_ternary__get_if_true(blob: *const Blob<IfTernary>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__if_ternary__set_if_true(blob: *mut Blob<IfTernary>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__if_ternary__get_if_false(blob: *const Blob<IfTernary>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__if_ternary__set_if_false(blob: *mut Blob<IfTernary>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__if_ternary__get_question_l(blob: *const Blob<IfTernary>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__if_ternary__set_question_l(blob: *mut Blob<IfTernary>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__if_ternary__get_colon_l(blob: *const Blob<IfTernary>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__if_ternary__set_colon_l(blob: *mut Blob<IfTernary>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__if_ternary__get_expression_l(blob: *const Blob<IfTernary>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__if_ternary__set_expression_l(blob: *mut Blob<IfTernary>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__if_ternary__into_internal(blob: Blob<IfTernary>) -> InternalIfTernary;
    fn lib_ruby_parser__external__nodes__if_ternary__drop(blob: *mut Blob<IfTernary>);
}

impl InnerNode for IfTernary {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_cond());
        result.push_node(self.get_if_true());
        result.push_node(self.get_if_false());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "if"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_cond().inner_ref().print_with_locs();
        self.get_if_true().inner_ref().print_with_locs();
        self.get_if_false().inner_ref().print_with_locs();
        self.get_question_l().print("question");
        self.get_colon_l().print("colon");
        self.get_expression_l().print("expression");
    }
}

impl Drop for IfTernary {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__if_ternary__drop(&mut self.blob) }
    }
}
