// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybePtr as MaybePtr;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalIfMod;
use crate::blobs::{HasBlob, Blob};

/// Represents an `if`/`unless` modifier (i.e. `stmt if cond`)
#[repr(C)]
pub struct IfMod {
    pub(crate) blob: Blob<IfMod>
}

impl std::fmt::Debug for IfMod {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("IfMod")
            .field("cond", &self.get_cond())
            .field("if_true", &self.get_if_true())
            .field("if_false", &self.get_if_false())
            .field("keyword_l", &self.get_keyword_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for IfMod {
    fn eq(&self, other: &Self) -> bool {
        self.get_cond() == other.get_cond()
            && self.get_if_true() == other.get_if_true()
            && self.get_if_false() == other.get_if_false()
            && self.get_keyword_l() == other.get_keyword_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl IfMod {
    /// Returns `cond` field
    pub fn get_cond(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_mod__get_cond(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `cond` field
    pub fn set_cond(&mut self, cond: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__if_mod__set_cond(&mut self.blob, cond.into_blob()) }
    }

    /// Returns `if_true` field
    pub fn get_if_true(&self) -> &MaybePtr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_mod__get_if_true(&self.blob) as *const MaybePtr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `if_true` field
    pub fn set_if_true(&mut self, if_true: MaybePtr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__if_mod__set_if_true(&mut self.blob, if_true.into_blob()) }
    }

    /// Returns `if_false` field
    pub fn get_if_false(&self) -> &MaybePtr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_mod__get_if_false(&self.blob) as *const MaybePtr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `if_false` field
    pub fn set_if_false(&mut self, if_false: MaybePtr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__if_mod__set_if_false(&mut self.blob, if_false.into_blob()) }
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_mod__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__if_mod__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if_mod__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__if_mod__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalIfMod {
        let internal = unsafe { lib_ruby_parser__external__nodes__if_mod__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__if_mod__get_cond(blob: *const Blob<IfMod>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__if_mod__set_cond(blob: *mut Blob<IfMod>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__if_mod__get_if_true(blob: *const Blob<IfMod>) -> *mut Blob<MaybePtr<Node>>;
    fn lib_ruby_parser__external__nodes__if_mod__set_if_true(blob: *mut Blob<IfMod>, blob: Blob<MaybePtr<Node>>);
    fn lib_ruby_parser__external__nodes__if_mod__get_if_false(blob: *const Blob<IfMod>) -> *mut Blob<MaybePtr<Node>>;
    fn lib_ruby_parser__external__nodes__if_mod__set_if_false(blob: *mut Blob<IfMod>, blob: Blob<MaybePtr<Node>>);
    fn lib_ruby_parser__external__nodes__if_mod__get_keyword_l(blob: *const Blob<IfMod>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__if_mod__set_keyword_l(blob: *mut Blob<IfMod>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__if_mod__get_expression_l(blob: *const Blob<IfMod>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__if_mod__set_expression_l(blob: *mut Blob<IfMod>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__if_mod__into_internal(blob: Blob<IfMod>) -> InternalIfMod;
    fn lib_ruby_parser__external__nodes__if_mod__drop(blob: *mut Blob<IfMod>);
}

impl InnerNode for IfMod {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_cond());
        result.push_maybe_node_or_nil(self.get_if_true());
        result.push_maybe_node_or_nil(self.get_if_false());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "if"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_cond().inner_ref().print_with_locs();
        self.get_if_true().as_ref().map(|node| node.inner_ref().print_with_locs());
        self.get_if_false().as_ref().map(|node| node.inner_ref().print_with_locs());
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}

impl Drop for IfMod {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__if_mod__drop(&mut self.blob) }
    }
}
