// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an `if` guard used in pattern matching (i.e. `case foo; in pattern if guard; end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct IfGuard {
    /// Condition of the guard, `Lvar("foo")` in `in pattern if guard`
    pub cond: Box<Node>,

    /// Location of the `if` keyword
    ///
    /// ```text
    /// case foo; in pattern if cond; end
    ///                      ~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; in pattern if cond; end
    ///                      ~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl IfGuard {
    #[doc(hidden)]
    pub fn get_cond(&self) -> &Box<Node> {
        &self.cond
    }

    #[doc(hidden)]
    pub fn get_cond_mut(&mut self) -> &mut Box<Node> {
        &mut self.cond
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_cond(&mut self, value: Box<Node>) {
        self.cond = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalIfGuard {
        let Self { cond, keyword_l, expression_l } = self;
        super::InternalIfGuard { cond, keyword_l, expression_l }
    }
}

impl InnerNode for IfGuard {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.cond);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "if_guard"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.cond.inner_ref().print_with_locs();
        self.keyword_l.print("keyword");
        self.expression_l.print("expression");
    }
}
