// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalList as List;
use crate::containers::ExternalMaybeLoc as MaybeLoc;

use super::internal::InternalHash;
use crate::blobs::{HasBlob, Blob};

/// Represents a hash literal (i.e. `{ foo: 42 }`)
#[repr(C)]
pub struct Hash {
    pub(crate) blob: Blob<Hash>
}

impl std::fmt::Debug for Hash {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Hash")
            .field("pairs", &self.get_pairs())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Hash {
    fn eq(&self, other: &Self) -> bool {
        self.get_pairs() == other.get_pairs()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_end_l() == other.get_end_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Hash {
    /// Returns `pairs` field
    pub fn get_pairs(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__hash__get_pairs(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `pairs` field
    pub fn set_pairs(&mut self, pairs: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__hash__set_pairs(&mut self.blob, pairs.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &MaybeLoc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__hash__get_begin_l(&self.blob) as *const MaybeLoc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: MaybeLoc) {
        unsafe { lib_ruby_parser__external__nodes__hash__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &MaybeLoc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__hash__get_end_l(&self.blob) as *const MaybeLoc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: MaybeLoc) {
        unsafe { lib_ruby_parser__external__nodes__hash__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__hash__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__hash__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalHash {
        let internal = unsafe { lib_ruby_parser__external__nodes__hash__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__hash__get_pairs(blob: *const Blob<Hash>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__hash__set_pairs(blob: *mut Blob<Hash>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__hash__get_begin_l(blob: *const Blob<Hash>) -> *mut Blob<MaybeLoc>;
    fn lib_ruby_parser__external__nodes__hash__set_begin_l(blob: *mut Blob<Hash>, blob: Blob<MaybeLoc>);
    fn lib_ruby_parser__external__nodes__hash__get_end_l(blob: *const Blob<Hash>) -> *mut Blob<MaybeLoc>;
    fn lib_ruby_parser__external__nodes__hash__set_end_l(blob: *mut Blob<Hash>, blob: Blob<MaybeLoc>);
    fn lib_ruby_parser__external__nodes__hash__get_expression_l(blob: *const Blob<Hash>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__hash__set_expression_l(blob: *mut Blob<Hash>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__hash__into_internal(blob: Blob<Hash>) -> InternalHash;
    fn lib_ruby_parser__external__nodes__hash__drop(blob: *mut Blob<Hash>);
}

impl InnerNode for Hash {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_pairs());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "hash"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_pairs().iter() {
          node.inner_ref().print_with_locs();
        }
        self.get_begin_l().as_ref().map(|loc| loc.print("begin"));
        self.get_end_l().as_ref().map(|loc| loc.print("end"));
        self.get_expression_l().print("expression");
    }
}

impl Drop for Hash {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__hash__drop(&mut self.blob) }
    }
}
