// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a find pattern using in pattern matching (i.e. `in [*x, 1 => a, *y]`)
///
/// It's different from `ArrayPattern`/`ConstPattern` because it supports multiple wildcard pattern
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct FindPattern {
    /// Inner part of the find pattern
    pub elements: Vec<Node>,

    /// Location of the begin
    ///
    /// ```text
    /// case foo; in [*x, 1 => a, *y]; end
    ///              ~
    /// ```
    ///
    /// `None` if there are no brackets/parentheses
    pub begin_l: Option<Loc>,

    /// Location of the end
    ///
    /// ```text
    /// case foo; in [*x, 1 => a, *y]; end
    ///                             ~
    /// ```
    ///
    /// `None` if there are no brackets/parentheses
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; in [*x, 1 => a, *y]; end
    ///              ~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl FindPattern {
    #[doc(hidden)]
    pub fn get_elements(&self) -> &Vec<Node> {
        &self.elements
    }

    #[doc(hidden)]
    pub fn get_elements_mut(&mut self) -> &mut Vec<Node> {
        &mut self.elements
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_elements(&mut self, value: Vec<Node>) {
        self.elements = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Option<Loc>) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Option<Loc>) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalFindPattern {
        let Self { elements, begin_l, end_l, expression_l } = self;
        super::InternalFindPattern { elements, begin_l, end_l, expression_l }
    }
}

impl InnerNode for FindPattern {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.elements);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "find_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.elements.iter() {
          node.inner_ref().print_with_locs();
        }
        self.begin_l.as_ref().map(|loc| loc.print("begin"));
        self.end_l.as_ref().map(|loc| loc.print("end"));
        self.expression_l.print("expression");
    }
}
