// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybePtr as MaybePtr;

use super::internal::InternalEnsure;
use crate::blobs::{HasBlob, Blob};

/// Represents a block of code with `ensure` (i.e. `begin; ensure; end`)
#[repr(C)]
pub struct Ensure {
    pub(crate) blob: Blob<Ensure>
}

impl std::fmt::Debug for Ensure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Ensure")
            .field("body", &self.get_body())
            .field("ensure", &self.get_ensure())
            .field("keyword_l", &self.get_keyword_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Ensure {
    fn eq(&self, other: &Self) -> bool {
        self.get_body() == other.get_body()
            && self.get_ensure() == other.get_ensure()
            && self.get_keyword_l() == other.get_keyword_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Ensure {
    /// Returns `body` field
    pub fn get_body(&self) -> &MaybePtr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__ensure__get_body(&self.blob) as *const MaybePtr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: MaybePtr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__ensure__set_body(&mut self.blob, body.into_blob()) }
    }

    /// Returns `ensure` field
    pub fn get_ensure(&self) -> &MaybePtr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__ensure__get_ensure(&self.blob) as *const MaybePtr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `ensure` field
    pub fn set_ensure(&mut self, ensure: MaybePtr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__ensure__set_ensure(&mut self.blob, ensure.into_blob()) }
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__ensure__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__ensure__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__ensure__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__ensure__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalEnsure {
        let internal = unsafe { lib_ruby_parser__external__nodes__ensure__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__ensure__get_body(blob: *const Blob<Ensure>) -> *mut Blob<MaybePtr<Node>>;
    fn lib_ruby_parser__external__nodes__ensure__set_body(blob: *mut Blob<Ensure>, blob: Blob<MaybePtr<Node>>);
    fn lib_ruby_parser__external__nodes__ensure__get_ensure(blob: *const Blob<Ensure>) -> *mut Blob<MaybePtr<Node>>;
    fn lib_ruby_parser__external__nodes__ensure__set_ensure(blob: *mut Blob<Ensure>, blob: Blob<MaybePtr<Node>>);
    fn lib_ruby_parser__external__nodes__ensure__get_keyword_l(blob: *const Blob<Ensure>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__ensure__set_keyword_l(blob: *mut Blob<Ensure>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__ensure__get_expression_l(blob: *const Blob<Ensure>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__ensure__set_expression_l(blob: *mut Blob<Ensure>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__ensure__into_internal(blob: Blob<Ensure>) -> InternalEnsure;
    fn lib_ruby_parser__external__nodes__ensure__drop(blob: *mut Blob<Ensure>);
}

impl InnerNode for Ensure {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_body());
        result.push_maybe_node_or_nil(self.get_ensure());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "ensure"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_body().as_ref().map(|node| node.inner_ref().print_with_locs());
        self.get_ensure().as_ref().map(|node| node.inner_ref().print_with_locs());
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Ensure {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__ensure__drop(&mut self.blob) }
    }
}
