// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents method definition using `def` keyword (not on a singleton, see `Defs` node).
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Def {
    /// Name of the method, `String("foo")` for `def foo; end`
    pub name: String,

    /// Arguments of a method, `None` if there's no arguments.
    ///
    /// All information about parentheses around arguments is stored in this node.
    pub args: Option<Box<Node>>,

    /// Body of a method, `None` if there's no body.
    pub body: Option<Box<Node>>,

    /// Location of the `def` keyword.
    ///
    /// ```text
    /// def foo; end
    /// ~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the method name.
    ///
    /// ```text
    /// def foo; end
    ///     ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the `end` keyword.
    ///
    /// ```text
    /// def foo; end
    ///          ~~~
    /// ```
    ///
    /// `None` for endless method definition
    pub end_l: Option<Loc>,

    /// Location of the `=` operator for endless method definition
    ///
    /// ```text
    /// def m() = 1
    ///         ~
    /// ```
    ///
    /// `None` for regular method definition
    pub assignment_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// def m(a); foo; end
    /// ~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Def {
    #[doc(hidden)]
    pub fn get_name(&self) -> &String {
        &self.name
    }

    #[doc(hidden)]
    pub fn get_name_mut(&mut self) -> &mut String {
        &mut self.name
    }

    #[doc(hidden)]
    pub fn get_args(&self) -> &Option<Box<Node>> {
        &self.args
    }

    #[doc(hidden)]
    pub fn get_args_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.args
    }

    #[doc(hidden)]
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    #[doc(hidden)]
    pub fn get_body_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.body
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    #[doc(hidden)]
    pub fn get_name_l_mut(&mut self) -> &mut Loc {
        &mut self.name_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_assignment_l(&self) -> &Option<Loc> {
        &self.assignment_l
    }

    #[doc(hidden)]
    pub fn get_assignment_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.assignment_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_name(&mut self, value: String) {
        self.name = value;
    }

    #[doc(hidden)]
    pub fn set_args(&mut self, value: Option<Box<Node>>) {
        self.args = value;
    }

    #[doc(hidden)]
    pub fn set_body(&mut self, value: Option<Box<Node>>) {
        self.body = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_name_l(&mut self, value: Loc) {
        self.name_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Option<Loc>) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_assignment_l(&mut self, value: Option<Loc>) {
        self.assignment_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalDef {
        let Self { name, args, body, keyword_l, name_l, end_l, assignment_l, expression_l } = self;
        super::InternalDef { name, args, body, keyword_l, name_l, end_l, assignment_l, expression_l }
    }
}

impl InnerNode for Def {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);
        result.push_maybe_node_or_nil(&self.args);
        result.push_maybe_node_or_nil(&self.body);
        
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "def"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.args.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.body.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.keyword_l.print("keyword");
        self.name_l.print("name");
        self.end_l.as_ref().map(|loc| loc.print("end"));
        self.assignment_l.as_ref().map(|loc| loc.print("assignment"));
        self.expression_l.print("expression");
    }
}
