// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalList as List;

use super::internal::InternalBreak;
use crate::blobs::{HasBlob, Blob};

/// Represents a `break` keyword (with optional argument)
#[repr(C)]
pub struct Break {
    pub(crate) blob: Blob<Break>
}

impl std::fmt::Debug for Break {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Break")
            .field("args", &self.get_args())
            .field("keyword_l", &self.get_keyword_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Break {
    fn eq(&self, other: &Self) -> bool {
        self.get_args() == other.get_args()
            && self.get_keyword_l() == other.get_keyword_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Break {
    /// Returns `args` field
    pub fn get_args(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__break__get_args(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `args` field
    pub fn set_args(&mut self, args: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__break__set_args(&mut self.blob, args.into_blob()) }
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__break__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__break__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__break__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__break__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalBreak {
        let internal = unsafe { lib_ruby_parser__external__nodes__break__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__break__get_args(blob: *const Blob<Break>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__break__set_args(blob: *mut Blob<Break>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__break__get_keyword_l(blob: *const Blob<Break>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__break__set_keyword_l(blob: *mut Blob<Break>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__break__get_expression_l(blob: *const Blob<Break>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__break__set_expression_l(blob: *mut Blob<Break>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__break__into_internal(blob: Blob<Break>) -> InternalBreak;
    fn lib_ruby_parser__external__nodes__break__drop(blob: *mut Blob<Break>);
}

impl InnerNode for Break {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_args());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "break"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_args().iter() {
          node.inner_ref().print_with_locs();
        }
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Break {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__break__drop(&mut self.blob) }
    }
}
