// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybePtr as MaybePtr;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalBlock;
use crate::blobs::{HasBlob, Blob};

/// Represents a Ruby block that is passed to a method (`proc { |foo| bar }`)
#[repr(C)]
pub struct Block {
    pub(crate) blob: Blob<Block>
}

impl std::fmt::Debug for Block {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Block")
            .field("call", &self.get_call())
            .field("args", &self.get_args())
            .field("body", &self.get_body())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Block {
    fn eq(&self, other: &Self) -> bool {
        self.get_call() == other.get_call()
            && self.get_args() == other.get_args()
            && self.get_body() == other.get_body()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_end_l() == other.get_end_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Block {
    /// Returns `call` field
    pub fn get_call(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__block__get_call(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `call` field
    pub fn set_call(&mut self, call: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__block__set_call(&mut self.blob, call.into_blob()) }
    }

    /// Returns `args` field
    pub fn get_args(&self) -> &MaybePtr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__block__get_args(&self.blob) as *const MaybePtr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `args` field
    pub fn set_args(&mut self, args: MaybePtr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__block__set_args(&mut self.blob, args.into_blob()) }
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &MaybePtr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__block__get_body(&self.blob) as *const MaybePtr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: MaybePtr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__block__set_body(&mut self.blob, body.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__block__get_begin_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__block__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__block__get_end_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__block__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__block__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__block__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalBlock {
        let internal = unsafe { lib_ruby_parser__external__nodes__block__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__block__get_call(blob: *const Blob<Block>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__block__set_call(blob: *mut Blob<Block>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__block__get_args(blob: *const Blob<Block>) -> *mut Blob<MaybePtr<Node>>;
    fn lib_ruby_parser__external__nodes__block__set_args(blob: *mut Blob<Block>, blob: Blob<MaybePtr<Node>>);
    fn lib_ruby_parser__external__nodes__block__get_body(blob: *const Blob<Block>) -> *mut Blob<MaybePtr<Node>>;
    fn lib_ruby_parser__external__nodes__block__set_body(blob: *mut Blob<Block>, blob: Blob<MaybePtr<Node>>);
    fn lib_ruby_parser__external__nodes__block__get_begin_l(blob: *const Blob<Block>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__block__set_begin_l(blob: *mut Blob<Block>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__block__get_end_l(blob: *const Blob<Block>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__block__set_end_l(blob: *mut Blob<Block>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__block__get_expression_l(blob: *const Blob<Block>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__block__set_expression_l(blob: *mut Blob<Block>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__block__into_internal(blob: Blob<Block>) -> InternalBlock;
    fn lib_ruby_parser__external__nodes__block__drop(blob: *mut Blob<Block>);
}

impl InnerNode for Block {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_call());
        result.push_maybe_node_or_nil(self.get_args());
        result.push_maybe_node_or_nil(self.get_body());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "block"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_call().inner_ref().print_with_locs();
        self.get_args().as_ref().map(|node| node.inner_ref().print_with_locs());
        self.get_body().as_ref().map(|node| node.inner_ref().print_with_locs());
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Block {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__block__drop(&mut self.blob) }
    }
}
