// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalList as List;
use crate::containers::ExternalMaybeLoc as MaybeLoc;

use super::internal::InternalBegin;
use crate::blobs::{HasBlob, Blob};

/// Represents compound statement (i.e. a multi-statement)
///
/// Basically all blocks of code are wrapped into `Begin` node (e.g. method/block body, rescue/ensure handler etc)
#[repr(C)]
pub struct Begin {
    pub(crate) blob: Blob<Begin>
}

impl std::fmt::Debug for Begin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Begin")
            .field("statements", &self.get_statements())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Begin {
    fn eq(&self, other: &Self) -> bool {
        self.get_statements() == other.get_statements()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_end_l() == other.get_end_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Begin {
    /// Returns `statements` field
    pub fn get_statements(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__begin__get_statements(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `statements` field
    pub fn set_statements(&mut self, statements: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__begin__set_statements(&mut self.blob, statements.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &MaybeLoc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__begin__get_begin_l(&self.blob) as *const MaybeLoc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: MaybeLoc) {
        unsafe { lib_ruby_parser__external__nodes__begin__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &MaybeLoc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__begin__get_end_l(&self.blob) as *const MaybeLoc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: MaybeLoc) {
        unsafe { lib_ruby_parser__external__nodes__begin__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__begin__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__begin__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalBegin {
        let internal = unsafe { lib_ruby_parser__external__nodes__begin__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__begin__get_statements(blob: *const Blob<Begin>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__begin__set_statements(blob: *mut Blob<Begin>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__begin__get_begin_l(blob: *const Blob<Begin>) -> *mut Blob<MaybeLoc>;
    fn lib_ruby_parser__external__nodes__begin__set_begin_l(blob: *mut Blob<Begin>, blob: Blob<MaybeLoc>);
    fn lib_ruby_parser__external__nodes__begin__get_end_l(blob: *const Blob<Begin>) -> *mut Blob<MaybeLoc>;
    fn lib_ruby_parser__external__nodes__begin__set_end_l(blob: *mut Blob<Begin>, blob: Blob<MaybeLoc>);
    fn lib_ruby_parser__external__nodes__begin__get_expression_l(blob: *const Blob<Begin>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__begin__set_expression_l(blob: *mut Blob<Begin>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__begin__into_internal(blob: Blob<Begin>) -> InternalBegin;
    fn lib_ruby_parser__external__nodes__begin__drop(blob: *mut Blob<Begin>);
}

impl InnerNode for Begin {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_statements());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "begin"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_statements().iter() {
          node.inner_ref().print_with_locs();
        }
        self.get_begin_l().as_ref().map(|loc| loc.print("begin"));
        self.get_end_l().as_ref().map(|loc| loc.print("end"));
        self.get_expression_l().print("expression");
    }
}

impl Drop for Begin {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__begin__drop(&mut self.blob) }
    }
}
