// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalBackRef;
use crate::blobs::{HasBlob, Blob};

/// Represents special global variables:
/// 1. `` $` ``
/// 2. `$&`
/// 3. `$'`
/// 4. `$+`
#[repr(C)]
pub struct BackRef {
    pub(crate) blob: Blob<BackRef>
}

impl std::fmt::Debug for BackRef {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("BackRef")
            .field("name", &self.get_name())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for BackRef {
    fn eq(&self, other: &Self) -> bool {
        self.get_name() == other.get_name()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl BackRef {
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__back_ref__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__back_ref__set_name(&mut self.blob, name.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__back_ref__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__back_ref__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalBackRef {
        let internal = unsafe { lib_ruby_parser__external__nodes__back_ref__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__back_ref__get_name(blob: *const Blob<BackRef>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__back_ref__set_name(blob: *mut Blob<BackRef>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__back_ref__get_expression_l(blob: *const Blob<BackRef>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__back_ref__set_expression_l(blob: *mut Blob<BackRef>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__back_ref__into_internal(blob: Blob<BackRef>) -> InternalBackRef;
    fn lib_ruby_parser__external__nodes__back_ref__drop(blob: *mut Blob<BackRef>);
}

impl InnerNode for BackRef {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "back_ref"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}

impl Drop for BackRef {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__back_ref__drop(&mut self.blob) }
    }
}
