// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalAlias;
use crate::blobs::{HasBlob, Blob};

/// Represents `alias to from` statement.
#[repr(C)]
pub struct Alias {
    pub(crate) blob: Blob<Alias>
}

impl std::fmt::Debug for Alias {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Alias")
            .field("to", &self.get_to())
            .field("from", &self.get_from())
            .field("keyword_l", &self.get_keyword_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Alias {
    fn eq(&self, other: &Self) -> bool {
        self.get_to() == other.get_to()
            && self.get_from() == other.get_from()
            && self.get_keyword_l() == other.get_keyword_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Alias {
    /// Returns `to` field
    pub fn get_to(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__alias__get_to(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `to` field
    pub fn set_to(&mut self, to: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__alias__set_to(&mut self.blob, to.into_blob()) }
    }

    /// Returns `from` field
    pub fn get_from(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__alias__get_from(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `from` field
    pub fn set_from(&mut self, from: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__alias__set_from(&mut self.blob, from.into_blob()) }
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__alias__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__alias__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__alias__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__alias__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalAlias {
        let internal = unsafe { lib_ruby_parser__external__nodes__alias__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__alias__get_to(blob: *const Blob<Alias>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__alias__set_to(blob: *mut Blob<Alias>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__alias__get_from(blob: *const Blob<Alias>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__alias__set_from(blob: *mut Blob<Alias>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__alias__get_keyword_l(blob: *const Blob<Alias>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__alias__set_keyword_l(blob: *mut Blob<Alias>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__alias__get_expression_l(blob: *const Blob<Alias>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__alias__set_expression_l(blob: *mut Blob<Alias>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__alias__into_internal(blob: Blob<Alias>) -> InternalAlias;
    fn lib_ruby_parser__external__nodes__alias__drop(blob: *mut Blob<Alias>);
}

impl InnerNode for Alias {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_to());
        result.push_node(self.get_from());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "alias"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_to().inner_ref().print_with_locs();
        self.get_from().inner_ref().print_with_locs();
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Alias {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__alias__drop(&mut self.blob) }
    }
}
