fn contents() -> String {
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "// This file is autogenerated by {generator}

{variants}

impl crate::DiagnosticMessage {{
    {as_variant_fns}
}}
",
        generator = file!(),
        variants = messages.map(variant).join("\n\n"),
        as_variant_fns = messages.map(as_variant_fn).join("\n    ")
    )
}

pub(crate) fn codegen() {
    std::fs::write("src/error/message/native/variants.rs", contents()).unwrap();
}

fn variant(message: &lib_ruby_parser_nodes::Message) -> String {
    let fields = message
        .fields
        .map(|field| {
            format!(
                "{comment}
    pub {field_name}: {field_type},",
                comment = field.render_comment("///", 4),
                field_name = field.name,
                field_type = field_type(field)
            )
        })
        .join("\n");

    let getters = message
        .fields
        .map(|field| {
            format!(
                "/// Returns `{field_name}` field
    pub fn get_{field_name}(&self) -> &{field_type} {{
        &self.{field_name}
    }}",
                field_name = field.name,
                field_type = field_type(field)
            )
        })
        .join("\n    ");

    format!(
        "{comment}
#[derive(Debug, PartialEq, Eq, Clone)]
pub struct {struct_name} {{
{fields}
}}

impl {struct_name} {{
    {getters}
}}",
        comment = message.render_comment("///", 0),
        struct_name = message.camelcase_name,
        fields = fields,
        getters = getters
    )
}

fn as_variant_fn(message: &lib_ruby_parser_nodes::Message) -> String {
    format!(
        "/// Casts `self` to `Option<&{variant}>`, return `None` if variant doesn't match
    pub fn as_{lower}(&self) -> Option<&{variant}> {{
        match self {{
            Self::{variant}(variant) => Some(variant),
            _ => None
        }}
    }}",
        variant = message.camelcase_name,
        lower = message.lower_name()
    )
}

fn field_type(field: &lib_ruby_parser_nodes::MessageField) -> &str {
    match field.field_type {
        lib_ruby_parser_nodes::MessageFieldType::Str => "String",
        lib_ruby_parser_nodes::MessageFieldType::Byte => "u8",
    }
}
