fn contents() -> String {
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "// This file is autogenerated by {generator}

use super::DiagnosticMessage;
use super::variants::*;

impl DiagnosticMessage {{
    {constructors}
}}
",
        generator = file!(),
        constructors = messages.map(constructor).join("\n    ")
    )
}

pub(crate) fn codegen() {
    std::fs::write("src/error/message/native/constructors.rs", contents()).unwrap();
}

fn constructor(message: &lib_ruby_parser_nodes::Message) -> String {
    let arglist = message
        .fields
        .map(|field| {
            let field_type = match field.field_type {
                lib_ruby_parser_nodes::MessageFieldType::Str => "String",
                lib_ruby_parser_nodes::MessageFieldType::Byte => "u8",
            };

            format!(
                "{field_name}: {field_type}",
                field_name = field.name,
                field_type = field_type
            )
        })
        .join(", ");

    let fields = message
        .fields
        .map(|field| format!("{}", field.name))
        .join(", ");

    format!(
        "/// Constructs {variant_name} variant
    pub fn new_{fn_name}({arglist}) -> Self {{
        Self::{variant_name}({variant_name} {{ {fields} }})
    }}",
        variant_name = message.camelcase_name,
        fn_name = message.lower_name(),
        arglist = arglist,
        fields = fields
    )
}
