use lib_ruby_parser_bindings::helpers::messages::variant_predicate as bindings_variant_predicate;

fn contents() -> String {
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "// This file is auto-generated by {generator}

use crate::blobs::Blob;
use super::DiagnosticMessage;

extern \"C\" {{
    {extern_predicates}
}}

impl DiagnosticMessage {{
    {foreign_predicates}
}}
",
        generator = file!(),
        extern_predicates = messages.map(extern_predicate).join("\n    "),
        foreign_predicates = messages.map(foreign_predicate).join("\n    "),
    )
}

pub(crate) fn codegen() {
    std::fs::write("src/error/message/external/predicates.rs", contents()).unwrap();
}

fn extern_predicate(message: &lib_ruby_parser_nodes::Message) -> String {
    format!(
        "fn {name}(blob: *const Blob<DiagnosticMessage>) -> bool;",
        name = bindings_variant_predicate::name(message),
    )
}

fn foreign_predicate(message: &lib_ruby_parser_nodes::Message) -> String {
    format!(
        "/// Returns true if current variant is {variant}
    pub fn is_{variant}(&self) -> bool {{
        unsafe {{ {extern_predicate}(&self.blob) }}
    }}",
        variant = message.lower_name(),
        extern_predicate = bindings_variant_predicate::name(message)
    )
}
