fn contents() -> String {
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "// This file is auto-generated by {generator}

use super::DiagnosticMessage;

impl PartialEq for DiagnosticMessage {{
    fn eq(&self, other: &Self) -> bool {{
        {branches} else {{
            panic!(\"unrecognized diagnostic message type\")
        }}
    }}
}}
",
        generator = file!(),
        branches = messages.map(branch).join(" else ")
    )
}

pub(crate) fn codegen() {
    std::fs::write("src/error/message/external/impl_partial_eq.rs", contents()).unwrap();
}

fn branch(message: &lib_ruby_parser_nodes::Message) -> String {
    format!(
        "if let Some(lhs) = self.as_{message_type}() {{
            if let Some(rhs) = other.as_{message_type}() {{
                lhs == rhs
            }} else {{
                false
            }}
        }}",
        message_type = message.lower_name()
    )
}
