fn contents() -> String {
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "// This file is auto-generated by {generator}

use super::{{DiagnosticMessage}};

impl std::fmt::Debug for DiagnosticMessage {{
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {{
        {branches} else {{
            panic!(\"unrecognized diagnostic message type\")
        }}
    }}
}}
",
        generator = file!(),
        branches = messages.map(branch).join(" else ")
    )
}

pub(crate) fn codegen() {
    std::fs::write("src/error/message/external/impl_debug.rs", contents()).unwrap();
}

fn branch(message: &lib_ruby_parser_nodes::Message) -> String {
    format!(
        "if let Some(inner) = self.as_{message_type}() {{
            write!(f, \"{struct_name}({{:?}})\", inner)
        }}",
        message_type = message.lower_name(),
        struct_name = message.camelcase_name,
    )
}
