fn contents() -> String {
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "// This file is auto-generated by {generator}

use super::{{DiagnosticMessage}};

impl Clone for DiagnosticMessage {{
    fn clone(&self) -> Self {{
        {branches} else {{
            panic!(\"unrecognized diagnostic message type\")
        }}
    }}
}}
",
        generator = file!(),
        branches = messages.map(branch).join(" else ")
    )
}

pub(crate) fn codegen() {
    std::fs::write("src/error/message/external/impl_clone.rs", contents()).unwrap();
}

fn branch(message: &lib_ruby_parser_nodes::Message) -> String {
    let var_name = if message.fields.0.is_empty() {
        "_"
    } else {
        "variant"
    };

    let arglist = message
        .fields
        .map(|field| {
            format!(
                "variant.get_{field_name}().clone()",
                field_name = field.name
            )
        })
        .join(", ");

    format!(
        "if let Some({var_name}) = self.as_{message_type}() {{
            Self::new_{message_type}({arglist})
        }}",
        message_type = message.lower_name(),
        arglist = arglist,
        var_name = var_name
    )
}
