use lib_ruby_parser_bindings::helpers::messages::constructor as bindings_constructor;

fn contents() -> String {
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "// This file is auto-generated by {generator}

use crate::containers::ExternalStringPtr as StringPtr;
use crate::blobs::{{Blob, HasBlob}};
use super::DiagnosticMessage;

extern \"C\" {{
    {extern_constructors}
}}

impl DiagnosticMessage {{
    {foreign_constructors}
}}

",
        generator = file!(),
        extern_constructors = messages.map(extern_constructor).join("\n    "),
        foreign_constructors = messages.map(foreign_constructor).join("\n    "),
    )
}

pub(crate) fn codegen() {
    std::fs::write("src/error/message/external/constructors.rs", contents()).unwrap();
}

fn extern_constructor(message: &lib_ruby_parser_nodes::Message) -> String {
    let arglist = message
        .fields
        .map(|field| {
            let field_type = match field.field_type {
                lib_ruby_parser_nodes::MessageFieldType::Str => "Blob<StringPtr>",
                lib_ruby_parser_nodes::MessageFieldType::Byte => "u8",
            };

            format!(
                "{field_name}: {field_type}",
                field_name = field.name,
                field_type = field_type
            )
        })
        .join(", ");

    format!(
        "fn {name}({arglist}) -> Blob<DiagnosticMessage>;",
        name = bindings_constructor::name(message),
        arglist = arglist
    )
}

fn foreign_constructor(message: &lib_ruby_parser_nodes::Message) -> String {
    let rust_arglist = message
        .fields
        .map(|field| {
            let field_type = match field.field_type {
                lib_ruby_parser_nodes::MessageFieldType::Str => "StringPtr",
                lib_ruby_parser_nodes::MessageFieldType::Byte => "u8",
            };

            format!(
                "{field_name}: {field_type}",
                field_name = field.name,
                field_type = field_type
            )
        })
        .join(", ");

    let extern_arglist = message
        .fields
        .map(|field| match field.field_type {
            lib_ruby_parser_nodes::MessageFieldType::Str => {
                format!("{name}.into_blob()", name = field.name)
            }
            lib_ruby_parser_nodes::MessageFieldType::Byte => field.name.to_string(),
        })
        .join(", ");

    format!(
        "/// Constructs {variant_name} variant
    pub fn new_{fn_name}({rust_arglist}) -> Self {{
        let blob = unsafe {{ {extern_constructor_name}({extern_arglist}) }};
        Self {{ blob }}
    }}",
        variant_name = message.camelcase_name,
        fn_name = message.lower_name(),
        rust_arglist = rust_arglist,
        extern_constructor_name = bindings_constructor::name(message),
        extern_arglist = extern_arglist,
    )
}
