pub(crate) mod helpers;

mod bindings_messages_cpp;
mod messages_cpp;
mod messages_hpp;

mod bindings_nodes_cpp;
mod nodes_cpp;
mod nodes_hpp;

mod bindings_hpp;

mod blobs_gen_hpp;
mod sizes_gen_hpp;

pub(crate) fn codegen() {
    let options = codegen_options();

    bindings_messages_cpp::codegen(&options);

    messages_hpp::codegen();
    messages_cpp::codegen();

    bindings_nodes_cpp::codegen(&options);

    nodes_hpp::codegen();
    nodes_cpp::codegen();

    bindings_hpp::codegen(&options);

    blobs_gen_hpp::codegen();
    sizes_gen_hpp::codegen();
}

pub(crate) fn codegen_options() -> lib_ruby_parser_bindings::Options {
    let pre_code = format!(
        "// This file is autogenerated by {generator}
#include \"structs.hpp\"
#include \"blobs.hpp\"

#ifdef __cplusplus
extern \"C\" {{
#endif
",
        generator = file!()
    );

    let post_code = format!(
        "#ifdef __cplusplus
}}
#endif"
    );

    lib_ruby_parser_bindings::Options {
        pre_code,
        post_code,
        ..Default::default()
    }
}
