use crate::codegen::cpp::helpers;

fn contents() -> String {
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "#ifndef LIB_RUBY_PARSER_EXTERNAL_CPP_SHARED_MESSAGES_HPP
#define LIB_RUBY_PARSER_EXTERNAL_CPP_SHARED_MESSAGES_HPP

// This file is autogenerated by {generator}

#include <variant>

namespace lib_ruby_parser
{{
    {classes}

    typedef std::variant<
        {variants}>
        diagnostic_message_variant_t;

    class DiagnosticMessage
    {{
    public:
        diagnostic_message_variant_t variant;

        DiagnosticMessage(diagnostic_message_variant_t variant);

        DiagnosticMessage(const DiagnosticMessage &) = delete;
        DiagnosticMessage &operator=(const DiagnosticMessage &other) = delete;

        DiagnosticMessage(DiagnosticMessage &&) = default;
        DiagnosticMessage &operator=(DiagnosticMessage &&other) = default;
    }};

    {drop_fns}

    void drop_diagnostic_message(DiagnosticMessage *message);

    // Diagnostic
    class Diagnostic
    {{
    public:
        ErrorLevel level;
        DiagnosticMessage message;
        Loc loc;

        explicit Diagnostic(ErrorLevel level, DiagnosticMessage message, Loc loc);
    }};
    using DiagnosticList = std::vector<Diagnostic>;
    void drop_diagnostic(Diagnostic *);
}}

#endif // LIB_RUBY_PARSER_EXTERNAL_CPP_SHARED_MESSAGES_HPP",
        generator = file!(),
        classes = messages.map(class).join("\n\n    "),
        variants = messages.map(variant).join(",\n        "),
        drop_fns = messages.map(drop_fn).join("\n    "),
    )
}

pub(crate) fn codegen() {
    std::fs::write("external/cpp/messages.hpp", contents()).unwrap();
}

fn class(message: &lib_ruby_parser_nodes::Message) -> String {
    let fields_declaration = message
        .fields
        .map(|field| {
            format!(
                "{t} {name};",
                t = helpers::messages::field_type(field),
                name = helpers::messages::field_name(field)
            )
        })
        .join("\n    ");

    format!(
        "class {name}
    {{
    public:
        {fields_declaration}

        {name}({constructor_arglist});

        {name}(const {name} &) = delete;
        {name} &operator=(const {name} &other) = delete;

        {name}({name} &&) = default;
        {name} &operator=({name} &&other) = default;
    }};",
        name = message.camelcase_name,
        constructor_arglist = helpers::messages::constructor_arglist(message),
        fields_declaration = fields_declaration
    )
}

fn variant(message: &lib_ruby_parser_nodes::Message) -> String {
    message.camelcase_name.to_string()
}

fn drop_fn(message: &lib_ruby_parser_nodes::Message) -> String {
    format!(
        "void drop_message_{variant}({struct_name}* variant);",
        variant = message.lower_name(),
        struct_name = message.camelcase_name
    )
}
