fn contents() -> String {
    format!(
        "#ifndef LIB_RUBY_PARSER_EXTERNAL_C_BLOBS_HPP
#define LIB_RUBY_PARSER_EXTERNAL_C_BLOBS_HPP

// This file is autogenerated by {generator}

#include \"structs.hpp\"
#include \"declare_blob.hpp\"

{node_blobs}

{message_blobs}

#endif // LIB_RUBY_PARSER_EXTERNAL_C_BLOBS_HPP
",
        generator = file!(),
        // blobs
        node_blobs = lib_ruby_parser_nodes::nodes().map(node_blob).join("\n"),
        message_blobs = lib_ruby_parser_nodes::messages()
            .map(message_blob)
            .join("\n"),
    )
}

pub(crate) fn codegen() {
    std::fs::write("external/cpp/blobs_gen.hpp", contents()).unwrap();
}

fn node_blob(node: &lib_ruby_parser_nodes::Node) -> String {
    format!(
        "DECLARE_BLOB_FOR({node_struct});
#define UNPACK_{node_struct}(blob) (({node_struct}_BLOB_UNION){{.as_blob = blob}}).as_value
#define PACK_{node_struct}(value) (({node_struct}_BLOB_UNION){{.as_value = value}}).as_blob",
        node_struct = node.camelcase_name
    )
}
fn message_blob(message: &lib_ruby_parser_nodes::Message) -> String {
    format!(
        "DECLARE_BLOB_FOR({message_struct});
#define UNPACK_{message_struct}(blob) (({message_struct}_BLOB_UNION){{.as_blob = blob}}).as_value
#define PACK_{message_struct}(value) (({message_struct}_BLOB_UNION){{.as_value = value}}).as_blob",
        message_struct = message.camelcase_name
    )
}
