pub(crate) fn codegen() {
    std::fs::write("external/c/sizes_gen.h", contents()).unwrap();
}

fn contents() -> String {
    let nodes = lib_ruby_parser_nodes::nodes();
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "#ifndef LIB_RUBY_PARSER_SIZES_GEN_H
#define LIB_RUBY_PARSER_SIZES_GEN_H

// This file is autogenerated by {generator}

#include <stdio.h>
#include \"structs.h\"

void print_node_sizes()
{{
    {node_sizes}
}}

void print_messages_sizes()
{{
    {message_sizes}
}}

#endif // LIB_RUBY_PARSER_SIZES_GEN_H
",
        generator = file!(),
        node_sizes = nodes.map(node_size).join("\n    "),
        message_sizes = messages.map(message_size).join("\n    ")
    )
}

fn node_size(node: &lib_ruby_parser_nodes::Node) -> String {
    format!(
        "printf(\"LIB_RUBY_PARSER_NODE_{upper}_SIZE=%lu\\n\", sizeof(LIB_RUBY_PARSER_{struct_name}));",
        upper = node.upper_name(),
        struct_name = node.camelcase_name
    )
}

fn message_size(message: &lib_ruby_parser_nodes::Message) -> String {
    format!(
        "printf(\"LIB_RUBY_PARSER_MESSAGE_{upper}_SIZE=%lu\\n\", sizeof(LIB_RUBY_PARSER_{struct_name}));",
        upper = message.upper_name(),
        struct_name = message.camelcase_name
    )
}
