use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents `redo` keyword
///
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Redo {
    /// Location of the full expression
    ///
    /// ```text
    /// redo
    /// ~~~~
    /// ```
    ///
    pub expression_l: Loc,
}

impl InnerNode for Redo {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "redo"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expression_l.print("expression");
    }
}

