use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a special `__ENCODING__` keyword
///
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Encoding {
    /// Location of the `__ENCODING__` keyword
    ///
    /// ```text
    /// __ENCODING__
    /// ~~~~~~~~~~~~
    /// ```
    ///
    pub expression_l: Loc,
}

impl InnerNode for Encoding {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "__ENCODING__"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expression_l.print("expression");
    }
}

