use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents leading `::` part of the constant access/assignment that is used to get/set on a global namespace.
///
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Cbase {
    /// Location of the full expression
    ///
    /// ```text
    /// ::A
    /// ~~
    /// ```
    ///
    pub expression_l: Loc,
}

impl InnerNode for Cbase {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "cbase"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expression_l.print("expression");
    }
}

