/* A Bison parser, made by GNU Bison 3.7.5.  */

/* Skeleton implementation for Bison LALR(1) parsers in Rust

   Copyright (C) 2007-2015, 2018-2020 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */




use std::convert::TryInto;


/* "%code use" blocks.  */
/* "src/parser.y":50  */


#[cfg(feature = "compile-with-external-structures")]
use crate::containers::ExternalPtr;
#[cfg(feature = "compile-with-external-structures")]
type Ptr<T> = ExternalPtr<T>;
#[cfg(not(feature = "compile-with-external-structures"))]
type Ptr<T> = Box<T>;

#[cfg(feature = "compile-with-external-structures")]
use crate::containers::ExternalList;
#[cfg(feature = "compile-with-external-structures")]
type List<T> = ExternalList<T>;
#[cfg(not(feature = "compile-with-external-structures"))]
type List<T> = Vec<T>;

#[cfg(feature = "compile-with-external-structures")]
use crate::containers::ExternalMaybePtr;
#[cfg(feature = "compile-with-external-structures")]
type MaybePtr<T> = ExternalMaybePtr<T>;
#[cfg(not(feature = "compile-with-external-structures"))]
type MaybePtr<T> = Option<Box<T>>;

#[cfg(feature = "compile-with-external-structures")]
use crate::containers::ExternalStringPtr;
#[cfg(feature = "compile-with-external-structures")]
type StringPtr = ExternalStringPtr;
#[cfg(not(feature = "compile-with-external-structures"))]
type StringPtr = String;

use crate::{ParserOptions, ParserResult};
use crate::{Token, TokenTrait};
use crate::{Lexer, Builder, CurrentArgStack, StaticEnvironment, MaxNumparamStack, VariablesStack};
use crate::lex_states::*;
use crate::{Context as ParserContext, ContextItem};
use crate::builder::{LoopType, KeywordCmd, LogicalOp, PKwLabel, ArgsType};
use crate::builder::clone_value;
use crate::parse_value::ParseValue as Value;
use crate::parse_value::*;
use crate::Node;
use crate::{Diagnostic, DiagnosticMessage, ErrorLevel};
use crate::error::Diagnostics;
use crate::token_rewriter::{LexStateAction, RewriteAction, TokenRewriter, TokenRewriterResult};
use crate::debug_level;
use crate::containers::helpers::{UnPtr, MaybePtrNone};
use crate::Loc;


/* "src/parser.rs":94  */


/// A Bison parser, automatically generated from src/parser.y.
#[derive(Debug)]
pub struct  Parser  {
    /// Lexer that is used to get tokens
    pub yylexer: Lexer,
    // true if verbose error messages are enabled.
    #[allow(dead_code)]
    yy_error_verbose: bool,
    // number of errors so far
    yynerrs: i32,

    /// Boolean field that enables printing shift/reduce actions during parsing
    pub yydebug: bool,

    yyerrstatus_: i32,

    /* "%code parser_fields" blocks.  */
/* "src/parser.y":9  */

    result: MaybePtr<Node>,
    builder: Builder,
    current_arg_stack: CurrentArgStack,
    /// Stack of sets of variables in current scopes.
    /// Each stack item represents locals in the scope.
    ///
    /// You can use it to pre-define some locals and parse
    /// your input as if these locals exist.
    ///
    /// For example, you can parse the following code
    ///
    /// ```text
    /// a = b + c
    /// ```
    ///
    /// as
    ///
    /// ```text
    /// Send(LocalVar(a), "+", LocalVar(b))
    /// ```
    ///
    /// by declaring `a` and `b` as locals using
    ///
    /// ```text
    /// parser.static_env.declare("a")
    /// parser.static_env.declare("b")
    /// parser.parse()
    /// ```
    pub static_env: StaticEnvironment,
    context: ParserContext,
    last_token_type: i32,
    max_numparam_stack: MaxNumparamStack,
    pattern_variables: VariablesStack,
    pattern_hash_keys: VariablesStack,
    tokens: List<Token>,
    diagnostics: Diagnostics,
    token_rewriter: TokenRewriter,
    record_tokens: bool,

/* "src/parser.rs":155  */

}

#[inline]
fn i32_to_usize(v: i32) -> usize {
    v.try_into().unwrap()
}

/// Maps token ID into human-readable name
pub fn token_name(id: i32) -> &'static str { /* ' */
    let first_token = Lexer::YYerror;
    if id > first_token + 1 {
        let pos: usize = (id - first_token + 1)
            .try_into()
            .expect("failed to cast token id into usize, is it negative?");
        Lexer::TOKEN_NAMES[pos]
    } else if id == 0 {
        "EOF"
    } else {
        panic!("token_name fails, {} (first token = {})", id, first_token)
    }
}

/// Local alias
type YYLoc = Loc;

impl  Parser  {
    // Version number for the Bison executable that generated this parser.
    #[allow(dead_code)]
    const BISON_VERSION: &'static str = "30705";

}


fn make_yylloc(rhs: &YYStack, n: usize) -> YYLoc {
    if 0 < n {
        YYLoc { begin: rhs.location_at(n - 1).begin, end: rhs.location_at(0).end }
    } else {
        YYLoc { begin: rhs.location_at(0).end, end: rhs.location_at(0).end }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub struct SymbolKind { value: i32 }

impl SymbolKind {



    #[allow(non_upper_case_globals)]
    const S_YYEOF: i32 = 0;        /* "end-of-input"  */

    #[allow(non_upper_case_globals)]
    const S_YYerror: i32 = 1;      /* error  */

    #[allow(non_upper_case_globals)]
    const S_YYUNDEF: i32 = 2;      /* "invalid token"  */

    #[allow(non_upper_case_globals)]
    const S_kCLASS: i32 = 3;       /* "`class'"  */

    #[allow(non_upper_case_globals)]
    const S_kMODULE: i32 = 4;      /* "`module'"  */

    #[allow(non_upper_case_globals)]
    const S_kDEF: i32 = 5;         /* "`def'"  */

    #[allow(non_upper_case_globals)]
    const S_kUNDEF: i32 = 6;       /* "`undef'"  */

    #[allow(non_upper_case_globals)]
    const S_kBEGIN: i32 = 7;       /* "`begin'"  */

    #[allow(non_upper_case_globals)]
    const S_kRESCUE: i32 = 8;      /* "`rescue'"  */

    #[allow(non_upper_case_globals)]
    const S_kENSURE: i32 = 9;      /* "`ensure'"  */

    #[allow(non_upper_case_globals)]
    const S_kEND: i32 = 10;        /* "`end'"  */

    #[allow(non_upper_case_globals)]
    const S_kIF: i32 = 11;         /* "`if'"  */

    #[allow(non_upper_case_globals)]
    const S_kUNLESS: i32 = 12;     /* "`unless'"  */

    #[allow(non_upper_case_globals)]
    const S_kTHEN: i32 = 13;       /* "`then'"  */

    #[allow(non_upper_case_globals)]
    const S_kELSIF: i32 = 14;      /* "`elsif'"  */

    #[allow(non_upper_case_globals)]
    const S_kELSE: i32 = 15;       /* "`else'"  */

    #[allow(non_upper_case_globals)]
    const S_kCASE: i32 = 16;       /* "`case'"  */

    #[allow(non_upper_case_globals)]
    const S_kWHEN: i32 = 17;       /* "`when'"  */

    #[allow(non_upper_case_globals)]
    const S_kWHILE: i32 = 18;      /* "`while'"  */

    #[allow(non_upper_case_globals)]
    const S_kUNTIL: i32 = 19;      /* "`until'"  */

    #[allow(non_upper_case_globals)]
    const S_kFOR: i32 = 20;        /* "`for'"  */

    #[allow(non_upper_case_globals)]
    const S_kBREAK: i32 = 21;      /* "`break'"  */

    #[allow(non_upper_case_globals)]
    const S_kNEXT: i32 = 22;       /* "`next'"  */

    #[allow(non_upper_case_globals)]
    const S_kREDO: i32 = 23;       /* "`redo'"  */

    #[allow(non_upper_case_globals)]
    const S_kRETRY: i32 = 24;      /* "`retry'"  */

    #[allow(non_upper_case_globals)]
    const S_kIN: i32 = 25;         /* "`in'"  */

    #[allow(non_upper_case_globals)]
    const S_kDO: i32 = 26;         /* "`do'"  */

    #[allow(non_upper_case_globals)]
    const S_kDO_COND: i32 = 27;    /* "`do' for condition"  */

    #[allow(non_upper_case_globals)]
    const S_kDO_BLOCK: i32 = 28;   /* "`do' for block"  */

    #[allow(non_upper_case_globals)]
    const S_kDO_LAMBDA: i32 = 29;  /* "`do' for lambda"  */

    #[allow(non_upper_case_globals)]
    const S_kRETURN: i32 = 30;     /* "`return'"  */

    #[allow(non_upper_case_globals)]
    const S_kYIELD: i32 = 31;      /* "`yield'"  */

    #[allow(non_upper_case_globals)]
    const S_kSUPER: i32 = 32;      /* "`super'"  */

    #[allow(non_upper_case_globals)]
    const S_kSELF: i32 = 33;       /* "`self'"  */

    #[allow(non_upper_case_globals)]
    const S_kNIL: i32 = 34;        /* "`nil'"  */

    #[allow(non_upper_case_globals)]
    const S_kTRUE: i32 = 35;       /* "`true'"  */

    #[allow(non_upper_case_globals)]
    const S_kFALSE: i32 = 36;      /* "`false'"  */

    #[allow(non_upper_case_globals)]
    const S_kAND: i32 = 37;        /* "`and'"  */

    #[allow(non_upper_case_globals)]
    const S_kOR: i32 = 38;         /* "`or'"  */

    #[allow(non_upper_case_globals)]
    const S_kNOT: i32 = 39;        /* "`not'"  */

    #[allow(non_upper_case_globals)]
    const S_kIF_MOD: i32 = 40;     /* "`if' modifier"  */

    #[allow(non_upper_case_globals)]
    const S_kUNLESS_MOD: i32 = 41; /* "`unless' modifier"  */

    #[allow(non_upper_case_globals)]
    const S_kWHILE_MOD: i32 = 42;  /* "`while' modifier"  */

    #[allow(non_upper_case_globals)]
    const S_kUNTIL_MOD: i32 = 43;  /* "`until' modifier"  */

    #[allow(non_upper_case_globals)]
    const S_kRESCUE_MOD: i32 = 44; /* "`rescue' modifier"  */

    #[allow(non_upper_case_globals)]
    const S_kALIAS: i32 = 45;      /* "`alias'"  */

    #[allow(non_upper_case_globals)]
    const S_kDEFINED: i32 = 46;    /* "`defined?'"  */

    #[allow(non_upper_case_globals)]
    const S_klBEGIN: i32 = 47;     /* "`BEGIN'"  */

    #[allow(non_upper_case_globals)]
    const S_klEND: i32 = 48;       /* "`END'"  */

    #[allow(non_upper_case_globals)]
    const S_k__LINE__: i32 = 49;   /* "`__LINE__'"  */

    #[allow(non_upper_case_globals)]
    const S_k__FILE__: i32 = 50;   /* "`__FILE__'"  */

    #[allow(non_upper_case_globals)]
    const S_k__ENCODING__: i32 = 51; /* "`__ENCODING__'"  */

    #[allow(non_upper_case_globals)]
    const S_tIDENTIFIER: i32 = 52; /* "local variable or method"  */

    #[allow(non_upper_case_globals)]
    const S_tFID: i32 = 53;        /* "method"  */

    #[allow(non_upper_case_globals)]
    const S_tGVAR: i32 = 54;       /* "global variable"  */

    #[allow(non_upper_case_globals)]
    const S_tIVAR: i32 = 55;       /* "instance variable"  */

    #[allow(non_upper_case_globals)]
    const S_tCONSTANT: i32 = 56;   /* "constant"  */

    #[allow(non_upper_case_globals)]
    const S_tCVAR: i32 = 57;       /* "class variable"  */

    #[allow(non_upper_case_globals)]
    const S_tLABEL: i32 = 58;      /* "label"  */

    #[allow(non_upper_case_globals)]
    const S_tINTEGER: i32 = 59;    /* "integer literal"  */

    #[allow(non_upper_case_globals)]
    const S_tFLOAT: i32 = 60;      /* "float literal"  */

    #[allow(non_upper_case_globals)]
    const S_tRATIONAL: i32 = 61;   /* "rational literal"  */

    #[allow(non_upper_case_globals)]
    const S_tIMAGINARY: i32 = 62;  /* "imaginary literal"  */

    #[allow(non_upper_case_globals)]
    const S_tCHAR: i32 = 63;       /* "char literal"  */

    #[allow(non_upper_case_globals)]
    const S_tNTH_REF: i32 = 64;    /* "numbered reference"  */

    #[allow(non_upper_case_globals)]
    const S_tBACK_REF: i32 = 65;   /* "back reference"  */

    #[allow(non_upper_case_globals)]
    const S_tSTRING_CONTENT: i32 = 66; /* "literal content"  */

    #[allow(non_upper_case_globals)]
    const S_tREGEXP_END: i32 = 67; /* tREGEXP_END  */

    #[allow(non_upper_case_globals)]
    const S_tDOT: i32 = 68;        /* tDOT  */

    #[allow(non_upper_case_globals)]
    const S_tBACKSLASH: i32 = 69;  /* "backslash"  */

    #[allow(non_upper_case_globals)]
    const S_tSP: i32 = 70;         /* "escaped space"  */

    #[allow(non_upper_case_globals)]
    const S_tSLASH_T: i32 = 71;    /* "escaped horizontal tab"  */

    #[allow(non_upper_case_globals)]
    const S_tSLASH_F: i32 = 72;    /* "escaped form feed"  */

    #[allow(non_upper_case_globals)]
    const S_tSLASH_R: i32 = 73;    /* "escaped carriage return"  */

    #[allow(non_upper_case_globals)]
    const S_tVTAB: i32 = 74;       /* "escaped vertical tab"  */

    #[allow(non_upper_case_globals)]
    const S_tUPLUS: i32 = 75;      /* "unary+"  */

    #[allow(non_upper_case_globals)]
    const S_tUMINUS: i32 = 76;     /* "unary-"  */

    #[allow(non_upper_case_globals)]
    const S_tPOW: i32 = 77;        /* "**"  */

    #[allow(non_upper_case_globals)]
    const S_tCMP: i32 = 78;        /* "<=>"  */

    #[allow(non_upper_case_globals)]
    const S_tEQ: i32 = 79;         /* "=="  */

    #[allow(non_upper_case_globals)]
    const S_tEQQ: i32 = 80;        /* "==="  */

    #[allow(non_upper_case_globals)]
    const S_tNEQ: i32 = 81;        /* "!="  */

    #[allow(non_upper_case_globals)]
    const S_tGEQ: i32 = 82;        /* ">="  */

    #[allow(non_upper_case_globals)]
    const S_tLEQ: i32 = 83;        /* "<="  */

    #[allow(non_upper_case_globals)]
    const S_tANDOP: i32 = 84;      /* "&&"  */

    #[allow(non_upper_case_globals)]
    const S_tOROP: i32 = 85;       /* "||"  */

    #[allow(non_upper_case_globals)]
    const S_tMATCH: i32 = 86;      /* "=~"  */

    #[allow(non_upper_case_globals)]
    const S_tNMATCH: i32 = 87;     /* "!~"  */

    #[allow(non_upper_case_globals)]
    const S_tDOT2: i32 = 88;       /* ".."  */

    #[allow(non_upper_case_globals)]
    const S_tDOT3: i32 = 89;       /* "..."  */

    #[allow(non_upper_case_globals)]
    const S_tBDOT2: i32 = 90;      /* "(.."  */

    #[allow(non_upper_case_globals)]
    const S_tBDOT3: i32 = 91;      /* "(..."  */

    #[allow(non_upper_case_globals)]
    const S_tAREF: i32 = 92;       /* "[]"  */

    #[allow(non_upper_case_globals)]
    const S_tASET: i32 = 93;       /* "[]="  */

    #[allow(non_upper_case_globals)]
    const S_tLSHFT: i32 = 94;      /* "<<"  */

    #[allow(non_upper_case_globals)]
    const S_tRSHFT: i32 = 95;      /* ">>"  */

    #[allow(non_upper_case_globals)]
    const S_tANDDOT: i32 = 96;     /* "&."  */

    #[allow(non_upper_case_globals)]
    const S_tCOLON2: i32 = 97;     /* "::"  */

    #[allow(non_upper_case_globals)]
    const S_tCOLON3: i32 = 98;     /* ":: at EXPR_BEG"  */

    #[allow(non_upper_case_globals)]
    const S_tOP_ASGN: i32 = 99;    /* "operator-assignment"  */

    #[allow(non_upper_case_globals)]
    const S_tASSOC: i32 = 100;     /* "=>"  */

    #[allow(non_upper_case_globals)]
    const S_tLPAREN: i32 = 101;    /* "("  */

    #[allow(non_upper_case_globals)]
    const S_tLPAREN_ARG: i32 = 102; /* "( arg"  */

    #[allow(non_upper_case_globals)]
    const S_tRPAREN: i32 = 103;    /* ")"  */

    #[allow(non_upper_case_globals)]
    const S_tLBRACK: i32 = 104;    /* "["  */

    #[allow(non_upper_case_globals)]
    const S_tLBRACE: i32 = 105;    /* "{"  */

    #[allow(non_upper_case_globals)]
    const S_tLBRACE_ARG: i32 = 106; /* "{ arg"  */

    #[allow(non_upper_case_globals)]
    const S_tSTAR: i32 = 107;      /* "*"  */

    #[allow(non_upper_case_globals)]
    const S_tDSTAR: i32 = 108;     /* "**arg"  */

    #[allow(non_upper_case_globals)]
    const S_tAMPER: i32 = 109;     /* "&"  */

    #[allow(non_upper_case_globals)]
    const S_tLAMBDA: i32 = 110;    /* "->"  */

    #[allow(non_upper_case_globals)]
    const S_tSYMBEG: i32 = 111;    /* "symbol literal"  */

    #[allow(non_upper_case_globals)]
    const S_tSTRING_BEG: i32 = 112; /* "string begin"  */

    #[allow(non_upper_case_globals)]
    const S_tXSTRING_BEG: i32 = 113; /* "backtick literal"  */

    #[allow(non_upper_case_globals)]
    const S_tREGEXP_BEG: i32 = 114; /* "regexp literal"  */

    #[allow(non_upper_case_globals)]
    const S_tWORDS_BEG: i32 = 115; /* "word list"  */

    #[allow(non_upper_case_globals)]
    const S_tQWORDS_BEG: i32 = 116; /* "verbatim word list"  */

    #[allow(non_upper_case_globals)]
    const S_tSYMBOLS_BEG: i32 = 117; /* "symbol list"  */

    #[allow(non_upper_case_globals)]
    const S_tQSYMBOLS_BEG: i32 = 118; /* "verbatim symbol list"  */

    #[allow(non_upper_case_globals)]
    const S_tSTRING_END: i32 = 119; /* "string end"  */

    #[allow(non_upper_case_globals)]
    const S_tSTRING_DEND: i32 = 120; /* "tRCURLY"  */

    #[allow(non_upper_case_globals)]
    const S_tSTRING_DBEG: i32 = 121; /* tSTRING_DBEG  */

    #[allow(non_upper_case_globals)]
    const S_tSTRING_DVAR: i32 = 122; /* tSTRING_DVAR  */

    #[allow(non_upper_case_globals)]
    const S_tLAMBEG: i32 = 123;    /* tLAMBEG  */

    #[allow(non_upper_case_globals)]
    const S_tLABEL_END: i32 = 124; /* tLABEL_END  */

    #[allow(non_upper_case_globals)]
    const S_tCOMMA: i32 = 125;     /* ","  */

    #[allow(non_upper_case_globals)]
    const S_tLCURLY: i32 = 126;    /* "{ (tLCURLY)"  */

    #[allow(non_upper_case_globals)]
    const S_tRCURLY: i32 = 127;    /* "}"  */

    #[allow(non_upper_case_globals)]
    const S_tLBRACK2: i32 = 128;   /* "[ (tLBRACK2)"  */

    #[allow(non_upper_case_globals)]
    const S_tEQL: i32 = 129;       /* "="  */

    #[allow(non_upper_case_globals)]
    const S_tPIPE: i32 = 130;      /* "|"  */

    #[allow(non_upper_case_globals)]
    const S_tAMPER2: i32 = 131;    /* "& (tAMPER2)"  */

    #[allow(non_upper_case_globals)]
    const S_tGT: i32 = 132;        /* ">"  */

    #[allow(non_upper_case_globals)]
    const S_tLT: i32 = 133;        /* "<"  */

    #[allow(non_upper_case_globals)]
    const S_tBACK_REF2: i32 = 134; /* "`"  */

    #[allow(non_upper_case_globals)]
    const S_tCARET: i32 = 135;     /* "^"  */

    #[allow(non_upper_case_globals)]
    const S_tLPAREN2: i32 = 136;   /* "( (tLPAREN2)"  */

    #[allow(non_upper_case_globals)]
    const S_tRBRACK: i32 = 137;    /* "]"  */

    #[allow(non_upper_case_globals)]
    const S_tSEMI: i32 = 138;      /* ";"  */

    #[allow(non_upper_case_globals)]
    const S_tSPACE: i32 = 139;     /* " "  */

    #[allow(non_upper_case_globals)]
    const S_tNL: i32 = 140;        /* "\n"  */

    #[allow(non_upper_case_globals)]
    const S_tPLUS: i32 = 141;      /* "+"  */

    #[allow(non_upper_case_globals)]
    const S_tMINUS: i32 = 142;     /* "-"  */

    #[allow(non_upper_case_globals)]
    const S_tSTAR2: i32 = 143;     /* "* (tSTAR2)"  */

    #[allow(non_upper_case_globals)]
    const S_tDIVIDE: i32 = 144;    /* "/"  */

    #[allow(non_upper_case_globals)]
    const S_tPERCENT: i32 = 145;   /* "%"  */

    #[allow(non_upper_case_globals)]
    const S_tTILDE: i32 = 146;     /* "~"  */

    #[allow(non_upper_case_globals)]
    const S_tBANG: i32 = 147;      /* "!"  */

    #[allow(non_upper_case_globals)]
    const S_tLOWEST: i32 = 148;    /* tLOWEST  */

    #[allow(non_upper_case_globals)]
    const S_tEH: i32 = 149;        /* tEH  */

    #[allow(non_upper_case_globals)]
    const S_tCOLON: i32 = 150;     /* tCOLON  */

    #[allow(non_upper_case_globals)]
    const S_tUMINUS_NUM: i32 = 151; /* tUMINUS_NUM  */

    #[allow(non_upper_case_globals)]
    const S_tLAST_TOKEN: i32 = 152; /* tLAST_TOKEN  */

    #[allow(non_upper_case_globals)]
    const S_YYACCEPT: i32 = 153;   /* $accept  */

    #[allow(non_upper_case_globals)]
    const S_program: i32 = 154;    /* program  */

    #[allow(non_upper_case_globals)]
    const S_155_1: i32 = 155;      /* @1  */

    #[allow(non_upper_case_globals)]
    const S_top_compstmt: i32 = 156; /* top_compstmt  */

    #[allow(non_upper_case_globals)]
    const S_top_stmts: i32 = 157;  /* top_stmts  */

    #[allow(non_upper_case_globals)]
    const S_top_stmt: i32 = 158;   /* top_stmt  */

    #[allow(non_upper_case_globals)]
    const S_begin_block: i32 = 159; /* begin_block  */

    #[allow(non_upper_case_globals)]
    const S_bodystmt: i32 = 160;   /* bodystmt  */

    #[allow(non_upper_case_globals)]
    const S_compstmt: i32 = 161;   /* compstmt  */

    #[allow(non_upper_case_globals)]
    const S_stmts: i32 = 162;      /* stmts  */

    #[allow(non_upper_case_globals)]
    const S_stmt_or_begin: i32 = 163; /* stmt_or_begin  */

    #[allow(non_upper_case_globals)]
    const S_164_2: i32 = 164;      /* $@2  */

    #[allow(non_upper_case_globals)]
    const S_stmt: i32 = 165;       /* stmt  */

    #[allow(non_upper_case_globals)]
    const S_166_3: i32 = 166;      /* @3  */

    #[allow(non_upper_case_globals)]
    const S_command_asgn: i32 = 167; /* command_asgn  */

    #[allow(non_upper_case_globals)]
    const S_command_rhs: i32 = 168; /* command_rhs  */

    #[allow(non_upper_case_globals)]
    const S_expr: i32 = 169;       /* expr  */

    #[allow(non_upper_case_globals)]
    const S_170_4: i32 = 170;      /* @4  */

    #[allow(non_upper_case_globals)]
    const S_171_5: i32 = 171;      /* @5  */

    #[allow(non_upper_case_globals)]
    const S_def_name: i32 = 172;   /* def_name  */

    #[allow(non_upper_case_globals)]
    const S_defn_head: i32 = 173;  /* defn_head  */

    #[allow(non_upper_case_globals)]
    const S_defs_head: i32 = 174;  /* defs_head  */

    #[allow(non_upper_case_globals)]
    const S_175_6: i32 = 175;      /* @6  */

    #[allow(non_upper_case_globals)]
    const S_expr_value: i32 = 176; /* expr_value  */

    #[allow(non_upper_case_globals)]
    const S_expr_value_do: i32 = 177; /* expr_value_do  */

    #[allow(non_upper_case_globals)]
    const S_178_7: i32 = 178;      /* @7  */

    #[allow(non_upper_case_globals)]
    const S_command_call: i32 = 179; /* command_call  */

    #[allow(non_upper_case_globals)]
    const S_block_command: i32 = 180; /* block_command  */

    #[allow(non_upper_case_globals)]
    const S_cmd_brace_block: i32 = 181; /* cmd_brace_block  */

    #[allow(non_upper_case_globals)]
    const S_182_8: i32 = 182;      /* @8  */

    #[allow(non_upper_case_globals)]
    const S_fcall: i32 = 183;      /* fcall  */

    #[allow(non_upper_case_globals)]
    const S_command: i32 = 184;    /* command  */

    #[allow(non_upper_case_globals)]
    const S_mlhs: i32 = 185;       /* mlhs  */

    #[allow(non_upper_case_globals)]
    const S_mlhs_inner: i32 = 186; /* mlhs_inner  */

    #[allow(non_upper_case_globals)]
    const S_mlhs_basic: i32 = 187; /* mlhs_basic  */

    #[allow(non_upper_case_globals)]
    const S_mlhs_item: i32 = 188;  /* mlhs_item  */

    #[allow(non_upper_case_globals)]
    const S_mlhs_head: i32 = 189;  /* mlhs_head  */

    #[allow(non_upper_case_globals)]
    const S_mlhs_post: i32 = 190;  /* mlhs_post  */

    #[allow(non_upper_case_globals)]
    const S_mlhs_node: i32 = 191;  /* mlhs_node  */

    #[allow(non_upper_case_globals)]
    const S_lhs: i32 = 192;        /* lhs  */

    #[allow(non_upper_case_globals)]
    const S_cname: i32 = 193;      /* cname  */

    #[allow(non_upper_case_globals)]
    const S_cpath: i32 = 194;      /* cpath  */

    #[allow(non_upper_case_globals)]
    const S_fname: i32 = 195;      /* fname  */

    #[allow(non_upper_case_globals)]
    const S_fitem: i32 = 196;      /* fitem  */

    #[allow(non_upper_case_globals)]
    const S_undef_list: i32 = 197; /* undef_list  */

    #[allow(non_upper_case_globals)]
    const S_198_9: i32 = 198;      /* @9  */

    #[allow(non_upper_case_globals)]
    const S_op: i32 = 199;         /* op  */

    #[allow(non_upper_case_globals)]
    const S_reswords: i32 = 200;   /* reswords  */

    #[allow(non_upper_case_globals)]
    const S_arg: i32 = 201;        /* arg  */

    #[allow(non_upper_case_globals)]
    const S_relop: i32 = 202;      /* relop  */

    #[allow(non_upper_case_globals)]
    const S_rel_expr: i32 = 203;   /* rel_expr  */

    #[allow(non_upper_case_globals)]
    const S_arg_value: i32 = 204;  /* arg_value  */

    #[allow(non_upper_case_globals)]
    const S_aref_args: i32 = 205;  /* aref_args  */

    #[allow(non_upper_case_globals)]
    const S_arg_rhs: i32 = 206;    /* arg_rhs  */

    #[allow(non_upper_case_globals)]
    const S_paren_args: i32 = 207; /* paren_args  */

    #[allow(non_upper_case_globals)]
    const S_opt_paren_args: i32 = 208; /* opt_paren_args  */

    #[allow(non_upper_case_globals)]
    const S_opt_call_args: i32 = 209; /* opt_call_args  */

    #[allow(non_upper_case_globals)]
    const S_call_args: i32 = 210;  /* call_args  */

    #[allow(non_upper_case_globals)]
    const S_command_args: i32 = 211; /* command_args  */

    #[allow(non_upper_case_globals)]
    const S_212_10: i32 = 212;     /* @10  */

    #[allow(non_upper_case_globals)]
    const S_block_arg: i32 = 213;  /* block_arg  */

    #[allow(non_upper_case_globals)]
    const S_opt_block_arg: i32 = 214; /* opt_block_arg  */

    #[allow(non_upper_case_globals)]
    const S_args: i32 = 215;       /* args  */

    #[allow(non_upper_case_globals)]
    const S_mrhs_arg: i32 = 216;   /* mrhs_arg  */

    #[allow(non_upper_case_globals)]
    const S_mrhs: i32 = 217;       /* mrhs  */

    #[allow(non_upper_case_globals)]
    const S_primary: i32 = 218;    /* primary  */

    #[allow(non_upper_case_globals)]
    const S_219_11: i32 = 219;     /* @11  */

    #[allow(non_upper_case_globals)]
    const S_220_12: i32 = 220;     /* @12  */

    #[allow(non_upper_case_globals)]
    const S_221_13: i32 = 221;     /* @13  */

    #[allow(non_upper_case_globals)]
    const S_222_14: i32 = 222;     /* @14  */

    #[allow(non_upper_case_globals)]
    const S_223_15: i32 = 223;     /* @15  */

    #[allow(non_upper_case_globals)]
    const S_224_16: i32 = 224;     /* @16  */

    #[allow(non_upper_case_globals)]
    const S_225_17: i32 = 225;     /* @17  */

    #[allow(non_upper_case_globals)]
    const S_226_18: i32 = 226;     /* @18  */

    #[allow(non_upper_case_globals)]
    const S_primary_value: i32 = 227; /* primary_value  */

    #[allow(non_upper_case_globals)]
    const S_k_begin: i32 = 228;    /* k_begin  */

    #[allow(non_upper_case_globals)]
    const S_k_if: i32 = 229;       /* k_if  */

    #[allow(non_upper_case_globals)]
    const S_k_unless: i32 = 230;   /* k_unless  */

    #[allow(non_upper_case_globals)]
    const S_k_while: i32 = 231;    /* k_while  */

    #[allow(non_upper_case_globals)]
    const S_k_until: i32 = 232;    /* k_until  */

    #[allow(non_upper_case_globals)]
    const S_k_case: i32 = 233;     /* k_case  */

    #[allow(non_upper_case_globals)]
    const S_k_for: i32 = 234;      /* k_for  */

    #[allow(non_upper_case_globals)]
    const S_k_class: i32 = 235;    /* k_class  */

    #[allow(non_upper_case_globals)]
    const S_k_module: i32 = 236;   /* k_module  */

    #[allow(non_upper_case_globals)]
    const S_k_def: i32 = 237;      /* k_def  */

    #[allow(non_upper_case_globals)]
    const S_k_do: i32 = 238;       /* k_do  */

    #[allow(non_upper_case_globals)]
    const S_k_do_block: i32 = 239; /* k_do_block  */

    #[allow(non_upper_case_globals)]
    const S_k_rescue: i32 = 240;   /* k_rescue  */

    #[allow(non_upper_case_globals)]
    const S_k_ensure: i32 = 241;   /* k_ensure  */

    #[allow(non_upper_case_globals)]
    const S_k_when: i32 = 242;     /* k_when  */

    #[allow(non_upper_case_globals)]
    const S_k_else: i32 = 243;     /* k_else  */

    #[allow(non_upper_case_globals)]
    const S_k_elsif: i32 = 244;    /* k_elsif  */

    #[allow(non_upper_case_globals)]
    const S_k_end: i32 = 245;      /* k_end  */

    #[allow(non_upper_case_globals)]
    const S_k_return: i32 = 246;   /* k_return  */

    #[allow(non_upper_case_globals)]
    const S_then: i32 = 247;       /* then  */

    #[allow(non_upper_case_globals)]
    const S_do: i32 = 248;         /* do  */

    #[allow(non_upper_case_globals)]
    const S_if_tail: i32 = 249;    /* if_tail  */

    #[allow(non_upper_case_globals)]
    const S_opt_else: i32 = 250;   /* opt_else  */

    #[allow(non_upper_case_globals)]
    const S_for_var: i32 = 251;    /* for_var  */

    #[allow(non_upper_case_globals)]
    const S_f_marg: i32 = 252;     /* f_marg  */

    #[allow(non_upper_case_globals)]
    const S_f_marg_list: i32 = 253; /* f_marg_list  */

    #[allow(non_upper_case_globals)]
    const S_f_margs: i32 = 254;    /* f_margs  */

    #[allow(non_upper_case_globals)]
    const S_f_rest_marg: i32 = 255; /* f_rest_marg  */

    #[allow(non_upper_case_globals)]
    const S_f_any_kwrest: i32 = 256; /* f_any_kwrest  */

    #[allow(non_upper_case_globals)]
    const S_block_args_tail: i32 = 257; /* block_args_tail  */

    #[allow(non_upper_case_globals)]
    const S_opt_block_args_tail: i32 = 258; /* opt_block_args_tail  */

    #[allow(non_upper_case_globals)]
    const S_excessed_comma: i32 = 259; /* excessed_comma  */

    #[allow(non_upper_case_globals)]
    const S_block_param: i32 = 260; /* block_param  */

    #[allow(non_upper_case_globals)]
    const S_opt_block_param: i32 = 261; /* opt_block_param  */

    #[allow(non_upper_case_globals)]
    const S_block_param_def: i32 = 262; /* block_param_def  */

    #[allow(non_upper_case_globals)]
    const S_opt_bv_decl: i32 = 263; /* opt_bv_decl  */

    #[allow(non_upper_case_globals)]
    const S_bv_decls: i32 = 264;   /* bv_decls  */

    #[allow(non_upper_case_globals)]
    const S_bvar: i32 = 265;       /* bvar  */

    #[allow(non_upper_case_globals)]
    const S_lambda: i32 = 266;     /* lambda  */

    #[allow(non_upper_case_globals)]
    const S_267_19: i32 = 267;     /* @19  */

    #[allow(non_upper_case_globals)]
    const S_268_20: i32 = 268;     /* @20  */

    #[allow(non_upper_case_globals)]
    const S_f_larglist: i32 = 269; /* f_larglist  */

    #[allow(non_upper_case_globals)]
    const S_lambda_body: i32 = 270; /* lambda_body  */

    #[allow(non_upper_case_globals)]
    const S_271_21: i32 = 271;     /* @21  */

    #[allow(non_upper_case_globals)]
    const S_272_22: i32 = 272;     /* @22  */

    #[allow(non_upper_case_globals)]
    const S_do_block: i32 = 273;   /* do_block  */

    #[allow(non_upper_case_globals)]
    const S_274_23: i32 = 274;     /* @23  */

    #[allow(non_upper_case_globals)]
    const S_block_call: i32 = 275; /* block_call  */

    #[allow(non_upper_case_globals)]
    const S_method_call: i32 = 276; /* method_call  */

    #[allow(non_upper_case_globals)]
    const S_brace_block: i32 = 277; /* brace_block  */

    #[allow(non_upper_case_globals)]
    const S_278_24: i32 = 278;     /* @24  */

    #[allow(non_upper_case_globals)]
    const S_279_25: i32 = 279;     /* @25  */

    #[allow(non_upper_case_globals)]
    const S_brace_body: i32 = 280; /* brace_body  */

    #[allow(non_upper_case_globals)]
    const S_281_26: i32 = 281;     /* @26  */

    #[allow(non_upper_case_globals)]
    const S_do_body: i32 = 282;    /* do_body  */

    #[allow(non_upper_case_globals)]
    const S_283_27: i32 = 283;     /* @27  */

    #[allow(non_upper_case_globals)]
    const S_case_args: i32 = 284;  /* case_args  */

    #[allow(non_upper_case_globals)]
    const S_case_body: i32 = 285;  /* case_body  */

    #[allow(non_upper_case_globals)]
    const S_cases: i32 = 286;      /* cases  */

    #[allow(non_upper_case_globals)]
    const S_p_case_body: i32 = 287; /* p_case_body  */

    #[allow(non_upper_case_globals)]
    const S_288_28: i32 = 288;     /* @28  */

    #[allow(non_upper_case_globals)]
    const S_289_29: i32 = 289;     /* @29  */

    #[allow(non_upper_case_globals)]
    const S_p_cases: i32 = 290;    /* p_cases  */

    #[allow(non_upper_case_globals)]
    const S_p_top_expr: i32 = 291; /* p_top_expr  */

    #[allow(non_upper_case_globals)]
    const S_p_top_expr_body: i32 = 292; /* p_top_expr_body  */

    #[allow(non_upper_case_globals)]
    const S_p_expr: i32 = 293;     /* p_expr  */

    #[allow(non_upper_case_globals)]
    const S_p_as: i32 = 294;       /* p_as  */

    #[allow(non_upper_case_globals)]
    const S_p_alt: i32 = 295;      /* p_alt  */

    #[allow(non_upper_case_globals)]
    const S_p_lparen: i32 = 296;   /* p_lparen  */

    #[allow(non_upper_case_globals)]
    const S_p_lbracket: i32 = 297; /* p_lbracket  */

    #[allow(non_upper_case_globals)]
    const S_p_expr_basic: i32 = 298; /* p_expr_basic  */

    #[allow(non_upper_case_globals)]
    const S_299_30: i32 = 299;     /* @30  */

    #[allow(non_upper_case_globals)]
    const S_300_31: i32 = 300;     /* @31  */

    #[allow(non_upper_case_globals)]
    const S_p_args: i32 = 301;     /* p_args  */

    #[allow(non_upper_case_globals)]
    const S_p_args_head: i32 = 302; /* p_args_head  */

    #[allow(non_upper_case_globals)]
    const S_p_args_tail: i32 = 303; /* p_args_tail  */

    #[allow(non_upper_case_globals)]
    const S_p_find: i32 = 304;     /* p_find  */

    #[allow(non_upper_case_globals)]
    const S_p_rest: i32 = 305;     /* p_rest  */

    #[allow(non_upper_case_globals)]
    const S_p_args_post: i32 = 306; /* p_args_post  */

    #[allow(non_upper_case_globals)]
    const S_p_arg: i32 = 307;      /* p_arg  */

    #[allow(non_upper_case_globals)]
    const S_p_kwargs: i32 = 308;   /* p_kwargs  */

    #[allow(non_upper_case_globals)]
    const S_p_kwarg: i32 = 309;    /* p_kwarg  */

    #[allow(non_upper_case_globals)]
    const S_p_kw: i32 = 310;       /* p_kw  */

    #[allow(non_upper_case_globals)]
    const S_p_kw_label: i32 = 311; /* p_kw_label  */

    #[allow(non_upper_case_globals)]
    const S_p_kwrest: i32 = 312;   /* p_kwrest  */

    #[allow(non_upper_case_globals)]
    const S_p_kwnorest: i32 = 313; /* p_kwnorest  */

    #[allow(non_upper_case_globals)]
    const S_p_any_kwrest: i32 = 314; /* p_any_kwrest  */

    #[allow(non_upper_case_globals)]
    const S_p_value: i32 = 315;    /* p_value  */

    #[allow(non_upper_case_globals)]
    const S_p_primitive: i32 = 316; /* p_primitive  */

    #[allow(non_upper_case_globals)]
    const S_p_variable: i32 = 317; /* p_variable  */

    #[allow(non_upper_case_globals)]
    const S_p_var_ref: i32 = 318;  /* p_var_ref  */

    #[allow(non_upper_case_globals)]
    const S_p_const: i32 = 319;    /* p_const  */

    #[allow(non_upper_case_globals)]
    const S_opt_rescue: i32 = 320; /* opt_rescue  */

    #[allow(non_upper_case_globals)]
    const S_exc_list: i32 = 321;   /* exc_list  */

    #[allow(non_upper_case_globals)]
    const S_exc_var: i32 = 322;    /* exc_var  */

    #[allow(non_upper_case_globals)]
    const S_opt_ensure: i32 = 323; /* opt_ensure  */

    #[allow(non_upper_case_globals)]
    const S_literal: i32 = 324;    /* literal  */

    #[allow(non_upper_case_globals)]
    const S_strings: i32 = 325;    /* strings  */

    #[allow(non_upper_case_globals)]
    const S_string: i32 = 326;     /* string  */

    #[allow(non_upper_case_globals)]
    const S_string1: i32 = 327;    /* string1  */

    #[allow(non_upper_case_globals)]
    const S_xstring: i32 = 328;    /* xstring  */

    #[allow(non_upper_case_globals)]
    const S_regexp: i32 = 329;     /* regexp  */

    #[allow(non_upper_case_globals)]
    const S_words: i32 = 330;      /* words  */

    #[allow(non_upper_case_globals)]
    const S_word_list: i32 = 331;  /* word_list  */

    #[allow(non_upper_case_globals)]
    const S_word: i32 = 332;       /* word  */

    #[allow(non_upper_case_globals)]
    const S_symbols: i32 = 333;    /* symbols  */

    #[allow(non_upper_case_globals)]
    const S_symbol_list: i32 = 334; /* symbol_list  */

    #[allow(non_upper_case_globals)]
    const S_qwords: i32 = 335;     /* qwords  */

    #[allow(non_upper_case_globals)]
    const S_qsymbols: i32 = 336;   /* qsymbols  */

    #[allow(non_upper_case_globals)]
    const S_qword_list: i32 = 337; /* qword_list  */

    #[allow(non_upper_case_globals)]
    const S_qsym_list: i32 = 338;  /* qsym_list  */

    #[allow(non_upper_case_globals)]
    const S_string_contents: i32 = 339; /* string_contents  */

    #[allow(non_upper_case_globals)]
    const S_xstring_contents: i32 = 340; /* xstring_contents  */

    #[allow(non_upper_case_globals)]
    const S_regexp_contents: i32 = 341; /* regexp_contents  */

    #[allow(non_upper_case_globals)]
    const S_string_content: i32 = 342; /* string_content  */

    #[allow(non_upper_case_globals)]
    const S_343_32: i32 = 343;     /* @32  */

    #[allow(non_upper_case_globals)]
    const S_344_33: i32 = 344;     /* @33  */

    #[allow(non_upper_case_globals)]
    const S_345_34: i32 = 345;     /* @34  */

    #[allow(non_upper_case_globals)]
    const S_346_35: i32 = 346;     /* @35  */

    #[allow(non_upper_case_globals)]
    const S_347_36: i32 = 347;     /* @36  */

    #[allow(non_upper_case_globals)]
    const S_348_37: i32 = 348;     /* @37  */

    #[allow(non_upper_case_globals)]
    const S_string_dvar: i32 = 349; /* string_dvar  */

    #[allow(non_upper_case_globals)]
    const S_symbol: i32 = 350;     /* symbol  */

    #[allow(non_upper_case_globals)]
    const S_ssym: i32 = 351;       /* ssym  */

    #[allow(non_upper_case_globals)]
    const S_sym: i32 = 352;        /* sym  */

    #[allow(non_upper_case_globals)]
    const S_dsym: i32 = 353;       /* dsym  */

    #[allow(non_upper_case_globals)]
    const S_numeric: i32 = 354;    /* numeric  */

    #[allow(non_upper_case_globals)]
    const S_simple_numeric: i32 = 355; /* simple_numeric  */

    #[allow(non_upper_case_globals)]
    const S_user_variable: i32 = 356; /* user_variable  */

    #[allow(non_upper_case_globals)]
    const S_keyword_variable: i32 = 357; /* keyword_variable  */

    #[allow(non_upper_case_globals)]
    const S_var_ref: i32 = 358;    /* var_ref  */

    #[allow(non_upper_case_globals)]
    const S_var_lhs: i32 = 359;    /* var_lhs  */

    #[allow(non_upper_case_globals)]
    const S_backref: i32 = 360;    /* backref  */

    #[allow(non_upper_case_globals)]
    const S_superclass: i32 = 361; /* superclass  */

    #[allow(non_upper_case_globals)]
    const S_362_38: i32 = 362;     /* @38  */

    #[allow(non_upper_case_globals)]
    const S_f_opt_paren_args: i32 = 363; /* f_opt_paren_args  */

    #[allow(non_upper_case_globals)]
    const S_f_paren_args: i32 = 364; /* f_paren_args  */

    #[allow(non_upper_case_globals)]
    const S_f_arglist: i32 = 365;  /* f_arglist  */

    #[allow(non_upper_case_globals)]
    const S_366_39: i32 = 366;     /* @39  */

    #[allow(non_upper_case_globals)]
    const S_args_tail: i32 = 367;  /* args_tail  */

    #[allow(non_upper_case_globals)]
    const S_opt_args_tail: i32 = 368; /* opt_args_tail  */

    #[allow(non_upper_case_globals)]
    const S_f_args: i32 = 369;     /* f_args  */

    #[allow(non_upper_case_globals)]
    const S_args_forward: i32 = 370; /* args_forward  */

    #[allow(non_upper_case_globals)]
    const S_f_bad_arg: i32 = 371;  /* f_bad_arg  */

    #[allow(non_upper_case_globals)]
    const S_f_norm_arg: i32 = 372; /* f_norm_arg  */

    #[allow(non_upper_case_globals)]
    const S_f_arg_asgn: i32 = 373; /* f_arg_asgn  */

    #[allow(non_upper_case_globals)]
    const S_f_arg_item: i32 = 374; /* f_arg_item  */

    #[allow(non_upper_case_globals)]
    const S_f_arg: i32 = 375;      /* f_arg  */

    #[allow(non_upper_case_globals)]
    const S_f_label: i32 = 376;    /* f_label  */

    #[allow(non_upper_case_globals)]
    const S_f_kw: i32 = 377;       /* f_kw  */

    #[allow(non_upper_case_globals)]
    const S_f_block_kw: i32 = 378; /* f_block_kw  */

    #[allow(non_upper_case_globals)]
    const S_f_block_kwarg: i32 = 379; /* f_block_kwarg  */

    #[allow(non_upper_case_globals)]
    const S_f_kwarg: i32 = 380;    /* f_kwarg  */

    #[allow(non_upper_case_globals)]
    const S_kwrest_mark: i32 = 381; /* kwrest_mark  */

    #[allow(non_upper_case_globals)]
    const S_f_no_kwarg: i32 = 382; /* f_no_kwarg  */

    #[allow(non_upper_case_globals)]
    const S_f_kwrest: i32 = 383;   /* f_kwrest  */

    #[allow(non_upper_case_globals)]
    const S_f_opt: i32 = 384;      /* f_opt  */

    #[allow(non_upper_case_globals)]
    const S_f_block_opt: i32 = 385; /* f_block_opt  */

    #[allow(non_upper_case_globals)]
    const S_f_block_optarg: i32 = 386; /* f_block_optarg  */

    #[allow(non_upper_case_globals)]
    const S_f_optarg: i32 = 387;   /* f_optarg  */

    #[allow(non_upper_case_globals)]
    const S_restarg_mark: i32 = 388; /* restarg_mark  */

    #[allow(non_upper_case_globals)]
    const S_f_rest_arg: i32 = 389; /* f_rest_arg  */

    #[allow(non_upper_case_globals)]
    const S_blkarg_mark: i32 = 390; /* blkarg_mark  */

    #[allow(non_upper_case_globals)]
    const S_f_block_arg: i32 = 391; /* f_block_arg  */

    #[allow(non_upper_case_globals)]
    const S_opt_f_block_arg: i32 = 392; /* opt_f_block_arg  */

    #[allow(non_upper_case_globals)]
    const S_singleton: i32 = 393;  /* singleton  */

    #[allow(non_upper_case_globals)]
    const S_394_40: i32 = 394;     /* @40  */

    #[allow(non_upper_case_globals)]
    const S_assoc_list: i32 = 395; /* assoc_list  */

    #[allow(non_upper_case_globals)]
    const S_assocs: i32 = 396;     /* assocs  */

    #[allow(non_upper_case_globals)]
    const S_assoc: i32 = 397;      /* assoc  */

    #[allow(non_upper_case_globals)]
    const S_operation: i32 = 398;  /* operation  */

    #[allow(non_upper_case_globals)]
    const S_operation2: i32 = 399; /* operation2  */

    #[allow(non_upper_case_globals)]
    const S_operation3: i32 = 400; /* operation3  */

    #[allow(non_upper_case_globals)]
    const S_dot_or_colon: i32 = 401; /* dot_or_colon  */

    #[allow(non_upper_case_globals)]
    const S_call_op: i32 = 402;    /* call_op  */

    #[allow(non_upper_case_globals)]
    const S_call_op2: i32 = 403;   /* call_op2  */

    #[allow(non_upper_case_globals)]
    const S_opt_terms: i32 = 404;  /* opt_terms  */

    #[allow(non_upper_case_globals)]
    const S_opt_nl: i32 = 405;     /* opt_nl  */

    #[allow(non_upper_case_globals)]
    const S_rparen: i32 = 406;     /* rparen  */

    #[allow(non_upper_case_globals)]
    const S_rbracket: i32 = 407;   /* rbracket  */

    #[allow(non_upper_case_globals)]
    const S_rbrace: i32 = 408;     /* rbrace  */

    #[allow(non_upper_case_globals)]
    const S_trailer: i32 = 409;    /* trailer  */

    #[allow(non_upper_case_globals)]
    const S_term: i32 = 410;       /* term  */

    #[allow(non_upper_case_globals)]
    const S_terms: i32 = 411;      /* terms  */

    #[allow(non_upper_case_globals)]
    const S_none: i32 = 412;       /* none  */


    const VALUES_: &'static [SymbolKind] = &[ 
        SymbolKind { value: SymbolKind::S_YYEOF },
        SymbolKind { value: SymbolKind::S_YYerror },
        SymbolKind { value: SymbolKind::S_YYUNDEF },
        SymbolKind { value: SymbolKind::S_kCLASS },
        SymbolKind { value: SymbolKind::S_kMODULE },
        SymbolKind { value: SymbolKind::S_kDEF },
        SymbolKind { value: SymbolKind::S_kUNDEF },
        SymbolKind { value: SymbolKind::S_kBEGIN },
        SymbolKind { value: SymbolKind::S_kRESCUE },
        SymbolKind { value: SymbolKind::S_kENSURE },
        SymbolKind { value: SymbolKind::S_kEND },
        SymbolKind { value: SymbolKind::S_kIF },
        SymbolKind { value: SymbolKind::S_kUNLESS },
        SymbolKind { value: SymbolKind::S_kTHEN },
        SymbolKind { value: SymbolKind::S_kELSIF },
        SymbolKind { value: SymbolKind::S_kELSE },
        SymbolKind { value: SymbolKind::S_kCASE },
        SymbolKind { value: SymbolKind::S_kWHEN },
        SymbolKind { value: SymbolKind::S_kWHILE },
        SymbolKind { value: SymbolKind::S_kUNTIL },
        SymbolKind { value: SymbolKind::S_kFOR },
        SymbolKind { value: SymbolKind::S_kBREAK },
        SymbolKind { value: SymbolKind::S_kNEXT },
        SymbolKind { value: SymbolKind::S_kREDO },
        SymbolKind { value: SymbolKind::S_kRETRY },
        SymbolKind { value: SymbolKind::S_kIN },
        SymbolKind { value: SymbolKind::S_kDO },
        SymbolKind { value: SymbolKind::S_kDO_COND },
        SymbolKind { value: SymbolKind::S_kDO_BLOCK },
        SymbolKind { value: SymbolKind::S_kDO_LAMBDA },
        SymbolKind { value: SymbolKind::S_kRETURN },
        SymbolKind { value: SymbolKind::S_kYIELD },
        SymbolKind { value: SymbolKind::S_kSUPER },
        SymbolKind { value: SymbolKind::S_kSELF },
        SymbolKind { value: SymbolKind::S_kNIL },
        SymbolKind { value: SymbolKind::S_kTRUE },
        SymbolKind { value: SymbolKind::S_kFALSE },
        SymbolKind { value: SymbolKind::S_kAND },
        SymbolKind { value: SymbolKind::S_kOR },
        SymbolKind { value: SymbolKind::S_kNOT },
        SymbolKind { value: SymbolKind::S_kIF_MOD },
        SymbolKind { value: SymbolKind::S_kUNLESS_MOD },
        SymbolKind { value: SymbolKind::S_kWHILE_MOD },
        SymbolKind { value: SymbolKind::S_kUNTIL_MOD },
        SymbolKind { value: SymbolKind::S_kRESCUE_MOD },
        SymbolKind { value: SymbolKind::S_kALIAS },
        SymbolKind { value: SymbolKind::S_kDEFINED },
        SymbolKind { value: SymbolKind::S_klBEGIN },
        SymbolKind { value: SymbolKind::S_klEND },
        SymbolKind { value: SymbolKind::S_k__LINE__ },
        SymbolKind { value: SymbolKind::S_k__FILE__ },
        SymbolKind { value: SymbolKind::S_k__ENCODING__ },
        SymbolKind { value: SymbolKind::S_tIDENTIFIER },
        SymbolKind { value: SymbolKind::S_tFID },
        SymbolKind { value: SymbolKind::S_tGVAR },
        SymbolKind { value: SymbolKind::S_tIVAR },
        SymbolKind { value: SymbolKind::S_tCONSTANT },
        SymbolKind { value: SymbolKind::S_tCVAR },
        SymbolKind { value: SymbolKind::S_tLABEL },
        SymbolKind { value: SymbolKind::S_tINTEGER },
        SymbolKind { value: SymbolKind::S_tFLOAT },
        SymbolKind { value: SymbolKind::S_tRATIONAL },
        SymbolKind { value: SymbolKind::S_tIMAGINARY },
        SymbolKind { value: SymbolKind::S_tCHAR },
        SymbolKind { value: SymbolKind::S_tNTH_REF },
        SymbolKind { value: SymbolKind::S_tBACK_REF },
        SymbolKind { value: SymbolKind::S_tSTRING_CONTENT },
        SymbolKind { value: SymbolKind::S_tREGEXP_END },
        SymbolKind { value: SymbolKind::S_tDOT },
        SymbolKind { value: SymbolKind::S_tBACKSLASH },
        SymbolKind { value: SymbolKind::S_tSP },
        SymbolKind { value: SymbolKind::S_tSLASH_T },
        SymbolKind { value: SymbolKind::S_tSLASH_F },
        SymbolKind { value: SymbolKind::S_tSLASH_R },
        SymbolKind { value: SymbolKind::S_tVTAB },
        SymbolKind { value: SymbolKind::S_tUPLUS },
        SymbolKind { value: SymbolKind::S_tUMINUS },
        SymbolKind { value: SymbolKind::S_tPOW },
        SymbolKind { value: SymbolKind::S_tCMP },
        SymbolKind { value: SymbolKind::S_tEQ },
        SymbolKind { value: SymbolKind::S_tEQQ },
        SymbolKind { value: SymbolKind::S_tNEQ },
        SymbolKind { value: SymbolKind::S_tGEQ },
        SymbolKind { value: SymbolKind::S_tLEQ },
        SymbolKind { value: SymbolKind::S_tANDOP },
        SymbolKind { value: SymbolKind::S_tOROP },
        SymbolKind { value: SymbolKind::S_tMATCH },
        SymbolKind { value: SymbolKind::S_tNMATCH },
        SymbolKind { value: SymbolKind::S_tDOT2 },
        SymbolKind { value: SymbolKind::S_tDOT3 },
        SymbolKind { value: SymbolKind::S_tBDOT2 },
        SymbolKind { value: SymbolKind::S_tBDOT3 },
        SymbolKind { value: SymbolKind::S_tAREF },
        SymbolKind { value: SymbolKind::S_tASET },
        SymbolKind { value: SymbolKind::S_tLSHFT },
        SymbolKind { value: SymbolKind::S_tRSHFT },
        SymbolKind { value: SymbolKind::S_tANDDOT },
        SymbolKind { value: SymbolKind::S_tCOLON2 },
        SymbolKind { value: SymbolKind::S_tCOLON3 },
        SymbolKind { value: SymbolKind::S_tOP_ASGN },
        SymbolKind { value: SymbolKind::S_tASSOC },
        SymbolKind { value: SymbolKind::S_tLPAREN },
        SymbolKind { value: SymbolKind::S_tLPAREN_ARG },
        SymbolKind { value: SymbolKind::S_tRPAREN },
        SymbolKind { value: SymbolKind::S_tLBRACK },
        SymbolKind { value: SymbolKind::S_tLBRACE },
        SymbolKind { value: SymbolKind::S_tLBRACE_ARG },
        SymbolKind { value: SymbolKind::S_tSTAR },
        SymbolKind { value: SymbolKind::S_tDSTAR },
        SymbolKind { value: SymbolKind::S_tAMPER },
        SymbolKind { value: SymbolKind::S_tLAMBDA },
        SymbolKind { value: SymbolKind::S_tSYMBEG },
        SymbolKind { value: SymbolKind::S_tSTRING_BEG },
        SymbolKind { value: SymbolKind::S_tXSTRING_BEG },
        SymbolKind { value: SymbolKind::S_tREGEXP_BEG },
        SymbolKind { value: SymbolKind::S_tWORDS_BEG },
        SymbolKind { value: SymbolKind::S_tQWORDS_BEG },
        SymbolKind { value: SymbolKind::S_tSYMBOLS_BEG },
        SymbolKind { value: SymbolKind::S_tQSYMBOLS_BEG },
        SymbolKind { value: SymbolKind::S_tSTRING_END },
        SymbolKind { value: SymbolKind::S_tSTRING_DEND },
        SymbolKind { value: SymbolKind::S_tSTRING_DBEG },
        SymbolKind { value: SymbolKind::S_tSTRING_DVAR },
        SymbolKind { value: SymbolKind::S_tLAMBEG },
        SymbolKind { value: SymbolKind::S_tLABEL_END },
        SymbolKind { value: SymbolKind::S_tCOMMA },
        SymbolKind { value: SymbolKind::S_tLCURLY },
        SymbolKind { value: SymbolKind::S_tRCURLY },
        SymbolKind { value: SymbolKind::S_tLBRACK2 },
        SymbolKind { value: SymbolKind::S_tEQL },
        SymbolKind { value: SymbolKind::S_tPIPE },
        SymbolKind { value: SymbolKind::S_tAMPER2 },
        SymbolKind { value: SymbolKind::S_tGT },
        SymbolKind { value: SymbolKind::S_tLT },
        SymbolKind { value: SymbolKind::S_tBACK_REF2 },
        SymbolKind { value: SymbolKind::S_tCARET },
        SymbolKind { value: SymbolKind::S_tLPAREN2 },
        SymbolKind { value: SymbolKind::S_tRBRACK },
        SymbolKind { value: SymbolKind::S_tSEMI },
        SymbolKind { value: SymbolKind::S_tSPACE },
        SymbolKind { value: SymbolKind::S_tNL },
        SymbolKind { value: SymbolKind::S_tPLUS },
        SymbolKind { value: SymbolKind::S_tMINUS },
        SymbolKind { value: SymbolKind::S_tSTAR2 },
        SymbolKind { value: SymbolKind::S_tDIVIDE },
        SymbolKind { value: SymbolKind::S_tPERCENT },
        SymbolKind { value: SymbolKind::S_tTILDE },
        SymbolKind { value: SymbolKind::S_tBANG },
        SymbolKind { value: SymbolKind::S_tLOWEST },
        SymbolKind { value: SymbolKind::S_tEH },
        SymbolKind { value: SymbolKind::S_tCOLON },
        SymbolKind { value: SymbolKind::S_tUMINUS_NUM },
        SymbolKind { value: SymbolKind::S_tLAST_TOKEN },
        SymbolKind { value: SymbolKind::S_YYACCEPT },
        SymbolKind { value: SymbolKind::S_program },
        SymbolKind { value: SymbolKind::S_155_1 },
        SymbolKind { value: SymbolKind::S_top_compstmt },
        SymbolKind { value: SymbolKind::S_top_stmts },
        SymbolKind { value: SymbolKind::S_top_stmt },
        SymbolKind { value: SymbolKind::S_begin_block },
        SymbolKind { value: SymbolKind::S_bodystmt },
        SymbolKind { value: SymbolKind::S_compstmt },
        SymbolKind { value: SymbolKind::S_stmts },
        SymbolKind { value: SymbolKind::S_stmt_or_begin },
        SymbolKind { value: SymbolKind::S_164_2 },
        SymbolKind { value: SymbolKind::S_stmt },
        SymbolKind { value: SymbolKind::S_166_3 },
        SymbolKind { value: SymbolKind::S_command_asgn },
        SymbolKind { value: SymbolKind::S_command_rhs },
        SymbolKind { value: SymbolKind::S_expr },
        SymbolKind { value: SymbolKind::S_170_4 },
        SymbolKind { value: SymbolKind::S_171_5 },
        SymbolKind { value: SymbolKind::S_def_name },
        SymbolKind { value: SymbolKind::S_defn_head },
        SymbolKind { value: SymbolKind::S_defs_head },
        SymbolKind { value: SymbolKind::S_175_6 },
        SymbolKind { value: SymbolKind::S_expr_value },
        SymbolKind { value: SymbolKind::S_expr_value_do },
        SymbolKind { value: SymbolKind::S_178_7 },
        SymbolKind { value: SymbolKind::S_command_call },
        SymbolKind { value: SymbolKind::S_block_command },
        SymbolKind { value: SymbolKind::S_cmd_brace_block },
        SymbolKind { value: SymbolKind::S_182_8 },
        SymbolKind { value: SymbolKind::S_fcall },
        SymbolKind { value: SymbolKind::S_command },
        SymbolKind { value: SymbolKind::S_mlhs },
        SymbolKind { value: SymbolKind::S_mlhs_inner },
        SymbolKind { value: SymbolKind::S_mlhs_basic },
        SymbolKind { value: SymbolKind::S_mlhs_item },
        SymbolKind { value: SymbolKind::S_mlhs_head },
        SymbolKind { value: SymbolKind::S_mlhs_post },
        SymbolKind { value: SymbolKind::S_mlhs_node },
        SymbolKind { value: SymbolKind::S_lhs },
        SymbolKind { value: SymbolKind::S_cname },
        SymbolKind { value: SymbolKind::S_cpath },
        SymbolKind { value: SymbolKind::S_fname },
        SymbolKind { value: SymbolKind::S_fitem },
        SymbolKind { value: SymbolKind::S_undef_list },
        SymbolKind { value: SymbolKind::S_198_9 },
        SymbolKind { value: SymbolKind::S_op },
        SymbolKind { value: SymbolKind::S_reswords },
        SymbolKind { value: SymbolKind::S_arg },
        SymbolKind { value: SymbolKind::S_relop },
        SymbolKind { value: SymbolKind::S_rel_expr },
        SymbolKind { value: SymbolKind::S_arg_value },
        SymbolKind { value: SymbolKind::S_aref_args },
        SymbolKind { value: SymbolKind::S_arg_rhs },
        SymbolKind { value: SymbolKind::S_paren_args },
        SymbolKind { value: SymbolKind::S_opt_paren_args },
        SymbolKind { value: SymbolKind::S_opt_call_args },
        SymbolKind { value: SymbolKind::S_call_args },
        SymbolKind { value: SymbolKind::S_command_args },
        SymbolKind { value: SymbolKind::S_212_10 },
        SymbolKind { value: SymbolKind::S_block_arg },
        SymbolKind { value: SymbolKind::S_opt_block_arg },
        SymbolKind { value: SymbolKind::S_args },
        SymbolKind { value: SymbolKind::S_mrhs_arg },
        SymbolKind { value: SymbolKind::S_mrhs },
        SymbolKind { value: SymbolKind::S_primary },
        SymbolKind { value: SymbolKind::S_219_11 },
        SymbolKind { value: SymbolKind::S_220_12 },
        SymbolKind { value: SymbolKind::S_221_13 },
        SymbolKind { value: SymbolKind::S_222_14 },
        SymbolKind { value: SymbolKind::S_223_15 },
        SymbolKind { value: SymbolKind::S_224_16 },
        SymbolKind { value: SymbolKind::S_225_17 },
        SymbolKind { value: SymbolKind::S_226_18 },
        SymbolKind { value: SymbolKind::S_primary_value },
        SymbolKind { value: SymbolKind::S_k_begin },
        SymbolKind { value: SymbolKind::S_k_if },
        SymbolKind { value: SymbolKind::S_k_unless },
        SymbolKind { value: SymbolKind::S_k_while },
        SymbolKind { value: SymbolKind::S_k_until },
        SymbolKind { value: SymbolKind::S_k_case },
        SymbolKind { value: SymbolKind::S_k_for },
        SymbolKind { value: SymbolKind::S_k_class },
        SymbolKind { value: SymbolKind::S_k_module },
        SymbolKind { value: SymbolKind::S_k_def },
        SymbolKind { value: SymbolKind::S_k_do },
        SymbolKind { value: SymbolKind::S_k_do_block },
        SymbolKind { value: SymbolKind::S_k_rescue },
        SymbolKind { value: SymbolKind::S_k_ensure },
        SymbolKind { value: SymbolKind::S_k_when },
        SymbolKind { value: SymbolKind::S_k_else },
        SymbolKind { value: SymbolKind::S_k_elsif },
        SymbolKind { value: SymbolKind::S_k_end },
        SymbolKind { value: SymbolKind::S_k_return },
        SymbolKind { value: SymbolKind::S_then },
        SymbolKind { value: SymbolKind::S_do },
        SymbolKind { value: SymbolKind::S_if_tail },
        SymbolKind { value: SymbolKind::S_opt_else },
        SymbolKind { value: SymbolKind::S_for_var },
        SymbolKind { value: SymbolKind::S_f_marg },
        SymbolKind { value: SymbolKind::S_f_marg_list },
        SymbolKind { value: SymbolKind::S_f_margs },
        SymbolKind { value: SymbolKind::S_f_rest_marg },
        SymbolKind { value: SymbolKind::S_f_any_kwrest },
        SymbolKind { value: SymbolKind::S_block_args_tail },
        SymbolKind { value: SymbolKind::S_opt_block_args_tail },
        SymbolKind { value: SymbolKind::S_excessed_comma },
        SymbolKind { value: SymbolKind::S_block_param },
        SymbolKind { value: SymbolKind::S_opt_block_param },
        SymbolKind { value: SymbolKind::S_block_param_def },
        SymbolKind { value: SymbolKind::S_opt_bv_decl },
        SymbolKind { value: SymbolKind::S_bv_decls },
        SymbolKind { value: SymbolKind::S_bvar },
        SymbolKind { value: SymbolKind::S_lambda },
        SymbolKind { value: SymbolKind::S_267_19 },
        SymbolKind { value: SymbolKind::S_268_20 },
        SymbolKind { value: SymbolKind::S_f_larglist },
        SymbolKind { value: SymbolKind::S_lambda_body },
        SymbolKind { value: SymbolKind::S_271_21 },
        SymbolKind { value: SymbolKind::S_272_22 },
        SymbolKind { value: SymbolKind::S_do_block },
        SymbolKind { value: SymbolKind::S_274_23 },
        SymbolKind { value: SymbolKind::S_block_call },
        SymbolKind { value: SymbolKind::S_method_call },
        SymbolKind { value: SymbolKind::S_brace_block },
        SymbolKind { value: SymbolKind::S_278_24 },
        SymbolKind { value: SymbolKind::S_279_25 },
        SymbolKind { value: SymbolKind::S_brace_body },
        SymbolKind { value: SymbolKind::S_281_26 },
        SymbolKind { value: SymbolKind::S_do_body },
        SymbolKind { value: SymbolKind::S_283_27 },
        SymbolKind { value: SymbolKind::S_case_args },
        SymbolKind { value: SymbolKind::S_case_body },
        SymbolKind { value: SymbolKind::S_cases },
        SymbolKind { value: SymbolKind::S_p_case_body },
        SymbolKind { value: SymbolKind::S_288_28 },
        SymbolKind { value: SymbolKind::S_289_29 },
        SymbolKind { value: SymbolKind::S_p_cases },
        SymbolKind { value: SymbolKind::S_p_top_expr },
        SymbolKind { value: SymbolKind::S_p_top_expr_body },
        SymbolKind { value: SymbolKind::S_p_expr },
        SymbolKind { value: SymbolKind::S_p_as },
        SymbolKind { value: SymbolKind::S_p_alt },
        SymbolKind { value: SymbolKind::S_p_lparen },
        SymbolKind { value: SymbolKind::S_p_lbracket },
        SymbolKind { value: SymbolKind::S_p_expr_basic },
        SymbolKind { value: SymbolKind::S_299_30 },
        SymbolKind { value: SymbolKind::S_300_31 },
        SymbolKind { value: SymbolKind::S_p_args },
        SymbolKind { value: SymbolKind::S_p_args_head },
        SymbolKind { value: SymbolKind::S_p_args_tail },
        SymbolKind { value: SymbolKind::S_p_find },
        SymbolKind { value: SymbolKind::S_p_rest },
        SymbolKind { value: SymbolKind::S_p_args_post },
        SymbolKind { value: SymbolKind::S_p_arg },
        SymbolKind { value: SymbolKind::S_p_kwargs },
        SymbolKind { value: SymbolKind::S_p_kwarg },
        SymbolKind { value: SymbolKind::S_p_kw },
        SymbolKind { value: SymbolKind::S_p_kw_label },
        SymbolKind { value: SymbolKind::S_p_kwrest },
        SymbolKind { value: SymbolKind::S_p_kwnorest },
        SymbolKind { value: SymbolKind::S_p_any_kwrest },
        SymbolKind { value: SymbolKind::S_p_value },
        SymbolKind { value: SymbolKind::S_p_primitive },
        SymbolKind { value: SymbolKind::S_p_variable },
        SymbolKind { value: SymbolKind::S_p_var_ref },
        SymbolKind { value: SymbolKind::S_p_const },
        SymbolKind { value: SymbolKind::S_opt_rescue },
        SymbolKind { value: SymbolKind::S_exc_list },
        SymbolKind { value: SymbolKind::S_exc_var },
        SymbolKind { value: SymbolKind::S_opt_ensure },
        SymbolKind { value: SymbolKind::S_literal },
        SymbolKind { value: SymbolKind::S_strings },
        SymbolKind { value: SymbolKind::S_string },
        SymbolKind { value: SymbolKind::S_string1 },
        SymbolKind { value: SymbolKind::S_xstring },
        SymbolKind { value: SymbolKind::S_regexp },
        SymbolKind { value: SymbolKind::S_words },
        SymbolKind { value: SymbolKind::S_word_list },
        SymbolKind { value: SymbolKind::S_word },
        SymbolKind { value: SymbolKind::S_symbols },
        SymbolKind { value: SymbolKind::S_symbol_list },
        SymbolKind { value: SymbolKind::S_qwords },
        SymbolKind { value: SymbolKind::S_qsymbols },
        SymbolKind { value: SymbolKind::S_qword_list },
        SymbolKind { value: SymbolKind::S_qsym_list },
        SymbolKind { value: SymbolKind::S_string_contents },
        SymbolKind { value: SymbolKind::S_xstring_contents },
        SymbolKind { value: SymbolKind::S_regexp_contents },
        SymbolKind { value: SymbolKind::S_string_content },
        SymbolKind { value: SymbolKind::S_343_32 },
        SymbolKind { value: SymbolKind::S_344_33 },
        SymbolKind { value: SymbolKind::S_345_34 },
        SymbolKind { value: SymbolKind::S_346_35 },
        SymbolKind { value: SymbolKind::S_347_36 },
        SymbolKind { value: SymbolKind::S_348_37 },
        SymbolKind { value: SymbolKind::S_string_dvar },
        SymbolKind { value: SymbolKind::S_symbol },
        SymbolKind { value: SymbolKind::S_ssym },
        SymbolKind { value: SymbolKind::S_sym },
        SymbolKind { value: SymbolKind::S_dsym },
        SymbolKind { value: SymbolKind::S_numeric },
        SymbolKind { value: SymbolKind::S_simple_numeric },
        SymbolKind { value: SymbolKind::S_user_variable },
        SymbolKind { value: SymbolKind::S_keyword_variable },
        SymbolKind { value: SymbolKind::S_var_ref },
        SymbolKind { value: SymbolKind::S_var_lhs },
        SymbolKind { value: SymbolKind::S_backref },
        SymbolKind { value: SymbolKind::S_superclass },
        SymbolKind { value: SymbolKind::S_362_38 },
        SymbolKind { value: SymbolKind::S_f_opt_paren_args },
        SymbolKind { value: SymbolKind::S_f_paren_args },
        SymbolKind { value: SymbolKind::S_f_arglist },
        SymbolKind { value: SymbolKind::S_366_39 },
        SymbolKind { value: SymbolKind::S_args_tail },
        SymbolKind { value: SymbolKind::S_opt_args_tail },
        SymbolKind { value: SymbolKind::S_f_args },
        SymbolKind { value: SymbolKind::S_args_forward },
        SymbolKind { value: SymbolKind::S_f_bad_arg },
        SymbolKind { value: SymbolKind::S_f_norm_arg },
        SymbolKind { value: SymbolKind::S_f_arg_asgn },
        SymbolKind { value: SymbolKind::S_f_arg_item },
        SymbolKind { value: SymbolKind::S_f_arg },
        SymbolKind { value: SymbolKind::S_f_label },
        SymbolKind { value: SymbolKind::S_f_kw },
        SymbolKind { value: SymbolKind::S_f_block_kw },
        SymbolKind { value: SymbolKind::S_f_block_kwarg },
        SymbolKind { value: SymbolKind::S_f_kwarg },
        SymbolKind { value: SymbolKind::S_kwrest_mark },
        SymbolKind { value: SymbolKind::S_f_no_kwarg },
        SymbolKind { value: SymbolKind::S_f_kwrest },
        SymbolKind { value: SymbolKind::S_f_opt },
        SymbolKind { value: SymbolKind::S_f_block_opt },
        SymbolKind { value: SymbolKind::S_f_block_optarg },
        SymbolKind { value: SymbolKind::S_f_optarg },
        SymbolKind { value: SymbolKind::S_restarg_mark },
        SymbolKind { value: SymbolKind::S_f_rest_arg },
        SymbolKind { value: SymbolKind::S_blkarg_mark },
        SymbolKind { value: SymbolKind::S_f_block_arg },
        SymbolKind { value: SymbolKind::S_opt_f_block_arg },
        SymbolKind { value: SymbolKind::S_singleton },
        SymbolKind { value: SymbolKind::S_394_40 },
        SymbolKind { value: SymbolKind::S_assoc_list },
        SymbolKind { value: SymbolKind::S_assocs },
        SymbolKind { value: SymbolKind::S_assoc },
        SymbolKind { value: SymbolKind::S_operation },
        SymbolKind { value: SymbolKind::S_operation2 },
        SymbolKind { value: SymbolKind::S_operation3 },
        SymbolKind { value: SymbolKind::S_dot_or_colon },
        SymbolKind { value: SymbolKind::S_call_op },
        SymbolKind { value: SymbolKind::S_call_op2 },
        SymbolKind { value: SymbolKind::S_opt_terms },
        SymbolKind { value: SymbolKind::S_opt_nl },
        SymbolKind { value: SymbolKind::S_rparen },
        SymbolKind { value: SymbolKind::S_rbracket },
        SymbolKind { value: SymbolKind::S_rbrace },
        SymbolKind { value: SymbolKind::S_trailer },
        SymbolKind { value: SymbolKind::S_term },
        SymbolKind { value: SymbolKind::S_terms },
        SymbolKind { value: SymbolKind::S_none }
    ];

    pub(crate) fn get(n: i32) -> &'static SymbolKind {
        &Self::VALUES_[i32_to_usize(n)]
    }

    pub(crate) fn code(&self) -> i32 {
        self.value
    }

    /* YYNAMES_[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
    First, the terminals, then, starting at \a YYNTOKENS_, nonterminals.  */
    #[allow(non_upper_case_globals)]
const yynames_: &'static [&'static str] = &[ "end-of-input", "error", "invalid token", "`class'", "`module'",
  "`def'", "`undef'", "`begin'", "`rescue'", "`ensure'", "`end'", "`if'",
  "`unless'", "`then'", "`elsif'", "`else'", "`case'", "`when'", "`while'",
  "`until'", "`for'", "`break'", "`next'", "`redo'", "`retry'", "`in'",
  "`do'", "`do' for condition", "`do' for block", "`do' for lambda",
  "`return'", "`yield'", "`super'", "`self'", "`nil'", "`true'", "`false'",
  "`and'", "`or'", "`not'", "`if' modifier", "`unless' modifier",
  "`while' modifier", "`until' modifier", "`rescue' modifier", "`alias'",
  "`defined?'", "`BEGIN'", "`END'", "`__LINE__'", "`__FILE__'",
  "`__ENCODING__'", "local variable or method", "method",
  "global variable", "instance variable", "constant", "class variable",
  "label", "integer literal", "float literal", "rational literal",
  "imaginary literal", "char literal", "numbered reference",
  "back reference", "literal content", "tREGEXP_END", "tDOT", "backslash",
  "escaped space", "escaped horizontal tab", "escaped form feed",
  "escaped carriage return", "escaped vertical tab", "unary+", "unary-",
  "**", "<=>", "==", "===", "!=", ">=", "<=", "&&", "||", "=~", "!~", "..",
  "...", "(..", "(...", "[]", "[]=", "<<", ">>", "&.", "::",
  ":: at EXPR_BEG", "operator-assignment", "=>", "(", "( arg", ")", "[",
  "{", "{ arg", "*", "**arg", "&", "->", "symbol literal", "string begin",
  "backtick literal", "regexp literal", "word list", "verbatim word list",
  "symbol list", "verbatim symbol list", "string end", "tRCURLY",
  "tSTRING_DBEG", "tSTRING_DVAR", "tLAMBEG", "tLABEL_END", ",",
  "{ (tLCURLY)", "}", "[ (tLBRACK2)", "=", "|", "& (tAMPER2)", ">", "<",
  "`", "^", "( (tLPAREN2)", "]", ";", " ", "\n", "+", "-", "* (tSTAR2)",
  "/", "%", "~", "!", "tLOWEST", "tEH", "tCOLON", "tUMINUS_NUM",
  "tLAST_TOKEN", "$accept", "program", "@1", "top_compstmt", "top_stmts",
  "top_stmt", "begin_block", "bodystmt", "compstmt", "stmts",
  "stmt_or_begin", "$@2", "stmt", "@3", "command_asgn", "command_rhs",
  "expr", "@4", "@5", "def_name", "defn_head", "defs_head", "@6",
  "expr_value", "expr_value_do", "@7", "command_call", "block_command",
  "cmd_brace_block", "@8", "fcall", "command", "mlhs", "mlhs_inner",
  "mlhs_basic", "mlhs_item", "mlhs_head", "mlhs_post", "mlhs_node", "lhs",
  "cname", "cpath", "fname", "fitem", "undef_list", "@9", "op", "reswords",
  "arg", "relop", "rel_expr", "arg_value", "aref_args", "arg_rhs",
  "paren_args", "opt_paren_args", "opt_call_args", "call_args",
  "command_args", "@10", "block_arg", "opt_block_arg", "args", "mrhs_arg",
  "mrhs", "primary", "@11", "@12", "@13", "@14", "@15", "@16", "@17",
  "@18", "primary_value", "k_begin", "k_if", "k_unless", "k_while",
  "k_until", "k_case", "k_for", "k_class", "k_module", "k_def", "k_do",
  "k_do_block", "k_rescue", "k_ensure", "k_when", "k_else", "k_elsif",
  "k_end", "k_return", "then", "do", "if_tail", "opt_else", "for_var",
  "f_marg", "f_marg_list", "f_margs", "f_rest_marg", "f_any_kwrest",
  "block_args_tail", "opt_block_args_tail", "excessed_comma",
  "block_param", "opt_block_param", "block_param_def", "opt_bv_decl",
  "bv_decls", "bvar", "lambda", "@19", "@20", "f_larglist", "lambda_body",
  "@21", "@22", "do_block", "@23", "block_call", "method_call",
  "brace_block", "@24", "@25", "brace_body", "@26", "do_body", "@27",
  "case_args", "case_body", "cases", "p_case_body", "@28", "@29",
  "p_cases", "p_top_expr", "p_top_expr_body", "p_expr", "p_as", "p_alt",
  "p_lparen", "p_lbracket", "p_expr_basic", "@30", "@31", "p_args",
  "p_args_head", "p_args_tail", "p_find", "p_rest", "p_args_post", "p_arg",
  "p_kwargs", "p_kwarg", "p_kw", "p_kw_label", "p_kwrest", "p_kwnorest",
  "p_any_kwrest", "p_value", "p_primitive", "p_variable", "p_var_ref",
  "p_const", "opt_rescue", "exc_list", "exc_var", "opt_ensure", "literal",
  "strings", "string", "string1", "xstring", "regexp", "words",
  "word_list", "word", "symbols", "symbol_list", "qwords", "qsymbols",
  "qword_list", "qsym_list", "string_contents", "xstring_contents",
  "regexp_contents", "string_content", "@32", "@33", "@34", "@35", "@36",
  "@37", "string_dvar", "symbol", "ssym", "sym", "dsym", "numeric",
  "simple_numeric", "user_variable", "keyword_variable", "var_ref",
  "var_lhs", "backref", "superclass", "@38", "f_opt_paren_args",
  "f_paren_args", "f_arglist", "@39", "args_tail", "opt_args_tail",
  "f_args", "args_forward", "f_bad_arg", "f_norm_arg", "f_arg_asgn",
  "f_arg_item", "f_arg", "f_label", "f_kw", "f_block_kw", "f_block_kwarg",
  "f_kwarg", "kwrest_mark", "f_no_kwarg", "f_kwrest", "f_opt",
  "f_block_opt", "f_block_optarg", "f_optarg", "restarg_mark",
  "f_rest_arg", "blkarg_mark", "f_block_arg", "opt_f_block_arg",
  "singleton", "@40", "assoc_list", "assocs", "assoc", "operation",
  "operation2", "operation3", "dot_or_colon", "call_op", "call_op2",
  "opt_terms", "opt_nl", "rparen", "rbracket", "rbrace", "trailer", "term",
  "terms", "none", "<<NULL>>" ] ;

    /* The user-facing name of this symbol.  */
    pub(crate) fn name(&self) -> String {
        let code: usize = self.code().try_into().unwrap();
        Self::yynames_[code].to_owned()
    }
}


const DYMMY_SYMBOL_KIND: SymbolKind = SymbolKind { value: 0 };

impl Lexer {
        /* Token kinds.  */
    /// Token `` "end-of-input" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const END_OF_INPUT: i32 = 0;
    /// Token `` error ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const YYerror: i32 = 256;
    /// Token `` "invalid token" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const YYUNDEF: i32 = 257;
    /// Token `` "`class'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kCLASS: i32 = 258;
    /// Token `` "`module'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kMODULE: i32 = 259;
    /// Token `` "`def'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kDEF: i32 = 260;
    /// Token `` "`undef'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kUNDEF: i32 = 261;
    /// Token `` "`begin'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kBEGIN: i32 = 262;
    /// Token `` "`rescue'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kRESCUE: i32 = 263;
    /// Token `` "`ensure'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kENSURE: i32 = 264;
    /// Token `` "`end'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kEND: i32 = 265;
    /// Token `` "`if'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kIF: i32 = 266;
    /// Token `` "`unless'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kUNLESS: i32 = 267;
    /// Token `` "`then'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kTHEN: i32 = 268;
    /// Token `` "`elsif'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kELSIF: i32 = 269;
    /// Token `` "`else'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kELSE: i32 = 270;
    /// Token `` "`case'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kCASE: i32 = 271;
    /// Token `` "`when'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kWHEN: i32 = 272;
    /// Token `` "`while'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kWHILE: i32 = 273;
    /// Token `` "`until'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kUNTIL: i32 = 274;
    /// Token `` "`for'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kFOR: i32 = 275;
    /// Token `` "`break'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kBREAK: i32 = 276;
    /// Token `` "`next'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kNEXT: i32 = 277;
    /// Token `` "`redo'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kREDO: i32 = 278;
    /// Token `` "`retry'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kRETRY: i32 = 279;
    /// Token `` "`in'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kIN: i32 = 280;
    /// Token `` "`do'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kDO: i32 = 281;
    /// Token `` "`do' for condition" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kDO_COND: i32 = 282;
    /// Token `` "`do' for block" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kDO_BLOCK: i32 = 283;
    /// Token `` "`do' for lambda" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kDO_LAMBDA: i32 = 284;
    /// Token `` "`return'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kRETURN: i32 = 285;
    /// Token `` "`yield'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kYIELD: i32 = 286;
    /// Token `` "`super'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kSUPER: i32 = 287;
    /// Token `` "`self'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kSELF: i32 = 288;
    /// Token `` "`nil'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kNIL: i32 = 289;
    /// Token `` "`true'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kTRUE: i32 = 290;
    /// Token `` "`false'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kFALSE: i32 = 291;
    /// Token `` "`and'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kAND: i32 = 292;
    /// Token `` "`or'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kOR: i32 = 293;
    /// Token `` "`not'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kNOT: i32 = 294;
    /// Token `` "`if' modifier" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kIF_MOD: i32 = 295;
    /// Token `` "`unless' modifier" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kUNLESS_MOD: i32 = 296;
    /// Token `` "`while' modifier" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kWHILE_MOD: i32 = 297;
    /// Token `` "`until' modifier" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kUNTIL_MOD: i32 = 298;
    /// Token `` "`rescue' modifier" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kRESCUE_MOD: i32 = 299;
    /// Token `` "`alias'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kALIAS: i32 = 300;
    /// Token `` "`defined?'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kDEFINED: i32 = 301;
    /// Token `` "`BEGIN'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const klBEGIN: i32 = 302;
    /// Token `` "`END'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const klEND: i32 = 303;
    /// Token `` "`__LINE__'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const k__LINE__: i32 = 304;
    /// Token `` "`__FILE__'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const k__FILE__: i32 = 305;
    /// Token `` "`__ENCODING__'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const k__ENCODING__: i32 = 306;
    /// Token `` "local variable or method" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tIDENTIFIER: i32 = 307;
    /// Token `` "method" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tFID: i32 = 308;
    /// Token `` "global variable" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tGVAR: i32 = 309;
    /// Token `` "instance variable" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tIVAR: i32 = 310;
    /// Token `` "constant" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCONSTANT: i32 = 311;
    /// Token `` "class variable" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCVAR: i32 = 312;
    /// Token `` "label" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLABEL: i32 = 313;
    /// Token `` "integer literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tINTEGER: i32 = 314;
    /// Token `` "float literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tFLOAT: i32 = 315;
    /// Token `` "rational literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tRATIONAL: i32 = 316;
    /// Token `` "imaginary literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tIMAGINARY: i32 = 317;
    /// Token `` "char literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCHAR: i32 = 318;
    /// Token `` "numbered reference" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tNTH_REF: i32 = 319;
    /// Token `` "back reference" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tBACK_REF: i32 = 320;
    /// Token `` "literal content" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTRING_CONTENT: i32 = 321;
    /// Token `` tREGEXP_END ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tREGEXP_END: i32 = 322;
    /// Token `` tDOT ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tDOT: i32 = 323;
    /// Token `` "backslash" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tBACKSLASH: i32 = 324;
    /// Token `` "escaped space" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSP: i32 = 325;
    /// Token `` "escaped horizontal tab" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSLASH_T: i32 = 326;
    /// Token `` "escaped form feed" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSLASH_F: i32 = 327;
    /// Token `` "escaped carriage return" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSLASH_R: i32 = 328;
    /// Token `` "escaped vertical tab" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tVTAB: i32 = 329;
    /// Token `` "unary+" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tUPLUS: i32 = 330;
    /// Token `` "unary-" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tUMINUS: i32 = 331;
    /// Token `` "**" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tPOW: i32 = 332;
    /// Token `` "<=>" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCMP: i32 = 333;
    /// Token `` "==" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tEQ: i32 = 334;
    /// Token `` "===" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tEQQ: i32 = 335;
    /// Token `` "!=" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tNEQ: i32 = 336;
    /// Token `` ">=" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tGEQ: i32 = 337;
    /// Token `` "<=" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLEQ: i32 = 338;
    /// Token `` "&&" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tANDOP: i32 = 339;
    /// Token `` "||" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tOROP: i32 = 340;
    /// Token `` "=~" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tMATCH: i32 = 341;
    /// Token `` "!~" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tNMATCH: i32 = 342;
    /// Token `` ".." ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tDOT2: i32 = 343;
    /// Token `` "..." ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tDOT3: i32 = 344;
    /// Token `` "(.." ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tBDOT2: i32 = 345;
    /// Token `` "(..." ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tBDOT3: i32 = 346;
    /// Token `` "[]" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tAREF: i32 = 347;
    /// Token `` "[]=" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tASET: i32 = 348;
    /// Token `` "<<" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLSHFT: i32 = 349;
    /// Token `` ">>" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tRSHFT: i32 = 350;
    /// Token `` "&." ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tANDDOT: i32 = 351;
    /// Token `` "::" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCOLON2: i32 = 352;
    /// Token `` ":: at EXPR_BEG" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCOLON3: i32 = 353;
    /// Token `` "operator-assignment" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tOP_ASGN: i32 = 354;
    /// Token `` "=>" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tASSOC: i32 = 355;
    /// Token `` "(" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLPAREN: i32 = 356;
    /// Token `` "( arg" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLPAREN_ARG: i32 = 357;
    /// Token `` ")" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tRPAREN: i32 = 358;
    /// Token `` "[" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLBRACK: i32 = 359;
    /// Token `` "{" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLBRACE: i32 = 360;
    /// Token `` "{ arg" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLBRACE_ARG: i32 = 361;
    /// Token `` "*" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTAR: i32 = 362;
    /// Token `` "**arg" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tDSTAR: i32 = 363;
    /// Token `` "&" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tAMPER: i32 = 364;
    /// Token `` "->" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLAMBDA: i32 = 365;
    /// Token `` "symbol literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSYMBEG: i32 = 366;
    /// Token `` "string begin" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTRING_BEG: i32 = 367;
    /// Token `` "backtick literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tXSTRING_BEG: i32 = 368;
    /// Token `` "regexp literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tREGEXP_BEG: i32 = 369;
    /// Token `` "word list" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tWORDS_BEG: i32 = 370;
    /// Token `` "verbatim word list" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tQWORDS_BEG: i32 = 371;
    /// Token `` "symbol list" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSYMBOLS_BEG: i32 = 372;
    /// Token `` "verbatim symbol list" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tQSYMBOLS_BEG: i32 = 373;
    /// Token `` "string end" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTRING_END: i32 = 374;
    /// Token `` "tRCURLY" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTRING_DEND: i32 = 375;
    /// Token `` tSTRING_DBEG ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTRING_DBEG: i32 = 376;
    /// Token `` tSTRING_DVAR ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTRING_DVAR: i32 = 377;
    /// Token `` tLAMBEG ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLAMBEG: i32 = 378;
    /// Token `` tLABEL_END ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLABEL_END: i32 = 379;
    /// Token `` "," ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCOMMA: i32 = 380;
    /// Token `` "{ (tLCURLY)" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLCURLY: i32 = 381;
    /// Token `` "}" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tRCURLY: i32 = 382;
    /// Token `` "[ (tLBRACK2)" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLBRACK2: i32 = 383;
    /// Token `` "=" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tEQL: i32 = 384;
    /// Token `` "|" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tPIPE: i32 = 385;
    /// Token `` "& (tAMPER2)" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tAMPER2: i32 = 386;
    /// Token `` ">" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tGT: i32 = 387;
    /// Token `` "<" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLT: i32 = 388;
    /// Token `` "`" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tBACK_REF2: i32 = 389;
    /// Token `` "^" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCARET: i32 = 390;
    /// Token `` "( (tLPAREN2)" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLPAREN2: i32 = 391;
    /// Token `` "]" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tRBRACK: i32 = 392;
    /// Token `` ";" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSEMI: i32 = 393;
    /// Token `` " " ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSPACE: i32 = 394;
    /// Token `` "\n" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tNL: i32 = 395;
    /// Token `` "+" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tPLUS: i32 = 396;
    /// Token `` "-" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tMINUS: i32 = 397;
    /// Token `` "* (tSTAR2)" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTAR2: i32 = 398;
    /// Token `` "/" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tDIVIDE: i32 = 399;
    /// Token `` "%" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tPERCENT: i32 = 400;
    /// Token `` "~" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tTILDE: i32 = 401;
    /// Token `` "!" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tBANG: i32 = 402;
    /// Token `` tLOWEST ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLOWEST: i32 = 403;
    /// Token `` tEH ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tEH: i32 = 404;
    /// Token `` tCOLON ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCOLON: i32 = 405;
    /// Token `` tUMINUS_NUM ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tUMINUS_NUM: i32 = 406;
    /// Token `` tLAST_TOKEN ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLAST_TOKEN: i32 = 407;


    // Deprecated, use END_OF_INPUT instead.
    #[allow(dead_code)]
    const EOF: i32 = Self::END_OF_INPUT;

    // Token values
    #[allow(dead_code)]
    pub(crate) const TOKEN_NAMES: &'static [&'static str] = &    [

    "END_OF_INPUT",

    "YYerror",

    "YYUNDEF",

    "kCLASS",

    "kMODULE",

    "kDEF",

    "kUNDEF",

    "kBEGIN",

    "kRESCUE",

    "kENSURE",

    "kEND",

    "kIF",

    "kUNLESS",

    "kTHEN",

    "kELSIF",

    "kELSE",

    "kCASE",

    "kWHEN",

    "kWHILE",

    "kUNTIL",

    "kFOR",

    "kBREAK",

    "kNEXT",

    "kREDO",

    "kRETRY",

    "kIN",

    "kDO",

    "kDO_COND",

    "kDO_BLOCK",

    "kDO_LAMBDA",

    "kRETURN",

    "kYIELD",

    "kSUPER",

    "kSELF",

    "kNIL",

    "kTRUE",

    "kFALSE",

    "kAND",

    "kOR",

    "kNOT",

    "kIF_MOD",

    "kUNLESS_MOD",

    "kWHILE_MOD",

    "kUNTIL_MOD",

    "kRESCUE_MOD",

    "kALIAS",

    "kDEFINED",

    "klBEGIN",

    "klEND",

    "k__LINE__",

    "k__FILE__",

    "k__ENCODING__",

    "tIDENTIFIER",

    "tFID",

    "tGVAR",

    "tIVAR",

    "tCONSTANT",

    "tCVAR",

    "tLABEL",

    "tINTEGER",

    "tFLOAT",

    "tRATIONAL",

    "tIMAGINARY",

    "tCHAR",

    "tNTH_REF",

    "tBACK_REF",

    "tSTRING_CONTENT",

    "tREGEXP_END",

    "tDOT",

    "tBACKSLASH",

    "tSP",

    "tSLASH_T",

    "tSLASH_F",

    "tSLASH_R",

    "tVTAB",

    "tUPLUS",

    "tUMINUS",

    "tPOW",

    "tCMP",

    "tEQ",

    "tEQQ",

    "tNEQ",

    "tGEQ",

    "tLEQ",

    "tANDOP",

    "tOROP",

    "tMATCH",

    "tNMATCH",

    "tDOT2",

    "tDOT3",

    "tBDOT2",

    "tBDOT3",

    "tAREF",

    "tASET",

    "tLSHFT",

    "tRSHFT",

    "tANDDOT",

    "tCOLON2",

    "tCOLON3",

    "tOP_ASGN",

    "tASSOC",

    "tLPAREN",

    "tLPAREN_ARG",

    "tRPAREN",

    "tLBRACK",

    "tLBRACE",

    "tLBRACE_ARG",

    "tSTAR",

    "tDSTAR",

    "tAMPER",

    "tLAMBDA",

    "tSYMBEG",

    "tSTRING_BEG",

    "tXSTRING_BEG",

    "tREGEXP_BEG",

    "tWORDS_BEG",

    "tQWORDS_BEG",

    "tSYMBOLS_BEG",

    "tQSYMBOLS_BEG",

    "tSTRING_END",

    "tSTRING_DEND",

    "tSTRING_DBEG",

    "tSTRING_DVAR",

    "tLAMBEG",

    "tLABEL_END",

    "tCOMMA",

    "tLCURLY",

    "tRCURLY",

    "tLBRACK2",

    "tEQL",

    "tPIPE",

    "tAMPER2",

    "tGT",

    "tLT",

    "tBACK_REF2",

    "tCARET",

    "tLPAREN2",

    "tRBRACK",

    "tSEMI",

    "tSPACE",

    "tNL",

    "tPLUS",

    "tMINUS",

    "tSTAR2",

    "tDIVIDE",

    "tPERCENT",

    "tTILDE",

    "tBANG",

    "tLOWEST",

    "tEH",

    "tCOLON",

    "tUMINUS_NUM",

    "tLAST_TOKEN",

]
;
}


impl  Parser  {

    fn yycdebug(&self, s: &str) {
        if self.yydebug {
            eprintln!("{}", s);
        }
    }

}

/// Local alias
type YYValue =  Value ;

#[derive(Clone, Debug)]
struct YYStackItem {
    state: i32,
    value: YYValue,
    loc: YYLoc,
}

#[derive(Clone, Debug)]
pub struct YYStack {
    stack: Vec<YYStackItem>,
}

impl YYStack {
    pub(crate) fn new() -> Self {
        Self {
          stack: Vec::with_capacity(20),
        }
    }

    pub(crate) fn push(&mut self, state: i32, value: YYValue, loc: YYLoc) {
        self.stack.push(YYStackItem { state, value, loc });
    }

    pub(crate) fn pop(&mut self) {
        self.stack.pop();
    }

    pub(crate) fn pop_n(&mut self, num: usize) {
        let len = self.stack.len() - num;
        self.stack.truncate(len);
    }

    pub(crate) fn state_at(&self, i: usize) -> i32 {
        self.stack[self.len() - 1 - i].state
    }

    pub(crate) fn location_at(&self, i: usize) -> &YYLoc {
        &self.stack[self.len() - 1 - i].loc
    }

    pub(crate) fn borrow_value_at(&self, i: usize) -> &YYValue {
        &self.stack[self.len() - 1 - i].value
    }

    pub(crate) fn owned_value_at(&mut self, i: usize) -> YYValue {
        let len = self.len();
        std::mem::take(&mut self.stack[len - 1 - i].value)
    }

    pub(crate) fn len(&self) -> usize {
      self.stack.len()
    }
}

impl std::fmt::Display for YYStack {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let states = self.stack.iter().map(|e| e.state.to_string()).collect::<Vec<String>>().join(" ");
        let values = self.stack.iter().map(|e| format!("{:?}", e.value)).collect::<Vec<String>>().join(" ");
        f.write_fmt(format_args!("Stack now states = {} / values = {:?} ", states, values))
    }
}

impl  Parser  {
  /// Returned by a Bison action in order to stop the parsing process and
  /// return success (true).
  pub(crate) const YYACCEPT: i32 = 0;

  /// Returned by a Bison action in order to stop the parsing process and
  /// return failure (false).
  pub(crate) const YYABORT: i32 = 1;

  /// Returned by a Bison action in order to start error recovery without
  /// printing an error message.
  pub(crate) const YYERROR: i32 = 2;

  /// Internal return codes that are not supported for user semantic
  /// actions.
  pub(crate) const YYERRLAB: i32 = 3;
  pub(crate) const YYNEWSTATE: i32 = 4;
  pub(crate) const YYDEFAULT: i32 = 5;
  pub(crate) const YYREDUCE: i32 = 6;
  pub(crate) const YYERRLAB1: i32 = 7;
  #[allow(dead_code)]
  pub(crate) const YYRETURN: i32 = 8;

  /// Whether error recovery is being done.  In this state, the parser
  /// reads token until it reaches a known state, and then restarts normal
  /// operation.
  #[allow(dead_code)]
  pub(crate) fn recovering(&self) -> bool {
      self.yyerrstatus_ == 0
  }

    // Compute post-reduction state.
    // yystate:   the current state
    // yysym:     the nonterminal to push on the stack
    fn yy_lr_goto_state(&self, yystate: i32, yysym: i32) -> i32 {
        let idx = i32_to_usize(yysym - Self::YYNTOKENS_);
        let yyr = Self::yypgoto_[idx] + yystate;
        if 0 <= yyr && yyr <= Self::YYLAST_ {
            let yyr = i32_to_usize(yyr);
            if Self::yycheck_[yyr] == yystate {
                return Self::yytable_[yyr];
            }
        }
        Self::yydefgoto_[idx]
    }

    fn yyaction(&mut self, yyn: i32, yystack: &mut YYStack, yylen: &mut usize) -> Result<i32, ()> {
        // If YYLEN is nonzero, implement the default value of the action:
        // '$$ = $1'.  Otherwise, use the top of the stack.
        //
        // Otherwise, the following line sets YYVAL to garbage.
        // This behavior is undocumented and Bison
        // users should not rely upon it.
        #[allow(unused_assignments)]
        let mut yyval: YYValue = YYValue::Uninitialized;
        let yyloc: YYLoc = make_yylloc(&yystack, *yylen);

        self.yy_reduce_print(yyn, yystack);

        match yyn {
              2 =>  /* @1: %empty  */
  /* "src/parser.y":370  */
                    {
                        self.yylexer.lex_state.set(EXPR_BEG);
                        self.current_arg_stack.push(None);
                        self.max_numparam_stack.push();

                        yyval = Value::None;
                    },


  3 =>  /* program: @1 top_compstmt  */
  /* "src/parser.y":378  */
                    {
                        let top_compstmt =  MaybeNode::from(yystack.owned_value_at(0));
                        self.result = top_compstmt.map(Box::new).into();
                        yyval = Value::None;

                        self.current_arg_stack.pop();
                        self.max_numparam_stack.pop();
                    },


  4 =>  /* top_compstmt: top_stmts opt_terms  */
  /* "src/parser.y":389  */
                    {
                        // TODO: run void_stmts
                        yyval = Value::MaybeNode(
                            self.builder.compstmt( NodeList::from(yystack.owned_value_at(1)))
                        );
                    },


  5 =>  /* top_stmts: none  */
  /* "src/parser.y":398  */
                    {
                      yyval = Value::NodeList( vec![] );
                    },


  6 =>  /* top_stmts: top_stmt  */
  /* "src/parser.y":402  */
                    {
                      yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  7 =>  /* top_stmts: top_stmts terms top_stmt  */
  /* "src/parser.y":406  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  8 =>  /* top_stmts: error top_stmt  */
  /* "src/parser.y":412  */
                    {
                      yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  9 =>  /* top_stmt: stmt  */
  /* "src/parser.y":418  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  10 =>  /* top_stmt: "`BEGIN'" begin_block  */
  /* "src/parser.y":422  */
                    {
                        let BeginBlock { begin_t, body, end_t } =  BeginBlock::from(yystack.owned_value_at(0));
                        yyval = Value::Node(
                            self.builder.preexe( Token::from(yystack.owned_value_at(1)), begin_t, body, end_t)
                        );
                    },


  11 =>  /* begin_block: "{ (tLCURLY)" top_compstmt "}"  */
  /* "src/parser.y":431  */
                    {
                        yyval = Value::new_begin_block(
                            BeginBlock {
                                begin_t:  Token::from(yystack.owned_value_at(2)),
                                body:  MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  12 =>  /* bodystmt: compstmt opt_rescue k_else compstmt opt_ensure  */
  /* "src/parser.y":446  */
                    {
                        let compound_stmt =  MaybeBoxedNode::from(yystack.owned_value_at(4));
                        let rescue_bodies =  NodeList::from(yystack.owned_value_at(3));
                        if rescue_bodies.is_empty() {
                            return self.yyerror(&yystack.location_at (2), DiagnosticMessage::ElseWithoutRescue);
                        }

                        let else_ = Some((  Token::from(yystack.owned_value_at(2)),  MaybeBoxedNode::from(yystack.owned_value_at(1)) ));
                        let ensure =  OptEnsure::from(yystack.owned_value_at(0)).map(|ensure| (ensure.ensure_t, ensure.body));

                        yyval = Value::MaybeNode(
                            self.builder.begin_body(
                                compound_stmt,
                                rescue_bodies,
                                else_,
                                ensure
                            )
                        );
                    },


  13 =>  /* bodystmt: compstmt opt_rescue opt_ensure  */
  /* "src/parser.y":468  */
                    {
                        let compound_stmt =  MaybeBoxedNode::from(yystack.owned_value_at(2));
                        let rescue_bodies =  NodeList::from(yystack.owned_value_at(1));
                        let ensure =  OptEnsure::from(yystack.owned_value_at(0)).map(|ensure| (ensure.ensure_t, ensure.body));

                        yyval = Value::MaybeNode(
                            self.builder.begin_body(
                                compound_stmt,
                                rescue_bodies,
                                None,
                                ensure
                            )
                        );
                    },


  14 =>  /* compstmt: stmts opt_terms  */
  /* "src/parser.y":485  */
                    {
                        // TODO: run void_stmts
                        yyval = Value::MaybeNode(
                            self.builder.compstmt( NodeList::from(yystack.owned_value_at(1)))
                        );
                    },


  15 =>  /* stmts: none  */
  /* "src/parser.y":494  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  16 =>  /* stmts: stmt_or_begin  */
  /* "src/parser.y":498  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  17 =>  /* stmts: stmts terms stmt_or_begin  */
  /* "src/parser.y":502  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  18 =>  /* stmts: error  */
  /* "src/parser.y":508  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  19 =>  /* stmt_or_begin: stmt  */
  /* "src/parser.y":514  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  20 =>  /* $@2: %empty  */
  /* "src/parser.y":518  */
                    {
                        return self.yyerror(&yystack.location_at (0), DiagnosticMessage::BeginNotAtTopLevel);
                    },


  21 =>  /* stmt_or_begin: "`BEGIN'" $@2 begin_block  */
  /* "src/parser.y":522  */
                    {
                        yyval = Value::None;
                    },


  22 =>  /* @3: %empty  */
  /* "src/parser.y":528  */
                    {
                        self.yylexer.lex_state.set(EXPR_FNAME|EXPR_FITEM);
                        yyval = Value::None;
                    },


  23 =>  /* stmt: "`alias'" fitem @3 fitem  */
  /* "src/parser.y":533  */
                    {
                        yyval = Value::Node(
                            self.builder.alias( Token::from(yystack.owned_value_at(3)),  BoxedNode::from(yystack.owned_value_at(2)),  BoxedNode::from(yystack.owned_value_at(0)))
                        );
                    },


  24 =>  /* stmt: "`alias'" "global variable" "global variable"  */
  /* "src/parser.y":539  */
                    {
                        yyval = Value::Node(
                            self.builder.alias(
                                 Token::from(yystack.owned_value_at(2)),
                                self.builder.gvar( Token::from(yystack.owned_value_at(1))),
                                self.builder.gvar( Token::from(yystack.owned_value_at(0))),
                            )
                        )
                    },


  25 =>  /* stmt: "`alias'" "global variable" "back reference"  */
  /* "src/parser.y":549  */
                    {
                        yyval = Value::Node(
                            self.builder.alias(
                                 Token::from(yystack.owned_value_at(2)),
                                self.builder.gvar( Token::from(yystack.owned_value_at(1))),
                                self.builder.back_ref( Token::from(yystack.owned_value_at(0))),
                            )
                        )
                    },


  26 =>  /* stmt: "`alias'" "global variable" "numbered reference"  */
  /* "src/parser.y":559  */
                    {
                        return self.yyerror(&yystack.location_at (0), DiagnosticMessage::AliasNthRef);
                    },


  27 =>  /* stmt: "`undef'" undef_list  */
  /* "src/parser.y":563  */
                    {
                        yyval = Value::Node(
                            self.builder.undef_method(
                                 Token::from(yystack.owned_value_at(1)),
                                 NodeList::from(yystack.owned_value_at(0))
                            )
                        )
                    },


  28 =>  /* stmt: stmt "`if' modifier" expr_value  */
  /* "src/parser.y":572  */
                    {
                        yyval = Value::Node(
                            self.builder.condition_mod(
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                None,
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  29 =>  /* stmt: stmt "`unless' modifier" expr_value  */
  /* "src/parser.y":583  */
                    {
                        yyval = Value::Node(
                            self.builder.condition_mod(
                                None,
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  30 =>  /* stmt: stmt "`while' modifier" expr_value  */
  /* "src/parser.y":594  */
                    {
                        yyval = Value::Node(
                            self.builder.loop_mod(
                                LoopType::While,
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  31 =>  /* stmt: stmt "`until' modifier" expr_value  */
  /* "src/parser.y":605  */
                    {
                        yyval = Value::Node(
                            self.builder.loop_mod(
                                LoopType::Until,
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  32 =>  /* stmt: stmt "`rescue' modifier" stmt  */
  /* "src/parser.y":616  */
                    {
                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0)))
                        );

                        yyval = Value::Node(
                            self.builder.begin_body(
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                vec![*rescue_body],
                                None,
                                None,
                            ).expect("expected begin_body to return Some (compound_stmt was given)")
                        );
                    },


  33 =>  /* stmt: "`END'" "{ (tLCURLY)" compstmt "}"  */
  /* "src/parser.y":636  */
                    {
                        if self.context.is_in_def() {
                            self.warn(&yystack.location_at (3), DiagnosticMessage::EndInMethod);
                        }

                        yyval = Value::Node(
                            self.builder.postexe(
                                 Token::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  34 =>  /* stmt: command_asgn  */
  /* "src/parser.y":651  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  35 =>  /* stmt: mlhs "=" command_call  */
  /* "src/parser.y":655  */
                    {
                        let command_call =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&command_call)?;

                        yyval = Value::Node(
                            self.builder.multi_assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                command_call
                            )
                        );
                    },


  36 =>  /* stmt: lhs "=" mrhs  */
  /* "src/parser.y":668  */
                    {
                        let mrhs = self.builder.array(
                            None,
                             NodeList::from(yystack.owned_value_at(0)),
                            None
                        );
                        self.value_expr(&mrhs)?;

                        yyval = Value::Node(
                            self.builder.assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                mrhs
                            )
                        );
                    },


  37 =>  /* stmt: mlhs "=" mrhs_arg "`rescue' modifier" stmt  */
  /* "src/parser.y":685  */
                    {
                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0)))
                        );

                        let mrhs_arg =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&mrhs_arg)?;

                        let begin_body = self.builder.begin_body(
                            Some(mrhs_arg),
                            vec![ *rescue_body ],
                            None,
                            None
                        ).expect("expected begin_body to return Some (compound_stmt was given)");

                        yyval = Value::Node(
                            self.builder.multi_assign(
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                begin_body
                            )
                        );
                    },


  38 =>  /* stmt: mlhs "=" mrhs_arg  */
  /* "src/parser.y":714  */
                    {
                        yyval = Value::Node(
                            self.builder.multi_assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  39 =>  /* stmt: expr  */
  /* "src/parser.y":724  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  40 =>  /* command_asgn: lhs "=" command_rhs  */
  /* "src/parser.y":730  */
                    {
                        yyval = Value::Node(
                            self.builder.assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  41 =>  /* command_asgn: var_lhs "operator-assignment" command_rhs  */
  /* "src/parser.y":740  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  42 =>  /* command_asgn: primary_value "[ (tLBRACK2)" opt_call_args rbracket "operator-assignment" command_rhs  */
  /* "src/parser.y":750  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.index(
                                     BoxedNode::from(yystack.owned_value_at(5)),
                                     Token::from(yystack.owned_value_at(4)),
                                     NodeList::from(yystack.owned_value_at(3)),
                                     Token::from(yystack.owned_value_at(2))
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  43 =>  /* command_asgn: primary_value call_op "local variable or method" "operator-assignment" command_rhs  */
  /* "src/parser.y":765  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.call_method(
                                    Some( BoxedNode::from(yystack.owned_value_at(4))),
                                    Some( Token::from(yystack.owned_value_at(3))),
                                    Some( Token::from(yystack.owned_value_at(2))),
                                    None,
                                    vec![],
                                    None
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  44 =>  /* command_asgn: primary_value call_op "constant" "operator-assignment" command_rhs  */
  /* "src/parser.y":782  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.call_method(
                                    Some( BoxedNode::from(yystack.owned_value_at(4))),
                                    Some( Token::from(yystack.owned_value_at(3))),
                                    Some( Token::from(yystack.owned_value_at(2))),
                                    None,
                                    vec![],
                                    None
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  45 =>  /* command_asgn: primary_value "::" "constant" "operator-assignment" command_rhs  */
  /* "src/parser.y":799  */
                    {
                        let const_ = self.builder.const_op_assignable(
                            self.builder.const_fetch(
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2))
                            )
                        );
                        yyval = Value::Node(
                            self.builder.op_assign(
                                const_,
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  46 =>  /* command_asgn: primary_value "::" "local variable or method" "operator-assignment" command_rhs  */
  /* "src/parser.y":816  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.call_method(
                                    Some( BoxedNode::from(yystack.owned_value_at(4))),
                                    Some( Token::from(yystack.owned_value_at(3))),
                                    Some( Token::from(yystack.owned_value_at(2))),
                                    None,
                                    vec![],
                                    None
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  47 =>  /* command_asgn: backref "operator-assignment" command_rhs  */
  /* "src/parser.y":833  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  48 =>  /* command_rhs: command_call  */
  /* "src/parser.y":845  */
                    {
                        let command_call =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&command_call)?;
                        yyval = Value::Node(command_call);
                    },


  49 =>  /* command_rhs: command_call "`rescue' modifier" stmt  */
  /* "src/parser.y":851  */
                    {
                        let command_call =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&command_call)?;

                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0)))
                        );

                        yyval = Value::Node(
                            self.builder.begin_body(
                                Some(command_call),
                                vec![ *rescue_body ],
                                None,
                                None
                            ).expect("expected begin_body to return Some (compound_stmt was given)")
                        );
                    },


  50 =>  /* command_rhs: command_asgn  */
  /* "src/parser.y":874  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  51 =>  /* expr: command_call  */
  /* "src/parser.y":880  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  52 =>  /* expr: expr "`and'" expr  */
  /* "src/parser.y":884  */
                    {
                        yyval = Value::Node(
                            self.builder.logical_op(
                                LogicalOp::And,
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  53 =>  /* expr: expr "`or'" expr  */
  /* "src/parser.y":895  */
                    {
                        yyval = Value::Node(
                            self.builder.logical_op(
                                LogicalOp::Or,
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  54 =>  /* expr: "`not'" opt_nl expr  */
  /* "src/parser.y":906  */
                    {
                        yyval = Value::Node(
                            self.builder.not_op(
                                 Token::from(yystack.owned_value_at(2)),
                                None,
                                Some( BoxedNode::from(yystack.owned_value_at(0))),
                                None
                            )?
                        );
                    },


  55 =>  /* expr: "!" command_call  */
  /* "src/parser.y":917  */
                    {
                        yyval = Value::Node(
                            self.builder.not_op(
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                Some( BoxedNode::from(yystack.owned_value_at(0))),
                                None
                            )?
                        );
                    },


  56 =>  /* @4: %empty  */
  /* "src/parser.y":928  */
                    {
                        let arg = match yystack.borrow_value_at(1) {
                            Value::Node(node) => node,
                            other => unreachable!("expected Node, got {:?}", other)
                        };
                        self.value_expr(arg)?;

                        self.yylexer.lex_state.set(EXPR_BEG|EXPR_LABEL);
                        self.yylexer.command_start = false;
                        self.pattern_variables.push();

                        yyval = Value::Bool(self.yylexer.in_kwarg);
                        self.yylexer.in_kwarg = true;
                    },


  57 =>  /* expr: arg "=>" @4 p_expr  */
  /* "src/parser.y":943  */
                    {
                        self.pattern_variables.pop();
                        self.yylexer.in_kwarg =  Bool::from(yystack.owned_value_at(1));

                        yyval = Value::Node(
                            self.builder.match_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  58 =>  /* @5: %empty  */
  /* "src/parser.y":956  */
                    {
                        let arg = match yystack.borrow_value_at(1) {
                            Value::Node(node) => node,
                            other => unreachable!("expected Node, got {:?}", other)
                        };
                        self.value_expr(arg)?;

                        self.yylexer.lex_state.set(EXPR_BEG|EXPR_LABEL);
                        self.yylexer.command_start = false;
                        self.pattern_variables.push();

                        yyval = Value::Bool(self.yylexer.in_kwarg);
                        self.yylexer.in_kwarg = true;
                    },


  59 =>  /* expr: arg "`in'" @5 p_expr  */
  /* "src/parser.y":971  */
                    {
                        self.pattern_variables.pop();
                        self.yylexer.in_kwarg =  Bool::from(yystack.owned_value_at(1));

                        yyval = Value::Node(
                            self.builder.match_pattern_p(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  60 =>  /* expr: arg  */
  /* "src/parser.y":984  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  61 =>  /* def_name: fname  */
  /* "src/parser.y":990  */
                    {
                        self.static_env.extend_static();
                        self.yylexer.cmdarg.push(false);
                        self.yylexer.cond.push(false);
                        self.current_arg_stack.push(None);

                        yyval =  yystack.owned_value_at(0);
                    },


  62 =>  /* defn_head: k_def def_name  */
  /* "src/parser.y":1001  */
                    {
                        self.context.push_def();

                        yyval = Value::new_defn_head(
                            DefnHead {
                                def_t:  Token::from(yystack.owned_value_at(1)),
                                name_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  63 =>  /* @6: %empty  */
  /* "src/parser.y":1014  */
                    {
                        self.yylexer.lex_state.set(EXPR_FNAME);
                        yyval = Value::None;
                    },


  64 =>  /* defs_head: k_def singleton dot_or_colon @6 def_name  */
  /* "src/parser.y":1019  */
                    {
                        self.yylexer.lex_state.set(EXPR_ENDFN|EXPR_LABEL);
                        self.context.push_defs();

                        yyval = Value::new_defs_head(
                            DefsHead {
                                def_t:  Token::from(yystack.owned_value_at(4)),
                                definee:  BoxedNode::from(yystack.owned_value_at(3)),
                                dot_t:  Token::from(yystack.owned_value_at(2)),
                                name_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  65 =>  /* expr_value: expr  */
  /* "src/parser.y":1035  */
                    {
                        let expr =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&expr)?;
                        yyval = Value::Node(expr);
                    },


  66 =>  /* @7: %empty  */
  /* "src/parser.y":1042  */
                    {
                        self.yylexer.cond.push(true);
                        yyval = Value::None;
                    },


  67 =>  /* expr_value_do: @7 expr_value do  */
  /* "src/parser.y":1047  */
                    {
                        self.yylexer.cond.pop();

                        yyval = Value::new_expr_value_do(
                            ExprValueDo {
                                value:  BoxedNode::from(yystack.owned_value_at(1)),
                                do_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  68 =>  /* command_call: command  */
  /* "src/parser.y":1061  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  69 =>  /* command_call: block_command  */
  /* "src/parser.y":1065  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  70 =>  /* block_command: block_call  */
  /* "src/parser.y":1071  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  71 =>  /* block_command: block_call call_op2 operation2 command_args  */
  /* "src/parser.y":1075  */
                    {
                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(3))),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  72 =>  /* @8: %empty  */
  /* "src/parser.y":1090  */
                    {
                        self.context.push_block();
                        yyval = Value::None;
                    },


  73 =>  /* cmd_brace_block: "{ arg" @8 brace_body "}"  */
  /* "src/parser.y":1095  */
                    {
                        self.context.pop();
                        let BraceBody { args_type, body } =  BraceBody::from(yystack.owned_value_at(1));
                        yyval = Value::new_cmd_brace_block(
                            CmdBraceBlock {
                                begin_t:  Token::from(yystack.owned_value_at(3)),
                                args_type,
                                body,
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  74 =>  /* fcall: operation  */
  /* "src/parser.y":1110  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  75 =>  /* command: fcall command_args  */
  /* "src/parser.y":1116  */
                    {
                        yyval = Value::Node(
                            self.builder.call_method(
                                None,
                                None,
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  76 =>  /* command: fcall command_args cmd_brace_block  */
  /* "src/parser.y":1129  */
                    {
                        let method_call = self.builder.call_method(
                            None,
                            None,
                            Some( Token::from(yystack.owned_value_at(2))),
                            None,
                             NodeList::from(yystack.owned_value_at(1)),
                            None
                        );
                        let CmdBraceBlock { begin_t, args_type, body, end_t } =  CmdBraceBlock::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.block(
                                method_call,
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  77 =>  /* command: primary_value call_op operation2 command_args  */
  /* "src/parser.y":1151  */
                    {
                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(3))),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  78 =>  /* command: primary_value call_op operation2 command_args cmd_brace_block  */
  /* "src/parser.y":1164  */
                    {
                        let method_call = self.builder.call_method(
                            Some( BoxedNode::from(yystack.owned_value_at(4))),
                            Some( Token::from(yystack.owned_value_at(3))),
                            Some( Token::from(yystack.owned_value_at(2))),
                            None,
                             NodeList::from(yystack.owned_value_at(1)),
                            None
                        );
                        let CmdBraceBlock { begin_t, args_type, body, end_t } =  CmdBraceBlock::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.block(
                                method_call,
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  79 =>  /* command: primary_value "::" operation2 command_args  */
  /* "src/parser.y":1186  */
                    {
                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(3))),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  80 =>  /* command: primary_value "::" operation2 command_args cmd_brace_block  */
  /* "src/parser.y":1199  */
                    {
                        let method_call = self.builder.call_method(
                            Some( BoxedNode::from(yystack.owned_value_at(4))),
                            Some( Token::from(yystack.owned_value_at(3))),
                            Some( Token::from(yystack.owned_value_at(2))),
                            None,
                             NodeList::from(yystack.owned_value_at(1)),
                            None
                        );
                        let CmdBraceBlock { begin_t, args_type, body, end_t } =  CmdBraceBlock::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.block(
                                method_call,
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  81 =>  /* command: "`super'" command_args  */
  /* "src/parser.y":1221  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Super,
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )?
                        );
                    },


  82 =>  /* command: "`yield'" command_args  */
  /* "src/parser.y":1233  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Yield,
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )?
                        );
                    },


  83 =>  /* command: k_return call_args  */
  /* "src/parser.y":1245  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Return,
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )?
                        );
                    },


  84 =>  /* command: "`break'" call_args  */
  /* "src/parser.y":1257  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Break,
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )?
                        );
                    },


  85 =>  /* command: "`next'" call_args  */
  /* "src/parser.y":1269  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Next,
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )?
                        );
                    },


  86 =>  /* mlhs: mlhs_basic  */
  /* "src/parser.y":1283  */
                    {
                        yyval = Value::Node(
                            self.builder.multi_lhs(
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  87 =>  /* mlhs: "(" mlhs_inner rparen  */
  /* "src/parser.y":1293  */
                    {
                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(2)),
                                Some( BoxedNode::from(yystack.owned_value_at(1))),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  88 =>  /* mlhs_inner: mlhs_basic  */
  /* "src/parser.y":1305  */
                    {
                        yyval = Value::Node(
                            self.builder.multi_lhs(
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  89 =>  /* mlhs_inner: "(" mlhs_inner rparen  */
  /* "src/parser.y":1315  */
                    {
                        let mlhs_items: Vec<Node> = match  Node::from(yystack.owned_value_at(1)) {
                            Node::Mlhs(mlhs) => mlhs.items.into(),
                            other => unreachable!("unsupported mlhs item {:?}", other)
                        };

                        yyval = Value::Node(
                            self.builder.multi_lhs(
                                Some( Token::from(yystack.owned_value_at(2))),
                                mlhs_items,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  90 =>  /* mlhs_basic: mlhs_head  */
  /* "src/parser.y":1332  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  91 =>  /* mlhs_basic: mlhs_head mlhs_item  */
  /* "src/parser.y":1336  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  92 =>  /* mlhs_basic: mlhs_head "*" mlhs_node  */
  /* "src/parser.y":1342  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push( *self.builder.splat( Token::from(yystack.owned_value_at(1)), Some( BoxedNode::from(yystack.owned_value_at(0)))) );
                        yyval = Value::NodeList(nodes);
                    },


  93 =>  /* mlhs_basic: mlhs_head "*" mlhs_node "," mlhs_post  */
  /* "src/parser.y":1348  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(4));
                        let mlhs_node = self.builder.splat( Token::from(yystack.owned_value_at(3)), Some( BoxedNode::from(yystack.owned_value_at(2))));
                        let mut mlhs_post =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(1 + mlhs_post.len());
                        nodes.push(*mlhs_node);
                        nodes.append(&mut mlhs_post);

                        yyval = Value::NodeList(nodes);
                    },


  94 =>  /* mlhs_basic: mlhs_head "*"  */
  /* "src/parser.y":1360  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.push( *self.builder.splat( Token::from(yystack.owned_value_at(0)), None) );
                        yyval = Value::NodeList(nodes);
                    },


  95 =>  /* mlhs_basic: mlhs_head "*" "," mlhs_post  */
  /* "src/parser.y":1366  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let splat = self.builder.splat( Token::from(yystack.owned_value_at(2)), None);
                        let mut mlhs_post =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(1 + mlhs_post.len());
                        nodes.push(*splat);
                        nodes.append(&mut mlhs_post);

                        yyval = Value::NodeList(nodes);
                    },


  96 =>  /* mlhs_basic: "*" mlhs_node  */
  /* "src/parser.y":1378  */
                    {
                        yyval = Value::NodeList(vec![ *self.builder.splat( Token::from(yystack.owned_value_at(1)), Some( BoxedNode::from(yystack.owned_value_at(0)))) ]);
                    },


  97 =>  /* mlhs_basic: "*" mlhs_node "," mlhs_post  */
  /* "src/parser.y":1382  */
                    {
                        let mut nodes;
                        let splat = self.builder.splat( Token::from(yystack.owned_value_at(3)), Some( BoxedNode::from(yystack.owned_value_at(2))));
                        let mut mlhs_post =  NodeList::from(yystack.owned_value_at(0));

                        nodes = Vec::with_capacity(1 + mlhs_post.len());
                        nodes.push(*splat);
                        nodes.append(&mut mlhs_post);

                        yyval = Value::NodeList(nodes);
                    },


  98 =>  /* mlhs_basic: "*"  */
  /* "src/parser.y":1394  */
                    {
                        yyval = Value::NodeList(vec![ *self.builder.splat( Token::from(yystack.owned_value_at(0)), None) ]);
                    },


  99 =>  /* mlhs_basic: "*" "," mlhs_post  */
  /* "src/parser.y":1398  */
                    {
                        let mut nodes;
                        let splat = self.builder.splat( Token::from(yystack.owned_value_at(2)), None);
                        let mut mlhs_post =  NodeList::from(yystack.owned_value_at(0));

                        nodes = Vec::with_capacity(1 + mlhs_post.len());
                        nodes.push(*splat);
                        nodes.append(&mut mlhs_post);

                        yyval = Value::NodeList(nodes);
                    },


  100 =>  /* mlhs_item: mlhs_node  */
  /* "src/parser.y":1412  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  101 =>  /* mlhs_item: "(" mlhs_inner rparen  */
  /* "src/parser.y":1416  */
                    {
                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(2)),
                                Some( BoxedNode::from(yystack.owned_value_at(1))),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  102 =>  /* mlhs_head: mlhs_item ","  */
  /* "src/parser.y":1428  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(1)) ]);
                    },


  103 =>  /* mlhs_head: mlhs_head mlhs_item ","  */
  /* "src/parser.y":1432  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(1)) );
                        yyval = Value::NodeList(nodes);
                    },


  104 =>  /* mlhs_post: mlhs_item  */
  /* "src/parser.y":1440  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  105 =>  /* mlhs_post: mlhs_post "," mlhs_item  */
  /* "src/parser.y":1444  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  106 =>  /* mlhs_node: user_variable  */
  /* "src/parser.y":1452  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable( BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  107 =>  /* mlhs_node: keyword_variable  */
  /* "src/parser.y":1458  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable( BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  108 =>  /* mlhs_node: primary_value "[ (tLBRACK2)" opt_call_args rbracket  */
  /* "src/parser.y":1464  */
                    {
                        yyval = Value::Node(
                            self.builder.index_asgn(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  109 =>  /* mlhs_node: primary_value call_op "local variable or method"  */
  /* "src/parser.y":1475  */
                    {
                        let op_t =  Token::from(yystack.owned_value_at(1));
                        if op_t.token_type() == Lexer::tANDDOT {
                            return self.yyerror(&yystack.location_at (1), DiagnosticMessage::CsendInsideMasgn);
                        }

                        yyval = Value::Node(
                            self.builder.attr_asgn(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                op_t,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  110 =>  /* mlhs_node: primary_value "::" "local variable or method"  */
  /* "src/parser.y":1490  */
                    {
                        yyval = Value::Node(
                            self.builder.attr_asgn(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  111 =>  /* mlhs_node: primary_value call_op "constant"  */
  /* "src/parser.y":1500  */
                    {
                        let op_t =  Token::from(yystack.owned_value_at(1));
                        if op_t.token_type() == Lexer::tANDDOT {
                            return self.yyerror(&yystack.location_at (1), DiagnosticMessage::CsendInsideMasgn);
                        }

                        yyval = Value::Node(
                            self.builder.attr_asgn(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                op_t,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  112 =>  /* mlhs_node: primary_value "::" "constant"  */
  /* "src/parser.y":1515  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable(
                                self.builder.const_fetch(
                                     BoxedNode::from(yystack.owned_value_at(2)),
                                     Token::from(yystack.owned_value_at(1)),
                                     Token::from(yystack.owned_value_at(0))
                                )
                            )?
                        );
                    },


  113 =>  /* mlhs_node: ":: at EXPR_BEG" "constant"  */
  /* "src/parser.y":1527  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable(
                                self.builder.const_global(
                                     Token::from(yystack.owned_value_at(1)),
                                     Token::from(yystack.owned_value_at(0))
                                )
                            )?
                        );
                    },


  114 =>  /* mlhs_node: backref  */
  /* "src/parser.y":1538  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable(
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  115 =>  /* lhs: user_variable  */
  /* "src/parser.y":1548  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable( BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  116 =>  /* lhs: keyword_variable  */
  /* "src/parser.y":1554  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable( BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  117 =>  /* lhs: primary_value "[ (tLBRACK2)" opt_call_args rbracket  */
  /* "src/parser.y":1560  */
                    {
                        yyval = Value::Node(
                            self.builder.index_asgn(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        )
                    },


  118 =>  /* lhs: primary_value call_op "local variable or method"  */
  /* "src/parser.y":1571  */
                    {
                        yyval = Value::Node(
                            self.builder.attr_asgn(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  119 =>  /* lhs: primary_value "::" "local variable or method"  */
  /* "src/parser.y":1581  */
                    {
                        yyval = Value::Node(
                            self.builder.attr_asgn(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  120 =>  /* lhs: primary_value call_op "constant"  */
  /* "src/parser.y":1591  */
                    {
                        yyval = Value::Node(
                            self.builder.attr_asgn(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  121 =>  /* lhs: primary_value "::" "constant"  */
  /* "src/parser.y":1601  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable(
                                self.builder.const_fetch(
                                     BoxedNode::from(yystack.owned_value_at(2)),
                                     Token::from(yystack.owned_value_at(1)),
                                     Token::from(yystack.owned_value_at(0)),
                                )
                            )?
                        );
                    },


  122 =>  /* lhs: ":: at EXPR_BEG" "constant"  */
  /* "src/parser.y":1613  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable(
                                self.builder.const_global(
                                     Token::from(yystack.owned_value_at(1)),
                                     Token::from(yystack.owned_value_at(0)),
                                )
                            )?
                        );
                    },


  123 =>  /* lhs: backref  */
  /* "src/parser.y":1624  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable(
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  124 =>  /* cname: "local variable or method"  */
  /* "src/parser.y":1634  */
                    {
                        return self.yyerror(&yystack.location_at (0), DiagnosticMessage::ClassOrModuleNameMustBeConstant);
                    },


  125 =>  /* cname: "constant"  */
  /* "src/parser.y":1638  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  126 =>  /* cpath: ":: at EXPR_BEG" cname  */
  /* "src/parser.y":1644  */
                    {
                        yyval = Value::Node(
                            self.builder.const_global( Token::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                        );
                    },


  127 =>  /* cpath: cname  */
  /* "src/parser.y":1650  */
                    {
                        yyval = Value::Node(
                            self.builder.const_( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  128 =>  /* cpath: primary_value "::" cname  */
  /* "src/parser.y":1656  */
                    {
                        yyval = Value::Node(
                            self.builder.const_fetch(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  129 =>  /* fname: "local variable or method"  */
  /* "src/parser.y":1668  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  130 =>  /* fname: "constant"  */
  /* "src/parser.y":1672  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  131 =>  /* fname: "method"  */
  /* "src/parser.y":1676  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  132 =>  /* fname: op  */
  /* "src/parser.y":1680  */
                    {
                        self.yylexer.lex_state.set(EXPR_ENDFN);
                        yyval =  yystack.owned_value_at(0);
                    },


  133 =>  /* fname: reswords  */
  /* "src/parser.y":1685  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  134 =>  /* fitem: fname  */
  /* "src/parser.y":1691  */
                    {
                        yyval = Value::Node(
                            self.builder.symbol_internal( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  135 =>  /* fitem: symbol  */
  /* "src/parser.y":1697  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  136 =>  /* undef_list: fitem  */
  /* "src/parser.y":1703  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  137 =>  /* @9: %empty  */
  /* "src/parser.y":1707  */
                    {
                        self.yylexer.lex_state.set(EXPR_FNAME|EXPR_FITEM);
                        yyval = Value::None;
                    },


  138 =>  /* undef_list: undef_list "," @9 fitem  */
  /* "src/parser.y":1712  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  139 =>  /* op: "|"  */
  /* "src/parser.y":1719  */
                             { yyval =  yystack.owned_value_at(0); },


  140 =>  /* op: "^"  */
  /* "src/parser.y":1720  */
                             { yyval =  yystack.owned_value_at(0); },


  141 =>  /* op: "& (tAMPER2)"  */
  /* "src/parser.y":1721  */
                             { yyval =  yystack.owned_value_at(0); },


  142 =>  /* op: "<=>"  */
  /* "src/parser.y":1722  */
                             { yyval =  yystack.owned_value_at(0); },


  143 =>  /* op: "=="  */
  /* "src/parser.y":1723  */
                             { yyval =  yystack.owned_value_at(0); },


  144 =>  /* op: "==="  */
  /* "src/parser.y":1724  */
                             { yyval =  yystack.owned_value_at(0); },


  145 =>  /* op: "=~"  */
  /* "src/parser.y":1725  */
                             { yyval =  yystack.owned_value_at(0); },


  146 =>  /* op: "!~"  */
  /* "src/parser.y":1726  */
                             { yyval =  yystack.owned_value_at(0); },


  147 =>  /* op: ">"  */
  /* "src/parser.y":1727  */
                             { yyval =  yystack.owned_value_at(0); },


  148 =>  /* op: ">="  */
  /* "src/parser.y":1728  */
                             { yyval =  yystack.owned_value_at(0); },


  149 =>  /* op: "<"  */
  /* "src/parser.y":1729  */
                             { yyval =  yystack.owned_value_at(0); },


  150 =>  /* op: "<="  */
  /* "src/parser.y":1730  */
                             { yyval =  yystack.owned_value_at(0); },


  151 =>  /* op: "!="  */
  /* "src/parser.y":1731  */
                             { yyval =  yystack.owned_value_at(0); },


  152 =>  /* op: "<<"  */
  /* "src/parser.y":1732  */
                             { yyval =  yystack.owned_value_at(0); },


  153 =>  /* op: ">>"  */
  /* "src/parser.y":1733  */
                             { yyval =  yystack.owned_value_at(0); },


  154 =>  /* op: "+"  */
  /* "src/parser.y":1734  */
                             { yyval =  yystack.owned_value_at(0); },


  155 =>  /* op: "-"  */
  /* "src/parser.y":1735  */
                             { yyval =  yystack.owned_value_at(0); },


  156 =>  /* op: "* (tSTAR2)"  */
  /* "src/parser.y":1736  */
                             { yyval =  yystack.owned_value_at(0); },


  157 =>  /* op: "*"  */
  /* "src/parser.y":1737  */
                             { yyval =  yystack.owned_value_at(0); },


  158 =>  /* op: "/"  */
  /* "src/parser.y":1738  */
                             { yyval =  yystack.owned_value_at(0); },


  159 =>  /* op: "%"  */
  /* "src/parser.y":1739  */
                             { yyval =  yystack.owned_value_at(0); },


  160 =>  /* op: "**"  */
  /* "src/parser.y":1740  */
                             { yyval =  yystack.owned_value_at(0); },


  161 =>  /* op: "**arg"  */
  /* "src/parser.y":1741  */
                             { yyval =  yystack.owned_value_at(0); },


  162 =>  /* op: "!"  */
  /* "src/parser.y":1742  */
                             { yyval =  yystack.owned_value_at(0); },


  163 =>  /* op: "~"  */
  /* "src/parser.y":1743  */
                             { yyval =  yystack.owned_value_at(0); },


  164 =>  /* op: "unary+"  */
  /* "src/parser.y":1744  */
                             { yyval =  yystack.owned_value_at(0); },


  165 =>  /* op: "unary-"  */
  /* "src/parser.y":1745  */
                             { yyval =  yystack.owned_value_at(0); },


  166 =>  /* op: "[]"  */
  /* "src/parser.y":1746  */
                             { yyval =  yystack.owned_value_at(0); },


  167 =>  /* op: "[]="  */
  /* "src/parser.y":1747  */
                             { yyval =  yystack.owned_value_at(0); },


  168 =>  /* op: "`"  */
  /* "src/parser.y":1748  */
                             { yyval =  yystack.owned_value_at(0); },


  169 =>  /* reswords: "`__LINE__'"  */
  /* "src/parser.y":1751  */
                                { yyval =  yystack.owned_value_at(0); },


  170 =>  /* reswords: "`__FILE__'"  */
  /* "src/parser.y":1752  */
                                { yyval =  yystack.owned_value_at(0); },


  171 =>  /* reswords: "`__ENCODING__'"  */
  /* "src/parser.y":1753  */
                                { yyval =  yystack.owned_value_at(0); },


  172 =>  /* reswords: "`BEGIN'"  */
  /* "src/parser.y":1754  */
                                { yyval =  yystack.owned_value_at(0); },


  173 =>  /* reswords: "`END'"  */
  /* "src/parser.y":1755  */
                                { yyval =  yystack.owned_value_at(0); },


  174 =>  /* reswords: "`alias'"  */
  /* "src/parser.y":1756  */
                                { yyval =  yystack.owned_value_at(0); },


  175 =>  /* reswords: "`and'"  */
  /* "src/parser.y":1757  */
                                { yyval =  yystack.owned_value_at(0); },


  176 =>  /* reswords: "`begin'"  */
  /* "src/parser.y":1758  */
                                { yyval =  yystack.owned_value_at(0); },


  177 =>  /* reswords: "`break'"  */
  /* "src/parser.y":1759  */
                                { yyval =  yystack.owned_value_at(0); },


  178 =>  /* reswords: "`case'"  */
  /* "src/parser.y":1760  */
                                { yyval =  yystack.owned_value_at(0); },


  179 =>  /* reswords: "`class'"  */
  /* "src/parser.y":1761  */
                                { yyval =  yystack.owned_value_at(0); },


  180 =>  /* reswords: "`def'"  */
  /* "src/parser.y":1762  */
                                { yyval =  yystack.owned_value_at(0); },


  181 =>  /* reswords: "`defined?'"  */
  /* "src/parser.y":1763  */
                                { yyval =  yystack.owned_value_at(0); },


  182 =>  /* reswords: "`do'"  */
  /* "src/parser.y":1764  */
                                { yyval =  yystack.owned_value_at(0); },


  183 =>  /* reswords: "`else'"  */
  /* "src/parser.y":1765  */
                                { yyval =  yystack.owned_value_at(0); },


  184 =>  /* reswords: "`elsif'"  */
  /* "src/parser.y":1766  */
                                { yyval =  yystack.owned_value_at(0); },


  185 =>  /* reswords: "`end'"  */
  /* "src/parser.y":1767  */
                                { yyval =  yystack.owned_value_at(0); },


  186 =>  /* reswords: "`ensure'"  */
  /* "src/parser.y":1768  */
                                { yyval =  yystack.owned_value_at(0); },


  187 =>  /* reswords: "`false'"  */
  /* "src/parser.y":1769  */
                                { yyval =  yystack.owned_value_at(0); },


  188 =>  /* reswords: "`for'"  */
  /* "src/parser.y":1770  */
                                { yyval =  yystack.owned_value_at(0); },


  189 =>  /* reswords: "`in'"  */
  /* "src/parser.y":1771  */
                                { yyval =  yystack.owned_value_at(0); },


  190 =>  /* reswords: "`module'"  */
  /* "src/parser.y":1772  */
                                { yyval =  yystack.owned_value_at(0); },


  191 =>  /* reswords: "`next'"  */
  /* "src/parser.y":1773  */
                                { yyval =  yystack.owned_value_at(0); },


  192 =>  /* reswords: "`nil'"  */
  /* "src/parser.y":1774  */
                                { yyval =  yystack.owned_value_at(0); },


  193 =>  /* reswords: "`not'"  */
  /* "src/parser.y":1775  */
                                { yyval =  yystack.owned_value_at(0); },


  194 =>  /* reswords: "`or'"  */
  /* "src/parser.y":1776  */
                                { yyval =  yystack.owned_value_at(0); },


  195 =>  /* reswords: "`redo'"  */
  /* "src/parser.y":1777  */
                                { yyval =  yystack.owned_value_at(0); },


  196 =>  /* reswords: "`rescue'"  */
  /* "src/parser.y":1778  */
                                { yyval =  yystack.owned_value_at(0); },


  197 =>  /* reswords: "`retry'"  */
  /* "src/parser.y":1779  */
                                { yyval =  yystack.owned_value_at(0); },


  198 =>  /* reswords: "`return'"  */
  /* "src/parser.y":1780  */
                                { yyval =  yystack.owned_value_at(0); },


  199 =>  /* reswords: "`self'"  */
  /* "src/parser.y":1781  */
                                { yyval =  yystack.owned_value_at(0); },


  200 =>  /* reswords: "`super'"  */
  /* "src/parser.y":1782  */
                                { yyval =  yystack.owned_value_at(0); },


  201 =>  /* reswords: "`then'"  */
  /* "src/parser.y":1783  */
                                { yyval =  yystack.owned_value_at(0); },


  202 =>  /* reswords: "`true'"  */
  /* "src/parser.y":1784  */
                                { yyval =  yystack.owned_value_at(0); },


  203 =>  /* reswords: "`undef'"  */
  /* "src/parser.y":1785  */
                                { yyval =  yystack.owned_value_at(0); },


  204 =>  /* reswords: "`when'"  */
  /* "src/parser.y":1786  */
                                { yyval =  yystack.owned_value_at(0); },


  205 =>  /* reswords: "`yield'"  */
  /* "src/parser.y":1787  */
                                { yyval =  yystack.owned_value_at(0); },


  206 =>  /* reswords: "`if'"  */
  /* "src/parser.y":1788  */
                                { yyval =  yystack.owned_value_at(0); },


  207 =>  /* reswords: "`unless'"  */
  /* "src/parser.y":1789  */
                                { yyval =  yystack.owned_value_at(0); },


  208 =>  /* reswords: "`while'"  */
  /* "src/parser.y":1790  */
                                { yyval =  yystack.owned_value_at(0); },


  209 =>  /* reswords: "`until'"  */
  /* "src/parser.y":1791  */
                                { yyval =  yystack.owned_value_at(0); },


  210 =>  /* arg: lhs "=" arg_rhs  */
  /* "src/parser.y":1795  */
                    {
                        yyval = Value::Node(
                            self.builder.assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  211 =>  /* arg: var_lhs "operator-assignment" arg_rhs  */
  /* "src/parser.y":1805  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  212 =>  /* arg: primary_value "[ (tLBRACK2)" opt_call_args rbracket "operator-assignment" arg_rhs  */
  /* "src/parser.y":1815  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.index(
                                     BoxedNode::from(yystack.owned_value_at(5)),
                                     Token::from(yystack.owned_value_at(4)),
                                     NodeList::from(yystack.owned_value_at(3)),
                                     Token::from(yystack.owned_value_at(2))
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  213 =>  /* arg: primary_value call_op "local variable or method" "operator-assignment" arg_rhs  */
  /* "src/parser.y":1830  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.call_method(
                                    Some( BoxedNode::from(yystack.owned_value_at(4))),
                                    Some( Token::from(yystack.owned_value_at(3))),
                                    Some( Token::from(yystack.owned_value_at(2))),
                                    None,
                                    vec![],
                                    None
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  214 =>  /* arg: primary_value call_op "constant" "operator-assignment" arg_rhs  */
  /* "src/parser.y":1847  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.call_method(
                                    Some( BoxedNode::from(yystack.owned_value_at(4))),
                                    Some( Token::from(yystack.owned_value_at(3))),
                                    Some( Token::from(yystack.owned_value_at(2))),
                                    None,
                                    vec![],
                                    None
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  215 =>  /* arg: primary_value "::" "local variable or method" "operator-assignment" arg_rhs  */
  /* "src/parser.y":1864  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.call_method(
                                    Some( BoxedNode::from(yystack.owned_value_at(4))),
                                    Some( Token::from(yystack.owned_value_at(3))),
                                    Some( Token::from(yystack.owned_value_at(2))),
                                    None,
                                    vec![],
                                    None
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  216 =>  /* arg: primary_value "::" "constant" "operator-assignment" arg_rhs  */
  /* "src/parser.y":1881  */
                    {
                        let const_ = self.builder.const_op_assignable(
                            self.builder.const_fetch(
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2))
                            )
                        );
                        yyval = Value::Node(
                            self.builder.op_assign(
                                const_,
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  217 =>  /* arg: ":: at EXPR_BEG" "constant" "operator-assignment" arg_rhs  */
  /* "src/parser.y":1898  */
                    {
                        let const_ = self.builder.const_op_assignable(
                            self.builder.const_global(
                                 Token::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2))
                            )
                        );
                        yyval = Value::Node(
                            self.builder.op_assign(
                                const_,
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  218 =>  /* arg: backref "operator-assignment" arg_rhs  */
  /* "src/parser.y":1914  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  219 =>  /* arg: arg ".." arg  */
  /* "src/parser.y":1924  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&left)?;

                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_inclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  220 =>  /* arg: arg "..." arg  */
  /* "src/parser.y":1940  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&left)?;

                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_exclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  221 =>  /* arg: arg ".."  */
  /* "src/parser.y":1956  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(1));
                        self.value_expr(&left)?;

                        yyval = Value::Node(
                            self.builder.range_inclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  222 =>  /* arg: arg "..."  */
  /* "src/parser.y":1969  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(1));
                        self.value_expr(&left)?;

                        yyval = Value::Node(
                            self.builder.range_exclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  223 =>  /* arg: "(.." arg  */
  /* "src/parser.y":1982  */
                    {
                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_inclusive(
                                None,
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  224 =>  /* arg: "(..." arg  */
  /* "src/parser.y":1995  */
                    {
                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_exclusive(
                                None,
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  225 =>  /* arg: arg "+" arg  */
  /* "src/parser.y":2008  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  226 =>  /* arg: arg "-" arg  */
  /* "src/parser.y":2014  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  227 =>  /* arg: arg "* (tSTAR2)" arg  */
  /* "src/parser.y":2020  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  228 =>  /* arg: arg "/" arg  */
  /* "src/parser.y":2026  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  229 =>  /* arg: arg "%" arg  */
  /* "src/parser.y":2032  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  230 =>  /* arg: arg "**" arg  */
  /* "src/parser.y":2038  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  231 =>  /* arg: tUMINUS_NUM simple_numeric "**" arg  */
  /* "src/parser.y":2044  */
                    {
                        yyval = Value::Node(
                            self.builder.unary_op(
                                 Token::from(yystack.owned_value_at(3)),
                                self.builder.binary_op(
                                     BoxedNode::from(yystack.owned_value_at(2)),
                                     Token::from(yystack.owned_value_at(1)),
                                     BoxedNode::from(yystack.owned_value_at(0))
                                )?
                            )?
                        );
                    },


  232 =>  /* arg: "unary+" arg  */
  /* "src/parser.y":2057  */
                    {
                        yyval = Value::Node(
                            self.builder.unary_op(
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  233 =>  /* arg: "unary-" arg  */
  /* "src/parser.y":2066  */
                    {
                        yyval = Value::Node(
                            self.builder.unary_op(
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  234 =>  /* arg: arg "|" arg  */
  /* "src/parser.y":2075  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  235 =>  /* arg: arg "^" arg  */
  /* "src/parser.y":2081  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  236 =>  /* arg: arg "& (tAMPER2)" arg  */
  /* "src/parser.y":2087  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  237 =>  /* arg: arg "<=>" arg  */
  /* "src/parser.y":2093  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  238 =>  /* arg: rel_expr  */
  /* "src/parser.y":2099  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  239 =>  /* arg: arg "==" arg  */
  /* "src/parser.y":2103  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  240 =>  /* arg: arg "===" arg  */
  /* "src/parser.y":2109  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  241 =>  /* arg: arg "!=" arg  */
  /* "src/parser.y":2115  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  242 =>  /* arg: arg "=~" arg  */
  /* "src/parser.y":2121  */
                    {
                        yyval = Value::Node(
                            self.builder.match_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  243 =>  /* arg: arg "!~" arg  */
  /* "src/parser.y":2127  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  244 =>  /* arg: "!" arg  */
  /* "src/parser.y":2137  */
                    {
                        yyval = Value::Node(
                            self.builder.not_op(
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                Some( BoxedNode::from(yystack.owned_value_at(0))),
                                None
                            )?
                        );
                    },


  245 =>  /* arg: "~" arg  */
  /* "src/parser.y":2148  */
                    {
                        yyval = Value::Node(
                            self.builder.unary_op(
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  246 =>  /* arg: arg "<<" arg  */
  /* "src/parser.y":2157  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  247 =>  /* arg: arg ">>" arg  */
  /* "src/parser.y":2163  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  248 =>  /* arg: arg "&&" arg  */
  /* "src/parser.y":2169  */
                    {
                        yyval = Value::Node(
                            self.builder.logical_op(
                                LogicalOp::And,
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  249 =>  /* arg: arg "||" arg  */
  /* "src/parser.y":2180  */
                    {
                        yyval = Value::Node(
                            self.builder.logical_op(
                                LogicalOp::Or,
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  250 =>  /* arg: "`defined?'" opt_nl arg  */
  /* "src/parser.y":2191  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Defined,
                                 Token::from(yystack.owned_value_at(2)),
                                None,
                                vec![  Node::from(yystack.owned_value_at(0)) ],
                                None
                            )?
                        );
                    },


  251 =>  /* arg: arg tEH arg opt_nl tCOLON arg  */
  /* "src/parser.y":2203  */
                    {
                        let expr =  BoxedNode::from(yystack.owned_value_at(5));
                        self.value_expr(&expr)?;

                        yyval = Value::Node(
                            self.builder.ternary(
                                expr,
                                 Token::from(yystack.owned_value_at(4)),
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  252 =>  /* arg: defn_head f_opt_paren_args "=" arg  */
  /* "src/parser.y":2218  */
                    {
                        let DefnHead { def_t, name_t } =  DefnHead::from(yystack.owned_value_at(3));
                        self.validate_endless_method_name(&name_t)?;

                        yyval = Value::Node(
                            self.builder.def_endless_method(
                                def_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                Some( BoxedNode::from(yystack.owned_value_at(0)))
                            )?
                        );

                        self.yylexer.cmdarg.pop();
                        self.yylexer.cond.pop();
                        self.static_env.unextend();
                        self.context.pop();
                        self.current_arg_stack.pop();
                    },


  253 =>  /* arg: defn_head f_opt_paren_args "=" arg "`rescue' modifier" arg  */
  /* "src/parser.y":2239  */
                    {
                        let DefnHead { def_t, name_t } =  DefnHead::from(yystack.owned_value_at(5));
                        self.validate_endless_method_name(&name_t)?;

                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0)))
                        );

                        let method_body = self.builder.begin_body(
                            Some( BoxedNode::from(yystack.owned_value_at(2))),
                            vec![ *rescue_body ],
                            None,
                            None
                        );

                        yyval = Value::Node(
                            self.builder.def_endless_method(
                                def_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                method_body
                            )?
                        );

                        self.yylexer.cmdarg.pop();
                        self.yylexer.cond.pop();
                        self.static_env.unextend();
                        self.context.pop();
                        self.current_arg_stack.pop();
                    },


  254 =>  /* arg: defs_head f_opt_paren_args "=" arg  */
  /* "src/parser.y":2276  */
                    {
                        let DefsHead { def_t, definee, dot_t, name_t } =  DefsHead::from(yystack.owned_value_at(3));
                        self.validate_endless_method_name(&name_t)?;

                        yyval = Value::Node(
                            self.builder.def_endless_singleton(
                                def_t,
                                definee,
                                dot_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                Some( BoxedNode::from(yystack.owned_value_at(0)))
                            )?
                        );

                        self.yylexer.cmdarg.pop();
                        self.yylexer.cond.pop();
                        self.static_env.unextend();
                        self.context.pop();
                        self.current_arg_stack.pop();
                    },


  255 =>  /* arg: defs_head f_opt_paren_args "=" arg "`rescue' modifier" arg  */
  /* "src/parser.y":2299  */
                    {
                        let DefsHead { def_t, definee, dot_t, name_t } =  DefsHead::from(yystack.owned_value_at(5));
                        self.validate_endless_method_name(&name_t)?;

                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0)))
                        );

                        let method_body = self.builder.begin_body(
                            Some( BoxedNode::from(yystack.owned_value_at(2))),
                            vec![ *rescue_body ],
                            None,
                            None
                        );

                        yyval = Value::Node(
                            self.builder.def_endless_singleton(
                                def_t,
                                definee,
                                dot_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                method_body
                            )?
                        );

                        self.yylexer.cmdarg.pop();
                        self.yylexer.cond.pop();
                        self.static_env.unextend();
                        self.context.pop();
                        self.current_arg_stack.pop();
                    },


  256 =>  /* arg: primary  */
  /* "src/parser.y":2338  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  257 =>  /* relop: ">"  */
  /* "src/parser.y":2344  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  258 =>  /* relop: "<"  */
  /* "src/parser.y":2348  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  259 =>  /* relop: ">="  */
  /* "src/parser.y":2352  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  260 =>  /* relop: "<="  */
  /* "src/parser.y":2356  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  261 =>  /* rel_expr: arg relop arg  */
  /* "src/parser.y":2362  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  262 =>  /* rel_expr: rel_expr relop arg  */
  /* "src/parser.y":2372  */
                    {
                        let op_t =  Token::from(yystack.owned_value_at(1));
                        self.warn(
                            &yystack.location_at (1),
                            DiagnosticMessage::ComparisonAfterComparison { comparison: clone_value(&op_t).into() }
                        );
                        yyval = Value::Node(
                            self.builder.binary_op(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                op_t,
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  263 =>  /* arg_value: arg  */
  /* "src/parser.y":2389  */
                    {
                        let arg =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&arg)?;
                        yyval = Value::Node(arg);
                    },


  264 =>  /* aref_args: none  */
  /* "src/parser.y":2397  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  265 =>  /* aref_args: args trailer  */
  /* "src/parser.y":2401  */
                    {
                        yyval =  yystack.owned_value_at(1);
                    },


  266 =>  /* aref_args: args "," assocs trailer  */
  /* "src/parser.y":2405  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        nodes.push(
                            *self.builder.associate(None,  NodeList::from(yystack.owned_value_at(1)), None)
                        );
                        yyval = Value::NodeList(nodes);
                    },


  267 =>  /* aref_args: assocs trailer  */
  /* "src/parser.y":2413  */
                    {
                        yyval = Value::NodeList(
                            vec![
                                *self.builder.associate(None,  NodeList::from(yystack.owned_value_at(1)), None)
                            ]
                        );
                    },


  268 =>  /* arg_rhs: arg  */
  /* "src/parser.y":2423  */
                    {
                        let arg =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&arg)?;
                        yyval = Value::Node(arg);
                    },


  269 =>  /* arg_rhs: arg "`rescue' modifier" arg  */
  /* "src/parser.y":2429  */
                    {
                        let arg =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&arg)?;

                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0)))
                        );

                        yyval = Value::Node(
                            self.builder.begin_body(
                                Some(arg),
                                vec![ *rescue_body ],
                                None,
                                None
                            ).expect("expected begin_body to return Some (compound_stmt was given)")
                        );
                    },


  270 =>  /* paren_args: "( (tLPAREN2)" opt_call_args rparen  */
  /* "src/parser.y":2454  */
                    {
                        yyval = Value::new_paren_args(
                            ParenArgs {
                                begin_t:  Token::from(yystack.owned_value_at(2)),
                                args:  NodeList::from(yystack.owned_value_at(1)),
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  271 =>  /* paren_args: "( (tLPAREN2)" args "," args_forward rparen  */
  /* "src/parser.y":2464  */
                    {
                        if !self.static_env.is_forward_args_declared() {
                            return self.yyerror(&yystack.location_at (1), DiagnosticMessage::UnexpectedToken { token_name: "tBDOT3".into() });
                        }

                        let mut args =  NodeList::from(yystack.owned_value_at(3));
                        args.push(*self.builder.forwarded_args( Token::from(yystack.owned_value_at(1))));

                        yyval = Value::new_paren_args(
                            ParenArgs {
                                begin_t:  Token::from(yystack.owned_value_at(4)),
                                args,
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  272 =>  /* paren_args: "( (tLPAREN2)" args_forward rparen  */
  /* "src/parser.y":2481  */
                    {
                        if !self.static_env.is_forward_args_declared() {
                            return self.yyerror(&yystack.location_at (1), DiagnosticMessage::UnexpectedToken { token_name: "tBDOT3".into() });
                        }

                        yyval = Value::new_paren_args(
                            ParenArgs {
                                begin_t:  Token::from(yystack.owned_value_at(2)),
                                args: vec![ *self.builder.forwarded_args( Token::from(yystack.owned_value_at(1))) ],
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  273 =>  /* opt_paren_args: none  */
  /* "src/parser.y":2497  */
                    {
                        yyval = Value::new_opt_paren_args(
                            OptParenArgs {
                                begin_t: None,
                                args: vec![],
                                end_t: None
                            }
                        );
                    },


  274 =>  /* opt_paren_args: paren_args  */
  /* "src/parser.y":2507  */
                    {
                        let ParenArgs { begin_t, args, end_t } =  ParenArgs::from(yystack.owned_value_at(0));
                        yyval = Value::new_opt_paren_args(
                            OptParenArgs {
                                begin_t: Some(begin_t),
                                args,
                                end_t: Some(end_t)
                            }
                        );
                    },


  275 =>  /* opt_call_args: none  */
  /* "src/parser.y":2520  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  276 =>  /* opt_call_args: call_args  */
  /* "src/parser.y":2524  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  277 =>  /* opt_call_args: args ","  */
  /* "src/parser.y":2528  */
                    {
                        yyval =  yystack.owned_value_at(1);
                    },


  278 =>  /* opt_call_args: args "," assocs ","  */
  /* "src/parser.y":2532  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        nodes.push( *self.builder.associate(None,  NodeList::from(yystack.owned_value_at(1)), None) );
                        yyval = Value::NodeList(nodes);
                    },


  279 =>  /* opt_call_args: assocs ","  */
  /* "src/parser.y":2538  */
                    {
                        yyval = Value::NodeList(
                            vec![
                                *self.builder.associate(None,  NodeList::from(yystack.owned_value_at(1)), None)
                            ]
                        );
                    },


  280 =>  /* call_args: command  */
  /* "src/parser.y":2548  */
                    {
                        let command =  Node::from(yystack.owned_value_at(0));
                        self.value_expr(&command)?;
                        yyval = Value::NodeList( vec![ command ] );
                    },


  281 =>  /* call_args: args opt_block_arg  */
  /* "src/parser.y":2554  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  282 =>  /* call_args: assocs opt_block_arg  */
  /* "src/parser.y":2561  */
                    {
                        let mut nodes;
                        let hash = self.builder.associate(None,  NodeList::from(yystack.owned_value_at(1)), None);
                        let mut opt_block_arg =  NodeList::from(yystack.owned_value_at(0));

                        nodes = Vec::with_capacity(1 + opt_block_arg.len());
                        nodes.push(*hash);
                        nodes.append(&mut opt_block_arg);

                        yyval = Value::NodeList(nodes);
                    },


  283 =>  /* call_args: args "," assocs opt_block_arg  */
  /* "src/parser.y":2573  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let hash = self.builder.associate(None,  NodeList::from(yystack.owned_value_at(1)), None);
                        let mut opt_block_arg =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(1 + opt_block_arg.len());
                        nodes.push(*hash);
                        nodes.append(&mut opt_block_arg);

                        yyval = Value::NodeList(nodes);
                    },


  284 =>  /* call_args: block_arg  */
  /* "src/parser.y":2585  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  285 =>  /* @10: %empty  */
  /* "src/parser.y":2590  */
                    {
                        let lookahead =
                            matches!(
                                self.last_token_type,
                                Lexer::tLPAREN2
                                    | Lexer::tLPAREN
                                    | Lexer:: tLPAREN_ARG
                                    | Lexer::tLBRACK2
                                    | Lexer::tLBRACK
                            );

                        if lookahead { self.yylexer.cmdarg.pop() }
                        self.yylexer.cmdarg.push(true);
                        if lookahead { self.yylexer.cmdarg.push(false) }
                        yyval = Value::None;
                    },


  286 =>  /* command_args: @10 call_args  */
  /* "src/parser.y":2607  */
                    {
                        let lookahead = matches!(self.last_token_type, Lexer::tLBRACE_ARG);

                        if lookahead { self.yylexer.cmdarg.pop() }
                        self.yylexer.cmdarg.pop();
                        if lookahead { self.yylexer.cmdarg.push(false) }

                        yyval =  yystack.owned_value_at(0);
                    },


  287 =>  /* block_arg: "&" arg_value  */
  /* "src/parser.y":2619  */
                    {
                        yyval = Value::Node(
                            self.builder.block_pass(
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  288 =>  /* opt_block_arg: "," block_arg  */
  /* "src/parser.y":2630  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  289 =>  /* opt_block_arg: none  */
  /* "src/parser.y":2634  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  290 =>  /* args: arg_value  */
  /* "src/parser.y":2640  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  291 =>  /* args: "*" arg_value  */
  /* "src/parser.y":2644  */
                    {
                        yyval = Value::NodeList(
                            vec![
                                *self.builder.splat( Token::from(yystack.owned_value_at(1)), Some( BoxedNode::from(yystack.owned_value_at(0))))
                            ]
                        );
                    },


  292 =>  /* args: args "," arg_value  */
  /* "src/parser.y":2652  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  293 =>  /* args: args "," "*" arg_value  */
  /* "src/parser.y":2658  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        nodes.push( *self.builder.splat( Token::from(yystack.owned_value_at(1)), Some( BoxedNode::from(yystack.owned_value_at(0)))) );
                        yyval = Value::NodeList(nodes);
                    },


  294 =>  /* mrhs_arg: mrhs  */
  /* "src/parser.y":2666  */
                    {
                        yyval = Value::Node(
                            self.builder.array(None,  NodeList::from(yystack.owned_value_at(0)), None)
                        );
                    },


  295 =>  /* mrhs_arg: arg_value  */
  /* "src/parser.y":2672  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  296 =>  /* mrhs: args "," arg_value  */
  /* "src/parser.y":2678  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  297 =>  /* mrhs: args "," "*" arg_value  */
  /* "src/parser.y":2684  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        nodes.push(
                            *self.builder.splat( Token::from(yystack.owned_value_at(1)), Some( BoxedNode::from(yystack.owned_value_at(0))))
                        );
                        yyval = Value::NodeList(nodes);
                    },


  298 =>  /* mrhs: "*" arg_value  */
  /* "src/parser.y":2692  */
                    {
                        yyval = Value::NodeList(
                            vec![
                                *self.builder.splat( Token::from(yystack.owned_value_at(1)), Some( BoxedNode::from(yystack.owned_value_at(0))))
                            ]
                        );
                    },


  299 =>  /* primary: literal  */
  /* "src/parser.y":2702  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  300 =>  /* primary: strings  */
  /* "src/parser.y":2706  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  301 =>  /* primary: xstring  */
  /* "src/parser.y":2710  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  302 =>  /* primary: regexp  */
  /* "src/parser.y":2714  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  303 =>  /* primary: words  */
  /* "src/parser.y":2718  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  304 =>  /* primary: qwords  */
  /* "src/parser.y":2722  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  305 =>  /* primary: symbols  */
  /* "src/parser.y":2726  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  306 =>  /* primary: qsymbols  */
  /* "src/parser.y":2730  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  307 =>  /* primary: var_ref  */
  /* "src/parser.y":2734  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  308 =>  /* primary: backref  */
  /* "src/parser.y":2738  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  309 =>  /* primary: "method"  */
  /* "src/parser.y":2742  */
                    {
                        yyval = Value::Node(
                            self.builder.call_method(
                                None,
                                None,
                                Some( Token::from(yystack.owned_value_at(0))),
                                None,
                                vec![],
                                None
                            )
                        );
                    },


  310 =>  /* @11: %empty  */
  /* "src/parser.y":2755  */
                    {
                        self.yylexer.cmdarg.push(false);
                        yyval = Value::None;
                    },


  311 =>  /* primary: k_begin @11 bodystmt k_end  */
  /* "src/parser.y":2761  */
                    {
                        self.yylexer.cmdarg.pop();

                        yyval = Value::Node(
                            self.builder.begin_keyword( Token::from(yystack.owned_value_at(3)),  MaybeBoxedNode::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                        );
                    },


  312 =>  /* @12: %empty  */
  /* "src/parser.y":2768  */
                              { self.yylexer.lex_state.set(EXPR_ENDARG); yyval = Value::None; },


  313 =>  /* primary: "( arg" @12 rparen  */
  /* "src/parser.y":2769  */
                    {
                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(2)),
                                None,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  314 =>  /* @13: %empty  */
  /* "src/parser.y":2778  */
                                   { self.yylexer.lex_state.set(EXPR_ENDARG); yyval = Value::None; },


  315 =>  /* primary: "( arg" stmt @13 rparen  */
  /* "src/parser.y":2779  */
                    {
                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(3)),
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  316 =>  /* primary: "(" compstmt ")"  */
  /* "src/parser.y":2789  */
                    {
                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(2)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  317 =>  /* primary: primary_value "::" "constant"  */
  /* "src/parser.y":2799  */
                    {
                        yyval = Value::Node(
                            self.builder.const_fetch(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  318 =>  /* primary: ":: at EXPR_BEG" "constant"  */
  /* "src/parser.y":2809  */
                    {
                        yyval = Value::Node(
                            self.builder.const_global( Token::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                        );
                    },


  319 =>  /* primary: "[" aref_args "]"  */
  /* "src/parser.y":2815  */
                    {
                        yyval = Value::Node(
                            self.builder.array(
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  320 =>  /* primary: "{" assoc_list "}"  */
  /* "src/parser.y":2825  */
                    {
                        yyval = Value::Node(
                            self.builder.associate(
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  321 =>  /* primary: k_return  */
  /* "src/parser.y":2835  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Return,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  322 =>  /* primary: "`yield'" "( (tLPAREN2)" call_args rparen  */
  /* "src/parser.y":2847  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Yield,
                                 Token::from(yystack.owned_value_at(3)),
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )?
                        );
                    },


  323 =>  /* primary: "`yield'" "( (tLPAREN2)" rparen  */
  /* "src/parser.y":2859  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Yield,
                                 Token::from(yystack.owned_value_at(2)),
                                Some( Token::from(yystack.owned_value_at(1))),
                                vec![],
                                Some( Token::from(yystack.owned_value_at(0)))
                            )?
                        );
                    },


  324 =>  /* primary: "`yield'"  */
  /* "src/parser.y":2871  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Yield,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  325 =>  /* primary: "`defined?'" opt_nl "( (tLPAREN2)" expr rparen  */
  /* "src/parser.y":2883  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Defined,
                                 Token::from(yystack.owned_value_at(4)),
                                Some( Token::from(yystack.owned_value_at(2))),
                                vec![  Node::from(yystack.owned_value_at(1)) ],
                                Some( Token::from(yystack.owned_value_at(0)))
                            )?
                        );
                    },


  326 =>  /* primary: "`not'" "( (tLPAREN2)" expr rparen  */
  /* "src/parser.y":2895  */
                    {
                        yyval = Value::Node(
                            self.builder.not_op(
                                 Token::from(yystack.owned_value_at(3)),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( BoxedNode::from(yystack.owned_value_at(1))),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )?
                        );
                    },


  327 =>  /* primary: "`not'" "( (tLPAREN2)" rparen  */
  /* "src/parser.y":2906  */
                    {
                        yyval = Value::Node(
                            self.builder.not_op(
                                 Token::from(yystack.owned_value_at(2)),
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )?
                        );
                    },


  328 =>  /* primary: fcall brace_block  */
  /* "src/parser.y":2917  */
                    {
                        let method_call = self.builder.call_method(
                            None,
                            None,
                            Some( Token::from(yystack.owned_value_at(1))),
                            None,
                            vec![],
                            None
                        );
                        let BraceBlock { begin_t, args_type, body, end_t } =  BraceBlock::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.block(
                                method_call,
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  329 =>  /* primary: method_call  */
  /* "src/parser.y":2939  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  330 =>  /* primary: method_call brace_block  */
  /* "src/parser.y":2943  */
                    {
                        let BraceBlock { begin_t, args_type, body, end_t } =  BraceBlock::from(yystack.owned_value_at(0));
                        yyval = Value::Node(
                            self.builder.block(
                                 BoxedNode::from(yystack.owned_value_at(1)),
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  331 =>  /* primary: lambda  */
  /* "src/parser.y":2956  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  332 =>  /* primary: k_if expr_value then compstmt if_tail k_end  */
  /* "src/parser.y":2963  */
                    {
                        let IfTail { keyword_t, body: else_body } =  IfTail::from(yystack.owned_value_at(1));

                        yyval = Value::Node(
                            self.builder.condition(
                                 Token::from(yystack.owned_value_at(5)),
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                keyword_t,
                                else_body,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  333 =>  /* primary: k_unless expr_value then compstmt opt_else k_end  */
  /* "src/parser.y":2982  */
                    {
                        let (else_t, body) =  OptElse::from(yystack.owned_value_at(1)).map(|else_| (Some(else_.else_t), else_.body)).unwrap_or_else(|| (None, None));

                        yyval = Value::Node(
                            self.builder.condition(
                                 Token::from(yystack.owned_value_at(5)),
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                body,
                                else_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  334 =>  /* primary: k_while expr_value_do compstmt k_end  */
  /* "src/parser.y":3000  */
                    {
                        let ExprValueDo { value, do_t } =  ExprValueDo::from(yystack.owned_value_at(2));
                        yyval = Value::Node(
                            self.builder.loop_(
                                LoopType::While,
                                 Token::from(yystack.owned_value_at(3)),
                                value,
                                do_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  335 =>  /* primary: k_until expr_value_do compstmt k_end  */
  /* "src/parser.y":3016  */
                    {
                        let ExprValueDo { value, do_t } =  ExprValueDo::from(yystack.owned_value_at(2));
                        yyval = Value::Node(
                            self.builder.loop_(
                                LoopType::Until,
                                 Token::from(yystack.owned_value_at(3)),
                                value,
                                do_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  336 =>  /* @14: %empty  */
  /* "src/parser.y":3030  */
                    {
                        // TODO: there's a warning that wq/parser doesn't trigger,
                        // search for `p->case_labels`
                        yyval = Value::None;
                    },


  337 =>  /* primary: k_case expr_value opt_terms @14 case_body k_end  */
  /* "src/parser.y":3037  */
                    {
                        let CaseBody { when_bodies, opt_else } =  CaseBody::from(yystack.owned_value_at(1));
                        let (else_t, else_body) = opt_else.map(|else_| (Some(else_.else_t), else_.body)).unwrap_or_else(|| (None, None));

                        yyval = Value::Node(
                            self.builder.case(
                                 Token::from(yystack.owned_value_at(5)),
                                Some( BoxedNode::from(yystack.owned_value_at(4))),
                                when_bodies,
                                else_t,
                                else_body,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  338 =>  /* @15: %empty  */
  /* "src/parser.y":3053  */
                    {
                        // TODO: there's a warning that wq/parser doesn't trigger,
                        // search for `p->case_labels`
                        yyval = Value::None;
                    },


  339 =>  /* primary: k_case opt_terms @15 case_body k_end  */
  /* "src/parser.y":3060  */
                    {
                        let CaseBody { when_bodies, opt_else } =  CaseBody::from(yystack.owned_value_at(1));
                        let (else_t, else_body) = opt_else.map(|else_| (Some(else_.else_t), else_.body)).unwrap_or_else(|| (None, None));

                        yyval = Value::Node(
                            self.builder.case(
                                 Token::from(yystack.owned_value_at(4)),
                                None,
                                when_bodies,
                                else_t,
                                else_body,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  340 =>  /* primary: k_case expr_value opt_terms p_case_body k_end  */
  /* "src/parser.y":3078  */
                    {
                        let PCaseBody { in_bodies, opt_else } =  PCaseBody::from(yystack.owned_value_at(1));
                        let (else_t, else_body) = opt_else.map(|else_| (Some(else_.else_t), else_.body)).unwrap_or_else(|| (None, None));

                        yyval = Value::Node(
                            self.builder.case_match(
                                 Token::from(yystack.owned_value_at(4)),
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                in_bodies,
                                else_t,
                                else_body,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  341 =>  /* primary: k_for for_var "`in'" expr_value_do compstmt k_end  */
  /* "src/parser.y":3096  */
                    {
                        let ExprValueDo { value, do_t } =  ExprValueDo::from(yystack.owned_value_at(2));
                        yyval = Value::Node(
                            self.builder.for_(
                                 Token::from(yystack.owned_value_at(5)),
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                value,
                                do_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  342 =>  /* @16: %empty  */
  /* "src/parser.y":3111  */
                    {
                        self.static_env.extend_static();
                        self.yylexer.cmdarg.push(false);
                        self.yylexer.cond.push(false);
                        self.context.push_class();
                        yyval = Value::None;
                    },


  343 =>  /* primary: k_class cpath superclass @16 bodystmt k_end  */
  /* "src/parser.y":3120  */
                    {
                        if !self.context.is_class_definition_allowed() {
                            return self.yyerror(&yystack.location_at (5), DiagnosticMessage::ClassDefinitionInMethodBody);
                        }

                        let Superclass { lt_t, value } =  Superclass::from(yystack.owned_value_at(3));

                        yyval = Value::Node(
                            self.builder.def_class(
                                 Token::from(yystack.owned_value_at(5)),
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                lt_t,
                                value,
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );

                        self.yylexer.cmdarg.pop();
                        self.yylexer.cond.pop();
                        self.static_env.unextend();
                        self.context.pop();
                    },


  344 =>  /* @17: %empty  */
  /* "src/parser.y":3144  */
                    {
                        self.static_env.extend_static();
                        self.yylexer.cmdarg.push(false);
                        self.yylexer.cond.push(false);
                        self.context.push_sclass();
                        yyval = Value::None;
                    },


  345 =>  /* primary: k_class "<<" expr @17 term bodystmt k_end  */
  /* "src/parser.y":3154  */
                    {
                        yyval = Value::Node(
                            self.builder.def_sclass(
                                 Token::from(yystack.owned_value_at(6)),
                                 Token::from(yystack.owned_value_at(5)),
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );

                        self.yylexer.cmdarg.pop();
                        self.yylexer.cond.pop();
                        self.static_env.unextend();
                        self.context.pop();
                    },


  346 =>  /* @18: %empty  */
  /* "src/parser.y":3171  */
                    {
                        self.static_env.extend_static();
                        self.yylexer.cmdarg.push(false);
                        self.context.push_module();
                        yyval = Value::None;
                    },


  347 =>  /* primary: k_module cpath @18 bodystmt k_end  */
  /* "src/parser.y":3179  */
                    {
                        if !self.context.is_module_definition_allowed() {
                            return self.yyerror(&yystack.location_at (4), DiagnosticMessage::ModuleDefinitionInMethodBody);
                        }

                        yyval = Value::Node(
                            self.builder.def_module(
                                 Token::from(yystack.owned_value_at(4)),
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );

                        self.yylexer.cmdarg.pop();
                        self.static_env.unextend();
                        self.context.pop();
                    },


  348 =>  /* primary: defn_head f_arglist bodystmt k_end  */
  /* "src/parser.y":3201  */
                    {
                        let DefnHead { def_t, name_t } =  DefnHead::from(yystack.owned_value_at(3));

                        yyval = Value::Node(
                            self.builder.def_method(
                                def_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )?
                        );

                        self.yylexer.cmdarg.pop();
                        self.yylexer.cond.pop();
                        self.static_env.unextend();
                        self.context.pop();
                        self.current_arg_stack.pop();
                    },


  349 =>  /* primary: defs_head f_arglist bodystmt k_end  */
  /* "src/parser.y":3224  */
                    {
                        let DefsHead { def_t, definee, dot_t, name_t } =  DefsHead::from(yystack.owned_value_at(3));

                        yyval = Value::Node(
                            self.builder.def_singleton(
                                def_t,
                                definee,
                                dot_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )?
                        );

                        self.yylexer.cmdarg.pop();
                        self.yylexer.cond.pop();
                        self.static_env.unextend();
                        self.context.pop();
                        self.current_arg_stack.pop();
                    },


  350 =>  /* primary: "`break'"  */
  /* "src/parser.y":3246  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Break,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  351 =>  /* primary: "`next'"  */
  /* "src/parser.y":3258  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Next,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  352 =>  /* primary: "`redo'"  */
  /* "src/parser.y":3270  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Redo,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  353 =>  /* primary: "`retry'"  */
  /* "src/parser.y":3282  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Retry,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  354 =>  /* primary_value: primary  */
  /* "src/parser.y":3296  */
                    {
                        let primary =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&primary)?;
                        yyval = Value::Node(primary);
                    },


  355 =>  /* k_begin: "`begin'"  */
  /* "src/parser.y":3304  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  356 =>  /* k_if: "`if'"  */
  /* "src/parser.y":3310  */
                    {
                        self.warn_eol(&yystack.location_at (0), "if");
                        yyval =  yystack.owned_value_at(0);
                    },


  357 =>  /* k_unless: "`unless'"  */
  /* "src/parser.y":3317  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  358 =>  /* k_while: "`while'"  */
  /* "src/parser.y":3323  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  359 =>  /* k_until: "`until'"  */
  /* "src/parser.y":3329  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  360 =>  /* k_case: "`case'"  */
  /* "src/parser.y":3335  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  361 =>  /* k_for: "`for'"  */
  /* "src/parser.y":3341  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  362 =>  /* k_class: "`class'"  */
  /* "src/parser.y":3347  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  363 =>  /* k_module: "`module'"  */
  /* "src/parser.y":3353  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  364 =>  /* k_def: "`def'"  */
  /* "src/parser.y":3359  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  365 =>  /* k_do: "`do'"  */
  /* "src/parser.y":3365  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  366 =>  /* k_do_block: "`do' for block"  */
  /* "src/parser.y":3371  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  367 =>  /* k_rescue: "`rescue'"  */
  /* "src/parser.y":3377  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  368 =>  /* k_ensure: "`ensure'"  */
  /* "src/parser.y":3383  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  369 =>  /* k_when: "`when'"  */
  /* "src/parser.y":3389  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  370 =>  /* k_else: "`else'"  */
  /* "src/parser.y":3395  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  371 =>  /* k_elsif: "`elsif'"  */
  /* "src/parser.y":3401  */
                    {
                        self.warn_eol(&yystack.location_at (0), "elsif");
                        yyval =  yystack.owned_value_at(0);
                    },


  372 =>  /* k_end: "`end'"  */
  /* "src/parser.y":3408  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  373 =>  /* k_return: "`return'"  */
  /* "src/parser.y":3414  */
                    {
                        if self.context.is_in_class() {
                            return self.yyerror(&yystack.location_at (0), DiagnosticMessage::InvalidReturnInClassOrModuleBody);
                        }
                        yyval =  yystack.owned_value_at(0);
                    },


  374 =>  /* then: term  */
  /* "src/parser.y":3423  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  375 =>  /* then: "`then'"  */
  /* "src/parser.y":3427  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  376 =>  /* then: term "`then'"  */
  /* "src/parser.y":3431  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  377 =>  /* do: term  */
  /* "src/parser.y":3437  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  378 =>  /* do: "`do' for condition"  */
  /* "src/parser.y":3441  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  379 =>  /* if_tail: opt_else  */
  /* "src/parser.y":3447  */
                    {
                        let (keyword_t, body) =  OptElse::from(yystack.owned_value_at(0)).map(|else_| (Some(else_.else_t), else_.body)).unwrap_or_else(|| (None, None));
                        yyval = Value::new_if_tail(IfTail { keyword_t, body });
                    },


  380 =>  /* if_tail: k_elsif expr_value then compstmt if_tail  */
  /* "src/parser.y":3454  */
                    {
                        let IfTail { keyword_t, body: else_body } =  IfTail::from(yystack.owned_value_at(0));

                        let elsif_t =  Token::from(yystack.owned_value_at(4));

                        yyval = Value::new_if_tail(
                            IfTail {
                                keyword_t: Some(elsif_t.clone()),
                                body: Some(
                                    self.builder.condition(
                                        elsif_t,
                                         BoxedNode::from(yystack.owned_value_at(3)),
                                         Token::from(yystack.owned_value_at(2)),
                                         MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                        keyword_t,
                                        else_body,
                                        None
                                    )
                                )
                            }
                        );
                    },


  381 =>  /* opt_else: none  */
  /* "src/parser.y":3479  */
                    {
                        yyval = Value::new_opt_else(None);
                    },


  382 =>  /* opt_else: k_else compstmt  */
  /* "src/parser.y":3483  */
                    {
                        let else_t =  Token::from(yystack.owned_value_at(1));
                        let body   =  MaybeBoxedNode::from(yystack.owned_value_at(0));
                        yyval = Value::new_opt_else(Some(Else { else_t, body }));
                    },


  383 =>  /* for_var: lhs  */
  /* "src/parser.y":3491  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  384 =>  /* for_var: mlhs  */
  /* "src/parser.y":3495  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  385 =>  /* f_marg: f_norm_arg  */
  /* "src/parser.y":3501  */
                    {
                        yyval = Value::Node(
                            self.builder.arg( Token::from(yystack.owned_value_at(0)))?
                        );
                    },


  386 =>  /* f_marg: "(" f_margs rparen  */
  /* "src/parser.y":3507  */
                    {
                        yyval = Value::Node(
                            self.builder.multi_lhs(
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  387 =>  /* f_marg_list: f_marg  */
  /* "src/parser.y":3519  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  388 =>  /* f_marg_list: f_marg_list "," f_marg  */
  /* "src/parser.y":3523  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  389 =>  /* f_margs: f_marg_list  */
  /* "src/parser.y":3531  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  390 =>  /* f_margs: f_marg_list "," f_rest_marg  */
  /* "src/parser.y":3535  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  391 =>  /* f_margs: f_marg_list "," f_rest_marg "," f_marg_list  */
  /* "src/parser.y":3541  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(4));
                        let f_rest_marg =  Node::from(yystack.owned_value_at(2));
                        let mut f_marg_list =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(1 + f_marg_list.len());
                        nodes.push(f_rest_marg);
                        nodes.append(&mut f_marg_list);

                        yyval = Value::NodeList(nodes);
                    },


  392 =>  /* f_margs: f_rest_marg  */
  /* "src/parser.y":3553  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  393 =>  /* f_margs: f_rest_marg "," f_marg_list  */
  /* "src/parser.y":3557  */
                    {
                        let mut nodes;
                        let f_rest_marg =  Node::from(yystack.owned_value_at(2));
                        let mut f_marg_list =  NodeList::from(yystack.owned_value_at(0));

                        nodes = Vec::with_capacity(1 + f_marg_list.len());
                        nodes.push(f_rest_marg);
                        nodes.append(&mut f_marg_list);

                        yyval = Value::NodeList(nodes);
                    },


  394 =>  /* f_rest_marg: "*" f_norm_arg  */
  /* "src/parser.y":3571  */
                    {
                        yyval = Value::Node(
                            self.builder.restarg( Token::from(yystack.owned_value_at(1)), Some( Token::from(yystack.owned_value_at(0))))?
                        );
                    },


  395 =>  /* f_rest_marg: "*"  */
  /* "src/parser.y":3577  */
                    {
                        yyval = Value::Node(
                            self.builder.restarg( Token::from(yystack.owned_value_at(0)), None)?
                        );
                    },


  396 =>  /* f_any_kwrest: f_kwrest  */
  /* "src/parser.y":3585  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  397 =>  /* f_any_kwrest: f_no_kwarg  */
  /* "src/parser.y":3589  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  398 =>  /* block_args_tail: f_block_kwarg "," f_kwrest opt_f_block_arg  */
  /* "src/parser.y":3595  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_kwrest =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_f_block_arg =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_kwrest.len() + opt_f_block_arg.len());
                        nodes.append(&mut f_kwrest);
                        nodes.append(&mut opt_f_block_arg);

                        yyval = Value::NodeList(nodes);
                    },


  399 =>  /* block_args_tail: f_block_kwarg opt_f_block_arg  */
  /* "src/parser.y":3607  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  400 =>  /* block_args_tail: f_any_kwrest opt_f_block_arg  */
  /* "src/parser.y":3614  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  401 =>  /* block_args_tail: f_block_arg  */
  /* "src/parser.y":3621  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  402 =>  /* opt_block_args_tail: "," block_args_tail  */
  /* "src/parser.y":3628  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  403 =>  /* opt_block_args_tail: %empty  */
  /* "src/parser.y":3632  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  404 =>  /* excessed_comma: ","  */
  /* "src/parser.y":3638  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  405 =>  /* block_param: f_arg "," f_block_optarg "," f_rest_arg opt_block_args_tail  */
  /* "src/parser.y":3644  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(5));
                        let mut f_block_optarg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_block_optarg.len() + f_rest_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_block_optarg);
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  406 =>  /* block_param: f_arg "," f_block_optarg "," f_rest_arg "," f_arg opt_block_args_tail  */
  /* "src/parser.y":3658  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(7));
                        let mut f_block_optarg =  NodeList::from(yystack.owned_value_at(5));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_block_optarg.len() + f_rest_arg.len() + f_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_block_optarg);
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  407 =>  /* block_param: f_arg "," f_block_optarg opt_block_args_tail  */
  /* "src/parser.y":3674  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_block_optarg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_block_optarg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_block_optarg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  408 =>  /* block_param: f_arg "," f_block_optarg "," f_arg opt_block_args_tail  */
  /* "src/parser.y":3686  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(5));
                        let mut f_block_optarg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_block_optarg.len() + f_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_block_optarg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  409 =>  /* block_param: f_arg "," f_rest_arg opt_block_args_tail  */
  /* "src/parser.y":3700  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  410 =>  /* block_param: f_arg excessed_comma  */
  /* "src/parser.y":3712  */
                    {
                        yyval =  yystack.owned_value_at(1);
                    },


  411 =>  /* block_param: f_arg "," f_rest_arg "," f_arg opt_block_args_tail  */
  /* "src/parser.y":3716  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(5));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + f_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  412 =>  /* block_param: f_arg opt_block_args_tail  */
  /* "src/parser.y":3730  */
                    {
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));
                        let mut nodes: Vec<Node>;

                        if opt_block_args_tail.is_empty() && f_arg.len() == 1 {
                            nodes = vec![ *self.builder.procarg0(Box::new(f_arg.pop().expect("f_arg is non empty"))) ];
                        } else {
                            nodes = f_arg;
                            nodes.append(&mut opt_block_args_tail);
                        }

                        yyval = Value::NodeList(nodes);
                    },


  413 =>  /* block_param: f_block_optarg "," f_rest_arg opt_block_args_tail  */
  /* "src/parser.y":3745  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  414 =>  /* block_param: f_block_optarg "," f_rest_arg "," f_arg opt_block_args_tail  */
  /* "src/parser.y":3757  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(5));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + f_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  415 =>  /* block_param: f_block_optarg opt_block_args_tail  */
  /* "src/parser.y":3771  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  416 =>  /* block_param: f_block_optarg "," f_arg opt_block_args_tail  */
  /* "src/parser.y":3778  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  417 =>  /* block_param: f_rest_arg opt_block_args_tail  */
  /* "src/parser.y":3790  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  418 =>  /* block_param: f_rest_arg "," f_arg opt_block_args_tail  */
  /* "src/parser.y":3797  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  419 =>  /* block_param: block_args_tail  */
  /* "src/parser.y":3809  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  420 =>  /* opt_block_param: none  */
  /* "src/parser.y":3815  */
                    {
                        yyval = Value::MaybeNode(
                            self.builder.args(None, vec![], None)
                        );
                    },


  421 =>  /* opt_block_param: block_param_def  */
  /* "src/parser.y":3821  */
                    {
                        self.yylexer.command_start = true;
                        yyval =  yystack.owned_value_at(0);
                    },


  422 =>  /* block_param_def: "|" opt_bv_decl "|"  */
  /* "src/parser.y":3828  */
                    {
                        self.max_numparam_stack.set_has_ordinary_params();
                        self.current_arg_stack.set(None);

                        yyval = Value::MaybeNode(
                            self.builder.args(
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  423 =>  /* block_param_def: "|" block_param opt_bv_decl "|"  */
  /* "src/parser.y":3841  */
                    {
                        self.max_numparam_stack.set_has_ordinary_params();
                        self.current_arg_stack.set(None);

                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(1)));

                        yyval = Value::MaybeNode(
                            self.builder.args(
                                Some( Token::from(yystack.owned_value_at(3))),
                                nodes,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  424 =>  /* opt_bv_decl: opt_nl  */
  /* "src/parser.y":3860  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  425 =>  /* opt_bv_decl: opt_nl ";" bv_decls opt_nl  */
  /* "src/parser.y":3864  */
                    {
                        yyval =  yystack.owned_value_at(1);
                    },


  426 =>  /* bv_decls: bvar  */
  /* "src/parser.y":3870  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  427 =>  /* bv_decls: bv_decls "," bvar  */
  /* "src/parser.y":3874  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  428 =>  /* bvar: "local variable or method"  */
  /* "src/parser.y":3882  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        self.static_env.declare(&clone_value(&ident_t));
                        yyval = Value::Node(
                            self.builder.shadowarg(ident_t)?
                        );
                    },


  429 =>  /* bvar: f_bad_arg  */
  /* "src/parser.y":3890  */
                    {
                        yyval = Value::None;
                    },


  430 =>  /* @19: %empty  */
  /* "src/parser.y":3896  */
                    {
                        self.static_env.extend_dynamic();
                        self.max_numparam_stack.push();
                        self.context.push_lambda();
                        yyval = Value::Num(self.yylexer.lpar_beg);
                        self.yylexer.lpar_beg = self.yylexer.paren_nest;
                    },


  431 =>  /* @20: %empty  */
  /* "src/parser.y":3904  */
                    {
                        self.context.pop();
                        self.yylexer.cmdarg.push(false);
                        yyval = Value::None;
                    },


  432 =>  /* lambda: "->" @19 f_larglist @20 lambda_body  */
  /* "src/parser.y":3910  */
                    {
                        self.yylexer.lpar_beg =  Num::from(yystack.owned_value_at(3));

                        let lambda_call = self.builder.call_lambda( Token::from(yystack.owned_value_at(4)));
                        let args = if self.max_numparam_stack.has_numparams() {
                            ArgsType::Numargs(self.max_numparam_stack.top() as u8)
                        } else {
                            ArgsType::Args( MaybeBoxedNode::from(yystack.owned_value_at(2)))
                        };
                        let LambdaBody { begin_t, body, end_t } =  LambdaBody::from(yystack.owned_value_at(0));

                        self.max_numparam_stack.pop();
                        self.static_env.unextend();
                        self.yylexer.cmdarg.pop();

                        yyval = Value::Node(
                            self.builder.block(
                                lambda_call,
                                begin_t,
                                args,
                                body,
                                end_t
                            )?
                        );
                    },


  433 =>  /* f_larglist: "( (tLPAREN2)" f_args opt_bv_decl ")"  */
  /* "src/parser.y":3938  */
                    {
                        self.max_numparam_stack.set_has_ordinary_params();

                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(1)));

                        yyval = Value::MaybeNode(
                            self.builder.args(
                                Some( Token::from(yystack.owned_value_at(3))),
                                nodes,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  434 =>  /* f_larglist: f_args  */
  /* "src/parser.y":3953  */
                    {
                        let args =  NodeList::from(yystack.owned_value_at(0));
                        if !args.is_empty() {
                            self.max_numparam_stack.set_has_ordinary_params();
                        }
                        yyval = Value::MaybeNode(
                            self.builder.args(None, args, None)
                        );
                    },


  435 =>  /* @21: %empty  */
  /* "src/parser.y":3965  */
                    {
                        self.context.push_lambda();
                        yyval = Value::None;
                    },


  436 =>  /* lambda_body: tLAMBEG @21 compstmt "}"  */
  /* "src/parser.y":3970  */
                    {
                        self.context.pop();
                        yyval = Value::new_lambda_body(
                            LambdaBody {
                                begin_t:  Token::from(yystack.owned_value_at(3)),
                                body:  MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  437 =>  /* @22: %empty  */
  /* "src/parser.y":3981  */
                    {
                        self.context.push_lambda();
                        yyval = Value::None;
                    },


  438 =>  /* lambda_body: "`do' for lambda" @22 bodystmt k_end  */
  /* "src/parser.y":3986  */
                    {
                        self.context.pop();
                        yyval = Value::new_lambda_body(
                            LambdaBody {
                                begin_t:  Token::from(yystack.owned_value_at(3)),
                                body:  MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  439 =>  /* @23: %empty  */
  /* "src/parser.y":3999  */
                    {
                        self.context.push_block();
                        yyval = Value::None;
                    },


  440 =>  /* do_block: k_do_block @23 do_body k_end  */
  /* "src/parser.y":4004  */
                    {
                        let DoBody { args_type, body } =  DoBody::from(yystack.owned_value_at(1));
                        self.context.pop();
                        yyval = Value::new_do_block(
                            DoBlock {
                                begin_t:  Token::from(yystack.owned_value_at(3)),
                                args_type,
                                body,
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  441 =>  /* block_call: command do_block  */
  /* "src/parser.y":4019  */
                    {
                        let DoBlock { begin_t, args_type, body, end_t } =  DoBlock::from(yystack.owned_value_at(0));
                        yyval = Value::Node(
                            self.builder.block(
                                 BoxedNode::from(yystack.owned_value_at(1)),
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  442 =>  /* block_call: block_call call_op2 operation2 opt_paren_args  */
  /* "src/parser.y":4032  */
                    {
                        let OptParenArgs { begin_t, args, end_t } =  OptParenArgs::from(yystack.owned_value_at(0));
                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(3))),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                begin_t,
                                args,
                                end_t
                            )
                        );
                    },


  443 =>  /* block_call: block_call call_op2 operation2 opt_paren_args brace_block  */
  /* "src/parser.y":4046  */
                    {
                        let OptParenArgs { begin_t, args, end_t } =  OptParenArgs::from(yystack.owned_value_at(1));
                        let method_call = self.builder.call_method(
                            Some( BoxedNode::from(yystack.owned_value_at(4))),
                            Some( Token::from(yystack.owned_value_at(3))),
                            Some( Token::from(yystack.owned_value_at(2))),
                            begin_t,
                            args,
                            end_t
                        );

                        let BraceBlock { begin_t, args_type, body, end_t } =  BraceBlock::from(yystack.owned_value_at(0));
                        yyval = Value::Node(
                            self.builder.block(
                                method_call,
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  444 =>  /* block_call: block_call call_op2 operation2 command_args do_block  */
  /* "src/parser.y":4069  */
                    {
                        let method_call = self.builder.call_method(
                            Some( BoxedNode::from(yystack.owned_value_at(4))),
                            Some( Token::from(yystack.owned_value_at(3))),
                            Some( Token::from(yystack.owned_value_at(2))),
                            None,
                             NodeList::from(yystack.owned_value_at(1)),
                            None
                        );

                        let DoBlock { begin_t, args_type, body, end_t } =  DoBlock::from(yystack.owned_value_at(0));
                        yyval = Value::Node(
                            self.builder.block(
                                method_call,
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  445 =>  /* method_call: fcall paren_args  */
  /* "src/parser.y":4093  */
                    {
                        let ParenArgs { begin_t, args, end_t } =  ParenArgs::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.call_method(
                                None,
                                None,
                                Some( Token::from(yystack.owned_value_at(1))),
                                Some(begin_t),
                                args,
                                Some(end_t)
                            )
                        );
                    },


  446 =>  /* method_call: primary_value call_op operation2 opt_paren_args  */
  /* "src/parser.y":4108  */
                    {
                        let OptParenArgs { begin_t, args, end_t } =  OptParenArgs::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(3))),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                begin_t,
                                args,
                                end_t
                            )
                        );
                    },


  447 =>  /* method_call: primary_value "::" operation2 paren_args  */
  /* "src/parser.y":4123  */
                    {
                        let ParenArgs { begin_t, args, end_t } =  ParenArgs::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(3))),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                Some(begin_t),
                                args,
                                Some(end_t)
                            )
                        );
                    },


  448 =>  /* method_call: primary_value "::" operation3  */
  /* "src/parser.y":4138  */
                    {
                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                Some( Token::from(yystack.owned_value_at(0))),
                                None,
                                vec![],
                                None
                            )
                        );
                    },


  449 =>  /* method_call: primary_value call_op paren_args  */
  /* "src/parser.y":4151  */
                    {
                        let ParenArgs { begin_t, args, end_t } =  ParenArgs::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                Some(begin_t),
                                args,
                                Some(end_t)
                            )
                        );
                    },


  450 =>  /* method_call: primary_value "::" paren_args  */
  /* "src/parser.y":4166  */
                    {
                        let ParenArgs { begin_t, args, end_t } =  ParenArgs::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                Some(begin_t),
                                args,
                                Some(end_t)
                            )
                        );
                    },


  451 =>  /* method_call: "`super'" paren_args  */
  /* "src/parser.y":4181  */
                    {
                        let ParenArgs { begin_t, args, end_t } =  ParenArgs::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Super,
                                 Token::from(yystack.owned_value_at(1)),
                                Some(begin_t),
                                args,
                                Some(end_t)
                            )?
                        );
                    },


  452 =>  /* method_call: "`super'"  */
  /* "src/parser.y":4195  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Zsuper,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  453 =>  /* method_call: primary_value "[ (tLBRACK2)" opt_call_args rbracket  */
  /* "src/parser.y":4207  */
                    {
                        yyval = Value::Node(
                            self.builder.index(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  454 =>  /* @24: %empty  */
  /* "src/parser.y":4220  */
                    {
                        self.context.push_block();
                        yyval = Value::None;
                    },


  455 =>  /* brace_block: "{ (tLCURLY)" @24 brace_body "}"  */
  /* "src/parser.y":4225  */
                    {
                        let BraceBody { args_type, body } =  BraceBody::from(yystack.owned_value_at(1));
                        self.context.pop();

                        yyval = Value::new_brace_block(
                            BraceBlock {
                                begin_t:  Token::from(yystack.owned_value_at(3)),
                                args_type,
                                body,
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  456 =>  /* @25: %empty  */
  /* "src/parser.y":4239  */
                    {
                        self.context.push_block();
                        yyval = Value::None;
                    },


  457 =>  /* brace_block: k_do @25 do_body k_end  */
  /* "src/parser.y":4244  */
                    {
                        let DoBody { args_type, body } =  DoBody::from(yystack.owned_value_at(1));
                        self.context.pop();

                        yyval = Value::new_brace_block(
                            BraceBlock {
                                begin_t:  Token::from(yystack.owned_value_at(3)),
                                args_type,
                                body,
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  458 =>  /* @26: %empty  */
  /* "src/parser.y":4259  */
                    {
                        self.static_env.extend_dynamic();
                        self.max_numparam_stack.push();
                        yyval = Value::None;
                    },


  459 =>  /* brace_body: @26 opt_block_param compstmt  */
  /* "src/parser.y":4265  */
                    {
                        let args_type = if self.max_numparam_stack.has_numparams() {
                            ArgsType::Numargs(self.max_numparam_stack.top() as u8)
                        } else {
                            ArgsType::Args( MaybeBoxedNode::from(yystack.owned_value_at(1)))
                        };

                        self.max_numparam_stack.pop();
                        self.static_env.unextend();

                        yyval = Value::new_brace_body(
                            BraceBody {
                                args_type,
                                body:  MaybeBoxedNode::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  460 =>  /* @27: %empty  */
  /* "src/parser.y":4284  */
                    {
                        self.static_env.extend_dynamic();
                        self.max_numparam_stack.push();
                        self.yylexer.cmdarg.push(false);
                        yyval = Value::None;
                    },


  461 =>  /* do_body: @27 opt_block_param bodystmt  */
  /* "src/parser.y":4291  */
                    {
                        let args_type = if self.max_numparam_stack.has_numparams() {
                            ArgsType::Numargs(self.max_numparam_stack.top() as u8)
                        } else {
                            ArgsType::Args( MaybeBoxedNode::from(yystack.owned_value_at(1)))
                        };

                        self.max_numparam_stack.pop();
                        self.static_env.unextend();
                        self.yylexer.cmdarg.pop();

                        yyval = Value::new_do_body(
                            DoBody { args_type, body:  MaybeBoxedNode::from(yystack.owned_value_at(0)) }
                        );
                    },


  462 =>  /* case_args: arg_value  */
  /* "src/parser.y":4309  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  463 =>  /* case_args: "*" arg_value  */
  /* "src/parser.y":4313  */
                    {
                        yyval = Value::NodeList(
                            vec![
                                *self.builder.splat( Token::from(yystack.owned_value_at(1)), Some( BoxedNode::from(yystack.owned_value_at(0))))
                            ]
                        );
                    },


  464 =>  /* case_args: case_args "," arg_value  */
  /* "src/parser.y":4321  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  465 =>  /* case_args: case_args "," "*" arg_value  */
  /* "src/parser.y":4327  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        nodes.push( *self.builder.splat( Token::from(yystack.owned_value_at(1)), Some( BoxedNode::from(yystack.owned_value_at(0)))) );
                        yyval = Value::NodeList(nodes);
                    },


  466 =>  /* case_body: k_when case_args then compstmt cases  */
  /* "src/parser.y":4337  */
                    {
                        let when = *self.builder.when( Token::from(yystack.owned_value_at(4)),  NodeList::from(yystack.owned_value_at(3)),  Token::from(yystack.owned_value_at(2)),  MaybeBoxedNode::from(yystack.owned_value_at(1)));
                        let Cases { mut when_bodies, opt_else } =  Cases::from(yystack.owned_value_at(0));

                        let mut nodes = Vec::with_capacity(1 + when_bodies.len());
                        nodes.push(when);
                        nodes.append(&mut when_bodies);

                        yyval = Value::new_case_body(CaseBody { when_bodies: nodes, opt_else });
                    },


  467 =>  /* cases: opt_else  */
  /* "src/parser.y":4350  */
                    {
                        yyval = Value::new_cases(Cases { when_bodies: vec![], opt_else:  OptElse::from(yystack.owned_value_at(0)) });
                    },


  468 =>  /* cases: case_body  */
  /* "src/parser.y":4354  */
                    {
                        let CaseBody { when_bodies, .. } =  CaseBody::from(yystack.owned_value_at(0));
                        yyval = Value::new_cases(Cases { when_bodies, opt_else: None });
                    },


  469 =>  /* @28: %empty  */
  /* "src/parser.y":4361  */
                    {
                        self.yylexer.lex_state.set(EXPR_BEG|EXPR_LABEL);
                        self.yylexer.command_start = false;
                        self.pattern_variables.push();
                        self.pattern_hash_keys.push();

                        yyval = Value::Bool(self.yylexer.in_kwarg);
                        self.yylexer.in_kwarg = true;
                    },


  470 =>  /* @29: %empty  */
  /* "src/parser.y":4371  */
                    {
                        self.yylexer.in_kwarg =  Bool::from(yystack.owned_value_at(2));
                        self.pattern_variables.pop();
                        self.pattern_hash_keys.pop();
                        yyval = Value::None;
                    },


  471 =>  /* p_case_body: "`in'" @28 p_top_expr then @29 compstmt p_cases  */
  /* "src/parser.y":4379  */
                    {
                        let PCases { mut in_bodies, opt_else } =  PCases::from(yystack.owned_value_at(0));
                        let PTopExpr { pattern, guard } =  PTopExpr::from(yystack.owned_value_at(4));

                        let mut nodes = Vec::with_capacity(1 + in_bodies.len());
                        nodes.push(
                            *self.builder.in_pattern(
                                 Token::from(yystack.owned_value_at(6)),
                                pattern,
                                guard,
                                 Token::from(yystack.owned_value_at(3)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1))
                            )
                        );
                        nodes.append(&mut in_bodies);

                        yyval = Value::new_p_case_body(PCaseBody { in_bodies: nodes, opt_else  });
                    },


  472 =>  /* p_cases: opt_else  */
  /* "src/parser.y":4400  */
                    {
                        yyval = Value::new_p_cases(PCases { in_bodies: vec![], opt_else:  OptElse::from(yystack.owned_value_at(0)) });
                    },


  473 =>  /* p_cases: p_case_body  */
  /* "src/parser.y":4404  */
                    {
                        let PCaseBody { in_bodies, .. } =  PCaseBody::from(yystack.owned_value_at(0));
                        yyval = Value::new_p_cases(PCases { in_bodies, opt_else: None });
                    },


  474 =>  /* p_top_expr: p_top_expr_body  */
  /* "src/parser.y":4411  */
                    {
                        yyval = Value::new_p_top_expr(PTopExpr { pattern:  BoxedNode::from(yystack.owned_value_at(0)), guard: None });
                    },


  475 =>  /* p_top_expr: p_top_expr_body "`if' modifier" expr_value  */
  /* "src/parser.y":4415  */
                    {
                        let guard = self.builder.if_guard( Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)));
                        yyval = Value::new_p_top_expr(PTopExpr { pattern:  BoxedNode::from(yystack.owned_value_at(2)), guard: Some(guard) });
                    },


  476 =>  /* p_top_expr: p_top_expr_body "`unless' modifier" expr_value  */
  /* "src/parser.y":4420  */
                    {
                        let guard = self.builder.unless_guard( Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)));
                        yyval = Value::new_p_top_expr(PTopExpr { pattern:  BoxedNode::from(yystack.owned_value_at(2)), guard: Some(guard) });
                    },


  477 =>  /* p_top_expr_body: p_expr  */
  /* "src/parser.y":4427  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  478 =>  /* p_top_expr_body: p_expr ","  */
  /* "src/parser.y":4431  */
                    {
                        yyval = Value::Node(
                            self.builder.array_pattern(
                                None,
                                vec![  Node::from(yystack.owned_value_at(1)) ],
                                Some( Token::from(yystack.owned_value_at(0))),
                                None
                            )
                        );
                    },


  479 =>  /* p_top_expr_body: p_expr "," p_args  */
  /* "src/parser.y":4442  */
                    {
                        let MatchPatternWithTrailingComma { mut elements, trailing_comma } =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(0));

                        let mut nodes = Vec::with_capacity(1 + elements.len());
                        nodes.push( Node::from(yystack.owned_value_at(2)));
                        nodes.append(&mut elements);

                        yyval = Value::Node(
                            self.builder.array_pattern(None, nodes, trailing_comma, None)
                        );
                    },


  480 =>  /* p_top_expr_body: p_find  */
  /* "src/parser.y":4454  */
                    {
                        yyval = Value::Node(
                            self.builder.find_pattern(None,  NodeList::from(yystack.owned_value_at(0)), None)
                        );
                    },


  481 =>  /* p_top_expr_body: p_args_tail  */
  /* "src/parser.y":4460  */
                    {
                        yyval = Value::Node(
                            self.builder.array_pattern(None,  NodeList::from(yystack.owned_value_at(0)), None, None)
                        );
                    },


  482 =>  /* p_top_expr_body: p_kwargs  */
  /* "src/parser.y":4466  */
                    {
                        yyval = Value::Node(
                            self.builder.hash_pattern(None,  NodeList::from(yystack.owned_value_at(0)), None)
                        );
                    },


  483 =>  /* p_expr: p_as  */
  /* "src/parser.y":4474  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  484 =>  /* p_as: p_expr "=>" p_variable  */
  /* "src/parser.y":4480  */
                    {
                        yyval = Value::Node(
                            self.builder.match_as(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  485 =>  /* p_as: p_alt  */
  /* "src/parser.y":4490  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  486 =>  /* p_alt: p_alt "|" p_expr_basic  */
  /* "src/parser.y":4496  */
                    {
                        yyval = Value::Node(
                            self.builder.match_alt(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  487 =>  /* p_alt: p_expr_basic  */
  /* "src/parser.y":4506  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  488 =>  /* p_lparen: "( (tLPAREN2)"  */
  /* "src/parser.y":4512  */
                    {
                        yyval =  yystack.owned_value_at(0);
                        self.pattern_hash_keys.push();
                    },


  489 =>  /* p_lbracket: "[ (tLBRACK2)"  */
  /* "src/parser.y":4519  */
                    {
                        yyval =  yystack.owned_value_at(0);
                        self.pattern_hash_keys.push();
                    },


  490 =>  /* p_expr_basic: p_value  */
  /* "src/parser.y":4526  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  491 =>  /* p_expr_basic: p_const p_lparen p_args rparen  */
  /* "src/parser.y":4530  */
                    {
                        self.pattern_hash_keys.pop();
                        let MatchPatternWithTrailingComma { elements, trailing_comma } =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(1));
                        let pattern = self.builder.array_pattern(None, elements, trailing_comma, None);
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                pattern,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  492 =>  /* p_expr_basic: p_const p_lparen p_find rparen  */
  /* "src/parser.y":4544  */
                    {
                        self.pattern_hash_keys.pop();
                        let pattern = self.builder.find_pattern(None,  NodeList::from(yystack.owned_value_at(1)), None);
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                pattern,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  493 =>  /* p_expr_basic: p_const p_lparen p_kwargs rparen  */
  /* "src/parser.y":4557  */
                    {
                        self.pattern_hash_keys.pop();
                        let pattern = self.builder.hash_pattern(None,  NodeList::from(yystack.owned_value_at(1)), None);
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                pattern,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  494 =>  /* p_expr_basic: p_const "( (tLPAREN2)" rparen  */
  /* "src/parser.y":4570  */
                    {
                        let lparen =  Token::from(yystack.owned_value_at(1));
                        let rparen =  Token::from(yystack.owned_value_at(0));
                        let pattern = self.builder.array_pattern(Some(lparen.clone()), vec![], None, Some(rparen.clone()));
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                lparen,
                                pattern,
                                rparen
                            )
                        );
                    },


  495 =>  /* p_expr_basic: p_const p_lbracket p_args rbracket  */
  /* "src/parser.y":4584  */
                    {
                        self.pattern_hash_keys.pop();
                        let MatchPatternWithTrailingComma { elements, trailing_comma } =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(1));
                        let pattern = self.builder.array_pattern(None, elements, trailing_comma, None);
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                pattern,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  496 =>  /* p_expr_basic: p_const p_lbracket p_find rbracket  */
  /* "src/parser.y":4598  */
                    {
                        self.pattern_hash_keys.pop();
                        let pattern = self.builder.find_pattern(None,  NodeList::from(yystack.owned_value_at(1)), None);
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                pattern,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  497 =>  /* p_expr_basic: p_const p_lbracket p_kwargs rbracket  */
  /* "src/parser.y":4611  */
                    {
                        self.pattern_hash_keys.pop();
                        let pattern = self.builder.hash_pattern(None,  NodeList::from(yystack.owned_value_at(1)), None);
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                pattern,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  498 =>  /* p_expr_basic: p_const "[ (tLBRACK2)" rbracket  */
  /* "src/parser.y":4624  */
                    {
                        let lparen =  Token::from(yystack.owned_value_at(1));
                        let rparen =  Token::from(yystack.owned_value_at(0));
                        let pattern = self.builder.array_pattern(Some(lparen.clone()), vec![], None, Some(rparen.clone()));
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                lparen,
                                pattern,
                                rparen
                            )
                        );
                    },


  499 =>  /* p_expr_basic: "[" p_args rbracket  */
  /* "src/parser.y":4638  */
                    {
                        let MatchPatternWithTrailingComma { elements, trailing_comma } =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(1));
                        yyval = Value::Node(
                            self.builder.array_pattern(
                                Some( Token::from(yystack.owned_value_at(2))),
                                elements,
                                trailing_comma,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  500 =>  /* p_expr_basic: "[" p_find rbracket  */
  /* "src/parser.y":4650  */
                    {
                        yyval = Value::Node(
                            self.builder.find_pattern(
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  501 =>  /* p_expr_basic: "[" rbracket  */
  /* "src/parser.y":4660  */
                    {
                        yyval = Value::Node(
                            self.builder.array_pattern(
                                Some( Token::from(yystack.owned_value_at(1))),
                                vec![],
                                None,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  502 =>  /* @30: %empty  */
  /* "src/parser.y":4671  */
                    {
                        self.pattern_hash_keys.push();
                        yyval = Value::Bool(self.yylexer.in_kwarg);
                        self.yylexer.in_kwarg = false;
                    },


  503 =>  /* p_expr_basic: "{" @30 p_kwargs rbrace  */
  /* "src/parser.y":4677  */
                    {
                        self.pattern_hash_keys.pop();
                        self.yylexer.in_kwarg =  Bool::from(yystack.owned_value_at(2));
                        yyval = Value::Node(
                            self.builder.hash_pattern(
                                Some( Token::from(yystack.owned_value_at(3))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  504 =>  /* p_expr_basic: "{" rbrace  */
  /* "src/parser.y":4689  */
                    {
                        yyval = Value::Node(
                            self.builder.hash_pattern(
                                Some( Token::from(yystack.owned_value_at(1))),
                                vec![],
                                Some( Token::from(yystack.owned_value_at(0))),
                            )
                        );
                    },


  505 =>  /* @31: %empty  */
  /* "src/parser.y":4699  */
                    {
                        self.pattern_hash_keys.push();
                        yyval = Value::None;
                    },


  506 =>  /* p_expr_basic: "(" @31 p_expr rparen  */
  /* "src/parser.y":4704  */
                    {
                        self.pattern_hash_keys.pop();
                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(3)),
                                Some( BoxedNode::from(yystack.owned_value_at(1))),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  507 =>  /* p_args: p_expr  */
  /* "src/parser.y":4717  */
                    {
                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements: vec![  Node::from(yystack.owned_value_at(0)) ],
                                trailing_comma: None
                            }
                        );
                    },


  508 =>  /* p_args: p_args_head  */
  /* "src/parser.y":4726  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  509 =>  /* p_args: p_args_head p_arg  */
  /* "src/parser.y":4730  */
                    {
                        let mut elements =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(1)).elements;
                        elements.push( Node::from(yystack.owned_value_at(0)));

                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements,
                                trailing_comma: None
                            }
                        );
                    },


  510 =>  /* p_args: p_args_head "*" "local variable or method"  */
  /* "src/parser.y":4742  */
                    {
                        let match_rest = self.builder.match_rest( Token::from(yystack.owned_value_at(1)), Some( Token::from(yystack.owned_value_at(0))))?;

                        let mut elements =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(2)).elements;
                        elements.push(*match_rest);

                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements,
                                trailing_comma: None
                            }
                        );
                    },


  511 =>  /* p_args: p_args_head "*" "local variable or method" "," p_args_post  */
  /* "src/parser.y":4756  */
                    {
                        let match_rest = self.builder.match_rest( Token::from(yystack.owned_value_at(3)), Some( Token::from(yystack.owned_value_at(2))))?;

                        let mut elements =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(4)).elements;
                        let mut p_args_post =  NodeList::from(yystack.owned_value_at(0));
                        elements.reserve(1 + p_args_post.len());
                        elements.push(*match_rest);
                        elements.append(&mut p_args_post);

                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements,
                                trailing_comma: None
                            }
                        );
                    },


  512 =>  /* p_args: p_args_head "*"  */
  /* "src/parser.y":4773  */
                    {
                        let match_rest = self.builder.match_rest( Token::from(yystack.owned_value_at(0)), None)?;

                        let mut elements =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(1)).elements;
                        elements.push(*match_rest);

                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements,
                                trailing_comma: None
                            }
                        );
                    },


  513 =>  /* p_args: p_args_head "*" "," p_args_post  */
  /* "src/parser.y":4787  */
                    {
                        let match_rest = self.builder.match_rest( Token::from(yystack.owned_value_at(2)), None)?;

                        let mut elements =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(3)).elements;
                        let mut p_args_post =  NodeList::from(yystack.owned_value_at(0));
                        elements.push(*match_rest);
                        elements.append(&mut p_args_post);

                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements,
                                trailing_comma: None
                            }
                        );
                    },


  514 =>  /* p_args: p_args_tail  */
  /* "src/parser.y":4803  */
                    {
                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements:  NodeList::from(yystack.owned_value_at(0)),
                                trailing_comma: None
                            }
                        );
                    },


  515 =>  /* p_args_head: p_arg ","  */
  /* "src/parser.y":4814  */
                    {
                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements: vec![ Node::from(yystack.owned_value_at(1))],
                                trailing_comma: Some( Token::from(yystack.owned_value_at(0))),
                            }
                        );
                    },


  516 =>  /* p_args_head: p_args_head p_arg ","  */
  /* "src/parser.y":4823  */
                    {
                        let mut elements =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(2)).elements;
                        elements.push( Node::from(yystack.owned_value_at(1)));

                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements,
                                trailing_comma: Some( Token::from(yystack.owned_value_at(0))),
                            }
                        );
                    },


  517 =>  /* p_args_tail: p_rest  */
  /* "src/parser.y":4837  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  518 =>  /* p_args_tail: p_rest "," p_args_post  */
  /* "src/parser.y":4841  */
                    {
                        let mut nodes;
                        let mut p_args_post =  NodeList::from(yystack.owned_value_at(0));
                        nodes = Vec::with_capacity(1 + p_args_post.len());
                        nodes.push( Node::from(yystack.owned_value_at(2)));
                        nodes.append(&mut p_args_post);

                        yyval = Value::NodeList(nodes);
                    },


  519 =>  /* p_find: p_rest "," p_args_post "," p_rest  */
  /* "src/parser.y":4853  */
                    {
                        let mut nodes;
                        let mut p_args_post =  NodeList::from(yystack.owned_value_at(2));
                        nodes = Vec::with_capacity(1 + p_args_post.len() + 1);
                        nodes.push( Node::from(yystack.owned_value_at(4)));
                        nodes.append(&mut p_args_post);
                        nodes.push( Node::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  520 =>  /* p_rest: "*" "local variable or method"  */
  /* "src/parser.y":4867  */
                    {
                        yyval = Value::Node(
                            self.builder.match_rest( Token::from(yystack.owned_value_at(1)), Some( Token::from(yystack.owned_value_at(0))))?
                        );
                    },


  521 =>  /* p_rest: "*"  */
  /* "src/parser.y":4873  */
                    {
                        yyval = Value::Node(
                            self.builder.match_rest( Token::from(yystack.owned_value_at(0)), None)?
                        );
                    },


  522 =>  /* p_args_post: p_arg  */
  /* "src/parser.y":4881  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  523 =>  /* p_args_post: p_args_post "," p_arg  */
  /* "src/parser.y":4885  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  524 =>  /* p_arg: p_expr  */
  /* "src/parser.y":4893  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  525 =>  /* p_kwargs: p_kwarg "," p_any_kwrest  */
  /* "src/parser.y":4899  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  526 =>  /* p_kwargs: p_kwarg  */
  /* "src/parser.y":4906  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  527 =>  /* p_kwargs: p_kwarg ","  */
  /* "src/parser.y":4910  */
                    {
                        yyval =  yystack.owned_value_at(1);
                    },


  528 =>  /* p_kwargs: p_any_kwrest  */
  /* "src/parser.y":4914  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  529 =>  /* p_kwarg: p_kw  */
  /* "src/parser.y":4920  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  530 =>  /* p_kwarg: p_kwarg "," p_kw  */
  /* "src/parser.y":4924  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  531 =>  /* p_kw: p_kw_label p_expr  */
  /* "src/parser.y":4932  */
                    {
                        yyval = Value::Node(
                            self.builder.match_pair(
                                 PKwLabel::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  532 =>  /* p_kw: p_kw_label  */
  /* "src/parser.y":4941  */
                    {
                        yyval = Value::Node(
                            self.builder.match_label(
                                 PKwLabel::from(yystack.owned_value_at(0)),
                            )?
                        );
                    },


  533 =>  /* p_kw_label: "label"  */
  /* "src/parser.y":4951  */
                    {
                        yyval = Value::new_p_kw_label(
                            PKwLabel::PlainLabel( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  534 =>  /* p_kw_label: "string begin" string_contents tLABEL_END  */
  /* "src/parser.y":4957  */
                    {
                        yyval = Value::new_p_kw_label(
                            PKwLabel::QuotedLabel( ( Token::from(yystack.owned_value_at(2)),  NodeList::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0))) )
                        );
                    },


  535 =>  /* p_kwrest: kwrest_mark "local variable or method"  */
  /* "src/parser.y":4965  */
                    {
                        yyval = Value::NodeList(
                            vec![
                                *self.builder.match_rest( Token::from(yystack.owned_value_at(1)), Some( Token::from(yystack.owned_value_at(0))))?
                            ]
                        );
                    },


  536 =>  /* p_kwrest: kwrest_mark  */
  /* "src/parser.y":4973  */
                    {
                        yyval = Value::NodeList(
                            vec![
                                *self.builder.match_rest( Token::from(yystack.owned_value_at(0)), None)?
                            ]
                        );
                    },


  537 =>  /* p_kwnorest: kwrest_mark "`nil'"  */
  /* "src/parser.y":4983  */
                    {
                        yyval = Value::NodeList(
                            vec![
                                *self.builder.match_nil_pattern( Token::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                            ]
                        );
                    },


  538 =>  /* p_any_kwrest: p_kwrest  */
  /* "src/parser.y":4993  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  539 =>  /* p_any_kwrest: p_kwnorest  */
  /* "src/parser.y":4997  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  540 =>  /* p_value: p_primitive  */
  /* "src/parser.y":5003  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  541 =>  /* p_value: p_primitive ".." p_primitive  */
  /* "src/parser.y":5007  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&left)?;

                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_inclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  542 =>  /* p_value: p_primitive "..." p_primitive  */
  /* "src/parser.y":5023  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&left)?;

                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_exclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  543 =>  /* p_value: p_primitive ".."  */
  /* "src/parser.y":5039  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(1));
                        self.value_expr(&left)?;

                        yyval = Value::Node(
                            self.builder.range_inclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  544 =>  /* p_value: p_primitive "..."  */
  /* "src/parser.y":5052  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(1));
                        self.value_expr(&left)?;

                        yyval = Value::Node(
                            self.builder.range_exclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  545 =>  /* p_value: p_variable  */
  /* "src/parser.y":5065  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  546 =>  /* p_value: p_var_ref  */
  /* "src/parser.y":5069  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  547 =>  /* p_value: p_const  */
  /* "src/parser.y":5073  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  548 =>  /* p_value: "(.." p_primitive  */
  /* "src/parser.y":5077  */
                    {
                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_inclusive(
                                None,
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  549 =>  /* p_value: "(..." p_primitive  */
  /* "src/parser.y":5090  */
                    {
                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_exclusive(
                                None,
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  550 =>  /* p_primitive: literal  */
  /* "src/parser.y":5105  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  551 =>  /* p_primitive: strings  */
  /* "src/parser.y":5109  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  552 =>  /* p_primitive: xstring  */
  /* "src/parser.y":5113  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  553 =>  /* p_primitive: regexp  */
  /* "src/parser.y":5117  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  554 =>  /* p_primitive: words  */
  /* "src/parser.y":5121  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  555 =>  /* p_primitive: qwords  */
  /* "src/parser.y":5125  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  556 =>  /* p_primitive: symbols  */
  /* "src/parser.y":5129  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  557 =>  /* p_primitive: qsymbols  */
  /* "src/parser.y":5133  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  558 =>  /* p_primitive: keyword_variable  */
  /* "src/parser.y":5137  */
                    {
                        yyval = Value::Node(
                            self.builder.accessible( BoxedNode::from(yystack.owned_value_at(0)))
                        );
                    },


  559 =>  /* p_primitive: lambda  */
  /* "src/parser.y":5143  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  560 =>  /* p_variable: "local variable or method"  */
  /* "src/parser.y":5149  */
                    {
                        yyval = Value::Node(
                            self.builder.match_var( Token::from(yystack.owned_value_at(0)))?
                        );
                    },


  561 =>  /* p_var_ref: "^" "local variable or method"  */
  /* "src/parser.y":5157  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        let name = clone_value(&ident_t);

                        if !self.static_env.is_declared(&name) {
                            return self.yyerror(&yystack.location_at (0), DiagnosticMessage::NoSuchLocalVariable { var_name: name.into() });
                        }

                        let lvar = self.builder.accessible(self.builder.lvar(ident_t));
                        yyval = Value::Node(
                            self.builder.pin( Token::from(yystack.owned_value_at(1)), lvar)
                        );
                    },


  562 =>  /* p_const: ":: at EXPR_BEG" cname  */
  /* "src/parser.y":5173  */
                    {
                        yyval = Value::Node(
                            self.builder.const_global( Token::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                        );
                    },


  563 =>  /* p_const: p_const "::" cname  */
  /* "src/parser.y":5179  */
                    {
                        yyval = Value::Node(
                            self.builder.const_fetch(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  564 =>  /* p_const: "constant"  */
  /* "src/parser.y":5189  */
                    {
                        yyval = Value::Node(self.builder.const_( Token::from(yystack.owned_value_at(0))));
                    },


  565 =>  /* opt_rescue: k_rescue exc_list exc_var then compstmt opt_rescue  */
  /* "src/parser.y":5197  */
                    {
                        let ExcVar { assoc_t, exc_var } =  ExcVar::from(yystack.owned_value_at(3));

                        let exc_list =  NodeList::from(yystack.owned_value_at(4));
                        let exc_list = if exc_list.is_empty() {
                            None
                        } else {
                            Some(self.builder.array(None, exc_list, None))
                        };

                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(5)),
                            exc_list,
                            assoc_t,
                            exc_var,
                            Some( Token::from(yystack.owned_value_at(2))),
                             MaybeBoxedNode::from(yystack.owned_value_at(1))
                        );
                        let mut nodes;
                        let mut opt_rescue =  NodeList::from(yystack.owned_value_at(0));
                        nodes = Vec::with_capacity(1 + opt_rescue.len());
                        nodes.push(*rescue_body);
                        nodes.append(&mut opt_rescue);

                        yyval = Value::NodeList(nodes);
                    },


  566 =>  /* opt_rescue: none  */
  /* "src/parser.y":5224  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  567 =>  /* exc_list: arg_value  */
  /* "src/parser.y":5230  */
                    {
                        yyval = Value::NodeList(vec![  Node::from(yystack.owned_value_at(0)) ]);
                    },


  568 =>  /* exc_list: mrhs  */
  /* "src/parser.y":5234  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  569 =>  /* exc_list: none  */
  /* "src/parser.y":5238  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  570 =>  /* exc_var: "=>" lhs  */
  /* "src/parser.y":5244  */
                    {
                        let assoc_t = Some( Token::from(yystack.owned_value_at(1)));
                        let exc_var = Some( BoxedNode::from(yystack.owned_value_at(0)));
                        yyval = Value::new_exc_var(ExcVar { assoc_t, exc_var });
                    },


  571 =>  /* exc_var: none  */
  /* "src/parser.y":5250  */
                    {
                        yyval = Value::new_exc_var(ExcVar { assoc_t: None, exc_var: None });
                    },


  572 =>  /* opt_ensure: k_ensure compstmt  */
  /* "src/parser.y":5256  */
                    {
                        let ensure_t =  Token::from(yystack.owned_value_at(1));
                        let body =  MaybeBoxedNode::from(yystack.owned_value_at(0));
                        yyval = Value::new_opt_ensure(Some(Ensure { ensure_t, body }));
                    },


  573 =>  /* opt_ensure: none  */
  /* "src/parser.y":5262  */
                    {
                        yyval = Value::new_opt_ensure(None);
                    },


  574 =>  /* literal: numeric  */
  /* "src/parser.y":5268  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  575 =>  /* literal: symbol  */
  /* "src/parser.y":5272  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  576 =>  /* strings: string  */
  /* "src/parser.y":5278  */
                    {
                        yyval = Value::Node(
                            self.builder.string_compose(
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  577 =>  /* string: "char literal"  */
  /* "src/parser.y":5290  */
                    {
                        yyval = Value::NodeList(
                            vec![
                                *self.builder.character( Token::from(yystack.owned_value_at(0)))
                            ]
                        );
                    },


  578 =>  /* string: string1  */
  /* "src/parser.y":5298  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  579 =>  /* string: string string1  */
  /* "src/parser.y":5302  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  580 =>  /* string1: "string begin" string_contents "string end"  */
  /* "src/parser.y":5310  */
                    {
                        let mut string = self.builder.string_compose(Some( Token::from(yystack.owned_value_at(2))),  NodeList::from(yystack.owned_value_at(1)), Some( Token::from(yystack.owned_value_at(0))));
                        let indent = self.yylexer.buffer.heredoc_indent;
                        self.yylexer.buffer.heredoc_indent = 0;
                        self.builder.heredoc_dedent(&mut string, indent);
                        yyval = Value::Node(string);
                    },


  581 =>  /* xstring: "backtick literal" xstring_contents "string end"  */
  /* "src/parser.y":5320  */
                    {
                        let mut string = self.builder.xstring_compose( Token::from(yystack.owned_value_at(2)),  NodeList::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)));
                        let indent = self.yylexer.buffer.heredoc_indent;
                        self.yylexer.buffer.heredoc_indent = 0;
                        self.builder.heredoc_dedent(&mut string, indent);
                        yyval = Value::Node(string);
                    },


  582 =>  /* regexp: "regexp literal" regexp_contents tREGEXP_END  */
  /* "src/parser.y":5330  */
                    {
                        let regexp_end =  Token::from(yystack.owned_value_at(0));
                        let opts = self.builder.regexp_options(regexp_end.clone());
                        yyval = Value::Node(
                            self.builder.regexp_compose(
                                 Token::from(yystack.owned_value_at(2)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                regexp_end,
                                opts
                            )
                        );
                    },


  583 =>  /* words: "word list" " " word_list "string end"  */
  /* "src/parser.y":5345  */
                    {
                        yyval = Value::Node(
                            self.builder.words_compose(
                                 Token::from(yystack.owned_value_at(3)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  584 =>  /* word_list: %empty  */
  /* "src/parser.y":5357  */
                    {
                        yyval = Value::NodeList( vec![] );

                    },


  585 =>  /* word_list: word_list word " "  */
  /* "src/parser.y":5362  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(
                            *self.builder.word(  NodeList::from(yystack.owned_value_at(1)) )
                        );
                        yyval = Value::NodeList(nodes);
                    },


  586 =>  /* word: string_content  */
  /* "src/parser.y":5372  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  587 =>  /* word: word string_content  */
  /* "src/parser.y":5376  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  588 =>  /* symbols: "symbol list" " " symbol_list "string end"  */
  /* "src/parser.y":5384  */
                    {
                        yyval = Value::Node(
                            self.builder.symbols_compose(
                                 Token::from(yystack.owned_value_at(3)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  589 =>  /* symbol_list: %empty  */
  /* "src/parser.y":5396  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  590 =>  /* symbol_list: symbol_list word " "  */
  /* "src/parser.y":5400  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(
                            *self.builder.word(  NodeList::from(yystack.owned_value_at(1)) )
                        );
                        yyval = Value::NodeList(nodes);
                    },


  591 =>  /* qwords: "verbatim word list" " " qword_list "string end"  */
  /* "src/parser.y":5410  */
                    {
                        yyval = Value::Node(
                            self.builder.words_compose(
                                 Token::from(yystack.owned_value_at(3)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  592 =>  /* qsymbols: "verbatim symbol list" " " qsym_list "string end"  */
  /* "src/parser.y":5422  */
                    {
                        yyval = Value::Node(
                            self.builder.symbols_compose(
                                 Token::from(yystack.owned_value_at(3)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  593 =>  /* qword_list: %empty  */
  /* "src/parser.y":5434  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  594 =>  /* qword_list: qword_list "literal content" " "  */
  /* "src/parser.y":5438  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(
                            *self.builder.string_internal(  Token::from(yystack.owned_value_at(1)) )
                        );
                        yyval = Value::NodeList(nodes);
                    },


  595 =>  /* qsym_list: %empty  */
  /* "src/parser.y":5448  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  596 =>  /* qsym_list: qsym_list "literal content" " "  */
  /* "src/parser.y":5452  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(
                            *self.builder.symbol_internal(  Token::from(yystack.owned_value_at(1)) )
                        );
                        yyval = Value::NodeList(nodes);
                    },


  597 =>  /* string_contents: %empty  */
  /* "src/parser.y":5462  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  598 =>  /* string_contents: string_contents string_content  */
  /* "src/parser.y":5466  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.push( Node::from(yystack.owned_value_at(0)));
                        yyval = Value::NodeList(nodes);
                    },


  599 =>  /* xstring_contents: %empty  */
  /* "src/parser.y":5474  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  600 =>  /* xstring_contents: xstring_contents string_content  */
  /* "src/parser.y":5478  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.push( Node::from(yystack.owned_value_at(0)));
                        yyval = Value::NodeList(nodes);
                    },


  601 =>  /* regexp_contents: %empty  */
  /* "src/parser.y":5486  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  602 =>  /* regexp_contents: regexp_contents string_content  */
  /* "src/parser.y":5490  */
                    {
                        let mut  nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  603 =>  /* string_content: "literal content"  */
  /* "src/parser.y":5498  */
                    {
                        yyval = Value::Node(
                            self.builder.string_internal( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  604 =>  /* @32: %empty  */
  /* "src/parser.y":5504  */
                    {
                        yyval = Value::MaybeStrTerm(Box::new(std::mem::take(&mut self.yylexer.strterm)));
                        self.yylexer.lex_state.set(EXPR_BEG);
                    },


  605 =>  /* string_content: tSTRING_DVAR @32 string_dvar  */
  /* "src/parser.y":5509  */
                    {
                        self.yylexer.strterm =  MaybeStrTerm::from(yystack.owned_value_at(1));
                        yyval =  yystack.owned_value_at(0);
                    },


  606 =>  /* @33: %empty  */
  /* "src/parser.y":5514  */
                    {
                        self.yylexer.cmdarg.push(false);
                        self.yylexer.cond.push(false);
                        yyval = Value::None;
                    },


  607 =>  /* @34: %empty  */
  /* "src/parser.y":5519  */
                    {
                        yyval = Value::MaybeStrTerm(Box::new(std::mem::take(&mut self.yylexer.strterm)));
                    },


  608 =>  /* @35: %empty  */
  /* "src/parser.y":5522  */
                    {
                        yyval = Value::Num( self.yylexer.lex_state.get() );
                        self.yylexer.lex_state.set(EXPR_BEG);
                    },


  609 =>  /* @36: %empty  */
  /* "src/parser.y":5526  */
                    {
                        yyval = Value::Num( self.yylexer.brace_nest );
                        self.yylexer.brace_nest = 0;
                    },


  610 =>  /* @37: %empty  */
  /* "src/parser.y":5530  */
                    {
                        yyval = Value::Num( self.yylexer.buffer.heredoc_indent );
                        self.yylexer.buffer.heredoc_indent = 0;
                    },


  611 =>  /* string_content: tSTRING_DBEG @33 @34 @35 @36 @37 compstmt "tRCURLY"  */
  /* "src/parser.y":5535  */
                    {
                        self.yylexer.cond.pop();
                        self.yylexer.cmdarg.pop();
                        self.yylexer.strterm =  MaybeStrTerm::from(yystack.owned_value_at(5));
                        self.yylexer.lex_state.set( Num::from(yystack.owned_value_at(4)));
                        self.yylexer.brace_nest =  Num::from(yystack.owned_value_at(3));
                        self.yylexer.buffer.heredoc_indent =  Num::from(yystack.owned_value_at(2));
                        self.yylexer.buffer.heredoc_line_indent = -1;

                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(7)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  612 =>  /* string_dvar: "global variable"  */
  /* "src/parser.y":5555  */
                    {
                        yyval = Value::Node(self.builder.gvar( Token::from(yystack.owned_value_at(0))));
                    },


  613 =>  /* string_dvar: "instance variable"  */
  /* "src/parser.y":5559  */
                    {
                        yyval = Value::Node(self.builder.ivar( Token::from(yystack.owned_value_at(0))));

                    },


  614 =>  /* string_dvar: "class variable"  */
  /* "src/parser.y":5564  */
                    {
                        yyval = Value::Node(self.builder.cvar( Token::from(yystack.owned_value_at(0))));
                    },


  615 =>  /* string_dvar: backref  */
  /* "src/parser.y":5568  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  616 =>  /* symbol: ssym  */
  /* "src/parser.y":5573  */
                       { yyval =  yystack.owned_value_at(0); },


  617 =>  /* symbol: dsym  */
  /* "src/parser.y":5574  */
                       { yyval =  yystack.owned_value_at(0); },


  618 =>  /* ssym: "symbol literal" sym  */
  /* "src/parser.y":5578  */
                    {
                        self.yylexer.lex_state.set(EXPR_END);
                        yyval = Value::Node(
                            self.builder.symbol( Token::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                        );
                    },


  619 =>  /* sym: fname  */
  /* "src/parser.y":5586  */
                        { yyval =  yystack.owned_value_at(0); },


  620 =>  /* sym: "instance variable"  */
  /* "src/parser.y":5587  */
                        { yyval =  yystack.owned_value_at(0); },


  621 =>  /* sym: "global variable"  */
  /* "src/parser.y":5588  */
                        { yyval =  yystack.owned_value_at(0); },


  622 =>  /* sym: "class variable"  */
  /* "src/parser.y":5589  */
                        { yyval =  yystack.owned_value_at(0); },


  623 =>  /* dsym: "symbol literal" string_contents "string end"  */
  /* "src/parser.y":5593  */
                    {
                        self.yylexer.lex_state.set(EXPR_END);
                        yyval = Value::Node(
                            self.builder.symbol_compose( Token::from(yystack.owned_value_at(2)),  NodeList::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                        );
                    },


  624 =>  /* numeric: simple_numeric  */
  /* "src/parser.y":5602  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  625 =>  /* numeric: tUMINUS_NUM simple_numeric  */
  /* "src/parser.y":5606  */
                    {
                        yyval = Value::Node(
                            self.builder.unary_num(
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  626 =>  /* simple_numeric: "integer literal"  */
  /* "src/parser.y":5617  */
                    {
                        yyval = Value::Node(
                            self.builder.integer( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  627 =>  /* simple_numeric: "float literal"  */
  /* "src/parser.y":5623  */
                    {
                        yyval = Value::Node(
                            self.builder.float( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  628 =>  /* simple_numeric: "rational literal"  */
  /* "src/parser.y":5629  */
                    {
                        yyval = Value::Node(
                            self.builder.rational( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  629 =>  /* simple_numeric: "imaginary literal"  */
  /* "src/parser.y":5635  */
                    {
                        yyval = Value::Node(
                            self.builder.complex( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  630 =>  /* user_variable: "local variable or method"  */
  /* "src/parser.y":5643  */
                    {
                        yyval = Value::Node(
                            self.builder.lvar( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  631 =>  /* user_variable: "instance variable"  */
  /* "src/parser.y":5649  */
                    {
                        yyval = Value::Node(
                            self.builder.ivar( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  632 =>  /* user_variable: "global variable"  */
  /* "src/parser.y":5655  */
                    {
                        yyval = Value::Node(
                            self.builder.gvar( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  633 =>  /* user_variable: "constant"  */
  /* "src/parser.y":5661  */
                    {
                        yyval = Value::Node(
                            self.builder.const_( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  634 =>  /* user_variable: "class variable"  */
  /* "src/parser.y":5667  */
                    {
                        yyval = Value::Node(
                            self.builder.cvar( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  635 =>  /* keyword_variable: "`nil'"  */
  /* "src/parser.y":5675  */
                    {
                        yyval = Value::Node(
                            self.builder.nil( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  636 =>  /* keyword_variable: "`self'"  */
  /* "src/parser.y":5681  */
                    {
                        yyval = Value::Node(
                            self.builder.self_( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  637 =>  /* keyword_variable: "`true'"  */
  /* "src/parser.y":5687  */
                    {
                        yyval = Value::Node(
                            self.builder.true_( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  638 =>  /* keyword_variable: "`false'"  */
  /* "src/parser.y":5693  */
                    {
                        yyval = Value::Node(
                            self.builder.false_( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  639 =>  /* keyword_variable: "`__FILE__'"  */
  /* "src/parser.y":5699  */
                    {
                        yyval = Value::Node(
                            self.builder.__file__( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  640 =>  /* keyword_variable: "`__LINE__'"  */
  /* "src/parser.y":5705  */
                    {
                        yyval = Value::Node(
                            self.builder.__line__( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  641 =>  /* keyword_variable: "`__ENCODING__'"  */
  /* "src/parser.y":5711  */
                    {
                        yyval = Value::Node(
                            self.builder.__encoding__( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  642 =>  /* var_ref: user_variable  */
  /* "src/parser.y":5719  */
                    {
                        let node =  BoxedNode::from(yystack.owned_value_at(0));
                        if let Node::Lvar(node) = &*node {
                            let name = node.name.as_str();
                            match name.as_bytes()[..] {
                                [b'_', n] if n >= b'1' && n <= b'9' => {
                                    if !self.static_env.is_declared(&name) && self.context.is_in_dynamic_block() {
                                        /* definitely an implicit param */

                                        if self.max_numparam_stack.has_ordinary_params() {
                                            return self.yyerror(
                                                &yystack.location_at (0),
                                                DiagnosticMessage::OrdinaryParamDefined,
                                            );
                                        }

                                        let mut raw_context = self.context.inner_clone();
                                        let mut raw_max_numparam_stack = self.max_numparam_stack.inner_clone();

                                        /* ignore current block scope */
                                        raw_context.pop();
                                        raw_max_numparam_stack.pop();

                                        for outer_scope in raw_context.iter().rev() {
                                            if *outer_scope == ContextItem::Block || *outer_scope == ContextItem::Lambda {
                                                let outer_scope_has_numparams = raw_max_numparam_stack
                                                    .pop()
                                                    .unwrap_or(0) > 0;

                                                if outer_scope_has_numparams {
                                                    return self.yyerror(
                                                        &yystack.location_at (0),
                                                        DiagnosticMessage::NumparamUsed,
                                                    );
                                                } else {
                                                    /* for now it's ok, but an outer scope can also be a block
                                                        with numparams, so we need to continue */
                                                }
                                            } else {
                                                /* found an outer scope that can't have numparams
                                                    like def/class/etc */
                                                break;
                                            }
                                        }

                                        self.static_env.declare(&name);
                                        self.max_numparam_stack.register((n - b'0') as i32)
                                    }
                                },
                                _ => {}
                            }
                        }

                        yyval = Value::Node(
                            self.builder.accessible(node)
                        );
                    },


  643 =>  /* var_ref: keyword_variable  */
  /* "src/parser.y":5777  */
                    {
                        yyval = Value::Node(
                            self.builder.accessible( BoxedNode::from(yystack.owned_value_at(0)))
                        );
                    },


  644 =>  /* var_lhs: user_variable  */
  /* "src/parser.y":5785  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable( BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  645 =>  /* var_lhs: keyword_variable  */
  /* "src/parser.y":5791  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable( BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  646 =>  /* backref: "numbered reference"  */
  /* "src/parser.y":5799  */
                    {
                        yyval = Value::Node(
                            self.builder.nth_ref( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  647 =>  /* backref: "back reference"  */
  /* "src/parser.y":5805  */
                    {
                        yyval = Value::Node(
                            self.builder.back_ref( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  648 =>  /* @38: %empty  */
  /* "src/parser.y":5813  */
                    {
                        self.yylexer.lex_state.set(EXPR_BEG);
                        self.yylexer.command_start = true;
                        yyval = Value::None;
                    },


  649 =>  /* superclass: "<" @38 expr_value term  */
  /* "src/parser.y":5819  */
                    {
                        let lt_t  = Some( Token::from(yystack.owned_value_at(3)));
                        let value = Some( BoxedNode::from(yystack.owned_value_at(1)));
                        yyval = Value::new_superclass(
                            Superclass { lt_t, value }
                        );
                    },


  650 =>  /* superclass: %empty  */
  /* "src/parser.y":5827  */
                    {
                        yyval = Value::new_superclass(Superclass { lt_t: None, value: None });
                    },


  651 =>  /* f_opt_paren_args: f_paren_args  */
  /* "src/parser.y":5833  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  652 =>  /* f_opt_paren_args: none  */
  /* "src/parser.y":5837  */
                    {
                        yyval = Value::MaybeNode(None);
                    },


  653 =>  /* f_paren_args: "( (tLPAREN2)" f_args rparen  */
  /* "src/parser.y":5843  */
                    {
                        yyval = Value::MaybeNode(
                            self.builder.args(Some( Token::from(yystack.owned_value_at(2))),  NodeList::from(yystack.owned_value_at(1)), Some( Token::from(yystack.owned_value_at(0))))
                        );

                        self.yylexer.lex_state.set(EXPR_BEG);
                        self.yylexer.command_start = true;
                    },


  654 =>  /* f_paren_args: "( (tLPAREN2)" f_arg "," args_forward rparen  */
  /* "src/parser.y":5852  */
                    {
                        let mut args =  NodeList::from(yystack.owned_value_at(3));
                        args.push(*self.builder.forward_arg( Token::from(yystack.owned_value_at(1))));

                        yyval = Value::MaybeNode(
                            self.builder.args(
                                Some( Token::from(yystack.owned_value_at(4))),
                                args,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );

                        self.static_env.declare_forward_args();
                        self.yylexer.lex_state.set(EXPR_BEG);
                        self.yylexer.command_start = true;
                    },


  655 =>  /* f_paren_args: "( (tLPAREN2)" args_forward rparen  */
  /* "src/parser.y":5869  */
                    {
                        yyval = Value::MaybeNode(
                            Some(
                                self.builder.forward_only_args( Token::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                            )
                        );

                        self.static_env.declare_forward_args();
                        self.yylexer.lex_state.set(EXPR_BEG);
                        self.yylexer.command_start = true;
                    },


  656 =>  /* f_arglist: f_paren_args  */
  /* "src/parser.y":5883  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  657 =>  /* @39: %empty  */
  /* "src/parser.y":5886  */
                    {
                        yyval = Value::Bool(self.yylexer.in_kwarg);
                        self.yylexer.in_kwarg = true;
                        self.yylexer.lex_state.set(self.yylexer.lex_state.get()|EXPR_LABEL);
                    },


  658 =>  /* f_arglist: @39 f_args term  */
  /* "src/parser.y":5892  */
                    {
                        self.yylexer.in_kwarg =  Bool::from(yystack.owned_value_at(2));
                        yyval = Value::MaybeNode(
                            self.builder.args(None,  NodeList::from(yystack.owned_value_at(1)), None)
                        );
                        self.yylexer.lex_state.set(EXPR_BEG);
                        self.yylexer.command_start = true;
                    },


  659 =>  /* args_tail: f_kwarg "," f_kwrest opt_f_block_arg  */
  /* "src/parser.y":5903  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_kwrest =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_f_block_arg =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_kwrest.len() + opt_f_block_arg.len());
                        nodes.append(&mut f_kwrest);
                        nodes.append(&mut opt_f_block_arg);

                        yyval = Value::NodeList(nodes);
                    },


  660 =>  /* args_tail: f_kwarg opt_f_block_arg  */
  /* "src/parser.y":5915  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  661 =>  /* args_tail: f_any_kwrest opt_f_block_arg  */
  /* "src/parser.y":5922  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  662 =>  /* args_tail: f_block_arg  */
  /* "src/parser.y":5929  */
                    {
                        yyval = Value::NodeList(vec![  Node::from(yystack.owned_value_at(0)) ]);
                    },


  663 =>  /* opt_args_tail: "," args_tail  */
  /* "src/parser.y":5935  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  664 =>  /* opt_args_tail: %empty  */
  /* "src/parser.y":5939  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  665 =>  /* f_args: f_arg "," f_optarg "," f_rest_arg opt_args_tail  */
  /* "src/parser.y":5945  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(5));
                        let mut f_optarg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_optarg.len() + f_rest_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_optarg);
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  666 =>  /* f_args: f_arg "," f_optarg "," f_rest_arg "," f_arg opt_args_tail  */
  /* "src/parser.y":5959  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(7));
                        let mut f_optarg =  NodeList::from(yystack.owned_value_at(5));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_optarg.len() + f_rest_arg.len() + f_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_optarg);
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  667 =>  /* f_args: f_arg "," f_optarg opt_args_tail  */
  /* "src/parser.y":5975  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_optarg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_optarg.len() + opt_args_tail.len());
                        nodes.append(&mut f_optarg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  668 =>  /* f_args: f_arg "," f_optarg "," f_arg opt_args_tail  */
  /* "src/parser.y":5987  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(5));
                        let mut f_optarg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_optarg.len() + f_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_optarg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  669 =>  /* f_args: f_arg "," f_rest_arg opt_args_tail  */
  /* "src/parser.y":6001  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  670 =>  /* f_args: f_arg "," f_rest_arg "," f_arg opt_args_tail  */
  /* "src/parser.y":6013  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(5));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + f_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  671 =>  /* f_args: f_arg opt_args_tail  */
  /* "src/parser.y":6027  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  672 =>  /* f_args: f_optarg "," f_rest_arg opt_args_tail  */
  /* "src/parser.y":6034  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  673 =>  /* f_args: f_optarg "," f_rest_arg "," f_arg opt_args_tail  */
  /* "src/parser.y":6046  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(5));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + f_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  674 =>  /* f_args: f_optarg opt_args_tail  */
  /* "src/parser.y":6060  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  675 =>  /* f_args: f_optarg "," f_arg opt_args_tail  */
  /* "src/parser.y":6067  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  676 =>  /* f_args: f_rest_arg opt_args_tail  */
  /* "src/parser.y":6079  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  677 =>  /* f_args: f_rest_arg "," f_arg opt_args_tail  */
  /* "src/parser.y":6086  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  678 =>  /* f_args: args_tail  */
  /* "src/parser.y":6098  */
                    {
                        yyval = Value::NodeList( NodeList::from(yystack.owned_value_at(0)));
                    },


  679 =>  /* f_args: %empty  */
  /* "src/parser.y":6102  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  680 =>  /* args_forward: "(..."  */
  /* "src/parser.y":6108  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  681 =>  /* f_bad_arg: "constant"  */
  /* "src/parser.y":6114  */
                    {
                        return self.yyerror(&yystack.location_at (0), DiagnosticMessage::ConstArgument);
                    },


  682 =>  /* f_bad_arg: "instance variable"  */
  /* "src/parser.y":6118  */
                    {
                        return self.yyerror(&yystack.location_at (0), DiagnosticMessage::IvarArgument);
                    },


  683 =>  /* f_bad_arg: "global variable"  */
  /* "src/parser.y":6122  */
                    {
                        return self.yyerror(&yystack.location_at (0), DiagnosticMessage::GvarArgument);
                    },


  684 =>  /* f_bad_arg: "class variable"  */
  /* "src/parser.y":6126  */
                    {
                        return self.yyerror(&yystack.location_at (0), DiagnosticMessage::CvarArgument);
                    },


  685 =>  /* f_norm_arg: f_bad_arg  */
  /* "src/parser.y":6132  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  686 =>  /* f_norm_arg: "local variable or method"  */
  /* "src/parser.y":6136  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        let name = clone_value(&ident_t);
                        self.static_env.declare(&name);
                        self.max_numparam_stack.set_has_ordinary_params();
                        yyval = Value::Token(ident_t);
                    },


  687 =>  /* f_arg_asgn: f_norm_arg  */
  /* "src/parser.y":6146  */
                    {
                        let arg_t =  Token::from(yystack.owned_value_at(0));
                        let arg_name = clone_value(&arg_t);
                        self.current_arg_stack.set(Some(arg_name));
                        yyval = Value::Token(arg_t);
                    },


  688 =>  /* f_arg_item: f_arg_asgn  */
  /* "src/parser.y":6155  */
                    {
                        self.current_arg_stack.set(None);
                        yyval = Value::Node(
                            self.builder.arg( Token::from(yystack.owned_value_at(0)))?
                        );
                    },


  689 =>  /* f_arg_item: "(" f_margs rparen  */
  /* "src/parser.y":6162  */
                    {
                        yyval = Value::Node(
                            self.builder.multi_lhs(
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  690 =>  /* f_arg: f_arg_item  */
  /* "src/parser.y":6174  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  691 =>  /* f_arg: f_arg "," f_arg_item  */
  /* "src/parser.y":6178  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  692 =>  /* f_label: "label"  */
  /* "src/parser.y":6187  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        self.check_kwarg_name(&ident_t)?;

                        let ident = clone_value(&ident_t);
                        self.static_env.declare(&ident);

                        self.max_numparam_stack.set_has_ordinary_params();

                        self.current_arg_stack.set(Some(ident));

                        yyval = Value::Token(ident_t);
                    },


  693 =>  /* f_kw: f_label arg_value  */
  /* "src/parser.y":6203  */
                    {
                        self.current_arg_stack.set(None);
                        yyval = Value::Node(
                            self.builder.kwoptarg( Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  694 =>  /* f_kw: f_label  */
  /* "src/parser.y":6210  */
                    {
                        self.current_arg_stack.set(None);
                        yyval = Value::Node(
                            self.builder.kwarg( Token::from(yystack.owned_value_at(0)))?
                        );
                    },


  695 =>  /* f_block_kw: f_label primary_value  */
  /* "src/parser.y":6219  */
                    {
                        yyval = Value::Node(
                            self.builder.kwoptarg( Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  696 =>  /* f_block_kw: f_label  */
  /* "src/parser.y":6225  */
                    {
                        yyval = Value::Node(
                            self.builder.kwarg( Token::from(yystack.owned_value_at(0)))?
                        );
                    },


  697 =>  /* f_block_kwarg: f_block_kw  */
  /* "src/parser.y":6233  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  698 =>  /* f_block_kwarg: f_block_kwarg "," f_block_kw  */
  /* "src/parser.y":6237  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  699 =>  /* f_kwarg: f_kw  */
  /* "src/parser.y":6246  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  700 =>  /* f_kwarg: f_kwarg "," f_kw  */
  /* "src/parser.y":6250  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  701 =>  /* kwrest_mark: "**"  */
  /* "src/parser.y":6258  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  702 =>  /* kwrest_mark: "**arg"  */
  /* "src/parser.y":6262  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  703 =>  /* f_no_kwarg: kwrest_mark "`nil'"  */
  /* "src/parser.y":6268  */
                    {
                        yyval = Value::NodeList(
                            vec![
                                *self.builder.kwnilarg( Token::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                            ]
                        );
                    },


  704 =>  /* f_kwrest: kwrest_mark "local variable or method"  */
  /* "src/parser.y":6278  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        self.static_env.declare(&clone_value(&ident_t));
                        yyval = Value::NodeList(
                            vec![
                                *self.builder.kwrestarg( Token::from(yystack.owned_value_at(1)), Some(ident_t))?
                            ]
                        );
                    },


  705 =>  /* f_kwrest: kwrest_mark  */
  /* "src/parser.y":6288  */
                    {
                        yyval = Value::NodeList(
                            vec![
                                *self.builder.kwrestarg( Token::from(yystack.owned_value_at(0)), None)?
                            ]
                        );
                    },


  706 =>  /* f_opt: f_arg_asgn "=" arg_value  */
  /* "src/parser.y":6298  */
                    {
                        self.current_arg_stack.set(None);
                        yyval = Value::Node(
                            self.builder.optarg(
                                 Token::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  707 =>  /* f_block_opt: f_arg_asgn "=" primary_value  */
  /* "src/parser.y":6311  */
                    {
                        self.current_arg_stack.set(None);
                        yyval = Value::Node(
                            self.builder.optarg(
                                 Token::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  708 =>  /* f_block_optarg: f_block_opt  */
  /* "src/parser.y":6324  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  709 =>  /* f_block_optarg: f_block_optarg "," f_block_opt  */
  /* "src/parser.y":6328  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  710 =>  /* f_optarg: f_opt  */
  /* "src/parser.y":6336  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  711 =>  /* f_optarg: f_optarg "," f_opt  */
  /* "src/parser.y":6340  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  712 =>  /* restarg_mark: "* (tSTAR2)"  */
  /* "src/parser.y":6348  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  713 =>  /* restarg_mark: "*"  */
  /* "src/parser.y":6352  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  714 =>  /* f_rest_arg: restarg_mark "local variable or method"  */
  /* "src/parser.y":6358  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        self.static_env.declare(&clone_value(&ident_t));

                        yyval = Value::NodeList(
                            vec![
                                *self.builder.restarg( Token::from(yystack.owned_value_at(1)), Some(ident_t))?
                            ]
                        );
                    },


  715 =>  /* f_rest_arg: restarg_mark  */
  /* "src/parser.y":6369  */
                    {
                        yyval = Value::NodeList(
                            vec![
                                *self.builder.restarg( Token::from(yystack.owned_value_at(0)), None)?
                            ]
                        );
                    },


  716 =>  /* blkarg_mark: "& (tAMPER2)"  */
  /* "src/parser.y":6379  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  717 =>  /* blkarg_mark: "&"  */
  /* "src/parser.y":6383  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  718 =>  /* f_block_arg: blkarg_mark "local variable or method"  */
  /* "src/parser.y":6389  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        self.static_env.declare(&clone_value(&ident_t));
                        yyval = Value::Node(
                            self.builder.blockarg( Token::from(yystack.owned_value_at(1)), ident_t)?
                        );
                    },


  719 =>  /* opt_f_block_arg: "," f_block_arg  */
  /* "src/parser.y":6399  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] )
                    },


  720 =>  /* opt_f_block_arg: none  */
  /* "src/parser.y":6403  */
                    {
                        yyval = Value::NodeList( vec![] );
                    },


  721 =>  /* singleton: var_ref  */
  /* "src/parser.y":6409  */
                    {
                        let var_ref =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&var_ref)?;
                        yyval = Value::Node(var_ref);
                    },


  722 =>  /* @40: %empty  */
  /* "src/parser.y":6414  */
                           { self.yylexer.lex_state.set(EXPR_BEG); yyval = Value::None; },


  723 =>  /* singleton: "( (tLPAREN2)" @40 expr rparen  */
  /* "src/parser.y":6415  */
                    {
                        let expr =  BoxedNode::from(yystack.owned_value_at(1));
                        match &*expr {
                            Node::Int(_)
                            | Node::Float(_)
                            | Node::Rational(_)
                            | Node::Complex(_)
                            | Node::Str(_)
                            | Node::Dstr(_)
                            | Node::Sym(_)
                            | Node::Dsym(_)
                            | Node::Heredoc(_)
                            | Node::XHeredoc(_)
                            | Node::Regexp(_)
                            | Node::Array(_)
                            | Node::Hash(_) => {
                                self.yyerror1(
                                    DiagnosticMessage::SingletonLiteral,
                                    expr.expression().clone(),
                                )?;
                            }
                            other => {
                                self.value_expr(other)?
                            },
                        }
                        yyval = Value::Node(expr);
                    },


  724 =>  /* assoc_list: none  */
  /* "src/parser.y":6445  */
                    {
                        yyval = Value::NodeList(vec![]);
                    },


  725 =>  /* assoc_list: assocs trailer  */
  /* "src/parser.y":6449  */
                    {
                        yyval =  yystack.owned_value_at(1);
                    },


  726 =>  /* assocs: assoc  */
  /* "src/parser.y":6455  */
                    {
                        yyval = Value::NodeList( vec![  Node::from(yystack.owned_value_at(0)) ] );
                    },


  727 =>  /* assocs: assocs "," assoc  */
  /* "src/parser.y":6459  */
                    {
                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.push( Node::from(yystack.owned_value_at(0)));
                        yyval = Value::NodeList(nodes);
                    },


  728 =>  /* assoc: arg_value "=>" arg_value  */
  /* "src/parser.y":6467  */
                    {
                        yyval = Value::Node(
                            self.builder.pair(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  729 =>  /* assoc: "label" arg_value  */
  /* "src/parser.y":6477  */
                    {
                        yyval = Value::Node(
                            self.builder.pair_keyword(
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  730 =>  /* assoc: "string begin" string_contents tLABEL_END arg_value  */
  /* "src/parser.y":6486  */
                    {
                        yyval = Value::Node(
                            self.builder.pair_quoted(
                                 Token::from(yystack.owned_value_at(3)),
                                 NodeList::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  731 =>  /* assoc: "**arg" arg_value  */
  /* "src/parser.y":6497  */
                    {
                        yyval = Value::Node(
                            self.builder.kwsplat( Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))
                        );
                    },


  732 =>  /* operation: "local variable or method"  */
  /* "src/parser.y":6505  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  733 =>  /* operation: "constant"  */
  /* "src/parser.y":6509  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  734 =>  /* operation: "method"  */
  /* "src/parser.y":6513  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  735 =>  /* operation2: "local variable or method"  */
  /* "src/parser.y":6519  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  736 =>  /* operation2: "constant"  */
  /* "src/parser.y":6523  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  737 =>  /* operation2: "method"  */
  /* "src/parser.y":6527  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  738 =>  /* operation2: op  */
  /* "src/parser.y":6531  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  739 =>  /* operation3: "local variable or method"  */
  /* "src/parser.y":6537  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  740 =>  /* operation3: "method"  */
  /* "src/parser.y":6541  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  741 =>  /* operation3: op  */
  /* "src/parser.y":6545  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  742 =>  /* dot_or_colon: tDOT  */
  /* "src/parser.y":6551  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  743 =>  /* dot_or_colon: "::"  */
  /* "src/parser.y":6555  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  744 =>  /* call_op: tDOT  */
  /* "src/parser.y":6561  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  745 =>  /* call_op: "&."  */
  /* "src/parser.y":6565  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  746 =>  /* call_op2: call_op  */
  /* "src/parser.y":6571  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  747 =>  /* call_op2: "::"  */
  /* "src/parser.y":6575  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  748 =>  /* opt_terms: %empty  */
  /* "src/parser.y":6581  */
                    {
                        yyval = Value::None;
                    },


  749 =>  /* opt_terms: terms  */
  /* "src/parser.y":6585  */
                    {
                        yyval = Value::None;
                    },


  750 =>  /* opt_nl: %empty  */
  /* "src/parser.y":6591  */
                    {
                        yyval = Value::None;
                    },


  751 =>  /* opt_nl: "\n"  */
  /* "src/parser.y":6595  */
                    {
                        yyval = Value::None;
                    },


  752 =>  /* rparen: opt_nl ")"  */
  /* "src/parser.y":6601  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  753 =>  /* rbracket: opt_nl "]"  */
  /* "src/parser.y":6607  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  754 =>  /* rbrace: opt_nl "}"  */
  /* "src/parser.y":6613  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  755 =>  /* trailer: %empty  */
  /* "src/parser.y":6619  */
                    {
                        yyval = Value::None;
                    },


  756 =>  /* trailer: "\n"  */
  /* "src/parser.y":6623  */
                    {
                        yyval = Value::None;
                    },


  757 =>  /* trailer: ","  */
  /* "src/parser.y":6627  */
                    {
                        yyval = Value::None;
                    },


  758 =>  /* term: ";"  */
  /* "src/parser.y":6633  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  759 =>  /* term: "\n"  */
  /* "src/parser.y":6637  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  760 =>  /* terms: term  */
  /* "src/parser.y":6643  */
                    {
                        yyval = Value::TokenList(vec![]);
                    },


  761 =>  /* terms: terms ";"  */
  /* "src/parser.y":6647  */
                    {
                        yyval = Value::TokenList(vec![]);
                    },


  762 =>  /* none: %empty  */
  /* "src/parser.y":6653  */
                  {
                        yyval = Value::None;
                  },



/* "src/parser.rs":11054  */

            _ => {}
        }

        if let YYValue::Uninitialized = yyval {
            panic!("yyval is Uninitialized in rule at line {}", Self::yyrline_[i32_to_usize(yyn)]);
        }

        self.yy_symbol_print("-> $$ =", SymbolKind::get(Self::yyr1_[i32_to_usize(yyn)]), &yyval, &yyloc);

        yystack.pop_n(*yylen);
        *yylen = 0;
        /* Shift the result of the reduction.  */
        let yystate = self.yy_lr_goto_state(yystack.state_at(0), Self::yyr1_[i32_to_usize(yyn)]);
        yystack.push(yystate, yyval, yyloc);
        Ok(Self::YYNEWSTATE)
    }

    // Print this symbol on YYOUTPUT.
    fn yy_symbol_print(&self, s: &str, yykind: &SymbolKind, yyvalue: &YYValue, yylocation: &YYLoc) {
        if self.yydebug {
            self.yycdebug(
                &format!("{}{} {:?} ( {:?}: {:?} )", // " fix highlighting
                s,
                if yykind.code() < Self::YYNTOKENS_ { " token " } else { " nterm " },
                yykind.name(),
                yylocation,
                yyvalue
                )
            )
        }
    }

    /// Parses given input. Returns true if the parsing was successful.
    pub fn parse(&mut self) -> bool {
        /* @$.  */
        let mut yyloc: YYLoc;
        
    /* Lookahead token kind.  */
    let mut yychar: i32 = Self::YYEMPTY_;
    /* Lookahead symbol kind.  */
    let mut yytoken = &DYMMY_SYMBOL_KIND;

    /* State.  */
    let mut yyn: i32 = 0;
    let mut yylen: usize = 0;
    let mut yystate: i32 = 0;
    let mut yystack = YYStack::new();
    let mut label: i32 = Self::YYNEWSTATE;

    /* The location where the error started.  */
    let mut yyerrloc: YYLoc = YYLoc { begin: 0, end: 0};

    /* Location. */
    let mut yylloc: YYLoc = YYLoc { begin: 0, end: 0 };

    /* Semantic value of the lookahead.  */
    let mut yylval: YYValue = YYValue::Uninitialized;

        self.yycdebug("Starting parse");
        self.yyerrstatus_ = 0;
        self.yynerrs = 0;

        /* Initialize the stack.  */
        yystack.push(yystate, yylval.clone(), yylloc.clone());

        loop {
            match label {
                // New state.  Unlike in the C/C++ skeletons, the state is already
                // pushed when we come here.

                Self::YYNEWSTATE => {
                    if self.yydebug {
                        self.yycdebug(&format!("Entering state {}", yystate));
                        eprintln!("{}", yystack);
                    }

                    /* Accept? */
                    if yystate == Self::YYFINAL_ {
                        return true;
                    }

                    /* Take a decision.  First try without lookahead.  */
                    yyn = Self::yypact_[i32_to_usize(yystate)];
                    if yy_pact_value_is_default(yyn) {
                        label = Self::YYDEFAULT;
                        continue;
                    }

                    /* Read a lookahead token.  */
                    if yychar == Self::YYEMPTY_ {
                        self.yycdebug("Reading a token");
                        let token = self.next_token();
                        yychar = token.token_type();
                        yylloc = token.loc().clone();
                        yylval = YYValue::from_token(token);
                    }

                    /* Convert token to internal form.  */
                    yytoken = Self::yytranslate_(yychar);
                    self.yy_symbol_print("Next token is", &yytoken, &yylval, &yylloc);

                    if yytoken == SymbolKind::get(1) {
                        // The scanner already issued an error message, process directly
                        // to error recovery.  But do not keep the error token as
                        // lookahead, it is too special and may lead us to an endless
                        // loop in error recovery. */
                        yychar = Lexer::YYUNDEF;
                        yytoken = SymbolKind::get(2);
                        yyerrloc = yylloc.clone();
                        label = Self::YYERRLAB1;
                    } else {
                        // If the proper action on seeing token YYTOKEN is to reduce or to
                        // detect an error, take that action.
                        yyn += yytoken.code();
                        if yyn < 0 || Self::YYLAST_ < yyn || Self::yycheck_[i32_to_usize(yyn)] != yytoken.code() {
                            label = Self::YYDEFAULT;
                        }

                        /* <= 0 means reduce or error.  */
                        else {
                            yyn = Self::yytable_[i32_to_usize(yyn)];
                            if yyn <= 0 {
                                if yy_table_value_is_error(yyn) {
                                    label = Self::YYERRLAB;
                                } else {
                                    yyn = -yyn;
                                    label = Self::YYREDUCE;
                                }
                            } else {
                                /* Shift the lookahead token.  */
                                self.yy_symbol_print("Shifting", &yytoken, &yylval, &yylloc);

                                /* Discard the token being shifted.  */
                                yychar = Self::YYEMPTY_;

                                /* Count tokens shifted since error; after three, turn off error status.  */
                                if self.yyerrstatus_ > 0 {
                                    self.yyerrstatus_ -= 1;
                                }

                                yystate = yyn;
                                yystack.push(yystate, std::mem::take(&mut yylval), std::mem::take(&mut yylloc));
                                label = Self::YYNEWSTATE;
                            }
                        }
                    }
                    continue;
                }, // YYNEWSTATE

                // yydefault -- do the default action for the current state.
                Self::YYDEFAULT => {
                    yyn = Self::yydefact_[i32_to_usize(yystate)];
                    if yyn == 0 {
                        label = Self::YYERRLAB;
                    } else {
                        label = Self::YYREDUCE;
                    }
                    continue;
                } // YYDEFAULT

                // yyreduce -- Do a reduction.
                Self::YYREDUCE => {
                    yylen = i32_to_usize(Self::yyr2_[i32_to_usize(yyn)]);
                    label = match self.yyaction(yyn, &mut yystack, &mut yylen) {
                        Ok(label) => label,
                        Err(_) => Self::YYERROR
                    };
                    yystate = yystack.state_at(0);
                    continue;
                }, // YYREDUCE

                // yyerrlab -- here on detecting error
                Self::YYERRLAB => {
                    /* If not already recovering from an error, report this error.  */
                    if self.yyerrstatus_ == 0 {
                        self.yynerrs += 1;
                        if yychar == Self::YYEMPTY_ {
                            yytoken = &DYMMY_SYMBOL_KIND;
                        }
                        self.report_syntax_error(&Context::new(yystack.clone(), yytoken.clone(), yylloc.clone()));
                    }
                    yyerrloc = yylloc.clone();
                    if self.yyerrstatus_ == 3 {
                        // If just tried and failed to reuse lookahead token after an error, discard it.

                        if yychar <= Lexer::END_OF_INPUT {
                            /* Return failure if at end of input.  */
                            if yychar == Lexer::END_OF_INPUT {
                                return false;
                            }
                        }
                        else {
                            yychar = Self::YYEMPTY_;
                        }
                    }

                    // Else will try to reuse lookahead token after shifting the error token.
                    label = Self::YYERRLAB1;
                    continue;
                }, // YYERRLAB

                // errorlab -- error raised explicitly by YYERROR.
                Self::YYERROR => {
                    /* Do not reclaim the symbols of the rule which action triggered
                    this YYERROR.  */
                    yystack.pop_n(yylen);
                    yylen = 0;
                    yystate = yystack.state_at(0);
                    label = Self::YYERRLAB1;
                    continue;
                }, // YYERROR

                // yyerrlab1 -- common code for both syntax error and YYERROR.
                Self::YYERRLAB1 => {
                    self.yyerrstatus_ = 3;       /* Each real token shifted decrements this.  */

                    // Pop stack until we find a state that shifts the error token.
                    loop {
                        yyn = Self::yypact_[i32_to_usize(yystate)];
                        if !yy_pact_value_is_default(yyn) {
                            yyn += SymbolKind { value: SymbolKind::S_YYerror }.code();
                            if 0 <= yyn && yyn <= Self::YYLAST_ {
                                let yyn_usize = i32_to_usize(yyn);
                                if Self::yycheck_[yyn_usize] == SymbolKind::S_YYerror {
                                    yyn = Self::yytable_[yyn_usize];
                                    if 0 < yyn {
                                        break;
                                    }
                                }
                            }
                        }

                        // Pop the current state because it cannot handle the error token.
                        if yystack.len() == 1 {
                            return false;
                        }

                        yyerrloc = yystack.location_at(0).clone();
                        yystack.pop();
                        yystate = yystack.state_at(0);
                        if self.yydebug {
                            eprintln!("{}", yystack);
                        }
                    }

                    if label == Self::YYABORT {
                        /* Leave the switch.  */
                        continue;
                    }

                    /* Muck with the stack to setup for yylloc.  */
                    yystack.push(0, YYValue::Uninitialized, yylloc.clone());
                    yystack.push(0, YYValue::Uninitialized, yyerrloc.clone());
                    yyloc = make_yylloc(&yystack, 2);
                    yystack.pop_n(2);

                    /* Shift the error token.  */
                    self.yy_symbol_print("Shifting", SymbolKind::get(Self::yystos_[i32_to_usize(yyn)]), &yylval, &yyloc);

                    yystate = yyn;
                    yystack.push(yyn, yylval.clone(), yyloc.clone());
                    label = Self::YYNEWSTATE;
                    continue;
                }, // YYERRLAB1

                // Accept
                Self::YYACCEPT => {
                    return true;
                }

                // Abort.
                Self::YYABORT => {
                    return false;
                },

                _ => {
                    panic!("internal bison error: unknown label {}", label);
                }
            }
        }
    }
}

#[derive(Debug)]
pub(crate) struct Context {
    yystack: YYStack,
    yytoken: SymbolKind,
    loc: YYLoc
}

impl Context {
    pub(crate) fn new(stack: YYStack, token: SymbolKind, loc: YYLoc) -> Self {
        Self { yystack: stack, yytoken: token, loc }
    }

    #[allow(dead_code)]
    pub(crate) fn token(&self) -> &SymbolKind {
        &self.yytoken
    }

    #[allow(dead_code)]
    pub(crate) fn location(&self) -> &YYLoc {
        &self.loc
    }
}

// Whether the given `yypact_` value indicates a defaulted state.
fn yy_pact_value_is_default(yyvalue: i32) -> bool {
    yyvalue == YYPACT_NINF_
}

// Whether the given `yytable_`
// value indicates a syntax error.
// yyvalue: the value to check
fn yy_table_value_is_error(yyvalue: i32) -> bool {
    yyvalue == YYTABLE_NINF_
}

const YYPACT_NINF_: i32 = -1042;
const YYTABLE_NINF_: i32 = -763;

impl  Parser  {

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
  #[allow(non_upper_case_globals)]
const yypact_: &'static [i32] = &[  -1042,    85,  4184, -1042,  7891, -1042, -1042, -1042, 12443, -1042,
   -1042, -1042, -1042, -1042, -1042, -1042,  8166,  8166, -1042, -1042,
   -1042,  6886,  4034, -1042, -1042, -1042, -1042,   360, 12298,    10,
      48,    51, -1042, -1042, -1042,  3874,  6594, -1042, -1042,  6010,
   -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, 10497, 10497,
   10497, 10497,   156,  5185,  8303,  8851,  9262, 10908, -1042, 12153,
   -1042, -1042, -1042,   163,   189,   236,   295, 10497, 10634,  1190,
   -1042,   726, -1042,  1008, -1042,   678,   465,   465, -1042, -1042,
     112,   431,   365, -1042,   392, 11031, -1042,   383,  3009,   514,
     534,   651, -1042, 10771, 10771, -1042, -1042,  9399, 11153, 11275,
   11520, 12008,  8166, -1042,   379,    62, -1042, -1042,   427, -1042,
   -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042,
   -1042,   108,   301, -1042,   452,   398, -1042, -1042, -1042, -1042,
   -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042,
   -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042,
   -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042,
   -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042,
   -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042,
   -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042,
   -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042,
   -1042, -1042, -1042, -1042, -1042,   442, -1042, -1042, -1042,   446,
   10497,   539,  5323, 10497, 10497, 10497, -1042, 10497, -1042,   485,
   14310,   526, -1042, -1042,   547,   692,   174,   220,   578,   261,
     566, -1042, -1042,  8028, -1042,  8166,  8440, -1042, -1042,  9537,
   -1042, 10771,   847, -1042,  9675,  5461, -1042,  5599, -1042, -1042,
     589,   604,   112, -1042,   718, -1042,   658, 14383, 14383,   407,
   -1042, -1042,  5185,   640,   726, -1042,  1008,    10,   620, -1042,
    1008,    10,   624,   315,   388, -1042,   526,   685,   388, -1042,
      10,   746, 11642,  1190,   682,   682,   696, -1042,   728,   780,
     826,   838,  1449, -1042, -1042, -1042, -1042,   599, -1042,   956,
    1109,   503, -1042, -1042, -1042, -1042, -1042, -1042, -1042,   749,
   -1042, -1042, -1042, -1042,  7617, 10771, 10771, 10771, 10771,  8303,
   10771, 10771,  1532,   701,   712,  4346,  1597, -1042,   715,  4346,
   -1042, -1042, -1042,   757, -1042, -1042, -1042, -1042, -1042,  9812,
   -1042,  5185, 11397,   730,  9812, -1042, 10497, 10497, 10497, 10497,
   10497, -1042, -1042, 10497, 10497, 10497, 10497, 10497, 10497, 10497,
   10497, -1042, 10497, 10497, -1042, -1042, 10497, 10497, 10497, 10497,
   10497, 10497, 10497, 10497, 10497, -1042, -1042, 13183,  8166, 13256,
    4346,   678,   157,   157,  5737, 10771,  5737,   726, -1042,   735,
     833, -1042, -1042,   853,   857,    54,    70,   114,   902,   958,
   10771,   607, -1042,   777,   938, -1042, -1042, -1042, -1042,   217,
     239,   291,   327,   448,   463,   488,   508,   581, -1042, -1042,
   -1042, -1042,   603, -1042, -1042, -1042, 14278, -1042, -1042, 10634,
   10634, -1042, -1042,   286, -1042, -1042, -1042,   339, 10497, 10497,
    8577, -1042, -1042, 13329,  8166, 13402, 10497, 10497,  8988, -1042,
      10,   812, -1042, -1042, 10497,    10, -1042,   792,    10,   794,
   -1042,   130, -1042, -1042, -1042, -1042, -1042, 12443, 10771, 14310,
     797,   799, 13329, 13402, 10497,    48,    10, -1042, -1042,  7754,
     808,    10, -1042, -1042,  9125, -1042, -1042,  9262, -1042, -1042,
   -1042,   800,  1056, -1042,   815, -1042, -1042, 11642, 13475,  8166,
   13548, -1042, -1042, -1042, -1042, -1042, -1042, -1042,  1342, -1042,
   -1042, -1042, -1042,  1597, -1042,   820, -1042, -1042, -1042, -1042,
   -1042,   824, -1042,   831, 10497, -1042,   835,    83, -1042, -1042,
   -1042,   842,   921,   850,   926, -1042, -1042, -1042, -1042, -1042,
   -1042, -1042, -1042, -1042, -1042, -1042,  1161,    63,  1193,    81,
   10497, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042,
   -1042,    10,    10,   855, 10497,   973,   980,   726, 10497,   973,
   -1042, -1042, -1042, -1042, -1042, 10497, -1042,   867,   876,   959,
   -1042,    10, 11642,   889, -1042, -1042, -1042,   972,   894,  3404,
   -1042, -1042, -1042,  1086,   382, 12999,   658,  2269,  2269,  2269,
    2269,  2605,  1828,  2269,  2269, 14383, 14383,   346,   346, 12999,
     996,   976,   996,   321,   321,   658,   658,   658,  3556,  1113,
    1113,  7032,  6156,  7324,  6302, -1042,   604, -1042,    10,   900,
     475, -1042,   627, -1042, -1042,  6740,   973, -1042,  4484,  1016,
    4898,   973,    88,   973,  1011,  1020,   136, 13621,  8166, 13694,
   -1042,   678, -1042,  1056, -1042, -1042, -1042, 13767,  8166, 13840,
    4346, 10771, -1042, -1042, -1042, -1042, -1042,  2979, -1042, 12997,
   -1042, -1042, -1042, 12443, 10497, -1042, 10497,   526, -1042,   566,
    3721,  6448,    10,   458,   629, -1042, -1042, -1042, -1042,  8714,
   -1042,  8988, -1042, -1042,   130, -1042, -1042,   604,   604, -1042,
   -1042,   535, -1042, -1042,   388, 11642,   815,   554,   642,    10,
     418,   583,  1342,   953, -1042,   916,    10,   917, -1042,    10,
     100, -1042, -1042,    91, 10497,  1597, -1042, -1042,   268, -1042,
   -1042, -1042,  1597, -1042, -1042,  1516, -1042, -1042, -1042,  1362,
   -1042,   281, -1042,   905, -1042, -1042,   387,   918, -1042,   658,
   -1042, -1042,  1532, 13074, -1042, -1042, -1042,  9949,   206, -1042,
   -1042, 13099, -1042,   935,   933, -1042,   973,   933,   973,   939,
   10086,  8303, -1042,   815, 11642,  8303, 10634, 10497, 13913,  8166,
   13986, -1042, -1042,  3565,  3565,   617, -1042, 12738,   181,  1024,
   -1042,   979, -1042,   942, -1042, -1042,   720, -1042, -1042,    56,
   -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042,   979,
     931, 10634, 10634, -1042,   757,   948,   669,  8577, 10634, 10634,
   -1042, -1042,   757, -1042, -1042,   924, -1042,  1072, -1042, -1042,
   -1042, -1042, -1042, -1042,  1020,   973, -1042, 10223,   973,   119,
     121,    10,   150,   164,  5737,   726, 10771,  4346,  1006,   642,
   -1042,    10,   973,   130, 12588,    62,   431, -1042, -1042, -1042,
   -1042, 10497, 10497,   675, 10497, 10497,    10,   964, -1042, -1042,
   -1042,   688,    10, -1042,  1342, -1042,   875,   989,   955, -1042,
   -1042, -1042, -1042, -1042, -1042, -1042,   971,   974, -1042,  1046,
     820,   990, -1042,   991, -1042,   990, -1042, -1042, -1042, -1042,
   -1042, -1042, -1042, -1042, -1042, -1042, -1042,    10, 10497,   867,
   -1042,  1005, -1042, -1042, -1042,  5737,  5047, -1042, -1042, 10497,
   -1042,  1658,  5599, -1042, -1042,   985, -1042,  4346, -1042, 10497,
    1003, -1042,   815, -1042, 14310,  7178,  7470,    10,   723,   751,
   -1042, -1042, -1042, -1042, 12999,  1062,   158,    10, 12825, -1042,
      10,  1004,  1021, -1042,   441,  1009, -1042, -1042,  1093, 12999,
    3565,  3565,   617,   574,    40, 12651, 12651, 10497, -1042, -1042,
   -1042, -1042, -1042, -1042, 10634, -1042, -1042, -1042, -1042, -1042,
   -1042,  5737, 10771,   973, -1042, -1042,   973, 12651,   973, -1042,
   10497, -1042,    94, -1042,   171,   973,  4346,   726,   973, -1042,
   -1042, -1042, -1042, -1042, -1042, 10497, -1042,  8988, -1042, -1042,
    1025,  1026, -1042,  1366,  4346,  5599,  1597, -1042,  1516, -1042,
   -1042,  1516, -1042,  1516, -1042, -1042, -1042, -1042, 14310, 11764,
     157, -1042, -1042,  1148, 14310,   820, -1042,    10,  1033,  1038,
    1043, 11886, -1042,  1052, -1042,  1061,  1066, -1042, -1042, -1042,
   -1042,  1067,   759,    16, -1042, -1042,   126,   979,  1069, -1042,
   12999, -1042, -1042, -1042,    10,  1070, -1042, 12999, -1042, -1042,
   -1042,   129, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042,
   -1042,    10,    10,    10,    10,    10,    10, 14310, -1042, -1042,
   -1042,   157, -1042, -1042,   157,   827,   307, -1042, -1042, -1042,
   -1042, -1042, 10360,  4622, -1042,   973, -1042, -1042,   875,   875,
   -1042,   408, -1042, -1042,   973,  1054,   990,  1075,   990,   990,
   -1042,  1149, -1042,  1092,   173,   203,   204,  4346, -1042, -1042,
    1074, -1042, 11886,  1597, -1042, -1042,  1153,  1119,   268, -1042,
    1597, -1042,  1516, -1042, -1042,  1085, 12999, -1042,  1087, -1042,
     103, -1042,   441,   979, -1042, -1042,   750, -1042, -1042, -1042,
   -1042, -1042, -1042,  4484, -1042, 10771, 10771, 12912, 10497, -1042,
     882, -1042,  1026,  1366, -1042, -1042, -1042, -1042,  1516, -1042,
   -1042, -1042,  5875,   234, 14059,  8166, 14132,   980, -1042,  1119,
   -1042,  1101,  1104, -1042, 14205, -1042,   820,  1107, -1042,  1110,
    1107, 12999,  1111, 12912, -1042, -1042, -1042,   924,  4760, -1042,
   -1042, -1042,  1114, -1042, -1042, -1042, -1042, -1042,   990,  1097,
      47,   184,    10,   241,   251, -1042,  1597, -1042,  1516, -1042,
    1102,  1124, -1042,  1516, -1042,  1516, -1042, -1042,  1111, 12999,
   -1042, -1042, -1042,   355, 12999, -1042, -1042,   256,  1107,  1115,
    1107,  1107, -1042, -1042, -1042,  1111, -1042,  1516, -1042, -1042,
   -1042,  1107, -1042 ];

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
  #[allow(non_upper_case_globals)]
const yydefact_: &'static [i32] = &[      2,     0,     0,     1,     0,   362,   363,   364,     0,   355,
     356,   357,   360,   358,   359,   361,   350,   351,   352,   353,
     373,   285,   285,   636,   635,   637,   638,   750,     0,   750,
       0,     0,   640,   639,   641,   732,   734,   632,   631,   733,
     634,   626,   627,   628,   629,   577,   646,   647,     0,     0,
       0,     0,     0,     0,   312,   762,   762,    98,   430,   597,
     597,   599,   601,     0,     0,     0,     0,     0,     0,     0,
       3,   748,     6,     9,    34,    39,   657,   657,    51,    69,
     285,    68,     0,    86,     0,    90,   100,     0,    60,   238,
     256,     0,   310,     0,     0,    66,    66,   748,     0,     0,
       0,     0,   321,   331,    70,   329,   299,   300,   576,   578,
     301,   302,   303,   305,   304,   306,   575,   616,   617,   574,
     624,   642,   643,   307,     0,   308,    74,     5,     8,   179,
     190,   180,   203,   176,   196,   186,   185,   206,   207,   201,
     184,   183,   178,   204,   208,   209,   188,   177,   191,   195,
     197,   189,   182,   198,   205,   200,   199,   192,   202,   187,
     175,   194,   193,   174,   181,   172,   173,   169,   170,   171,
     129,   131,   130,   164,   165,   160,   142,   143,   144,   151,
     148,   150,   145,   146,   166,   167,   152,   153,   157,   161,
     139,   141,   147,   149,   168,   140,   154,   155,   156,   158,
     159,   163,   162,   134,   136,    27,   132,   133,   135,     0,
       0,     0,     0,     0,     0,     0,   597,     0,   280,     0,
     263,   290,    84,   284,   762,     0,   642,   643,     0,   308,
     762,   726,    85,   750,    82,     0,   762,   451,    81,   750,
     751,     0,     0,    22,     0,     0,    10,     0,   350,   351,
     324,   452,     0,   232,     0,   321,   233,   223,   224,   318,
      18,    20,     0,     0,   748,    16,    19,   750,    88,    15,
     314,   750,     0,   755,   755,   264,     0,     0,   755,   724,
     750,     0,     0,     0,   657,   657,    96,   354,     0,   106,
     107,   114,   679,   621,   620,   622,   619,     0,   618,     0,
       0,     0,   584,   593,   589,   595,   245,    55,   244,   625,
     758,   759,     4,   760,   749,     0,     0,     0,     0,     0,
       0,     0,   679,     0,   656,     0,   679,   652,     0,     0,
     365,   454,   445,    75,   456,   328,   366,   439,   441,     0,
     102,     0,    94,    91,     0,    58,     0,     0,     0,     0,
       0,   259,   260,     0,     0,     0,     0,   221,   222,     0,
       0,    56,     0,     0,   257,   258,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   744,   745,     0,   762,     0,
       0,    65,     0,     0,     0,     0,     0,   748,   338,   749,
       0,   384,   383,     0,     0,   642,   643,   308,   124,   125,
       0,     0,   127,   650,     0,   642,   643,   308,   346,   199,
     192,   202,   187,   169,   170,   171,   129,   130,   722,    62,
      61,   721,     0,    83,   747,   746,     0,   330,   579,     0,
       0,   137,   729,   318,   291,   731,   287,     0,     0,     0,
       0,   281,   289,     0,   762,     0,     0,     0,     0,   282,
     750,     0,   323,   286,   680,   750,   276,   762,   750,   762,
     275,   750,   327,    54,    24,    26,    25,     0,     0,   250,
       0,     0,     0,     0,     0,     0,   750,   316,    14,   749,
      87,   750,   313,   319,   757,   756,   265,   757,   267,   320,
     725,     0,   113,   104,    99,   625,   656,     0,     0,   762,
       0,   686,   683,   682,   681,   684,   692,   701,     0,   713,
     702,   717,   716,   679,   712,   762,   431,   678,   434,   685,
     687,   688,   690,   664,   694,   699,   762,   705,   397,   396,
     710,   664,   715,   664,     0,   662,   603,   623,   606,   604,
     598,   580,   581,   600,   582,   602,     0,     0,     0,     0,
       0,   761,     7,    28,    29,    30,    31,    32,    52,    53,
     680,   750,   750,   664,     0,     0,   762,     0,     0,     0,
     458,    72,    76,   460,   460,     0,    35,   295,     0,    38,
     294,   750,     0,    92,   103,    50,    40,    48,     0,   268,
     290,   210,    36,     0,   308,     0,   230,   237,   239,   240,
     241,   248,   249,   242,   243,   219,   220,   246,   247,     0,
     234,   236,   235,   225,   226,   227,   228,   229,   750,   261,
     262,   735,   737,   736,   738,   450,   285,   448,   750,   762,
     735,   737,   736,   738,   449,   285,     0,   375,     0,   374,
       0,     0,     0,     0,   336,     0,   318,     0,   762,     0,
      66,   344,   124,   125,   126,   648,   342,     0,   762,     0,
       0,     0,   742,   743,    63,   735,   736,   285,    41,   268,
     211,    47,   218,     0,     0,   728,     0,   292,   288,   762,
     735,   736,   750,   735,   736,   727,   322,   752,   270,   277,
     272,   279,   326,    23,   750,    11,    33,     0,   762,   217,
      21,    89,    17,   315,   755,     0,    97,   739,   112,   750,
     735,   736,     0,   395,   387,   389,   750,   392,   385,   750,
       0,   661,   720,     0,     0,     0,   671,   693,     0,   660,
     703,   704,     0,   674,   714,     0,   676,   718,   607,     0,
     583,     0,   586,     0,   591,   588,     0,     0,   592,   231,
     653,   655,     0,   252,   372,   348,   367,   762,   762,   566,
     658,   254,   349,     0,   762,   458,     0,   762,     0,   298,
       0,     0,   101,    95,     0,     0,     0,     0,     0,   762,
       0,   560,   564,     0,     0,     0,   505,   750,   502,     0,
     559,    59,   483,   485,   487,   490,   540,   545,   546,   547,
     550,   551,   552,   553,   554,   556,   555,   557,   558,    57,
       0,     0,     0,   447,    79,     0,   453,   277,     0,     0,
     274,   446,    77,   273,   311,   762,   376,   762,   334,   378,
      67,   377,   335,   469,     0,     0,   369,     0,     0,   739,
     317,   750,   735,   736,     0,     0,     0,     0,   124,   125,
     128,   750,     0,   750,     0,   442,    71,   138,   730,   293,
     283,     0,     0,   453,     0,     0,   750,   762,   325,   266,
     105,   453,   750,   394,     0,   689,     0,     0,   424,   719,
     437,   435,   432,   706,   663,   691,   664,   664,   700,   705,
     762,   664,   711,   664,   688,   664,   608,   612,   613,   614,
     605,   615,   585,   587,   594,   590,   596,   750,     0,   567,
     568,   762,   569,   368,   370,     0,     0,    13,   573,     0,
     455,   750,     0,   421,   420,     0,   457,     0,   440,     0,
     296,    37,    93,    49,   269,   735,   736,   750,   735,   736,
     548,   549,   125,   562,     0,   521,   507,   750,   508,   514,
     750,   517,     0,   501,     0,     0,   504,   561,     0,     0,
     543,   544,     0,   489,   488,     0,     0,     0,    46,   215,
      45,   216,    80,   753,     0,    43,   213,    44,   214,    78,
     371,     0,     0,     0,   379,   381,     0,     0,     0,   340,
       0,   462,     0,   339,   453,     0,     0,     0,     0,   453,
     347,   723,    64,   443,   444,     0,   271,   278,   386,   388,
     390,   393,   433,     0,     0,     0,     0,   667,     0,   669,
     659,     0,   675,     0,   672,   677,   609,   654,   253,     0,
       0,   571,   572,   762,   255,   762,   419,   750,     0,   688,
     403,   696,   697,   762,   708,   403,   403,   401,   459,    73,
     461,   297,   453,   750,   520,   499,   512,   524,   509,   500,
       0,   515,   533,   597,   750,   526,   529,   532,   538,   539,
     528,   536,   754,   484,   486,   541,   542,   563,   498,   494,
     597,   750,   750,   750,   750,   750,   750,   251,    42,   212,
     382,     0,   332,   333,     0,   474,   477,   481,   480,   482,
     337,   463,     0,     0,   341,     0,   649,   343,     0,     0,
     428,   750,   426,   429,     0,     0,   664,   664,   664,   664,
     610,     0,   570,     0,   642,   643,   308,     0,    12,   400,
       0,   422,     0,   404,   412,   410,     0,   695,     0,   399,
       0,   415,     0,   417,   506,   510,     0,   516,   518,   522,
       0,   503,   527,   531,   537,   535,     0,   491,   492,   493,
     495,   496,   497,     0,   470,     0,     0,   478,     0,   464,
     762,   345,   391,     0,   425,   438,   436,   668,     0,   665,
     670,   673,     0,   318,     0,   762,     0,   762,   423,   707,
     402,   403,   403,   318,     0,   698,   762,   403,   709,   403,
     403,     0,   513,     0,   534,   530,   525,   762,     0,   475,
     476,   479,   517,   465,   467,   468,   466,   427,   664,     0,
     739,   317,   750,   735,   736,   565,     0,   407,     0,   409,
     739,   317,   398,     0,   416,     0,   413,   418,   511,     0,
     519,   523,   380,   762,     0,   666,   611,   453,   403,   403,
     403,   403,   472,   473,   471,   518,   408,     0,   405,   411,
     414,   403,   406 ];

/* YYPGOTO[NTERM-NUM].  */
  #[allow(non_upper_case_globals)]
const yypgoto_: &'static [i32] = &[  -1042, -1042, -1042,  1000, -1042,    23,   786,  -259,   303, -1042,
     784, -1042,    32, -1042,  -257,  -228,    37, -1042, -1042,   412,
     -52,    27, -1042,   -17,   -82, -1042,    73, -1042,  -201, -1042,
    1029,   -13,  1169,  -100,   -10,   -78, -1042,  -424,    -7,  2401,
    -364,  1171,   -48,   -19, -1042, -1042,     7, -1042,  3219,  1183,
   -1042,    53, -1042,   522,   -16,   606,  -354,    46,    69, -1042,
    -373,  -217,    97, -1042,  -319,    66, -1042, -1042, -1042, -1042,
   -1042, -1042, -1042, -1042,   518, -1042, -1042, -1042, -1042, -1042,
   -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042, -1042,
     517, -1042,  1152,  1513,  -360, -1042,    71,  -808, -1042,  -825,
    -834,   565,   405,  -122,   366,   128, -1042, -1042,   523, -1042,
    -847, -1042,   122,   576, -1042, -1042, -1042, -1042, -1042, -1042,
     440, -1042, -1042, -1042,   -88, -1042, -1042,   533, -1042,   725,
   -1042, -1042,  -803, -1042,    58, -1042, -1042, -1042, -1042, -1042,
    -538, -1042, -1042, -1042, -1042,   345, -1042, -1042,  -829, -1042,
     319,  -290, -1027, -1041,  -494,  -190, -1042,   159, -1042, -1042,
   -1042,   161, -1042,  -673,   350, -1042, -1042,   123, -1042, -1042,
     283,   987,  1076, -1042,  1209,  1141,  1422,  1823, -1042,   773,
    1970, -1042,  1978,  2294, -1042, -1042,   -59, -1042, -1042,  -182,
   -1042, -1042, -1042, -1042, -1042, -1042, -1042,    12, -1042, -1042,
   -1042, -1042,   -11,  2211,    -2,  1221,  2529,  1737, -1042, -1042,
    1246,   706,   -32, -1042,  -198,  -477,  -222,  -306,  -944,  -407,
    -254,  -660,   146,  -233,   598,   193, -1042, -1042,  -515, -1042,
    -696,  -691, -1018,   199,  -593, -1042,  -534, -1042,   167,  -497,
   -1042, -1042, -1042,   138,  -426, -1042,  -367, -1042, -1042,   -83,
   -1042,   -58,   515,  1014,    24,   271,  -248,   -53,    22,    26 ];

/* YYDEFGOTO[NTERM-NUM].  */
  #[allow(non_upper_case_globals)]
const yydefgoto_: &'static [i32] = &[      0,     1,     2,    70,    71,    72,   246,   565,   566,   264,
     265,   475,   266,   467,    74,   586,    75,   609,   595,   419,
      76,    77,   854,   382,   384,   385,    78,    79,   572,   765,
     252,    81,    82,   267,    83,    84,    85,   494,    86,   219,
     402,   403,   203,   204,   205,   673,   624,   207,    88,   373,
      89,   221,   272,   591,   625,   821,   455,   456,   234,   235,
     223,   441,   629,   579,   580,    90,   380,   271,   481,   834,
     645,   847,   845,   660,   254,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   334,   337,   757,   915,   837,
     981,   982,   755,   255,   638,   830,   983,   984,   394,   714,
     715,   716,   717,   515,  1190,  1134,  1135,  1037,   922,   923,
     877,  1111,  1112,   103,   292,   723,   516,   882,  1015,  1014,
     338,   574,   104,   105,   335,   570,   573,   763,   764,   766,
     767,   992,   838,  1216,   835,   987,  1208,  1254,  1094,  1095,
    1057,   792,   793,   965,   966,   794,   954,   944,   947,   948,
     949,   950,   951,  1148,   952,  1064,  1065,  1066,  1067,  1068,
    1069,  1070,   795,   796,   797,   798,   799,   758,   911,  1030,
     917,   106,   107,   108,   109,   110,   111,   112,   546,   741,
     113,   548,   114,   115,   547,   549,   297,   300,   301,   540,
     739,   738,   896,  1026,  1120,  1182,   900,   116,   117,   298,
     118,   119,   120,   226,   227,   123,   228,   229,   656,   846,
     323,   324,   325,   326,   884,   726,   518,   458,   519,   520,
     894,   522,   523,   524,   525,  1042,  1043,   526,   527,   528,
     529,   530,  1044,  1045,   531,   532,   533,   534,   535,   721,
     422,   661,   277,   459,   231,   126,   697,   627,   664,   659,
     426,   312,   451,   452,   816,   956,   486,   639,   389,   269 ];

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
  #[allow(non_upper_case_globals)]
const yytable_: &'static [i32] = &[    122,   299,   122,   218,   218,   284,   237,   343,   379,   243,
     626,   296,   635,   449,   386,   206,   562,   427,   313,   986,
     208,   425,   685,   640,   628,   592,   488,   128,   127,   729,
     490,   988,   890,   284,    73,   206,    73,   654,   521,   388,
     208,   892,  1011,   268,   313,   329,   284,   284,   284,  1009,
     286,   122,   122,   420,   733,   290,   736,   791,   309,   667,
    -119,   685,   222,   232,   332,   885,   206,   678,   521,  1113,
     569,   809,   521,   706,  1038,   678,   626,   383,   635,  -115,
     387,   275,   279,   290,   285,     3,   270,   585,   330,   218,
     682,   238,   885,   314,   517,  -116,   396,   406,   406,   406,
     561,   718,   327,   327,   567,  1202,   698,   637,   206,   276,
     940,   941,   285,   224,   224,   829,   958,   730,   543,   545,
     880,   636,  1198,   287,   517,   285,   285,   285,   517,   743,
     381,   381,   886,   698,   381,   731,  1081,  1084,   330,  -123,
    1212,   307,   445,  -750,  -119,   709,  -121,   747,   423,   333,
     240,   287,   273,   962,   230,   230,   240,   437,   773,   886,
    1238,  -122,   476,  1154,   287,   287,   287,   320,   321,   536,
     637,   473,   585,   585,   245,  -118,  1240,   247,  1145,  -106,
     240,  1155,   744,  -735,   963,  -119,  -115,  -119,   331,  -120,
    1130,   887,   964,   274,   278,  -107,  -117,  -121,   893,   224,
     748,   668,   671,  1255,   493,   500,   478,  -644,  1198,   511,
     122,   313,   259,   889,   881,   913,  -116,  -123,   887,  1102,
     218,   914,   218,   218,   538,   539,   310,  1204,   311,  1113,
     284,   512,   310,  -106,   311,   237,   332,  -115,   331,  -114,
     230,   581,   449,   122,  -110,   122,  -112,  -122,   236,   946,
     442,  1146,   268,   329,  -118,  -735,   442,  -736,   958,   521,
     122,  -113,   460,   432,  -120,   685,   434,   435,   436,  -117,
     240,   127,   495,  -644,  1172,  -109,   461,    73,   463,   450,
     290,   453,   698,  -524,  1009,  -636,   479,  1075,  1076,  -111,
     284,   719,   698,   850,   841,   310,  -108,   311,   553,   554,
     555,   556,   302,  -115,   851,   718,   873,  -635,  -750,   285,
     649,  -115,   122,  -115,  -636,   517,   678,   122,   678,  -645,
    -736,   240,  -121,   122,  -121,   892,   506,   122,   303,   644,
     224,   268,   224,   457,   313,   583,  -635,   552,  1211,   122,
     290,  -116,  -123,  -116,  -123,   507,    73,   536,   287,  -116,
     932,   557,   381,   381,   381,   381,   263,   558,   559,  -637,
     447,   885,  1214,   634,   742,   218,   742,  1215,   642,   285,
     914,   230,  -122,   230,  -122,   304,   510,   511,   122,  -118,
     833,  -118,   122,   866,   122,   474,   633,  1046,  -637,  -120,
    -123,  -120,   577,  1020,  -117,  -638,  -117,   590,   346,   512,
    -645,   852,   538,   539,   460,   536,  1053,   958,   287,  1017,
    1019,   626,   576,   635,  1022,  -122,  1024,   587,  1025,   493,
     902,   943,   381,   346,  -638,   937,  -107,   946,   946,   634,
    -116,   218,  1167,   633,   305,  1252,   578,   651,   910,  1071,
     484,   578,  1196,  -109,   678,   284,   907,   375,   693,  1096,
    1071,  1071,   633,   536,  1058,   485,   869,   634,   541,   336,
     538,   539,   860,   674,   369,   370,   371,   718,   563,   718,
     460,   521,  1071,   885,   206,   376,   424,   122,   521,   208,
     633,   430,  1117,   442,   634,   442,   218,   367,   368,   369,
     370,   371,   675,   677,   339,   290,   239,   430,   521,  1062,
     240,   276,   587,   587,   493,   694,   474,   633,   538,   539,
     780,  -123,   344,   487,   760,   263,  -640,   340,   507,   585,
      91,  -109,    91,  -114,   285,   460,   905,  -123,   485,  1153,
     284,  -639,  -113,  1173,   225,   225,  -122,   677,  1129,    60,
     276,   722,   241,  -109,   244,  -640,  1139,  -109,   240,   510,
     471,   429,   722,  1063,   585,   585,  -641,   864,  -109,   903,
    -639,   585,   585,   287,   903,   263,  1149,   431,   844,   536,
     544,    91,    91,   885,   818,   288,  -630,   727,   679,  -110,
     290,   685,   239,   968,   970,  -641,   225,  -118,   998,   831,
     975,   977,   759,   808,  -762,   433,   351,   352,  1077,  1192,
    -109,   322,  -354,   288,  -118,  -630,  1199,   808,  -111,   285,
     813,   225,   225,   972,   438,   225,   393,   404,   404,   820,
     225,   979,   704,   889,   538,   539,   439,   870,   769,   946,
    -354,  -354,  1103,   634,   678,   218,   122,  1071,   122,  1177,
    1179,  1180,  1181,   634,   263,   218,   364,   365,   287,  -633,
     860,   820,  1149,   284,   857,   442,   633,  -110,   122,   652,
    -101,   823,  -354,   653,   -87,   536,   633,  1039,  1050,   652,
    1127,   662,   440,   942,   460,  1082,  1085,   446,  -633,  -110,
     206,   813,   820,  -110,   460,   208,  -111,   641,  1041,   643,
    -735,   448,  1249,   823,  -110,   814,   493,  1098,   853,  1232,
     663,   718,   718,   290,   822,   442,   863,  1149,  -111,  1241,
    -317,  -750,  -111,  -108,   240,   320,   321,   585,   537,   375,
     538,   539,   284,  -111,   823,   233,   819,   858,   865,   859,
      91,  1163,   285,   871,  1164,   346,   856,  1105,  -317,  -317,
     236,  1245,   677,   477,   276,  1241,  1088,   376,   377,   -86,
    1149,   225,  -111,   225,   225,  1114,  -120,   225,  -120,   225,
     375,   483,   521,    91,   634,    91,   218,  1003,   974,   122,
    -317,   287,   290,   122,  1005,  1083,  1086,   883,  -736,   378,
      91,   808,   808,   912,   918,   808,   375,   633,   376,   443,
     924,  -108,   996,   924,  -108,   491,   375,  1099,  -117,  1035,
     288,   285,   492,   931,  -117,   460,   420,   933,   960,   961,
     909,   953,   489,  -108,   376,   472,   536,  -108,   322,   698,
     444,   497,   818,   930,   376,   498,   550,   867,  -108,   997,
     564,  1222,    91,   225,   225,   225,   225,    91,   225,   225,
     287,  -651,   122,    91,   568,   122,   444,    91,  -642,   587,
     819,   985,  -118,   985,   578,   584,   499,   225,   974,    91,
     288,   206,   593,   571,   310,   994,   311,  1165,  1166,   541,
     677,   538,   539,   551,  1204,   999,  -642,  -642,   891,  1039,
    -120,   895,   650,   381,   587,   587,  1039,   879,  -117,   646,
     991,   587,   587,   442,  -643,   879,   225,   914,    91,   836,
    1041,   464,    91,   225,    91,  1041,  -308,  1041,  -642,  1041,
     655,   465,   466,   122,   122,   687,   722,   689,   225,   691,
     122,   375,  -643,  -643,   695,   122,   696,   501,  -732,   502,
     503,   504,   505,  -101,  -308,  -308,   468,  1031,   980,   914,
     705,   825,   808,   827,  1106,   720,   808,   593,   593,   376,
     647,   670,   672,   724,  -643,   867,   725,   808,   808,   808,
     728,  1052,   225,   808,   808,  1091,  -308,   732,   670,   672,
    -630,  1055,  1039,   734,  1059,   735,   712,   284,   737,   122,
     752,   648,  1051,   754,  -733,   808,   225,  1078,   756,   284,
     496,   496,  -290,  1041,   122,  1041,   699,    91,  -630,  -630,
    1041,   770,  1041,   771,  1150,   501,   375,   502,   503,   504,
     505,  1035,   122,   122,   774,   288,   775,   225,  1035,   381,
    1035,  1156,   536,   776,  1041,   817,  -633,  1125,  -732,   826,
    -630,    80,  -739,    80,   376,   657,   833,   836,  -732,   406,
    1186,   874,   876,  1101,   904,    80,    80,   587,   315,   316,
     317,   318,   319,   346,  -633,  -633,   285,   906,   808,   918,
     276,   722,   920,   921,  -291,   808,   658,  1040,   285,   722,
     359,   360,   959,   346,  -739,   541,   957,   538,   539,   958,
     284,   967,    80,    80,  -733,   973,  -633,   914,  1047,  1007,
     359,   360,  1012,  1013,  -733,   287,  1016,    80,   731,  1018,
     288,   122,  -739,  -739,  1035,  1029,  1035,   287,  1160,  1161,
    1162,  1035,  1049,  1035,  1054,  1021,  1023,   367,   368,   369,
     370,   371,    80,    80,  -318,   122,    80,   363,  -292,  1060,
     406,    80,  -739,   810,  -739,  1035,  1072,   367,   368,   369,
     370,   371,  -735,   815,   808,   781,  1061,   995,  1209,  1210,
    1108,  1109,  -318,  -318,   375,  1169,    91,   913,    91,   285,
     375,   122,  1116,  1131,  1118,   808,   225,  1132,  1133,  1119,
     634,   790,   218,  1141,  1143,   536,   225,  1138,    91,   225,
     122,  1176,   376,   778,  -318,   790,  1140,   375,   376,  1184,
     346,  1142,  -293,   633,  1147,  1152,   985,   815,   287,   808,
    1178,   808,   381,   381,  1188,  1183,   122,   359,   360,  1193,
    1201,   460,  1203,   759,   779,   376,  1194,  1246,  1032,  1033,
    1185,  1213,   722,   288,   815,  1048,  1226,   536,   542,  1228,
     538,   539,  1233,   985,   878,  1235,  1239,   808,  -735,  1244,
    1257,    80,   808,   362,   363,   470,  1247,   658,   366,    41,
      42,    43,    44,   462,   367,   368,   369,   370,   371,   536,
    -736,   700,    80,   702,    80,    80,  1002,   391,    80,   985,
      80,   408,   374,   855,    80,   916,    80,   872,  1242,  1010,
     740,   480,   538,   539,  1090,   482,  1197,  1036,  1200,    91,
     927,    80,   288,    91,   593,  1217,  1004,   225,   925,   768,
    1047,  1253,   815,   955,  1074,   879,  1097,  1047,  1073,  1047,
    1225,  1205,   745,  1206,   538,   539,  1128,   428,  1115,  1227,
    1229,   746,   421,   328,  1218,  1234,   888,  1236,  1237,   593,
     593,  1195,  1191,   969,   971,  1151,   593,   593,     0,     0,
     976,   978,     0,    80,    80,    80,    80,    80,    80,    80,
      80,     0,     0,     0,    80,     0,   815,     0,    80,   790,
     790,     0,    91,   790,   225,    91,   815,     0,    80,     0,
      80,     0,  1248,    80,  1250,     0,  1256,  1258,  1259,  1260,
       0,  1251,     0,   969,   971,     0,   976,   978,     0,  1262,
       0,     0,     0,  1047,   501,  1047,   502,   503,   504,   505,
    1047,     0,  1047,  1261,     0,     0,  1170,    80,     0,    80,
       0,     0,     0,    80,    80,    80,   897,   898,  1110,   899,
     502,   503,   504,   505,  1047,     0,    46,    47,     0,    80,
    1187,     0,     0,    91,    91,     0,   878,     0,     0,     0,
      91,     0,     0,   712,     0,    91,     0,     0,     0,   713,
       0,     0,   815,     0,     0,     0,     0,     0,    80,    80,
       0,     0,   815,     0,   686,   815,  1207,     0,     0,   688,
       0,     0,   690,    80,     0,   692,     0,     0,   815,     0,
       0,     0,     0,     0,     0,  1219,     0,     0,     0,     0,
     701,     0,   593,     0,     0,   703,  1089,    80,     0,    91,
     225,   501,     0,   502,   503,   504,   505,   506,    80,     0,
       0,  1243,     0,     0,    91,   102,     0,   102,     0,     0,
     790,     0,     0,     0,   790,     0,   507,  1089,    80,   102,
     102,     0,    91,    91,     0,   790,   790,   790,     0,     0,
       0,   790,   790,     0,     0,     0,     0,  1123,     0,     0,
     508,     0,   878,     0,     0,     0,   509,   510,   511,  1137,
       0,     0,     0,   790,     0,     0,   102,   102,   501,     0,
     502,   503,   504,   505,   506,   750,   751,     0,     0,   955,
     512,   102,   800,     0,   501,   513,   502,   503,   504,   505,
     506,     0,   514,   507,     0,   772,   800,     0,     0,   815,
     815,   815,     0,     0,     0,     0,   102,   102,     0,   507,
     102,     0,     0,     0,     0,   102,     0,   508,     0,     0,
       0,    91,     0,   560,   510,   511,  1174,     0,     0,     0,
       0,     0,     0,   508,     0,     0,   790,     0,     0,   509,
     510,   511,     0,   790,     0,    91,     0,   512,     0,   501,
    1189,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,     0,   512,     0,     0,     0,    80,     0,    80,
       0,   801,     0,     0,   507,   514,     0,    80,     0,     0,
       0,    91,     0,   225,   225,   801,     0,    80,     0,    80,
      80,     0,     0,     0,     0,     0,     0,     0,   508,     0,
      91,     0,     0,   225,   509,   510,   511,     0,   868,     0,
     501,     0,   502,   503,   504,   505,   506,     0,     0,     0,
       0,   762,   790,     0,     0,   102,    91,     0,   512,     0,
     875,     0,     0,     0,     0,   507,   802,   815,     0,   125,
     514,   125,     0,   790,     0,     0,   102,     0,   102,   102,
     802,     0,   102,     0,   102,     0,     0,     0,   102,   508,
     102,     0,     0,     0,     0,   509,   510,   511,     0,     0,
     800,   800,     0,     0,   800,   102,     0,   790,     0,   790,
       0,     0,     0,     0,     0,     0,     0,     0,   824,   512,
     125,   125,     0,   828,   291,   832,     0,     0,   240,     0,
      80,   514,     0,     0,    80,    80,     0,     0,    80,     0,
       0,     0,     0,     0,     0,   790,     0,     0,     0,     0,
     790,     0,   291,     0,     0,     0,     0,   102,   102,   102,
     102,   102,   102,   102,   102,   397,   407,   407,   102,     0,
      80,    80,   102,     0,     0,     0,     0,    80,    80,     0,
       0,     0,   102,     0,   102,     0,     0,   102,     0,   801,
     801,     0,     0,   801,     0,     0,     0,  1001,     0,     0,
       0,     0,     0,    80,     0,    80,    80,     0,     0,     0,
    1006,     0,     0,     0,     0,     0,  1008,     0,     0,     0,
       0,   102,     0,   102,     0,     0,     0,   102,   102,   102,
       0,     0,     0,     0,     0,   346,   347,   348,   349,   350,
     351,   352,   353,   102,   355,   356,     0,     0,   926,     0,
     928,  1027,   359,   360,   802,   802,     0,     0,   802,     0,
       0,   800,     0,     0,     0,   800,     0,     0,     0,     0,
       0,     0,   102,   102,    80,    80,   800,   800,   800,   125,
       0,    80,   800,   800,     0,     0,    80,   102,   362,   363,
     364,   365,     0,   366,     0,     0,     0,     0,     0,   367,
     368,   369,   370,   371,   800,     0,     0,     0,  1079,     0,
       0,   102,   125,     0,   125,     0,     0,   989,     0,     0,
     993,     0,   102,     0,     0,     0,     0,     0,     0,   125,
       0,     0,     0,    80,  1000,     0,     0,     0,     0,     0,
      80,    80,   102,     0,     0,     0,     0,   803,     0,   291,
     801,     0,     0,     0,   801,    80,     0,     0,     0,     0,
       0,   803,     0,     0,     0,   801,   801,   801,     0,     0,
       0,   801,   801,    80,    80,     0,     0,   800,     0,     0,
       0,   125,     0,     0,   800,     0,   125,     0,     0,     0,
       0,     0,   125,   801,     0,     0,   125,  1144,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   125,   291,
       0,   594,     0,     0,     0,   802,     0,     0,     0,   802,
       0,     0,     0,     0,     0,  1157,  1158,  1159,     0,     0,
     802,   802,   802,     0,     0,     0,   802,   802,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   125,     0,     0,
       0,   125,     0,   125,     0,     0,     0,     0,   802,     0,
       0,     0,    80,   800,     0,  1092,   801,     0,  1093,     0,
    1100,     0,     0,   801,     0,     0,     0,  1104,     0,     0,
    1107,   102,     0,   102,   800,     0,    80,     0,     0,     0,
       0,   102,     0,     0,     0,     0,   594,   594,     0,     0,
       0,   102,     0,   102,   102,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   800,     0,
     800,     0,    80,     0,    80,    80,     0,     0,     0,     0,
       0,   802,     0,     0,     0,   803,   803,     0,   802,   803,
       0,    80,     0,   121,    80,   121,   125,     0,     0,     0,
       0,     0,   801,     0,     0,     0,   800,     0,     0,     0,
       0,   800,     0,     0,   291,     0,     0,    80,     0,     0,
       0,     0,     0,   801,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1171,     0,     0,
       0,     0,     0,     0,   121,   121,  1175,     0,   289,     0,
       0,     0,     0,     0,     0,     0,     0,   801,     0,   801,
       0,     0,     0,     0,   102,     0,     0,   802,   102,   102,
       0,     0,   102,     0,     0,     0,   289,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   802,   395,
     405,   405,   405,     0,     0,   801,     0,     0,     0,   291,
     801,     0,     0,     0,   102,   102,     0,     0,     0,     0,
       0,   102,   102,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   802,     0,   802,     0,   346,  -763,  -763,  -763,
    -763,   351,   352,     0,     0,  -763,  -763,   102,     0,   102,
     102,     0,     0,   359,   360,     0,   803,     0,     0,     0,
     803,     0,     0,     0,     0,   125,     0,   125,     0,     0,
     802,   803,   803,   803,     0,   802,     0,   803,   803,     0,
       0,     0,     0,     0,     0,     0,     0,   125,     0,   362,
     363,   364,   365,    87,   366,    87,     0,     0,     0,   803,
     367,   368,   369,   370,   371,     0,     0,     0,   804,     0,
       0,     0,     0,   121,     0,     0,     0,     0,   102,   102,
       0,     0,   804,     0,     0,   102,     0,     0,     0,     0,
     102,     0,   291,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    87,    87,   121,     0,   121,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   121,     0,     0,   901,     0,     0,     0,
       0,     0,   803,     0,     0,     0,     0,   102,     0,   803,
       0,     0,     0,   289,   102,   102,     0,     0,     0,   392,
       0,     0,     0,     0,     0,     0,     0,     0,   125,   102,
       0,   291,   125,   594,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   121,     0,   102,   102,     0,
     121,   124,     0,   124,     0,     0,   121,     0,     0,     0,
     121,     0,     0,     0,     0,     0,     0,     0,   594,   594,
       0,     0,   121,   289,     0,   594,   594,     0,     0,     0,
       0,     0,     0,     0,     0,   805,     0,     0,   803,     0,
       0,     0,     0,   806,     0,     0,     0,     0,     0,   805,
       0,   125,   124,   124,   125,     0,     0,   806,     0,   803,
       0,   121,     0,     0,     0,   121,     0,   121,     0,     0,
       0,     0,     0,     0,     0,     0,   804,   804,     0,     0,
     804,     0,     0,    87,     0,     0,   102,     0,     0,     0,
       0,     0,     0,   803,     0,   803,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     102,     0,     0,     0,     0,     0,    87,     0,    87,     0,
       0,     0,   125,   125,     0,     0,     0,     0,     0,   125,
       0,   803,     0,    87,   125,     0,   803,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   102,     0,   102,   102,
       0,     0,   346,   347,   348,   349,   350,   351,   352,     0,
     121,   355,   356,     0,     0,   102,     0,     0,   102,   359,
     360,     0,     0,     0,     0,     0,     0,     0,   289,     0,
       0,   594,     0,     0,     0,    87,     0,     0,   125,     0,
      87,   102,     0,     0,     0,     0,    87,     0,     0,     0,
      87,     0,     0,   125,     0,   362,   363,   364,   365,     0,
     366,   124,    87,     0,     0,   588,   367,   368,   369,   370,
     371,   125,   125,   805,   805,     0,     0,   805,     0,     0,
       0,   806,   806,     0,     0,   806,  1126,   804,     0,     0,
       0,   804,     0,     0,   124,     0,   124,     0,   407,     0,
       0,    87,   804,   804,   804,    87,     0,    87,   804,   804,
       0,   124,     0,   289,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     804,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     588,   588,     0,     0,     0,     0,     0,     0,     0,     0,
     125,     0,     0,   124,     0,     0,     0,     0,   124,   121,
       0,   121,     0,     0,   124,     0,     0,     0,   124,     0,
       0,     0,     0,     0,   125,     0,     0,     0,     0,   407,
     124,   121,     0,   124,     0,     0,     0,     0,     0,     0,
      87,     0,     0,   804,     0,     0,     0,     0,     0,   807,
     804,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     125,     0,     0,   807,     0,     0,     0,     0,     0,   124,
       0,     0,     0,   124,   805,   124,   289,     0,   805,   125,
       0,     0,   806,     0,     0,     0,   806,     0,     0,   805,
     805,   805,     0,     0,     0,   805,   805,   806,   806,   806,
       0,     0,     0,   806,   806,   125,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   805,   124,   124,
       0,     0,     0,     0,     0,   806,     0,     0,     0,   804,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -762,
       0,     0,   121,     0,     0,   289,   121,  -762,  -762,  -762,
     804,     0,  -762,  -762,  -762,     0,  -762,     0,     0,     0,
       0,     0,     0,     0,  -762,  -762,  -762,     0,   124,     0,
       0,     0,     0,     0,     0,     0,  -762,  -762,     0,  -762,
    -762,  -762,  -762,  -762,   804,     0,   804,     0,     0,     0,
     805,     0,     0,     0,   345,     0,     0,   805,   806,    87,
       0,    87,     0,     0,     0,   806,     0,  -762,     0,     0,
       0,     0,     0,     0,     0,   121,     0,     0,   121,     0,
       0,    87,   804,     0,     0,     0,     0,   804,     0,     0,
       0,     0,     0,     0,     0,  -762,  -762,   807,   807,     0,
       0,   807,  -762,     0,     0,     0,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,  -762,
       0,     0,     0,   359,   360,  -762,  -762,     0,     0,   361,
       0,     0,     0,     0,     0,   236,   805,  -762,     0,  -762,
       0,     0,     0,     0,   806,     0,   121,   121,     0,     0,
       0,     0,     0,   121,     0,     0,     0,   805,   121,   362,
     363,   364,   365,     0,   366,   806,     0,     0,     0,     0,
     367,   368,   369,   370,   371,     0,     0,     0,   372,     0,
       0,     0,     0,     0,     0,     0,     0,   124,     0,   124,
       0,   805,    87,   805,     0,     0,    87,   588,     0,   806,
       0,   806,     0,     0,     0,     0,     0,     0,     0,   124,
       0,     0,   121,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   121,     0,   805,
       0,     0,   588,   588,   805,     0,     0,   806,     0,   588,
     588,     0,   806,     0,     0,   121,   121,     0,     0,     0,
       0,     0,     0,     0,     0,   220,   220,     0,   807,     0,
    1124,     0,   807,     0,     0,    87,     0,     0,    87,     0,
       0,     0,   405,   807,   807,   807,     0,     0,     0,   807,
     807,     0,     0,     0,     0,     0,     0,   253,   256,   257,
     258,     0,     0,     0,   220,   220,     0,     0,     0,     0,
       0,   807,     0,     0,     0,     0,   306,   308,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     124,     0,     0,     0,   124,   124,     0,     0,     0,     0,
       0,     0,     0,     0,   121,     0,    87,    87,     0,     0,
       0,   220,     0,    87,     0,     0,     0,     0,    87,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   121,     0,
     124,   124,     0,   405,     0,     0,     0,   124,   124,     0,
       0,     0,     0,     0,   807,     0,     0,     0,     0,     0,
       0,   807,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   124,   121,   588,   124,     0,     0,     0,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   121,     0,     0,     0,    87,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    87,    87,     0,     0,   121,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   220,
    1122,     0,   220,   220,   220,     0,   308,     0,     0,     0,
     807,     0,     0,     0,   124,   124,     0,     0,   777,     0,
       0,   124,   220,     0,   220,   220,   124,     0,     0,     0,
       0,   807,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,     0,   807,     0,   807,   359,   360,
       0,     0,     0,   124,    87,     0,     0,     0,     0,     0,
     124,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,     0,    87,  -263,
       0,     0,     0,   807,   362,   363,   364,   365,   807,   366,
       0,     0,     0,   124,   124,   367,   368,   369,   370,   371,
       0,     0,     0,   372,     0,     0,     0,     0,   220,     0,
       0,     0,     0,   589,    87,   596,   597,   598,   599,   600,
       0,     0,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   610,   611,    87,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,     0,     0,   220,    23,    24,
      25,    26,     0,     0,     0,     0,     0,     0,     0,    87,
       0,     0,     0,     0,    32,    33,    34,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,     0,
       0,     0,   124,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,     0,     0,   669,   669,
     359,   360,     0,     0,     0,     0,   124,   669,   220,   220,
       0,     0,     0,   220,     0,   669,   669,   220,     0,     0,
       0,     0,     0,   258,     0,    58,    59,    60,    61,    62,
      63,    64,    65,    66,     0,     0,   362,   363,   364,   365,
       0,   366,   124,   669,     0,     0,   240,   367,   368,   369,
     370,   371,     0,   220,     0,   372,   220,     0,     0,     0,
       0,   124,     0,     0,     0,     0,   283,     0,   220,     0,
       0,  -739,     0,     0,     0,     0,     0,     0,     0,  -739,
    -739,  -739,     0,     0,  -739,  -739,  -739,   124,  -739,     0,
       0,     0,     0,   220,     0,     0,  -739,  -739,  -739,  -739,
    -739,     0,     0,     0,     0,     0,     0,     0,  -739,  -739,
       0,  -739,  -739,  -739,  -739,  -739,     0,     0,     0,   749,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   753,     0,     0,     0,   761,     0,  -739,
       0,     0,     0,     0,   220,     0,     0,     0,  -739,  -739,
    -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,
    -739,     0,     0,     0,     0,  -739,  -739,  -739,  -739,     0,
     861,  -739,     0,     0,  -739,     0,     0,  -739,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -739,     0,     0,  -739,     0,  -739,  -739,  -739,  -739,
    -119,  -739,  -739,  -739,  -739,     0,  -739,     0,  -739,  -739,
       0,  -739,  -739,  -739,  -739,  -739,  -739,   220,     0,     0,
    -739,  -739,     0,     0,  -630,     0,     0,   220,     0,     0,
       0,     0,  -630,  -630,  -630,     0,     0,  -630,  -630,  -630,
       0,  -630,     0,   220,     0,   220,     0,     0,     0,  -630,
       0,  -630,  -630,  -630,     0,     0,     0,     0,   220,     0,
     220,  -630,  -630,     0,  -630,  -630,  -630,  -630,  -630,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -630,   220,     0,     0,     0,     0,     0,     0,
       0,  -630,  -630,  -630,  -630,  -630,  -630,  -630,  -630,  -630,
    -630,  -630,  -630,  -630,     0,     0,     0,     0,  -630,  -630,
    -630,  -630,     0,  -630,  -630,     0,   220,  -630,     0,     0,
    -630,     0,     0,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,     0,  -630,   669,   934,  -630,   220,  -630,
       0,  -630,  -630,  -630,  -630,  -630,  -630,  -630,     0,  -630,
       0,  -630,  -630,     0,  -630,  -630,  -630,  -630,  -630,  -630,
       0,     0,     0,  -630,  -630,     0,     0,     0,     0,     0,
     669,   669,     0,     0,  -452,     0,   220,   669,   669,     0,
       0,     0,  -452,  -452,  -452,     0,     0,  -452,  -452,  -452,
       0,  -452,     0,     0,     0,     0,   220,     0,     0,  -452,
    -452,  -452,  -452,     0,     0,     0,     0,     0,     0,     0,
       0,  -452,  -452,     0,  -452,  -452,  -452,  -452,  -452,     0,
     669,   669,     0,   669,   669,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -452,     0,     0,     0,     0,     0,     0,     0,
       0,  -452,  -452,  -452,  -452,  -452,  -452,  -452,  -452,  -452,
    -452,  -452,  -452,  -452,     0,     0,     0,  1028,  -452,  -452,
    -452,  -452,     0,     0,  -452,     0,     0,  -452,  1034,     0,
    -452,     0,     0,     0,     0,     0,     0,     0,   220,     0,
       0,     0,     0,     0,  -452,     0,     0,     0,     0,  -452,
    -452,  -452,  -452,     0,  -452,  -452,  -452,  -452,     0,  -452,
     236,  -452,  -452,     0,  -452,  -452,  -452,  -452,  -452,  -452,
       0,     0,     0,  -452,  -762,     4,  1087,     5,     6,     7,
       8,     9,     0,   669,     0,    10,    11,     0,     0,     0,
      12,     0,    13,    14,    15,    16,    17,    18,    19,   220,
       0,     0,     0,     0,    20,    21,    22,    23,    24,    25,
      26,     0,     0,    27,   669,     0,   220,     0,     0,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,     0,    41,    42,    43,    44,    45,    46,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,    51,     0,     0,     0,     0,
       0,     0,    52,     0,     0,    53,    54,     0,    55,    56,
       0,    57,     0,     0,    58,    59,    60,    61,    62,    63,
      64,    65,    66,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   220,  -762,     0,  -762,     0,     0,     0,     0,     0,
      67,    68,     0,     0,     0,    69,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   260,     0,     5,
       6,     7,     8,     9,  -762,  -762,  -762,    10,    11,     0,
       0,  -762,    12,     0,    13,    14,    15,    16,    17,    18,
      19,     0,     0,     0,     0,     0,    20,    21,    22,    23,
      24,    25,    26,     0,     0,    27,     0,   220,     0,     0,
       0,    28,    29,   261,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,   220,    41,    42,    43,    44,    45,
      46,    47,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    48,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    50,    51,     0,     0,
       0,     0,     0,     0,    52,     0,     0,    53,    54,     0,
      55,    56,     0,    57,     0,     0,    58,    59,    60,    61,
      62,    63,    64,    65,    66,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -762,   260,  -762,     5,     6,     7,
       8,     9,    67,    68,  -762,    10,    11,    69,  -762,  -762,
      12,     0,    13,    14,    15,    16,    17,    18,    19,     0,
       0,     0,     0,     0,    20,    21,    22,    23,    24,    25,
      26,     0,     0,    27,     0,     0,     0,     0,     0,    28,
      29,   261,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,     0,    41,    42,    43,    44,    45,    46,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,    51,     0,     0,     0,     0,
       0,     0,    52,     0,     0,    53,    54,     0,    55,    56,
       0,    57,     0,     0,    58,    59,    60,    61,    62,    63,
      64,    65,    66,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -762,   260,  -762,     5,     6,     7,     8,     9,
      67,    68,  -762,    10,    11,    69,     0,  -762,    12,  -762,
      13,    14,    15,    16,    17,    18,    19,     0,     0,     0,
       0,     0,    20,    21,    22,    23,    24,    25,    26,     0,
       0,    27,     0,     0,     0,     0,     0,    28,    29,   261,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
       0,    41,    42,    43,    44,    45,    46,    47,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    48,    49,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,    51,     0,     0,     0,     0,     0,     0,
      52,     0,     0,    53,    54,     0,    55,    56,     0,    57,
       0,     0,    58,    59,    60,    61,    62,    63,    64,    65,
      66,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -762,   260,  -762,     5,     6,     7,     8,     9,    67,    68,
    -762,    10,    11,    69,     0,  -762,    12,     0,    13,    14,
      15,    16,    17,    18,    19,  -762,     0,     0,     0,     0,
      20,    21,    22,    23,    24,    25,    26,     0,     0,    27,
       0,     0,     0,     0,     0,    28,    29,   261,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,     0,    41,
      42,    43,    44,    45,    46,    47,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    48,    49,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,    51,     0,     0,     0,     0,     0,     0,    52,     0,
       0,    53,    54,     0,    55,    56,     0,    57,     0,     0,
      58,    59,    60,    61,    62,    63,    64,    65,    66,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -762,   260,
    -762,     5,     6,     7,     8,     9,    67,    68,  -762,    10,
      11,    69,     0,  -762,    12,     0,    13,    14,    15,    16,
      17,    18,    19,     0,     0,     0,     0,     0,    20,    21,
      22,    23,    24,    25,    26,     0,     0,    27,     0,     0,
       0,     0,     0,    28,    29,   261,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,     0,    41,    42,    43,
      44,    45,    46,    47,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    48,    49,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    50,    51,
       0,     0,     0,     0,     0,     0,    52,     0,     0,    53,
      54,     0,    55,    56,     0,    57,     0,     0,    58,    59,
      60,    61,    62,    63,    64,    65,    66,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -762,     0,  -762,     0,
       0,     0,     0,     0,    67,    68,     0,     0,   260,    69,
       5,     6,     7,     8,     9,     0,  -762,  -762,    10,    11,
       0,     0,     0,    12,     0,    13,    14,    15,    16,    17,
      18,    19,     0,     0,     0,     0,     0,    20,    21,    22,
      23,    24,    25,    26,     0,     0,    27,     0,     0,     0,
       0,     0,    28,    29,   261,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,     0,    41,    42,    43,    44,
      45,    46,    47,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    48,    49,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    50,    51,     0,
       0,     0,     0,     0,     0,    52,     0,     0,    53,    54,
       0,    55,    56,     0,    57,     0,     0,    58,    59,    60,
      61,    62,    63,    64,    65,    66,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -762,   260,  -762,     5,     6,
       7,     8,     9,    67,    68,     0,    10,    11,    69,     0,
       0,    12,     0,    13,    14,    15,    16,    17,    18,    19,
       0,     0,     0,     0,     0,    20,    21,    22,    23,    24,
      25,    26,     0,     0,    27,     0,     0,     0,     0,     0,
      28,    29,   261,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,     0,    41,    42,    43,    44,    45,    46,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      48,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    50,    51,     0,     0,     0,
       0,     0,     0,    52,     0,     0,   262,    54,  -762,    55,
      56,     0,    57,     0,     0,    58,    59,    60,    61,    62,
      63,    64,    65,    66,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -762,   260,  -762,     5,     6,     7,     8,
       9,    67,    68,     0,    10,    11,    69,     0,     0,    12,
       0,    13,    14,    15,    16,    17,    18,    19,     0,     0,
       0,     0,     0,    20,    21,    22,    23,    24,    25,    26,
       0,     0,    27,     0,     0,     0,     0,     0,    28,    29,
     261,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,     0,    41,    42,    43,    44,    45,    46,    47,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    48,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,    51,     0,     0,     0,     0,     0,
       0,    52,     0,     0,    53,    54,  -762,    55,    56,     0,
      57,     0,     0,    58,    59,    60,    61,    62,    63,    64,
      65,    66,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -762,     4,  -762,     5,     6,     7,     8,     9,    67,
      68,     0,    10,    11,    69,     0,     0,    12,     0,    13,
      14,    15,    16,    17,    18,    19,     0,     0,     0,     0,
       0,    20,    21,    22,    23,    24,    25,    26,     0,     0,
      27,     0,     0,     0,     0,     0,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,     0,
      41,    42,    43,    44,    45,    46,    47,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    48,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,    51,     0,     0,     0,     0,     0,     0,    52,
       0,     0,    53,    54,     0,    55,    56,     0,    57,     0,
       0,    58,    59,    60,    61,    62,    63,    64,    65,    66,
       0,     0,     0,     0,     0,     0,     0,     0,  -762,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -762,
     260,  -762,     5,     6,     7,     8,     9,    67,    68,     0,
      10,    11,    69,     0,     0,    12,     0,    13,    14,    15,
      16,    17,    18,    19,     0,     0,     0,     0,     0,    20,
      21,    22,    23,    24,    25,    26,     0,     0,    27,     0,
       0,     0,     0,     0,    28,    29,   261,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,     0,    41,    42,
      43,    44,    45,    46,    47,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    48,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    50,
      51,     0,     0,     0,     0,     0,     0,    52,     0,     0,
      53,    54,     0,    55,    56,     0,    57,     0,     0,    58,
      59,    60,    61,    62,    63,    64,    65,    66,     0,     0,
       0,     0,     0,     0,     0,     0,  -762,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -762,   260,  -762,
       5,     6,     7,     8,     9,    67,    68,  -762,    10,    11,
      69,     0,     0,    12,     0,    13,    14,    15,    16,    17,
      18,    19,     0,     0,     0,     0,     0,    20,    21,    22,
      23,    24,    25,    26,     0,     0,    27,     0,     0,     0,
       0,     0,    28,    29,   261,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,     0,    41,    42,    43,    44,
      45,    46,    47,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    48,    49,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    50,    51,     0,
       0,     0,     0,     0,     0,    52,     0,     0,    53,    54,
       0,    55,    56,     0,    57,     0,     0,    58,    59,    60,
      61,    62,    63,    64,    65,    66,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -762,   260,  -762,     5,     6,
       7,     8,     9,    67,    68,     0,    10,    11,    69,     0,
       0,    12,     0,    13,    14,    15,    16,    17,    18,    19,
       0,     0,     0,     0,     0,    20,    21,    22,    23,    24,
      25,    26,     0,     0,    27,     0,     0,     0,     0,     0,
      28,    29,   261,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,     0,    41,    42,    43,    44,    45,    46,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      48,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    50,    51,     0,     0,     0,
       0,     0,     0,    52,     0,     0,    53,    54,     0,    55,
      56,     0,    57,     0,     0,    58,    59,    60,    61,    62,
      63,    64,    65,    66,     0,  -762,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -633,     0,     0,  -762,     0,  -762,     0,     0,  -633,  -633,
    -633,    67,    68,  -633,  -633,  -633,    69,  -633,     0,     0,
       0,     0,     0,     0,     0,  -633,     0,  -633,  -633,  -633,
       0,     0,     0,     0,     0,     0,     0,  -633,  -633,     0,
    -633,  -633,  -633,  -633,  -633,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -633,     0,
       0,     0,     0,     0,     0,     0,     0,  -633,  -633,  -633,
    -633,  -633,  -633,  -633,  -633,  -633,  -633,  -633,  -633,  -633,
       0,     0,     0,     0,  -633,  -633,  -633,  -633,     0,  -633,
    -633,     0,     0,  -633,     0,     0,  -633,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -633,     0,     0,  -633,     0,  -633,     0,  -633,  -633,  -633,
    -633,  -633,  -633,  -633,     0,  -633,     0,  -633,  -633,     0,
    -633,  -633,  -633,  -633,  -633,  -633,  -740,     0,     0,  -633,
    -633,     0,     0,     0,  -740,  -740,  -740,     0,     0,  -740,
    -740,  -740,     0,  -740,     0,     0,     0,     0,     0,     0,
       0,  -740,  -740,  -740,  -740,  -740,     0,     0,     0,     0,
       0,     0,     0,  -740,  -740,     0,  -740,  -740,  -740,  -740,
    -740,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -740,     0,     0,     0,     0,     0,
       0,     0,     0,  -740,  -740,  -740,  -740,  -740,  -740,  -740,
    -740,  -740,  -740,  -740,  -740,  -740,     0,     0,     0,     0,
    -740,  -740,  -740,  -740,     0,     0,  -740,     0,     0,  -740,
       0,     0,  -740,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -740,     0,     0,  -740,
       0,  -740,  -740,  -740,  -740,     0,  -740,  -740,  -740,  -740,
       0,  -740,     0,  -740,  -740,     0,  -740,  -740,  -740,  -740,
    -740,  -740,  -741,     0,     0,  -740,  -740,     0,     0,     0,
    -741,  -741,  -741,     0,     0,  -741,  -741,  -741,     0,  -741,
       0,     0,     0,     0,     0,     0,     0,  -741,  -741,  -741,
    -741,  -741,     0,     0,     0,     0,     0,     0,     0,  -741,
    -741,     0,  -741,  -741,  -741,  -741,  -741,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -741,     0,     0,     0,     0,     0,     0,     0,     0,  -741,
    -741,  -741,  -741,  -741,  -741,  -741,  -741,  -741,  -741,  -741,
    -741,  -741,     0,     0,     0,     0,  -741,  -741,  -741,  -741,
       0,     0,  -741,     0,     0,  -741,     0,     0,  -741,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -741,     0,     0,  -741,     0,  -741,  -741,  -741,
    -741,     0,  -741,  -741,  -741,  -741,     0,  -741,     0,  -741,
    -741,     0,  -741,  -741,  -741,  -741,  -741,  -741,  -317,     0,
       0,  -741,  -741,     0,     0,     0,  -317,  -317,  -317,     0,
       0,  -317,  -317,  -317,     0,  -317,     0,     0,     0,     0,
       0,     0,     0,  -317,     0,  -317,  -317,  -317,     0,     0,
       0,     0,     0,     0,     0,  -317,  -317,     0,  -317,  -317,
    -317,  -317,  -317,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -317,     0,     0,     0,
       0,     0,     0,     0,     0,  -317,  -317,  -317,  -317,  -317,
    -317,  -317,  -317,  -317,  -317,  -317,  -317,  -317,     0,     0,
       0,     0,  -317,  -317,  -317,  -317,     0,   862,  -317,     0,
       0,  -317,     0,     0,  -317,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -317,     0,
       0,  -317,     0,  -317,     0,  -317,  -317,  -121,  -317,  -317,
    -317,  -317,     0,  -317,     0,  -317,  -317,     0,  -317,  -317,
    -317,  -317,  -317,  -317,  -309,     0,     0,  -317,  -317,     0,
       0,     0,  -309,  -309,  -309,     0,     0,  -309,  -309,  -309,
       0,  -309,     0,     0,     0,     0,     0,     0,     0,  -309,
       0,  -309,  -309,  -309,     0,     0,     0,     0,     0,     0,
       0,  -309,  -309,     0,  -309,  -309,  -309,  -309,  -309,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -309,     0,     0,     0,     0,     0,     0,     0,
       0,  -309,  -309,  -309,  -309,  -309,  -309,  -309,  -309,  -309,
    -309,  -309,  -309,  -309,     0,     0,     0,     0,  -309,  -309,
    -309,  -309,     0,     0,  -309,     0,     0,  -309,     0,     0,
    -309,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -309,     0,     0,  -309,     0,  -309,
       0,  -309,  -309,     0,  -309,  -309,  -309,  -309,     0,  -309,
       0,  -309,  -309,     0,  -309,  -309,  -309,  -309,  -309,  -309,
    -762,     0,     0,  -309,  -309,     0,     0,     0,  -762,  -762,
    -762,     0,     0,  -762,  -762,  -762,     0,  -762,     0,     0,
       0,     0,     0,     0,     0,  -762,  -762,  -762,  -762,     0,
       0,     0,     0,     0,     0,     0,     0,  -762,  -762,     0,
    -762,  -762,  -762,  -762,  -762,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -762,     0,
       0,     0,     0,     0,     0,     0,     0,  -762,  -762,  -762,
    -762,  -762,  -762,  -762,  -762,  -762,  -762,  -762,  -762,  -762,
       0,     0,     0,     0,  -762,  -762,  -762,  -762,     0,     0,
    -762,     0,     0,  -762,     0,     0,  -762,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -762,     0,     0,     0,     0,  -762,  -762,  -762,  -762,     0,
    -762,  -762,  -762,  -762,     0,  -762,   236,  -762,  -762,     0,
    -762,  -762,  -762,  -762,  -762,  -762,  -324,     0,     0,  -762,
       0,     0,     0,     0,  -324,  -324,  -324,     0,     0,  -324,
    -324,  -324,     0,  -324,     0,     0,     0,     0,     0,     0,
       0,  -324,     0,  -324,  -324,     0,     0,     0,     0,     0,
       0,     0,     0,  -324,  -324,     0,  -324,  -324,  -324,  -324,
    -324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -324,     0,     0,     0,     0,     0,
       0,     0,     0,  -324,  -324,  -324,  -324,  -324,  -324,  -324,
    -324,  -324,  -324,  -324,  -324,  -324,     0,     0,     0,     0,
    -324,  -324,  -324,  -324,     0,     0,  -324,     0,     0,  -324,
       0,     0,  -324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -324,     0,     0,     0,
       0,  -324,     0,  -324,  -324,     0,  -324,  -324,  -324,  -324,
       0,  -324,   233,  -324,  -324,     0,  -324,  -324,  -324,  -324,
    -324,  -324,  -739,     0,     0,  -324,     0,     0,     0,     0,
    -739,  -739,  -739,     0,     0,     0,  -739,  -739,     0,  -739,
       0,     0,     0,     0,     0,     0,     0,  -739,  -739,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -739,
    -739,     0,  -739,  -739,  -739,  -739,  -739,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -739,     0,     0,     0,     0,     0,     0,     0,     0,  -739,
    -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,
    -739,  -739,     0,     0,     0,     0,  -739,  -739,  -739,  -739,
       0,   811,  -739,     0,     0,  -739,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -739,     0,     0,     0,     0,  -110,  -739,  -739,
    -739,  -119,  -739,  -739,  -739,  -739,     0,  -739,     0,     0,
    -739,     0,  -739,  -739,  -739,  -739,  -739,  -739,  -739,     0,
       0,  -739,     0,     0,     0,     0,  -739,  -739,  -739,     0,
       0,     0,  -739,  -739,     0,  -739,     0,     0,     0,     0,
       0,     0,     0,  -739,  -739,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -739,  -739,     0,  -739,  -739,
    -739,  -739,  -739,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -739,     0,     0,     0,
       0,     0,     0,     0,     0,  -739,  -739,  -739,  -739,  -739,
    -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,     0,     0,
       0,     0,  -739,  -739,  -739,  -739,     0,   811,  -739,     0,
       0,  -739,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -739,     0,
       0,     0,     0,  -739,  -739,  -739,  -739,  -119,  -739,  -739,
    -739,  -739,     0,  -739,     0,     0,  -739,     0,  -739,  -739,
    -739,  -739,  -739,  -739,  -317,     0,     0,  -739,     0,     0,
       0,     0,  -317,  -317,  -317,     0,     0,     0,  -317,  -317,
       0,  -317,     0,     0,     0,     0,     0,     0,     0,  -317,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -317,  -317,     0,  -317,  -317,  -317,  -317,  -317,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -317,     0,     0,     0,     0,     0,     0,     0,
       0,  -317,  -317,  -317,  -317,  -317,  -317,  -317,  -317,  -317,
    -317,  -317,  -317,  -317,     0,     0,     0,     0,  -317,  -317,
    -317,  -317,     0,   812,  -317,     0,     0,  -317,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -317,     0,     0,     0,     0,  -112,
       0,  -317,  -317,  -121,  -317,  -317,  -317,  -317,     0,  -317,
       0,     0,  -317,     0,  -317,  -317,  -317,  -317,  -317,  -317,
    -317,     0,     0,  -317,     0,     0,     0,     0,  -317,  -317,
    -317,     0,     0,     0,  -317,  -317,     0,  -317,     0,     0,
       0,     0,     0,     0,     0,  -317,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -317,  -317,     0,
    -317,  -317,  -317,  -317,  -317,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -317,     0,
       0,     0,     0,     0,     0,     0,     0,  -317,  -317,  -317,
    -317,  -317,  -317,  -317,  -317,  -317,  -317,  -317,  -317,  -317,
       0,     0,     0,     0,  -317,  -317,  -317,  -317,     0,   812,
    -317,     0,     0,  -317,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -317,     0,     0,     0,     0,  -317,     0,  -317,  -317,  -121,
    -317,  -317,  -317,  -317,     0,  -317,     0,     0,  -317,     0,
    -317,  -317,  -317,  -317,  -317,  -317,     0,     0,     0,  -317,
       5,     6,     7,     8,     9,     0,     0,     0,    10,    11,
       0,     0,     0,    12,     0,    13,    14,    15,    16,    17,
      18,    19,     0,     0,     0,     0,     0,    20,    21,    22,
      23,    24,    25,    26,     0,     0,    27,     0,     0,     0,
       0,     0,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,     0,    41,    42,    43,    44,
      45,    46,    47,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    48,    49,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    50,    51,     0,
       0,     0,     0,     0,     0,    52,     0,     0,    53,    54,
       0,    55,    56,     0,    57,     0,     0,    58,    59,    60,
      61,    62,    63,    64,    65,    66,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   551,     0,     5,     6,     7,
       8,     9,     0,    67,    68,    10,    11,     0,    69,     0,
      12,     0,    13,    14,    15,    16,    17,    18,    19,     0,
       0,     0,     0,     0,    20,    21,    22,    23,    24,    25,
      26,     0,     0,    27,     0,     0,     0,     0,     0,    28,
      29,   261,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,     0,    41,    42,    43,    44,    45,    46,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,    51,     0,     0,     0,     0,
       0,     0,    52,     0,     0,    53,    54,     0,    55,    56,
       0,    57,     0,     0,    58,    59,    60,    61,    62,    63,
      64,    65,    66,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   551,     0,     5,     6,     7,     8,     9,     0,
      67,    68,    10,    11,     0,    69,     0,    12,     0,    13,
      14,    15,    16,    17,    18,    19,     0,     0,     0,     0,
       0,    20,    21,    22,    23,    24,    25,    26,     0,     0,
      27,     0,     0,     0,     0,     0,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,     0,
      41,    42,    43,    44,    45,    46,    47,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    48,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,    51,     0,     0,     0,     0,     0,     0,    52,
       0,     0,    53,    54,     0,    55,    56,     0,    57,     0,
       0,    58,    59,    60,    61,    62,    63,    64,    65,    66,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     6,     7,     0,     9,     0,    67,    68,    10,
      11,     0,    69,     0,    12,     0,    13,    14,    15,    16,
      17,    18,    19,     0,     0,     0,     0,     0,    20,    21,
      22,    23,    24,    25,    26,     0,     0,   209,     0,     0,
       0,     0,     0,     0,    29,     0,     0,    32,    33,    34,
      35,    36,    37,    38,    39,    40,   210,    41,    42,    43,
      44,    45,    46,    47,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    48,    49,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    50,    51,
       0,     0,     0,     0,     0,     0,   211,     0,     0,   212,
      54,     0,    55,    56,     0,   213,   214,   215,    58,    59,
     216,    61,    62,    63,    64,    65,    66,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   240,     5,
       6,     7,     0,     9,    67,   217,     0,    10,    11,    69,
       0,     0,    12,     0,    13,    14,    15,    16,    17,    18,
      19,     0,     0,     0,     0,     0,    20,    21,    22,    23,
      24,    25,    26,     0,     0,   209,     0,     0,     0,     0,
       0,     0,    29,     0,     0,    32,    33,    34,    35,    36,
      37,    38,    39,    40,   210,    41,    42,    43,    44,    45,
      46,    47,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    48,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    50,    51,     0,     0,
       0,     0,     0,     0,   211,     0,     0,   212,    54,     0,
      55,    56,     0,   213,   214,   215,    58,    59,   216,    61,
      62,    63,    64,    65,    66,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     6,     7,     8,
       9,     0,    67,   217,    10,    11,     0,    69,     0,    12,
       0,    13,    14,    15,    16,    17,    18,    19,     0,     0,
       0,     0,     0,    20,    21,    22,    23,    24,    25,    26,
       0,     0,    27,     0,     0,     0,     0,     0,    28,    29,
       0,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,     0,    41,    42,    43,    44,    45,    46,    47,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    48,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,    51,     0,     0,     0,     0,     0,
       0,    52,     0,     0,    53,    54,     0,    55,    56,     0,
      57,     0,     0,    58,    59,    60,    61,    62,    63,    64,
      65,    66,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     6,     7,     0,     9,     0,    67,
      68,    10,    11,     0,    69,     0,    12,     0,    13,    14,
      15,    16,    17,    18,    19,     0,     0,     0,     0,     0,
      20,    21,    22,    23,    24,    25,    26,     0,     0,   209,
       0,     0,     0,     0,     0,     0,    29,     0,     0,    32,
      33,    34,    35,    36,    37,    38,    39,    40,   210,    41,
      42,    43,    44,    45,    46,    47,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    48,    49,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,   454,     0,     0,     0,     0,     0,     0,   211,     0,
       0,   212,    54,     0,    55,    56,     0,   213,   214,   215,
      58,    59,   216,    61,    62,    63,    64,    65,    66,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     6,     7,     0,     9,     0,    67,   217,    10,    11,
       0,    69,     0,    12,     0,    13,    14,    15,   248,   249,
      18,    19,     0,     0,     0,     0,     0,    20,   250,   251,
      23,    24,    25,    26,     0,     0,   209,     0,     0,     0,
       0,     0,     0,    29,     0,     0,    32,    33,    34,    35,
      36,    37,    38,    39,    40,   210,    41,    42,    43,    44,
      45,    46,    47,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    48,    49,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    50,    51,     0,
       0,     0,     0,     0,     0,   211,     0,     0,   212,    54,
       0,    55,    56,     0,   676,   214,   215,    58,    59,   216,
      61,    62,    63,    64,    65,    66,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     6,     7,
       0,     9,     0,    67,   217,    10,    11,     0,    69,     0,
      12,     0,    13,    14,    15,   248,   249,    18,    19,     0,
       0,     0,     0,     0,    20,   250,   251,    23,    24,    25,
      26,     0,     0,   209,     0,     0,     0,     0,     0,     0,
      29,     0,     0,    32,    33,    34,    35,    36,    37,    38,
      39,    40,   210,    41,    42,    43,    44,    45,    46,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,   454,     0,     0,     0,     0,
       0,     0,   211,     0,     0,   212,    54,     0,    55,    56,
       0,   676,   214,   215,    58,    59,   216,    61,    62,    63,
      64,    65,    66,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     6,     7,     0,     9,     0,
      67,   217,    10,    11,     0,    69,     0,    12,     0,    13,
      14,    15,   248,   249,    18,    19,     0,     0,     0,     0,
       0,    20,   250,   251,    23,    24,    25,    26,     0,     0,
     209,     0,     0,     0,     0,     0,     0,    29,     0,     0,
      32,    33,    34,    35,    36,    37,    38,    39,    40,   210,
      41,    42,    43,    44,    45,    46,    47,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    48,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,    51,     0,     0,     0,     0,     0,     0,   211,
       0,     0,   212,    54,     0,    55,    56,     0,   213,   214,
       0,    58,    59,   216,    61,    62,    63,    64,    65,    66,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     6,     7,     0,     9,     0,    67,   217,    10,
      11,     0,    69,     0,    12,     0,    13,    14,    15,   248,
     249,    18,    19,     0,     0,     0,     0,     0,    20,   250,
     251,    23,    24,    25,    26,     0,     0,   209,     0,     0,
       0,     0,     0,     0,    29,     0,     0,    32,    33,    34,
      35,    36,    37,    38,    39,    40,   210,    41,    42,    43,
      44,    45,    46,    47,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    48,    49,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    50,    51,
       0,     0,     0,     0,     0,     0,   211,     0,     0,   212,
      54,     0,    55,    56,     0,     0,   214,   215,    58,    59,
     216,    61,    62,    63,    64,    65,    66,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     6,
       7,     0,     9,     0,    67,   217,    10,    11,     0,    69,
       0,    12,     0,    13,    14,    15,   248,   249,    18,    19,
       0,     0,     0,     0,     0,    20,   250,   251,    23,    24,
      25,    26,     0,     0,   209,     0,     0,     0,     0,     0,
       0,    29,     0,     0,    32,    33,    34,    35,    36,    37,
      38,    39,    40,   210,    41,    42,    43,    44,    45,    46,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      48,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    50,    51,     0,     0,     0,
       0,     0,     0,   211,     0,     0,   212,    54,     0,    55,
      56,     0,   676,   214,     0,    58,    59,   216,    61,    62,
      63,    64,    65,    66,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     5,     6,     7,     0,     9,
       0,    67,   217,    10,    11,     0,    69,     0,    12,     0,
      13,    14,    15,   248,   249,    18,    19,     0,     0,     0,
       0,     0,    20,   250,   251,    23,    24,    25,    26,     0,
       0,   209,     0,     0,     0,     0,     0,     0,    29,     0,
       0,    32,    33,    34,    35,    36,    37,    38,    39,    40,
     210,    41,    42,    43,    44,    45,    46,    47,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    48,    49,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,    51,     0,     0,     0,     0,     0,     0,
     211,     0,     0,   212,    54,     0,    55,    56,     0,     0,
     214,     0,    58,    59,   216,    61,    62,    63,    64,    65,
      66,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     5,     6,     7,     0,     9,     0,    67,   217,
      10,    11,     0,    69,     0,    12,     0,    13,    14,    15,
      16,    17,    18,    19,     0,     0,     0,     0,     0,    20,
      21,    22,    23,    24,    25,    26,     0,     0,    27,     0,
       0,     0,     0,     0,     0,    29,     0,     0,    32,    33,
      34,    35,    36,    37,    38,    39,    40,     0,    41,    42,
      43,    44,    45,    46,    47,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    48,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    50,
      51,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     212,    54,     0,    55,    56,     0,     0,     0,     0,    58,
      59,    60,    61,    62,    63,    64,    65,    66,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   310,     0,   311,
       5,     6,     7,     0,     9,    67,    68,     0,    10,    11,
      69,     0,     0,    12,     0,    13,    14,    15,    16,    17,
      18,    19,     0,     0,     0,     0,     0,    20,    21,    22,
      23,    24,    25,    26,     0,     0,    27,     0,     0,     0,
       0,     0,     0,    29,     0,     0,    32,    33,    34,    35,
      36,    37,    38,    39,    40,     0,    41,    42,    43,    44,
      45,    46,    47,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    48,    49,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    50,    51,     0,
       0,     0,     0,     0,     0,   211,     0,     0,   212,    54,
       0,    55,    56,     0,     0,     0,     0,    58,    59,    60,
      61,    62,    63,    64,    65,    66,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   240,     5,     6,
       7,     0,     9,    67,    68,     0,    10,    11,    69,     0,
       0,    12,     0,    13,    14,    15,   248,   249,    18,    19,
       0,     0,     0,     0,     0,    20,   250,   251,    23,    24,
      25,    26,     0,     0,   209,     0,     0,     0,     0,     0,
       0,    29,     0,     0,    32,    33,    34,    35,    36,    37,
      38,    39,    40,     0,    41,    42,    43,    44,    45,    46,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      48,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    50,    51,     0,     0,     0,
       0,     0,     0,   211,     0,     0,   212,    54,     0,    55,
      56,     0,     0,     0,     0,    58,    59,    60,    61,    62,
      63,    64,    65,    66,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   468,     0,     0,     0,     5,     6,     7,     0,     9,
       0,    67,   217,    10,    11,     0,    69,     0,    12,     0,
      13,    14,    15,    16,    17,    18,    19,     0,     0,     0,
       0,     0,    20,    21,    22,    23,    24,    25,    26,     0,
       0,   209,     0,     0,     0,     0,     0,     0,    29,     0,
       0,    32,    33,    34,    35,    36,    37,    38,    39,    40,
       0,    41,    42,    43,    44,    45,    46,    47,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    48,    49,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,    51,     0,     0,     0,     0,     0,     0,
     211,     0,     0,   212,    54,     0,    55,    56,     0,   575,
       0,     0,    58,    59,    60,    61,    62,    63,    64,    65,
      66,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     5,     6,     7,     0,     9,     0,    67,   217,
      10,    11,     0,    69,     0,    12,     0,    13,    14,    15,
     248,   249,    18,    19,     0,     0,     0,     0,     0,    20,
     250,   251,    23,    24,    25,    26,     0,     0,   209,     0,
       0,     0,     0,     0,     0,    29,     0,     0,    32,    33,
      34,    35,    36,    37,    38,    39,    40,     0,    41,    42,
      43,    44,    45,    46,    47,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    48,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    50,
      51,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     212,    54,     0,    55,    56,     0,   575,     0,     0,    58,
      59,    60,    61,    62,    63,    64,    65,    66,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     5,
       6,     7,     0,     9,     0,    67,   217,    10,    11,     0,
      69,     0,    12,     0,    13,    14,    15,   248,   249,    18,
      19,     0,     0,     0,     0,     0,    20,   250,   251,    23,
      24,    25,    26,     0,     0,   209,     0,     0,     0,     0,
       0,     0,    29,     0,     0,    32,    33,    34,    35,    36,
      37,    38,    39,    40,     0,    41,    42,    43,    44,    45,
      46,    47,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    48,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    50,    51,     0,     0,
       0,     0,     0,     0,   211,     0,     0,   212,    54,     0,
      55,    56,     0,   929,     0,     0,    58,    59,    60,    61,
      62,    63,    64,    65,    66,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     6,     7,     0,
       9,     0,    67,   217,    10,    11,     0,    69,     0,    12,
       0,    13,    14,    15,   248,   249,    18,    19,     0,     0,
       0,     0,     0,    20,   250,   251,    23,    24,    25,    26,
       0,     0,   209,     0,     0,     0,     0,     0,     0,    29,
       0,     0,    32,    33,    34,    35,    36,    37,    38,    39,
      40,     0,    41,    42,    43,    44,    45,    46,    47,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    48,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,    51,     0,     0,     0,     0,     0,
       0,   211,     0,     0,   212,    54,     0,    55,    56,     0,
     990,     0,     0,    58,    59,    60,    61,    62,    63,    64,
      65,    66,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     6,     7,     0,     9,     0,    67,
     217,    10,    11,     0,    69,     0,    12,     0,    13,    14,
      15,   248,   249,    18,    19,     0,     0,     0,     0,     0,
      20,   250,   251,    23,    24,    25,    26,     0,     0,   209,
       0,     0,     0,     0,     0,     0,    29,     0,     0,    32,
      33,    34,    35,    36,    37,    38,    39,    40,     0,    41,
      42,    43,    44,    45,    46,    47,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    48,    49,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,    51,     0,     0,     0,     0,     0,     0,   211,     0,
       0,   212,    54,     0,    55,    56,     0,  1168,     0,     0,
      58,    59,    60,    61,    62,    63,    64,    65,    66,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     6,     7,     0,     9,     0,    67,   217,    10,    11,
       0,    69,     0,    12,     0,    13,    14,    15,   248,   249,
      18,    19,     0,     0,     0,     0,     0,    20,   250,   251,
      23,    24,    25,    26,     0,     0,   209,     0,     0,     0,
       0,     0,     0,    29,     0,     0,    32,    33,    34,    35,
      36,    37,    38,    39,    40,     0,    41,    42,    43,    44,
      45,    46,    47,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    48,    49,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    50,    51,     0,
       0,     0,     0,     0,     0,   211,     0,     0,   212,    54,
       0,    55,    56,     0,     0,     0,     0,    58,    59,    60,
      61,    62,    63,    64,    65,    66,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     6,     7,
       0,     9,     0,    67,   217,    10,    11,     0,    69,     0,
      12,     0,    13,    14,    15,    16,    17,    18,    19,     0,
       0,     0,     0,     0,    20,    21,    22,    23,    24,    25,
      26,     0,     0,   209,     0,     0,     0,     0,     0,     0,
      29,     0,     0,    32,    33,    34,    35,    36,    37,    38,
      39,    40,     0,    41,    42,    43,    44,    45,    46,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,    51,     0,     0,     0,     0,
       0,     0,   211,     0,     0,   212,    54,     0,    55,    56,
       0,     0,     0,     0,    58,    59,    60,    61,    62,    63,
      64,    65,    66,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     6,     7,     0,     9,     0,
      67,   217,    10,    11,     0,    69,     0,    12,     0,    13,
      14,    15,    16,    17,    18,    19,     0,     0,     0,     0,
       0,    20,    21,    22,    23,    24,    25,    26,     0,     0,
      27,     0,     0,     0,     0,     0,     0,    29,     0,     0,
      32,    33,    34,    35,    36,    37,    38,    39,    40,     0,
      41,    42,    43,    44,    45,    46,    47,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    48,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,    51,     0,     0,     0,     0,     0,     0,   211,
       0,     0,   212,    54,     0,    55,    56,     0,     0,     0,
       0,    58,    59,    60,    61,    62,    63,    64,    65,    66,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     6,     7,     0,     9,     0,    67,    68,    10,
      11,     0,    69,     0,    12,     0,    13,    14,    15,   248,
     249,    18,    19,     0,     0,     0,     0,     0,    20,   250,
     251,    23,    24,    25,    26,     0,     0,   209,     0,     0,
       0,     0,     0,     0,   280,     0,     0,    32,    33,    34,
      35,    36,    37,    38,    39,    40,     0,    41,    42,    43,
      44,    45,    46,    47,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   281,     0,     0,   212,
      54,     0,    55,    56,     0,     0,     0,     0,    58,    59,
      60,    61,    62,    63,    64,    65,    66,     0,     0,     0,
       0,     0,     0,   282,     5,     6,     7,     0,     9,     0,
       0,     0,    10,    11,     0,     0,     0,    12,     0,    13,
      14,    15,   248,   249,    18,    19,     0,     0,     0,   283,
       0,    20,   250,   251,    23,    24,    25,    26,     0,     0,
     209,     0,     0,     0,     0,     0,     0,   280,     0,     0,
      32,    33,    34,    35,    36,    37,    38,    39,    40,     0,
      41,    42,    43,    44,    45,    46,    47,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   281,
       0,     0,   341,    54,     0,    55,    56,     0,   342,     0,
       0,    58,    59,    60,    61,    62,    63,    64,    65,    66,
       0,     0,     0,     0,     0,     0,     5,     6,     7,     0,
       9,     0,     0,     0,    10,    11,     0,     0,     0,    12,
       0,    13,    14,    15,   248,   249,    18,    19,     0,     0,
       0,     0,   283,    20,   250,   251,    23,    24,    25,    26,
       0,     0,   209,     0,     0,     0,     0,     0,     0,   280,
       0,     0,    32,    33,    34,    35,    36,    37,    38,    39,
      40,     0,    41,    42,    43,    44,    45,    46,    47,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   390,     0,     0,    53,    54,     0,    55,    56,     0,
      57,     0,     0,    58,    59,    60,    61,    62,    63,    64,
      65,    66,     0,     0,     0,     0,     0,     0,     5,     6,
       7,     0,     9,     0,     0,     0,    10,    11,     0,     0,
       0,    12,     0,    13,    14,    15,   248,   249,    18,    19,
       0,     0,     0,     0,   283,    20,   250,   251,    23,    24,
      25,    26,     0,     0,   209,     0,     0,     0,     0,     0,
       0,   280,     0,     0,    32,    33,    34,   398,    36,    37,
      38,   399,    40,     0,    41,    42,    43,    44,    45,    46,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   400,
       0,     0,     0,   401,     0,     0,   212,    54,     0,    55,
      56,     0,     0,     0,     0,    58,    59,    60,    61,    62,
      63,    64,    65,    66,     0,     0,     0,     0,     0,     0,
       5,     6,     7,     0,     9,     0,     0,     0,    10,    11,
       0,     0,     0,    12,     0,    13,    14,    15,   248,   249,
      18,    19,     0,     0,     0,     0,   283,    20,   250,   251,
      23,    24,    25,    26,     0,     0,   209,     0,     0,     0,
       0,     0,     0,   280,     0,     0,    32,    33,    34,    35,
      36,    37,    38,    39,    40,     0,    41,    42,    43,    44,
      45,    46,    47,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   281,     0,     0,   212,    54,
       0,    55,    56,     0,     0,     0,     0,    58,    59,    60,
      61,    62,    63,    64,    65,    66,     0,     0,     0,     0,
       0,     0,   582,     5,     6,     7,     0,     9,     0,     0,
       0,    10,    11,     0,     0,     0,    12,     0,    13,    14,
      15,   248,   249,    18,    19,     0,     0,     0,   283,     0,
      20,   250,   251,    23,    24,    25,    26,     0,     0,   209,
       0,     0,     0,     0,     0,     0,   280,     0,     0,    32,
      33,    34,   398,    36,    37,    38,   399,    40,     0,    41,
      42,    43,    44,    45,    46,    47,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   401,     0,
       0,   212,    54,     0,    55,    56,     0,     0,     0,     0,
      58,    59,    60,    61,    62,    63,    64,    65,    66,     0,
       0,     0,     0,     0,     0,     5,     6,     7,     0,     9,
       0,     0,     0,    10,    11,     0,     0,     0,    12,     0,
      13,    14,    15,   248,   249,    18,    19,     0,     0,     0,
       0,   283,    20,   250,   251,    23,    24,    25,    26,     0,
       0,   209,     0,     0,     0,     0,     0,     0,   280,     0,
       0,    32,    33,    34,    35,    36,    37,    38,    39,    40,
       0,    41,    42,    43,    44,    45,    46,    47,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     281,     0,     0,   341,    54,     0,    55,    56,     0,     0,
       0,     0,    58,    59,    60,    61,    62,    63,    64,    65,
      66,     0,     0,     0,     0,     0,     0,     5,     6,     7,
       0,     9,     0,     0,     0,    10,    11,     0,     0,     0,
      12,     0,    13,    14,    15,   248,   249,    18,    19,     0,
       0,     0,     0,   283,    20,   250,   251,    23,    24,    25,
      26,     0,     0,   209,     0,     0,     0,     0,     0,     0,
     280,     0,     0,    32,    33,    34,    35,    36,    37,    38,
      39,    40,     0,    41,    42,    43,    44,    45,    46,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1121,     0,     0,   212,    54,     0,    55,    56,
       0,     0,     0,     0,    58,    59,    60,    61,    62,    63,
      64,    65,    66,     0,     0,     0,     0,     0,     0,     5,
       6,     7,     0,     9,     0,     0,     0,    10,    11,     0,
       0,     0,    12,     0,    13,    14,    15,   248,   249,    18,
      19,     0,     0,     0,     0,   283,    20,   250,   251,    23,
      24,    25,    26,     0,     0,   209,     0,     0,     0,     0,
       0,     0,   280,     0,     0,    32,    33,    34,    35,    36,
      37,    38,    39,    40,     0,    41,    42,    43,    44,    45,
      46,    47,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1136,     0,     0,   212,    54,     0,
      55,    56,     0,     0,     0,     0,    58,    59,    60,    61,
      62,    63,    64,    65,    66,     0,     0,     0,     0,     0,
       0,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,     0,     0,   283,   153,   154,
     155,   409,   410,   411,   412,   160,   161,   162,     0,     0,
       0,     0,     0,   163,   164,   165,   166,   413,   414,   415,
     416,   171,    37,    38,   417,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   173,   174,   175,   176,   177,   178,   179,
     180,   181,     0,     0,   182,   183,     0,     0,     0,     0,
     184,   185,   186,   187,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   190,   191,
     192,   193,   194,   195,   418,     0,     0,     0,     0,   196,
     197,   198,   199,   200,   201,   202,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
       0,     0,     0,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,     0,     0,     0,     0,     0,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   293,   294,   172,
     295,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   173,   174,
     175,   176,   177,   178,   179,   180,   181,     0,     0,   182,
     183,     0,     0,     0,     0,   184,   185,   186,   187,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   190,   191,   192,   193,   194,   195,     0,
       0,     0,     0,     0,   196,   197,   198,   199,   200,   201,
     202,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,     0,     0,     0,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,     0,     0,
       0,     0,     0,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   242,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   173,   174,   175,   176,   177,   178,   179,
     180,   181,     0,     0,   182,   183,     0,     0,     0,     0,
     184,   185,   186,   187,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,     0,     0,    59,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   190,   191,
     192,   193,   194,   195,     0,     0,     0,     0,     0,   196,
     197,   198,   199,   200,   201,   202,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
       0,     0,     0,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,     0,     0,     0,     0,     0,   163,   164,
     165,   166,   167,   168,   169,   170,   171,     0,     0,   172,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   173,   174,
     175,   176,   177,   178,   179,   180,   181,     0,     0,   182,
     183,     0,     0,     0,     0,   184,   185,   186,   187,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,     0,     0,    59,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   190,   191,   192,   193,   194,   195,     0,
       0,     0,     0,     0,   196,   197,   198,   199,   200,   201,
     202,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,     0,     0,     0,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,     0,     0,
       0,     0,     0,   163,   164,   165,   166,   167,   168,   169,
     170,   171,     0,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   173,   174,   175,   176,   177,   178,   179,
     180,   181,     0,     0,   182,   183,     0,     0,     0,     0,
     184,   185,   186,   187,    23,    24,    25,    26,     0,     0,
       0,     0,     0,     0,     0,   188,   189,     0,     0,     0,
      32,    33,    34,   781,     0,     0,     0,   782,     0,  1062,
      41,    42,    43,    44,    45,     0,     0,     0,   190,   191,
     192,   193,   194,   195,     0,     0,     0,     0,   507,   196,
     197,   198,   199,   200,   201,   202,     0,     0,     0,     0,
       0,   783,   784,     0,     0,     0,     0,     0,     0,   785,
       0,     0,   786,     0,     0,   787,   788,     0,   945,   510,
       0,    58,    59,  1080,    61,    62,    63,    64,    65,    66,
       0,    23,    24,    25,    26,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   789,    32,    33,    34,
     781,     0,     0,     0,   782,     0,     0,    41,    42,    43,
      44,    45,   283,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   783,   784,
       0,     0,     0,     0,     0,     0,   785,     0,     0,   786,
       0,     0,   787,   788,     0,   945,     0,     0,    58,    59,
      60,    61,    62,    63,    64,    65,    66,     0,    23,    24,
      25,    26,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   789,    32,    33,    34,   781,   240,     0,
       0,   782,     0,     0,    41,    42,    43,    44,    45,   283,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   783,   784,     0,     0,     0,
       0,     0,     0,   785,     0,     0,   786,     0,     0,   787,
     788,     0,  1056,     0,     0,    58,    59,    60,    61,    62,
      63,    64,    65,    66,     0,    23,    24,    25,    26,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     789,    32,    33,    34,   781,     0,     0,     0,   782,     0,
       0,    41,    42,    43,    44,    45,   283,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   783,   784,     0,     0,     0,     0,     0,     0,
     785,     0,     0,   786,     0,     0,   787,   788,     0,   945,
       0,     0,    58,    59,    60,    61,    62,    63,    64,    65,
      66,     0,    23,    24,    25,    26,     0,     0,     0,     0,
       0,   777,     0,     0,     0,     0,     0,   789,    32,    33,
      34,   781,     0,     0,     0,   782,     0,     0,    41,    42,
      43,    44,    45,   283,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   783,
     784,   359,   360,     0,     0,     0,     0,   785,     0,     0,
     786,     0,     0,   787,   788,     0,     0,     0,     0,    58,
      59,    60,    61,    62,    63,    64,    65,    66,   908,     0,
       0,     0,     0,     0,     0,     0,     0,   362,   363,   364,
     365,     0,   366,     0,   789,     0,     0,     0,   367,   368,
     369,   370,   371,   919,     0,     0,   372,     0,     0,     0,
     283,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,     0,     0,     0,     0,   359,   360,
       0,     0,     0,     0,     0,     0,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,     0,
       0,     0,     0,   359,   360,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   362,   363,   364,   365,     0,   366,
       0,     0,     0,     0,     0,   367,   368,   369,   370,   371,
       0,     0,     0,   372,     0,     0,     0,     0,     0,   362,
     363,   364,   365,     0,   366,   621,   622,     0,     0,   623,
     367,   368,   369,   370,   371,     0,     0,     0,   372,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   173,   174,
     175,   176,   177,   178,   179,   180,   181,     0,     0,   182,
     183,     0,     0,     0,     0,   184,   185,   186,   187,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   630,   631,
       0,     0,   632,   190,   191,   192,   193,   194,   195,   236,
       0,     0,     0,     0,   196,   197,   198,   199,   200,   201,
     202,   173,   174,   175,   176,   177,   178,   179,   180,   181,
       0,     0,   182,   183,     0,     0,     0,     0,   184,   185,
     186,   187,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   188,   189,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   680,   622,     0,     0,   681,   190,   191,   192,   193,
     194,   195,   236,     0,     0,     0,     0,   196,   197,   198,
     199,   200,   201,   202,   173,   174,   175,   176,   177,   178,
     179,   180,   181,     0,     0,   182,   183,     0,     0,     0,
       0,   184,   185,   186,   187,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   188,   189,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   683,   631,     0,     0,   684,   190,
     191,   192,   193,   194,   195,   236,     0,     0,     0,     0,
     196,   197,   198,   199,   200,   201,   202,   173,   174,   175,
     176,   177,   178,   179,   180,   181,     0,     0,   182,   183,
       0,     0,     0,     0,   184,   185,   186,   187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   188,
     189,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   707,   622,     0,
       0,   708,   190,   191,   192,   193,   194,   195,   236,     0,
       0,     0,     0,   196,   197,   198,   199,   200,   201,   202,
     173,   174,   175,   176,   177,   178,   179,   180,   181,     0,
       0,   182,   183,     0,     0,     0,     0,   184,   185,   186,
     187,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   188,   189,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     710,   631,     0,     0,   711,   190,   191,   192,   193,   194,
     195,   236,     0,     0,     0,     0,   196,   197,   198,   199,
     200,   201,   202,   173,   174,   175,   176,   177,   178,   179,
     180,   181,     0,     0,   182,   183,     0,     0,     0,     0,
     184,   185,   186,   187,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   839,   622,     0,     0,   840,   190,   191,
     192,   193,   194,   195,   236,     0,     0,     0,     0,   196,
     197,   198,   199,   200,   201,   202,   173,   174,   175,   176,
     177,   178,   179,   180,   181,     0,     0,   182,   183,     0,
       0,     0,     0,   184,   185,   186,   187,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   188,   189,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   842,   631,     0,     0,
     843,   190,   191,   192,   193,   194,   195,   236,     0,     0,
       0,     0,   196,   197,   198,   199,   200,   201,   202,   173,
     174,   175,   176,   177,   178,   179,   180,   181,     0,     0,
     182,   183,     0,     0,     0,     0,   184,   185,   186,   187,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   188,   189,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   848,
     622,     0,     0,   849,   190,   191,   192,   193,   194,   195,
     236,     0,     0,     0,     0,   196,   197,   198,   199,   200,
     201,   202,   173,   174,   175,   176,   177,   178,   179,   180,
     181,     0,     0,   182,   183,     0,     0,     0,     0,   184,
     185,   186,   187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   665,   631,     0,     0,   666,   190,   191,   192,
     193,   194,   195,   236,     0,     0,     0,     0,   196,   197,
     198,   199,   200,   201,   202,   173,   174,   175,   176,   177,
     178,   179,   180,   181,     0,     0,   182,   183,     0,     0,
       0,     0,   184,   185,   186,   187,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   188,   189,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   935,   622,     0,     0,   936,
     190,   191,   192,   193,   194,   195,   236,     0,     0,     0,
       0,   196,   197,   198,   199,   200,   201,   202,   173,   174,
     175,   176,   177,   178,   179,   180,   181,     0,     0,   182,
     183,     0,     0,     0,     0,   184,   185,   186,   187,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   938,   631,
       0,     0,   939,   190,   191,   192,   193,   194,   195,   236,
       0,     0,     0,     0,   196,   197,   198,   199,   200,   201,
     202,   173,   174,   175,   176,   177,   178,   179,   180,   181,
       0,     0,   182,   183,     0,     0,     0,     0,   184,   185,
     186,   187,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   188,   189,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1220,   622,     0,     0,  1221,   190,   191,   192,   193,
     194,   195,   236,     0,     0,     0,     0,   196,   197,   198,
     199,   200,   201,   202,   173,   174,   175,   176,   177,   178,
     179,   180,   181,     0,     0,   182,   183,     0,     0,     0,
       0,   184,   185,   186,   187,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   188,   189,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1223,   631,     0,     0,  1224,   190,
     191,   192,   193,   194,   195,   236,     0,     0,     0,     0,
     196,   197,   198,   199,   200,   201,   202,   173,   174,   175,
     176,   177,   178,   179,   180,   181,     0,     0,   182,   183,
       0,     0,     0,     0,   184,   185,   186,   187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   188,
     189,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1230,   622,     0,
       0,  1231,   190,   191,   192,   193,   194,   195,   236,     0,
       0,     0,     0,   196,   197,   198,   199,   200,   201,   202,
     173,   174,   175,   176,   177,   178,   179,   180,   181,     0,
       0,   182,   183,     0,     0,     0,     0,   184,   185,   186,
     187,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   188,   189,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     665,   631,     0,     0,   666,   190,   191,   192,   193,   194,
     195,   236,     0,     0,     0,     0,   196,   197,   198,   199,
     200,   201,   202,   173,   174,   175,   176,   177,   178,   179,
     180,   181,     0,     0,   182,   183,     0,     0,     0,     0,
     184,   185,   186,   187,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
       0,     0,     0,     0,   359,   360,     0,     0,   190,   191,
     192,   193,   194,   195,     0,     0,     0,     0,     0,   196,
     197,   198,   199,   200,   201,   202,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     362,   363,   364,   365,     0,   366,     0,     0,     0,     0,
       0,   367,   368,   369,   370,   371,     0,     0,     0,   372,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,  -763,  -763,     0,     0,     0,     0,   359,   360,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   362,   363,   364,   365,     0,   366,     0,
       0,     0,     0,     0,   367,   368,   369,   370,   371 ];

#[allow(non_upper_case_globals)]
const yycheck_: &'static [i32] = &[      2,    60,     4,    16,    17,    57,    22,    85,    91,    28,
     377,    59,   379,   230,    96,     8,   322,   105,    71,   827,
       8,   104,   448,   383,   378,   344,   274,     4,     2,   526,
     278,   834,   728,    85,     2,    28,     4,   401,   292,    97,
      28,   732,   876,    53,    97,    77,    98,    99,   100,   874,
      57,    53,    54,   101,   531,    57,   533,   595,    69,   426,
      13,   487,    16,    17,    80,   725,    59,   440,   322,  1013,
     329,   609,   326,   497,   921,   448,   443,    94,   445,    25,
      97,    55,    56,    85,    57,     0,    54,   344,    26,   102,
     444,    22,   752,    71,   292,    25,    98,    99,   100,   101,
     322,   508,    76,    77,   326,  1146,   473,    13,   101,    56,
     783,   784,    85,    16,    17,    27,   100,    34,   300,   301,
      29,   380,  1140,    57,   322,    98,    99,   100,   326,    66,
      93,    94,   725,   500,    97,    52,   965,   966,    26,    25,
    1167,    68,   225,   103,    25,   499,    25,    66,   102,    80,
     140,    85,    55,    97,    16,    17,   140,   216,   582,   752,
    1201,    25,   262,    34,    98,    99,   100,    37,    38,    66,
      13,   254,   429,   430,   126,    25,  1203,   126,    52,   125,
     140,    52,   119,   136,   128,   138,    13,   140,   126,    25,
    1037,   725,   136,    55,    56,   125,    25,    13,   732,   102,
     119,   429,   430,  1244,   282,   288,   264,    99,  1226,   109,
     212,   264,    56,   728,   123,     9,    13,    13,   752,   125,
     233,    15,   235,   236,   121,   122,   138,   124,   140,  1173,
     282,   131,   138,   125,   140,   251,   252,   129,   126,   125,
     102,   341,   459,   245,   125,   247,   125,    13,   136,   787,
     224,   125,   262,   285,    13,   136,   230,   136,   100,   513,
     262,   125,   236,   210,    13,   691,   213,   214,   215,    13,
     140,   245,   283,    99,  1108,   125,   239,   245,   241,   233,
     282,   235,   649,   125,  1109,    68,   264,   960,   961,   125,
     342,   513,   659,   657,   648,   138,   125,   140,   315,   316,
     317,   318,   139,   129,   658,   712,   713,    68,   127,   282,
     393,   138,   314,   140,    97,   513,   689,   319,   691,    99,
     136,   140,   138,   325,   140,  1016,    58,   329,   139,   387,
     233,   341,   235,   236,   387,   342,    97,   314,  1167,   341,
     342,   138,   138,   140,   140,    77,   314,    66,   282,   129,
     774,   319,   315,   316,   317,   318,    53,   320,   321,    68,
      99,  1021,  1170,   379,   546,   378,   548,  1170,   385,   342,
      15,   233,   138,   235,   140,   139,   108,   109,   380,   138,
      25,   140,   384,   689,   386,    99,   379,   921,    97,   138,
     129,   140,   339,   890,   138,    68,   140,   344,    77,   131,
      99,   660,   121,   122,   378,    66,   944,   100,   342,   886,
     887,   778,   339,   780,   891,   129,   893,   344,   895,   497,
     139,   785,   385,    77,    97,   779,   125,   965,   966,   445,
     129,   444,   125,   426,   139,  1243,   339,   400,   757,   954,
     125,   344,  1138,    25,   817,   497,   752,    68,   467,   987,
     965,   966,   445,    66,   948,   140,   704,   473,   119,    28,
     121,   122,   679,   124,   143,   144,   145,   874,   322,   876,
     444,   725,   987,  1133,   467,    96,    97,   479,   732,   467,
     473,    99,  1016,   457,   500,   459,   499,   141,   142,   143,
     144,   145,   439,   440,   129,   497,   136,    99,   752,    58,
     140,   448,   429,   430,   582,   468,    99,   500,   121,   122,
     593,   129,   129,   125,   567,   212,    68,   125,    77,   776,
       2,   103,     4,   125,   497,   499,   139,   129,   140,  1067,
     582,    68,   125,   125,    16,    17,   129,   484,  1035,   112,
     487,   515,    27,   125,    29,    97,  1043,   129,   140,   108,
     247,    99,   526,   112,   811,   812,    68,    99,   140,   741,
      97,   818,   819,   497,   746,   262,  1060,   125,   650,    66,
      67,    53,    54,  1233,    99,    57,    68,   524,   440,    25,
     582,  1007,   136,   811,   812,    97,    68,   129,   847,   642,
     818,   819,   566,   595,   129,    56,    82,    83,   962,  1133,
     125,   136,    68,    85,   129,    97,  1140,   609,    25,   582,
     626,    93,    94,   814,   129,    97,    98,    99,   100,   635,
     102,   822,   484,  1138,   121,   122,   100,   705,   575,  1167,
      96,    97,   992,   649,  1007,   648,   638,  1152,   640,  1116,
    1117,  1118,  1119,   659,   341,   658,   132,   133,   582,    68,
     867,   667,  1146,   705,   673,   629,   649,   103,   660,    52,
     125,   635,   128,    56,   129,    66,   659,   921,   927,    52,
    1030,    68,   125,    56,   648,   965,   966,    99,    97,   125,
     673,   697,   698,   129,   658,   673,   103,   384,   921,   386,
     136,   125,  1226,   667,   140,   626,   774,   987,   661,  1196,
      97,  1108,  1109,   705,   635,   679,   682,  1201,   125,  1203,
      68,   137,   129,    25,   140,    37,    38,   974,   119,    68,
     121,   122,   774,   140,   698,   136,    99,   674,    99,   676,
     212,  1091,   705,   709,  1094,    77,   667,   996,    96,    97,
     136,  1218,   689,   103,   691,  1239,   974,    96,    97,   129,
    1244,   233,   125,   235,   236,  1014,   129,   239,   129,   241,
      68,   137,  1016,   245,   780,   247,   779,   855,    99,   771,
     128,   705,   774,   775,    99,   965,   966,   724,   136,   128,
     262,   783,   784,   757,   758,   787,    68,   780,    96,    97,
     764,   103,   845,   767,   125,   280,    68,   987,   129,   921,
     282,   774,    56,   771,   129,   779,   854,   775,    88,    89,
     757,   787,   127,   125,    96,    97,    66,   129,   136,  1186,
     128,   125,    99,   770,    96,    97,    77,   689,   140,   846,
     129,  1185,   314,   315,   316,   317,   318,   319,   320,   321,
     774,   129,   844,   325,   129,   847,   128,   329,    68,   776,
      99,   825,   129,   827,   757,   125,   128,   339,    99,   341,
     342,   854,   344,   106,   138,   841,   140,    40,    41,   119,
     817,   121,   122,   138,   124,   851,    96,    97,   732,  1133,
     129,   735,    25,   846,   811,   812,  1140,   720,   129,    56,
     837,   818,   819,   867,    68,   728,   378,    15,   380,    17,
    1133,    54,   384,   385,   386,  1138,    68,  1140,   128,  1142,
     133,    64,    65,   915,   916,   103,   890,   125,   400,   125,
     922,    68,    96,    97,   127,   927,   127,    52,    26,    54,
      55,    56,    57,   125,    96,    97,   136,   911,    14,    15,
     125,   638,   944,   640,   997,   125,   948,   429,   430,    96,
      97,   429,   430,   129,   128,   817,   125,   959,   960,   961,
     125,   937,   444,   965,   966,   982,   128,   125,   446,   447,
      68,   947,  1226,    52,   950,   125,   101,  1029,    52,   981,
     125,   128,   929,    10,    26,   987,   468,   963,     8,  1041,
     284,   285,   125,  1226,   996,  1228,   474,   479,    96,    97,
    1233,   125,  1235,    44,  1063,    52,    68,    54,    55,    56,
      57,  1133,  1014,  1015,   125,   497,    44,   499,  1140,   982,
    1142,  1080,    66,   129,  1257,   125,    68,  1029,   126,    13,
     128,     2,    26,     4,    96,    97,    25,    17,   136,  1041,
    1123,   125,   125,   990,   139,    16,    17,   974,    40,    41,
      42,    43,    44,    77,    96,    97,  1029,   139,  1060,  1033,
    1007,  1035,   127,   130,   125,  1067,   128,   921,  1041,  1043,
      94,    95,   130,    77,    68,   119,    52,   121,   122,   100,
    1132,   150,    53,    54,   126,   137,   128,    15,   921,   125,
      94,    95,   103,   138,   136,  1029,   125,    68,    52,   125,
     582,  1103,    96,    97,  1226,   100,  1228,  1041,  1084,  1085,
    1086,  1233,   127,  1235,    52,   125,   125,   141,   142,   143,
     144,   145,    93,    94,    68,  1127,    97,   131,   125,   125,
    1132,   102,   126,   618,   128,  1257,   127,   141,   142,   143,
     144,   145,   136,   628,  1146,    52,   125,   844,  1165,  1166,
     125,   125,    96,    97,    68,  1102,   638,     9,   640,  1132,
      68,  1163,  1016,   130,  1018,  1167,   648,   129,   125,  1023,
    1186,   595,  1185,  1045,  1046,    66,   658,   125,   660,   661,
    1182,   127,    96,    97,   128,   609,   125,    68,    96,    97,
      77,   125,   125,  1186,   125,   125,  1170,   682,  1132,  1201,
     125,  1203,  1165,  1166,   130,    56,  1208,    94,    95,    56,
     125,  1185,   125,  1187,   128,    96,    97,   120,   915,   916,
     128,  1168,  1196,   705,   709,   922,   125,    66,   119,   125,
     121,   122,   125,  1207,   719,   125,   125,  1239,   136,   125,
     125,   212,  1244,   130,   131,   245,  1222,   128,   135,    59,
      60,    61,    62,   239,   141,   142,   143,   144,   145,    66,
     136,   475,   233,   479,   235,   236,   854,    98,   239,  1243,
     241,   100,    89,   667,   245,   758,   247,   712,  1207,   874,
     119,   267,   121,   122,   981,   271,  1140,   921,  1142,   771,
     767,   262,   774,   775,   776,  1173,   856,   779,   765,   574,
    1133,  1243,   787,   788,   959,  1138,   987,  1140,   958,  1142,
    1187,  1152,   119,  1152,   121,   122,  1033,   108,  1015,  1191,
    1192,   548,   101,    77,  1178,  1197,   728,  1199,  1200,   811,
     812,  1138,  1133,   811,   812,  1064,   818,   819,    -1,    -1,
     818,   819,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,    -1,    -1,    -1,   325,    -1,   841,    -1,   329,   783,
     784,    -1,   844,   787,   846,   847,   851,    -1,   339,    -1,
     341,    -1,  1226,   344,  1228,    -1,  1248,  1249,  1250,  1251,
      -1,  1235,    -1,   861,   862,    -1,   864,   865,    -1,  1261,
      -1,    -1,    -1,  1226,    52,  1228,    54,    55,    56,    57,
    1233,    -1,  1235,  1257,    -1,    -1,  1103,   378,    -1,   380,
      -1,    -1,    -1,   384,   385,   386,    54,    55,    52,    57,
      54,    55,    56,    57,  1257,    -1,    64,    65,    -1,   400,
    1127,    -1,    -1,   915,   916,    -1,   921,    -1,    -1,    -1,
     922,    -1,    -1,   101,    -1,   927,    -1,    -1,    -1,   107,
      -1,    -1,   937,    -1,    -1,    -1,    -1,    -1,   429,   430,
      -1,    -1,   947,    -1,   450,   950,  1163,    -1,    -1,   455,
      -1,    -1,   458,   444,    -1,   461,    -1,    -1,   963,    -1,
      -1,    -1,    -1,    -1,    -1,  1182,    -1,    -1,    -1,    -1,
     476,    -1,   974,    -1,    -1,   481,   974,   468,    -1,   981,
     982,    52,    -1,    54,    55,    56,    57,    58,   479,    -1,
      -1,  1208,    -1,    -1,   996,     2,    -1,     4,    -1,    -1,
     944,    -1,    -1,    -1,   948,    -1,    77,  1005,   499,    16,
      17,    -1,  1014,  1015,    -1,   959,   960,   961,    -1,    -1,
      -1,   965,   966,    -1,    -1,    -1,    -1,  1029,    -1,    -1,
     101,    -1,  1037,    -1,    -1,    -1,   107,   108,   109,  1041,
      -1,    -1,    -1,   987,    -1,    -1,    53,    54,    52,    -1,
      54,    55,    56,    57,    58,   561,   562,    -1,    -1,  1064,
     131,    68,   595,    -1,    52,   136,    54,    55,    56,    57,
      58,    -1,   143,    77,    -1,   581,   609,    -1,    -1,  1084,
    1085,  1086,    -1,    -1,    -1,    -1,    93,    94,    -1,    77,
      97,    -1,    -1,    -1,    -1,   102,    -1,   101,    -1,    -1,
      -1,  1103,    -1,    91,   108,   109,  1111,    -1,    -1,    -1,
      -1,    -1,    -1,   101,    -1,    -1,  1060,    -1,    -1,   107,
     108,   109,    -1,  1067,    -1,  1127,    -1,   131,    -1,    52,
    1132,    54,    55,    56,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   131,    -1,    -1,    -1,   638,    -1,   640,
      -1,   595,    -1,    -1,    77,   143,    -1,   648,    -1,    -1,
      -1,  1163,    -1,  1165,  1166,   609,    -1,   658,    -1,   660,
     661,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,    -1,
    1182,    -1,    -1,  1185,   107,   108,   109,    -1,   694,    -1,
      52,    -1,    54,    55,    56,    57,    58,    -1,    -1,    -1,
      -1,   569,  1146,    -1,    -1,   212,  1208,    -1,   131,    -1,
     716,    -1,    -1,    -1,    -1,    77,   595,  1222,    -1,     2,
     143,     4,    -1,  1167,    -1,    -1,   233,    -1,   235,   236,
     609,    -1,   239,    -1,   241,    -1,    -1,    -1,   245,   101,
     247,    -1,    -1,    -1,    -1,   107,   108,   109,    -1,    -1,
     783,   784,    -1,    -1,   787,   262,    -1,  1201,    -1,  1203,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   636,   131,
      53,    54,    -1,   641,    57,   643,    -1,    -1,   140,    -1,
     771,   143,    -1,    -1,   775,   776,    -1,    -1,   779,    -1,
      -1,    -1,    -1,    -1,    -1,  1239,    -1,    -1,    -1,    -1,
    1244,    -1,    85,    -1,    -1,    -1,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,    98,    99,   100,   325,    -1,
     811,   812,   329,    -1,    -1,    -1,    -1,   818,   819,    -1,
      -1,    -1,   339,    -1,   341,    -1,    -1,   344,    -1,   783,
     784,    -1,    -1,   787,    -1,    -1,    -1,   853,    -1,    -1,
      -1,    -1,    -1,   844,    -1,   846,   847,    -1,    -1,    -1,
     866,    -1,    -1,    -1,    -1,    -1,   872,    -1,    -1,    -1,
      -1,   378,    -1,   380,    -1,    -1,    -1,   384,   385,   386,
      -1,    -1,    -1,    -1,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,   400,    86,    87,    -1,    -1,   766,    -1,
     768,   907,    94,    95,   783,   784,    -1,    -1,   787,    -1,
      -1,   944,    -1,    -1,    -1,   948,    -1,    -1,    -1,    -1,
      -1,    -1,   429,   430,   915,   916,   959,   960,   961,   212,
      -1,   922,   965,   966,    -1,    -1,   927,   444,   130,   131,
     132,   133,    -1,   135,    -1,    -1,    -1,    -1,    -1,   141,
     142,   143,   144,   145,   987,    -1,    -1,    -1,   964,    -1,
      -1,   468,   245,    -1,   247,    -1,    -1,   835,    -1,    -1,
     838,    -1,   479,    -1,    -1,    -1,    -1,    -1,    -1,   262,
      -1,    -1,    -1,   974,   852,    -1,    -1,    -1,    -1,    -1,
     981,   982,   499,    -1,    -1,    -1,    -1,   595,    -1,   282,
     944,    -1,    -1,    -1,   948,   996,    -1,    -1,    -1,    -1,
      -1,   609,    -1,    -1,    -1,   959,   960,   961,    -1,    -1,
      -1,   965,   966,  1014,  1015,    -1,    -1,  1060,    -1,    -1,
      -1,   314,    -1,    -1,  1067,    -1,   319,    -1,    -1,    -1,
      -1,    -1,   325,   987,    -1,    -1,   329,  1053,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   341,   342,
      -1,   344,    -1,    -1,    -1,   944,    -1,    -1,    -1,   948,
      -1,    -1,    -1,    -1,    -1,  1081,  1082,  1083,    -1,    -1,
     959,   960,   961,    -1,    -1,    -1,   965,   966,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,    -1,    -1,
      -1,   384,    -1,   386,    -1,    -1,    -1,    -1,   987,    -1,
      -1,    -1,  1103,  1146,    -1,   983,  1060,    -1,   986,    -1,
     988,    -1,    -1,  1067,    -1,    -1,    -1,   995,    -1,    -1,
     998,   638,    -1,   640,  1167,    -1,  1127,    -1,    -1,    -1,
      -1,   648,    -1,    -1,    -1,    -1,   429,   430,    -1,    -1,
      -1,   658,    -1,   660,   661,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1201,    -1,
    1203,    -1,  1163,    -1,  1165,  1166,    -1,    -1,    -1,    -1,
      -1,  1060,    -1,    -1,    -1,   783,   784,    -1,  1067,   787,
      -1,  1182,    -1,     2,  1185,     4,   479,    -1,    -1,    -1,
      -1,    -1,  1146,    -1,    -1,    -1,  1239,    -1,    -1,    -1,
      -1,  1244,    -1,    -1,   497,    -1,    -1,  1208,    -1,    -1,
      -1,    -1,    -1,  1167,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1105,    -1,    -1,
      -1,    -1,    -1,    -1,    53,    54,  1114,    -1,    57,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1201,    -1,  1203,
      -1,    -1,    -1,    -1,   771,    -1,    -1,  1146,   775,   776,
      -1,    -1,   779,    -1,    -1,    -1,    85,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1167,    98,
      99,   100,   101,    -1,    -1,  1239,    -1,    -1,    -1,   582,
    1244,    -1,    -1,    -1,   811,   812,    -1,    -1,    -1,    -1,
      -1,   818,   819,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1201,    -1,  1203,    -1,    77,    78,    79,    80,
      81,    82,    83,    -1,    -1,    86,    87,   844,    -1,   846,
     847,    -1,    -1,    94,    95,    -1,   944,    -1,    -1,    -1,
     948,    -1,    -1,    -1,    -1,   638,    -1,   640,    -1,    -1,
    1239,   959,   960,   961,    -1,  1244,    -1,   965,   966,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   660,    -1,   130,
     131,   132,   133,     2,   135,     4,    -1,    -1,    -1,   987,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   595,    -1,
      -1,    -1,    -1,   212,    -1,    -1,    -1,    -1,   915,   916,
      -1,    -1,   609,    -1,    -1,   922,    -1,    -1,    -1,    -1,
     927,    -1,   705,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    53,    54,   245,    -1,   247,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   262,    -1,    -1,   739,    -1,    -1,    -1,
      -1,    -1,  1060,    -1,    -1,    -1,    -1,   974,    -1,  1067,
      -1,    -1,    -1,   282,   981,   982,    -1,    -1,    -1,    98,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   771,   996,
      -1,   774,   775,   776,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   314,    -1,  1014,  1015,    -1,
     319,     2,    -1,     4,    -1,    -1,   325,    -1,    -1,    -1,
     329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   811,   812,
      -1,    -1,   341,   342,    -1,   818,   819,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   595,    -1,    -1,  1146,    -1,
      -1,    -1,    -1,   595,    -1,    -1,    -1,    -1,    -1,   609,
      -1,   844,    53,    54,   847,    -1,    -1,   609,    -1,  1167,
      -1,   380,    -1,    -1,    -1,   384,    -1,   386,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   783,   784,    -1,    -1,
     787,    -1,    -1,   212,    -1,    -1,  1103,    -1,    -1,    -1,
      -1,    -1,    -1,  1201,    -1,  1203,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1127,    -1,    -1,    -1,    -1,    -1,   245,    -1,   247,    -1,
      -1,    -1,   915,   916,    -1,    -1,    -1,    -1,    -1,   922,
      -1,  1239,    -1,   262,   927,    -1,  1244,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1163,    -1,  1165,  1166,
      -1,    -1,    77,    78,    79,    80,    81,    82,    83,    -1,
     479,    86,    87,    -1,    -1,  1182,    -1,    -1,  1185,    94,
      95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   497,    -1,
      -1,   974,    -1,    -1,    -1,   314,    -1,    -1,   981,    -1,
     319,  1208,    -1,    -1,    -1,    -1,   325,    -1,    -1,    -1,
     329,    -1,    -1,   996,    -1,   130,   131,   132,   133,    -1,
     135,   212,   341,    -1,    -1,   344,   141,   142,   143,   144,
     145,  1014,  1015,   783,   784,    -1,    -1,   787,    -1,    -1,
      -1,   783,   784,    -1,    -1,   787,  1029,   944,    -1,    -1,
      -1,   948,    -1,    -1,   245,    -1,   247,    -1,  1041,    -1,
      -1,   380,   959,   960,   961,   384,    -1,   386,   965,   966,
      -1,   262,    -1,   582,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     987,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     429,   430,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1103,    -1,    -1,   314,    -1,    -1,    -1,    -1,   319,   638,
      -1,   640,    -1,    -1,   325,    -1,    -1,    -1,   329,    -1,
      -1,    -1,    -1,    -1,  1127,    -1,    -1,    -1,    -1,  1132,
     341,   660,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,
     479,    -1,    -1,  1060,    -1,    -1,    -1,    -1,    -1,   595,
    1067,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1163,    -1,    -1,   609,    -1,    -1,    -1,    -1,    -1,   380,
      -1,    -1,    -1,   384,   944,   386,   705,    -1,   948,  1182,
      -1,    -1,   944,    -1,    -1,    -1,   948,    -1,    -1,   959,
     960,   961,    -1,    -1,    -1,   965,   966,   959,   960,   961,
      -1,    -1,    -1,   965,   966,  1208,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   987,   429,   430,
      -1,    -1,    -1,    -1,    -1,   987,    -1,    -1,    -1,  1146,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     0,
      -1,    -1,   771,    -1,    -1,   774,   775,     8,     9,    10,
    1167,    -1,    13,    14,    15,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    25,    26,    27,    -1,   479,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    -1,    40,
      41,    42,    43,    44,  1201,    -1,  1203,    -1,    -1,    -1,
    1060,    -1,    -1,    -1,    25,    -1,    -1,  1067,  1060,   638,
      -1,   640,    -1,    -1,    -1,  1067,    -1,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   844,    -1,    -1,   847,    -1,
      -1,   660,  1239,    -1,    -1,    -1,    -1,  1244,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,   783,   784,    -1,
      -1,   787,   103,    -1,    -1,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,   120,
      -1,    -1,    -1,    94,    95,   126,   127,    -1,    -1,   100,
      -1,    -1,    -1,    -1,    -1,   136,  1146,   138,    -1,   140,
      -1,    -1,    -1,    -1,  1146,    -1,   915,   916,    -1,    -1,
      -1,    -1,    -1,   922,    -1,    -1,    -1,  1167,   927,   130,
     131,   132,   133,    -1,   135,  1167,    -1,    -1,    -1,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   638,    -1,   640,
      -1,  1201,   771,  1203,    -1,    -1,   775,   776,    -1,  1201,
      -1,  1203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   660,
      -1,    -1,   981,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   996,    -1,  1239,
      -1,    -1,   811,   812,  1244,    -1,    -1,  1239,    -1,   818,
     819,    -1,  1244,    -1,    -1,  1014,  1015,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    16,    17,    -1,   944,    -1,
    1029,    -1,   948,    -1,    -1,   844,    -1,    -1,   847,    -1,
      -1,    -1,  1041,   959,   960,   961,    -1,    -1,    -1,   965,
     966,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      -1,   987,    -1,    -1,    -1,    -1,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     771,    -1,    -1,    -1,   775,   776,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1103,    -1,   915,   916,    -1,    -1,
      -1,   102,    -1,   922,    -1,    -1,    -1,    -1,   927,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1127,    -1,
     811,   812,    -1,  1132,    -1,    -1,    -1,   818,   819,    -1,
      -1,    -1,    -1,    -1,  1060,    -1,    -1,    -1,    -1,    -1,
      -1,  1067,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   844,  1163,   974,   847,    -1,    -1,    -1,
      -1,    -1,   981,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1182,    -1,    -1,    -1,   996,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1014,  1015,    -1,    -1,  1208,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   210,
    1029,    -1,   213,   214,   215,    -1,   217,    -1,    -1,    -1,
    1146,    -1,    -1,    -1,   915,   916,    -1,    -1,    44,    -1,
      -1,   922,   233,    -1,   235,   236,   927,    -1,    -1,    -1,
      -1,  1167,    -1,   244,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,  1201,    -1,  1203,    94,    95,
      -1,    -1,    -1,   974,  1103,    -1,    -1,    -1,    -1,    -1,
     981,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   996,    -1,    -1,  1127,   125,
      -1,    -1,    -1,  1239,   130,   131,   132,   133,  1244,   135,
      -1,    -1,    -1,  1014,  1015,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,    -1,    -1,   339,    -1,
      -1,    -1,    -1,   344,  1163,   346,   347,   348,   349,   350,
      -1,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,   363,  1182,    -1,   366,   367,   368,   369,   370,
     371,   372,   373,   374,    -1,    -1,    -1,   378,    33,    34,
      35,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1208,
      -1,    -1,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    59,    60,    61,    62,    63,    -1,
      -1,    -1,  1103,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    -1,   429,   430,
      94,    95,    -1,    -1,    -1,    -1,  1127,   438,   439,   440,
      -1,    -1,    -1,   444,    -1,   446,   447,   448,    -1,    -1,
      -1,    -1,    -1,   454,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,    -1,   130,   131,   132,   133,
      -1,   135,  1163,   474,    -1,    -1,   140,   141,   142,   143,
     144,   145,    -1,   484,    -1,   149,   487,    -1,    -1,    -1,
      -1,  1182,    -1,    -1,    -1,    -1,   151,    -1,   499,    -1,
      -1,     0,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     8,
       9,    10,    -1,    -1,    13,    14,    15,  1208,    17,    -1,
      -1,    -1,    -1,   524,    -1,    -1,    25,    26,    27,    28,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,
      -1,    40,    41,    42,    43,    44,    -1,    -1,    -1,   550,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   564,    -1,    -1,    -1,   568,    -1,    68,
      -1,    -1,    -1,    -1,   575,    -1,    -1,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    -1,    94,    95,    96,    97,    -1,
      99,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   120,    -1,    -1,   123,    -1,   125,   126,   127,   128,
     129,   130,   131,   132,   133,    -1,   135,    -1,   137,   138,
      -1,   140,   141,   142,   143,   144,   145,   648,    -1,    -1,
     149,   150,    -1,    -1,     0,    -1,    -1,   658,    -1,    -1,
      -1,    -1,     8,     9,    10,    -1,    -1,    13,    14,    15,
      -1,    17,    -1,   674,    -1,   676,    -1,    -1,    -1,    25,
      -1,    27,    28,    29,    -1,    -1,    -1,    -1,   689,    -1,
     691,    37,    38,    -1,    40,    41,    42,    43,    44,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,   724,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    -1,    94,    95,
      96,    97,    -1,    99,   100,    -1,   757,   103,    -1,    -1,
     106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   770,
      -1,    -1,    -1,    -1,   120,   776,   777,   123,   779,   125,
      -1,   127,   128,   129,   130,   131,   132,   133,    -1,   135,
      -1,   137,   138,    -1,   140,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,   150,    -1,    -1,    -1,    -1,    -1,
     811,   812,    -1,    -1,     0,    -1,   817,   818,   819,    -1,
      -1,    -1,     8,     9,    10,    -1,    -1,    13,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,   837,    -1,    -1,    25,
      26,    27,    28,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    37,    38,    -1,    40,    41,    42,    43,    44,    -1,
     861,   862,    -1,   864,   865,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    -1,    -1,   908,    94,    95,
      96,    97,    -1,    -1,   100,    -1,    -1,   103,   919,    -1,
     106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   929,    -1,
      -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,   125,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,   138,    -1,   140,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,     0,     1,   967,     3,     4,     5,
       6,     7,    -1,   974,    -1,    11,    12,    -1,    -1,    -1,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,   990,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,  1005,    -1,  1007,    -1,    -1,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,
      -1,   107,    -1,    -1,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1102,   138,    -1,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,    -1,    -1,    -1,   151,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,  1168,    -1,    -1,
      -1,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,  1185,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,
     104,   105,    -1,   107,    -1,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   138,     1,   140,     3,     4,     5,
       6,     7,   146,   147,    10,    11,    12,   151,    14,    15,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,
      -1,   107,    -1,    -1,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,     1,   140,     3,     4,     5,     6,     7,
     146,   147,    10,    11,    12,   151,    -1,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,
      -1,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,     1,   140,     3,     4,     5,     6,     7,   146,   147,
      10,    11,    12,   151,    -1,    15,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    25,    -1,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,   101,   102,    -1,   104,   105,    -1,   107,    -1,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,     1,
     140,     3,     4,     5,     6,     7,   146,   147,    10,    11,
      12,   151,    -1,    15,    16,    -1,    18,    19,    20,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,
     102,    -1,   104,   105,    -1,   107,    -1,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,    -1,    -1,     1,   151,
       3,     4,     5,     6,     7,    -1,     9,    10,    11,    12,
      -1,    -1,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,
      -1,   104,   105,    -1,   107,    -1,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   138,     1,   140,     3,     4,
       5,     6,     7,   146,   147,    -1,    11,    12,   151,    -1,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,   101,   102,   103,   104,
     105,    -1,   107,    -1,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   138,     1,   140,     3,     4,     5,     6,
       7,   146,   147,    -1,    11,    12,   151,    -1,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,   101,   102,   103,   104,   105,    -1,
     107,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,     1,   140,     3,     4,     5,     6,     7,   146,
     147,    -1,    11,    12,   151,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   127,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,
       1,   140,     3,     4,     5,     6,     7,   146,   147,    -1,
      11,    12,   151,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
     101,   102,    -1,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   127,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,     1,   140,
       3,     4,     5,     6,     7,   146,   147,    10,    11,    12,
     151,    -1,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,
      -1,   104,   105,    -1,   107,    -1,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   138,     1,   140,     3,     4,
       5,     6,     7,   146,   147,    -1,    11,    12,   151,    -1,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,
     105,    -1,   107,    -1,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       0,    -1,    -1,   138,    -1,   140,    -1,    -1,     8,     9,
      10,   146,   147,    13,    14,    15,   151,    17,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    25,    -1,    27,    28,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    -1,
      40,    41,    42,    43,    44,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    -1,    94,    95,    96,    97,    -1,    99,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     120,    -1,    -1,   123,    -1,   125,    -1,   127,   128,   129,
     130,   131,   132,   133,    -1,   135,    -1,   137,   138,    -1,
     140,   141,   142,   143,   144,   145,     0,    -1,    -1,   149,
     150,    -1,    -1,    -1,     8,     9,    10,    -1,    -1,    13,
      14,    15,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    37,    38,    -1,    40,    41,    42,    43,
      44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    -1,    -1,    -1,
      94,    95,    96,    97,    -1,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,   123,
      -1,   125,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,    -1,   137,   138,    -1,   140,   141,   142,   143,
     144,   145,     0,    -1,    -1,   149,   150,    -1,    -1,    -1,
       8,     9,    10,    -1,    -1,    13,    14,    15,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    26,    27,
      28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      38,    -1,    40,    41,    42,    43,    44,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    -1,    -1,    -1,    94,    95,    96,    97,
      -1,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   120,    -1,    -1,   123,    -1,   125,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,    -1,   137,
     138,    -1,   140,   141,   142,   143,   144,   145,     0,    -1,
      -1,   149,   150,    -1,    -1,    -1,     8,     9,    10,    -1,
      -1,    13,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    25,    -1,    27,    28,    29,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    37,    38,    -1,    40,    41,
      42,    43,    44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    -1,    94,    95,    96,    97,    -1,    99,   100,    -1,
      -1,   103,    -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,
      -1,   123,    -1,   125,    -1,   127,   128,   129,   130,   131,
     132,   133,    -1,   135,    -1,   137,   138,    -1,   140,   141,
     142,   143,   144,   145,     0,    -1,    -1,   149,   150,    -1,
      -1,    -1,     8,     9,    10,    -1,    -1,    13,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,
      -1,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    37,    38,    -1,    40,    41,    42,    43,    44,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    -1,    94,    95,
      96,    97,    -1,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,   125,
      -1,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
      -1,   137,   138,    -1,   140,   141,   142,   143,   144,   145,
       0,    -1,    -1,   149,   150,    -1,    -1,    -1,     8,     9,
      10,    -1,    -1,    13,    14,    15,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    25,    26,    27,    28,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    -1,
      40,    41,    42,    43,    44,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    -1,    94,    95,    96,    97,    -1,    -1,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     120,    -1,    -1,    -1,    -1,   125,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,    -1,
     140,   141,   142,   143,   144,   145,     0,    -1,    -1,   149,
      -1,    -1,    -1,    -1,     8,     9,    10,    -1,    -1,    13,
      14,    15,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    25,    -1,    27,    28,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    37,    38,    -1,    40,    41,    42,    43,
      44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    -1,    -1,    -1,
      94,    95,    96,    97,    -1,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,
      -1,   125,    -1,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,    -1,   140,   141,   142,   143,
     144,   145,     0,    -1,    -1,   149,    -1,    -1,    -1,    -1,
       8,     9,    10,    -1,    -1,    -1,    14,    15,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    26,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      38,    -1,    40,    41,    42,    43,    44,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    -1,    -1,    -1,    94,    95,    96,    97,
      -1,    99,   100,    -1,    -1,   103,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   120,    -1,    -1,    -1,    -1,   125,   126,   127,
     128,   129,   130,   131,   132,   133,    -1,   135,    -1,    -1,
     138,    -1,   140,   141,   142,   143,   144,   145,     0,    -1,
      -1,   149,    -1,    -1,    -1,    -1,     8,     9,    10,    -1,
      -1,    -1,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    25,    26,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    37,    38,    -1,    40,    41,
      42,    43,    44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    -1,    94,    95,    96,    97,    -1,    99,   100,    -1,
      -1,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,
      -1,    -1,    -1,   125,   126,   127,   128,   129,   130,   131,
     132,   133,    -1,   135,    -1,    -1,   138,    -1,   140,   141,
     142,   143,   144,   145,     0,    -1,    -1,   149,    -1,    -1,
      -1,    -1,     8,     9,    10,    -1,    -1,    -1,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    37,    38,    -1,    40,    41,    42,    43,    44,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    -1,    94,    95,
      96,    97,    -1,    99,   100,    -1,    -1,   103,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,   125,
      -1,   127,   128,   129,   130,   131,   132,   133,    -1,   135,
      -1,    -1,   138,    -1,   140,   141,   142,   143,   144,   145,
       0,    -1,    -1,   149,    -1,    -1,    -1,    -1,     8,     9,
      10,    -1,    -1,    -1,    14,    15,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    25,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    -1,
      40,    41,    42,    43,    44,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    -1,    94,    95,    96,    97,    -1,    99,
     100,    -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     120,    -1,    -1,    -1,    -1,   125,    -1,   127,   128,   129,
     130,   131,   132,   133,    -1,   135,    -1,    -1,   138,    -1,
     140,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
       3,     4,     5,     6,     7,    -1,    -1,    -1,    11,    12,
      -1,    -1,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,
      -1,   104,   105,    -1,   107,    -1,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   138,    -1,     3,     4,     5,
       6,     7,    -1,   146,   147,    11,    12,    -1,   151,    -1,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,
      -1,   107,    -1,    -1,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,     3,     4,     5,     6,     7,    -1,
     146,   147,    11,    12,    -1,   151,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     3,     4,     5,    -1,     7,    -1,   146,   147,    11,
      12,    -1,   151,    -1,    16,    -1,    18,    19,    20,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,
     102,    -1,   104,   105,    -1,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,     3,
       4,     5,    -1,     7,   146,   147,    -1,    11,    12,   151,
      -1,    -1,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,
     104,   105,    -1,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,     6,
       7,    -1,   146,   147,    11,    12,    -1,   151,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,
      -1,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,
     107,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,    -1,     7,    -1,   146,
     147,    11,    12,    -1,   151,    -1,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,   101,   102,    -1,   104,   105,    -1,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,     4,     5,    -1,     7,    -1,   146,   147,    11,    12,
      -1,   151,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,
      -1,   104,   105,    -1,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
      -1,     7,    -1,   146,   147,    11,    12,    -1,   151,    -1,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      46,    -1,    -1,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,
      -1,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     3,     4,     5,    -1,     7,    -1,
     146,   147,    11,    12,    -1,   151,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,   108,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     3,     4,     5,    -1,     7,    -1,   146,   147,    11,
      12,    -1,   151,    -1,    16,    -1,    18,    19,    20,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,
     102,    -1,   104,   105,    -1,    -1,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,
       5,    -1,     7,    -1,   146,   147,    11,    12,    -1,   151,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,
     105,    -1,   107,   108,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,     4,     5,    -1,     7,
      -1,   146,   147,    11,    12,    -1,   151,    -1,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,
      -1,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,    -1,
     108,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,   146,   147,
      11,    12,    -1,   151,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
     101,   102,    -1,   104,   105,    -1,    -1,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,   140,
       3,     4,     5,    -1,     7,   146,   147,    -1,    11,    12,
     151,    -1,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,
      -1,   104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,     3,     4,
       5,    -1,     7,   146,   147,    -1,    11,    12,   151,    -1,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,
     105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   136,    -1,    -1,    -1,     3,     4,     5,    -1,     7,
      -1,   146,   147,    11,    12,    -1,   151,    -1,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,
      -1,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,
      -1,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,   146,   147,
      11,    12,    -1,   151,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
     101,   102,    -1,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,     5,    -1,     7,    -1,   146,   147,    11,    12,    -1,
     151,    -1,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,
     104,   105,    -1,   107,    -1,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,    -1,
       7,    -1,   146,   147,    11,    12,    -1,   151,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,
     107,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,    -1,     7,    -1,   146,
     147,    11,    12,    -1,   151,    -1,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,   101,   102,    -1,   104,   105,    -1,   107,    -1,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,     4,     5,    -1,     7,    -1,   146,   147,    11,    12,
      -1,   151,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,
      -1,   104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
      -1,     7,    -1,   146,   147,    11,    12,    -1,   151,    -1,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      46,    -1,    -1,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,
      -1,    -1,    -1,    -1,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     3,     4,     5,    -1,     7,    -1,
     146,   147,    11,    12,    -1,   151,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,   101,   102,    -1,   104,   105,    -1,    -1,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     3,     4,     5,    -1,     7,    -1,   146,   147,    11,
      12,    -1,   151,    -1,    16,    -1,    18,    19,    20,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,
     102,    -1,   104,   105,    -1,    -1,    -1,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,    -1,    -1,
      -1,    -1,    -1,   125,     3,     4,     5,    -1,     7,    -1,
      -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,   151,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,    -1,
       7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,   151,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,
     107,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,
       5,    -1,     7,    -1,    -1,    -1,    11,    12,    -1,    -1,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,   151,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    94,
      -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,
     105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,
       3,     4,     5,    -1,     7,    -1,    -1,    -1,    11,    12,
      -1,    -1,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,   151,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,
      -1,   104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
      -1,    -1,   125,     3,     4,     5,    -1,     7,    -1,    -1,
      -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    -1,    -1,    -1,   151,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,   101,   102,    -1,   104,   105,    -1,    -1,    -1,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    -1,     3,     4,     5,    -1,     7,
      -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,   151,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,
      -1,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,    -1,
      -1,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
      -1,     7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,   151,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      46,    -1,    -1,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,
      -1,    -1,    -1,    -1,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,     5,    -1,     7,    -1,    -1,    -1,    11,    12,    -1,
      -1,    -1,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,   151,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,
     104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,
      -1,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    -1,    -1,   151,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    -1,    -1,
      -1,    -1,    -1,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    93,    94,    95,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,   131,
     132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,   141,
     142,   143,   144,   145,   146,   147,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    -1,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    93,    94,    95,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,   131,   132,   133,   134,   135,    -1,
      -1,    -1,    -1,    -1,   141,   142,   143,   144,   145,   146,
     147,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    -1,    -1,
      -1,    -1,    -1,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    -1,    56,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    93,    94,    95,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,   111,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    -1,    -1,   141,
     142,   143,   144,   145,   146,   147,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    -1,    -1,    56,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    -1,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    93,    94,    95,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,   111,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,   131,   132,   133,   134,   135,    -1,
      -1,    -1,    -1,    -1,   141,   142,   143,   144,   145,   146,
     147,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    -1,    -1,
      -1,    -1,    -1,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    -1,    -1,    56,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    93,    94,    95,    33,    34,    35,    36,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    -1,    58,
      59,    60,    61,    62,    63,    -1,    -1,    -1,   130,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    -1,    77,   141,
     142,   143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,
      -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,   101,    -1,    -1,   104,   105,    -1,   107,   108,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    33,    34,    35,    36,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   135,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    -1,    -1,    59,    60,    61,
      62,    63,   151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,
      -1,    -1,   104,   105,    -1,   107,    -1,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,    33,    34,
      35,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   135,    49,    50,    51,    52,   140,    -1,
      -1,    56,    -1,    -1,    59,    60,    61,    62,    63,   151,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,   101,    -1,    -1,   104,
     105,    -1,   107,    -1,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,    33,    34,    35,    36,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     135,    49,    50,    51,    52,    -1,    -1,    -1,    56,    -1,
      -1,    59,    60,    61,    62,    63,   151,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,   101,    -1,    -1,   104,   105,    -1,   107,
      -1,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,    -1,    33,    34,    35,    36,    -1,    -1,    -1,    -1,
      -1,    44,    -1,    -1,    -1,    -1,    -1,   135,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    -1,    -1,    59,    60,
      61,    62,    63,   151,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    -1,    90,
      91,    94,    95,    -1,    -1,    -1,    -1,    98,    -1,    -1,
     101,    -1,    -1,   104,   105,    -1,    -1,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    44,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,   131,   132,
     133,    -1,   135,    -1,   135,    -1,    -1,    -1,   141,   142,
     143,   144,   145,    44,    -1,    -1,   149,    -1,    -1,    -1,
     151,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    -1,    94,    95,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    -1,    94,    95,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   130,   131,   132,   133,    -1,   135,
      -1,    -1,    -1,    -1,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,    -1,    -1,    -1,   130,
     131,   132,   133,    -1,   135,    52,    53,    -1,    -1,    56,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    -1,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    93,    94,    95,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    52,    53,
      -1,    -1,    56,   130,   131,   132,   133,   134,   135,   136,
      -1,    -1,    -1,    -1,   141,   142,   143,   144,   145,   146,
     147,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      -1,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,    93,
      94,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    52,    53,    -1,    -1,    56,   130,   131,   132,   133,
     134,   135,   136,    -1,    -1,    -1,    -1,   141,   142,   143,
     144,   145,   146,   147,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    -1,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    93,    94,    95,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    52,    53,    -1,    -1,    56,   130,
     131,   132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,
     141,   142,   143,   144,   145,   146,   147,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    -1,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    93,    94,    95,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    52,    53,    -1,
      -1,    56,   130,   131,   132,   133,   134,   135,   136,    -1,
      -1,    -1,    -1,   141,   142,   143,   144,   145,   146,   147,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    93,    94,
      95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      52,    53,    -1,    -1,    56,   130,   131,   132,   133,   134,
     135,   136,    -1,    -1,    -1,    -1,   141,   142,   143,   144,
     145,   146,   147,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    93,    94,    95,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    52,    53,    -1,    -1,    56,   130,   131,
     132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,   141,
     142,   143,   144,   145,   146,   147,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    -1,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    93,    94,    95,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    52,    53,    -1,    -1,
      56,   130,   131,   132,   133,   134,   135,   136,    -1,    -1,
      -1,    -1,   141,   142,   143,   144,   145,   146,   147,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    -1,    -1,
      86,    87,    -1,    -1,    -1,    -1,    92,    93,    94,    95,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    52,
      53,    -1,    -1,    56,   130,   131,   132,   133,   134,   135,
     136,    -1,    -1,    -1,    -1,   141,   142,   143,   144,   145,
     146,   147,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      93,    94,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    52,    53,    -1,    -1,    56,   130,   131,   132,
     133,   134,   135,   136,    -1,    -1,    -1,    -1,   141,   142,
     143,   144,   145,   146,   147,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    -1,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    93,    94,    95,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    52,    53,    -1,    -1,    56,
     130,   131,   132,   133,   134,   135,   136,    -1,    -1,    -1,
      -1,   141,   142,   143,   144,   145,   146,   147,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    -1,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    93,    94,    95,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    52,    53,
      -1,    -1,    56,   130,   131,   132,   133,   134,   135,   136,
      -1,    -1,    -1,    -1,   141,   142,   143,   144,   145,   146,
     147,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      -1,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,    93,
      94,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    52,    53,    -1,    -1,    56,   130,   131,   132,   133,
     134,   135,   136,    -1,    -1,    -1,    -1,   141,   142,   143,
     144,   145,   146,   147,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    -1,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    93,    94,    95,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    52,    53,    -1,    -1,    56,   130,
     131,   132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,
     141,   142,   143,   144,   145,   146,   147,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    -1,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    93,    94,    95,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    52,    53,    -1,
      -1,    56,   130,   131,   132,   133,   134,   135,   136,    -1,
      -1,    -1,    -1,   141,   142,   143,   144,   145,   146,   147,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    93,    94,
      95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      52,    53,    -1,    -1,    56,   130,   131,   132,   133,   134,
     135,   136,    -1,    -1,    -1,    -1,   141,   142,   143,   144,
     145,   146,   147,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    93,    94,    95,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    -1,    94,    95,    -1,    -1,   130,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    -1,    -1,   141,
     142,   143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     130,   131,   132,   133,    -1,   135,    -1,    -1,    -1,    -1,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    -1,    94,    95,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,   131,   132,   133,    -1,   135,    -1,
      -1,    -1,    -1,    -1,   141,   142,   143,   144,   145 ];

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
  #[allow(non_upper_case_globals)]
const yystos_: &'static [i32] = &[      0,   154,   155,     0,     1,     3,     4,     5,     6,     7,
      11,    12,    16,    18,    19,    20,    21,    22,    23,    24,
      30,    31,    32,    33,    34,    35,    36,    39,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    59,    60,    61,    62,    63,    64,    65,    75,    76,
      90,    91,    98,   101,   102,   104,   105,   107,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   146,   147,   151,
     156,   157,   158,   165,   167,   169,   173,   174,   179,   180,
     183,   184,   185,   187,   188,   189,   191,   192,   201,   203,
     218,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   246,   266,   275,   276,   324,   325,   326,   327,
     328,   329,   330,   333,   335,   336,   350,   351,   353,   354,
     355,   356,   357,   358,   359,   360,   398,   412,   158,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    56,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    86,    87,    92,    93,    94,    95,   107,   108,
     130,   131,   132,   133,   134,   135,   141,   142,   143,   144,
     145,   146,   147,   195,   196,   197,   199,   200,   350,    39,
      58,    98,   101,   107,   108,   109,   112,   147,   184,   192,
     201,   204,   210,   213,   215,   227,   356,   357,   359,   360,
     396,   397,   210,   136,   211,   212,   136,   207,   211,   136,
     140,   405,    54,   196,   405,   126,   159,   126,    21,    22,
      31,    32,   183,   201,   227,   246,   201,   201,   201,    56,
       1,    47,   101,   161,   162,   163,   165,   186,   187,   412,
     165,   220,   205,   215,   396,   412,   204,   395,   396,   412,
      46,    98,   125,   151,   173,   174,   191,   218,   227,   356,
     357,   360,   267,    54,    55,    57,   195,   339,   352,   339,
     340,   341,   139,   139,   139,   139,   201,   179,   201,   355,
     138,   140,   404,   410,   411,    40,    41,    42,    43,    44,
      37,    38,   136,   363,   364,   365,   366,   412,   363,   365,
      26,   126,   207,   211,   238,   277,    28,   239,   273,   129,
     125,   101,   107,   188,   129,    25,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    94,
      95,   100,   130,   131,   132,   133,   135,   141,   142,   143,
     144,   145,   149,   202,   202,    68,    96,    97,   128,   402,
     219,   169,   176,   176,   177,   178,   177,   176,   404,   411,
      98,   185,   192,   227,   251,   356,   357,   360,    52,    56,
      94,    98,   193,   194,   227,   356,   357,   360,   194,    33,
      34,    35,    36,    49,    50,    51,    52,    56,   136,   172,
     195,   358,   393,   210,    97,   402,   403,   277,   327,    99,
      99,   125,   204,    56,   204,   204,   204,   339,   129,   100,
     125,   214,   412,    97,   128,   402,    99,    99,   125,   214,
     210,   405,   406,   210,    91,   209,   210,   215,   370,   396,
     412,   169,   406,   169,    54,    64,    65,   166,   136,   201,
     156,   161,    97,   402,    99,   164,   186,   103,   404,   411,
     406,   221,   406,   137,   125,   140,   409,   125,   409,   127,
     409,   405,    56,   188,   190,   355,   364,   125,    97,   128,
     402,    52,    54,    55,    56,    57,    58,    77,   101,   107,
     108,   109,   131,   136,   143,   256,   269,   367,   369,   371,
     372,   373,   374,   375,   376,   377,   380,   381,   382,   383,
     384,   387,   388,   389,   390,   391,    66,   119,   121,   122,
     342,   119,   119,   342,    67,   342,   331,   337,   334,   338,
      77,   138,   158,   176,   176,   176,   176,   165,   169,   169,
      91,   369,   370,   375,   129,   160,   161,   369,   129,   160,
     278,   106,   181,   279,   274,   107,   179,   204,   215,   216,
     217,   186,   125,   191,   125,   167,   168,   179,   192,   201,
     204,   206,   217,   227,   360,   171,   201,   201,   201,   201,
     201,   201,   201,   201,   201,   201,   201,   201,   201,   170,
     201,   201,   201,   201,   201,   201,   201,   201,   201,   201,
     201,    52,    53,    56,   199,   207,   399,   400,   209,   215,
      52,    53,    56,   199,   207,   399,   160,    13,   247,   410,
     247,   161,   176,   161,   404,   223,    56,    97,   128,   402,
      25,   169,    52,    56,   193,   133,   361,    97,   128,   402,
     226,   394,    68,    97,   401,    52,    56,   399,   168,   201,
     206,   168,   206,   198,   124,   204,   107,   204,   213,   396,
      52,    56,   209,    52,    56,   397,   406,   103,   406,   125,
     406,   125,   406,   196,   169,   127,   127,   399,   399,   206,
     159,   406,   163,   406,   396,   125,   190,    52,    56,   209,
      52,    56,   101,   107,   252,   253,   254,   255,   372,   369,
     125,   392,   412,   268,   129,   125,   368,   204,   125,   392,
      34,    52,   125,   368,    52,   125,   368,    52,   344,   343,
     119,   332,   342,    66,   119,   119,   332,    66,   119,   201,
     406,   406,   125,   201,    10,   245,     8,   240,   320,   412,
     410,   201,   245,   280,   281,   182,   282,   283,   282,   204,
     125,    44,   406,   190,   125,    44,   129,    44,    97,   128,
     402,    52,    56,    90,    91,    98,   101,   104,   105,   135,
     266,   293,   294,   295,   298,   315,   316,   317,   318,   319,
     324,   325,   328,   329,   330,   333,   335,   336,   357,   293,
     405,    99,    99,   207,   211,   405,   407,   125,    99,    99,
     207,   208,   211,   412,   245,   161,    13,   161,   245,    27,
     248,   410,   245,    25,   222,   287,    17,   242,   285,    52,
      56,   209,    52,    56,   177,   225,   362,   224,    52,    56,
     193,   209,   160,   169,   175,   208,   211,   196,   204,   204,
     214,    99,    99,   407,    99,    99,   370,   396,   406,   409,
     188,   407,   254,   372,   125,   406,   125,   263,   405,   391,
      29,   123,   270,   204,   367,   374,   387,   389,   377,   381,
     383,   375,   384,   389,   373,   375,   345,    54,    55,    57,
     349,   360,   139,   342,   139,   139,   139,   370,    44,   204,
     217,   321,   412,     9,    15,   241,   243,   323,   412,    44,
     127,   130,   261,   262,   412,   280,   245,   261,   245,   107,
     204,   165,   190,   165,   201,    52,    56,   209,    52,    56,
     316,   316,    56,   193,   300,   107,   293,   301,   302,   303,
     304,   305,   307,   407,   299,   405,   408,    52,   100,   130,
      88,    89,    97,   128,   136,   296,   297,   150,   168,   206,
     168,   206,   181,   137,    99,   168,   206,   168,   206,   181,
      14,   243,   244,   249,   250,   412,   250,   288,   285,   245,
     107,   204,   284,   245,   407,   161,   410,   176,   160,   407,
     245,   406,   172,   277,   273,    99,   406,   125,   406,   252,
     255,   253,   103,   138,   272,   271,   125,   368,   125,   368,
     392,   125,   368,   125,   368,   368,   346,   406,   201,   100,
     322,   412,   161,   161,   201,   256,   257,   260,   263,   373,
     375,   376,   378,   379,   385,   386,   389,   391,   161,   127,
     160,   204,   407,   293,    52,   407,   107,   293,   307,   407,
     125,   125,    58,   112,   308,   309,   310,   311,   312,   313,
     314,   381,   127,   317,   298,   316,   316,   193,   407,   406,
     112,   301,   304,   308,   301,   304,   308,   201,   168,   206,
     161,   176,   245,   245,   291,   292,   293,   303,   304,   308,
     245,   204,   125,   247,   245,   160,   410,   245,   125,   125,
      52,   264,   265,   371,   160,   161,   375,   389,   375,   375,
     347,    98,   192,   227,   356,   357,   360,   247,   323,   392,
     263,   130,   129,   125,   258,   259,    98,   227,   125,   392,
     125,   258,   125,   258,   406,    52,   125,   125,   306,   307,
     339,   408,   125,   293,    34,    52,   339,   406,   406,   406,
     407,   407,   407,   247,   247,    40,    41,   125,   107,   204,
     161,   245,   253,   125,   405,   245,   127,   368,   125,   368,
     368,   368,   348,    56,    97,   128,   402,   161,   130,   227,
     257,   386,   389,    56,    97,   378,   383,   375,   385,   389,
     375,   125,   306,   125,   124,   310,   314,   161,   289,   176,
     176,   301,   305,   204,   250,   285,   286,   265,   375,   161,
      52,    56,   209,    52,    56,   320,   125,   258,   125,   258,
      52,    56,   392,   125,   258,   125,   258,   258,   306,   125,
     305,   307,   249,   161,   125,   368,   120,   407,   375,   389,
     375,   375,   250,   287,   290,   306,   258,   125,   258,   258,
     258,   375,   258 ];

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
  #[allow(non_upper_case_globals)]
const yyr1_: &'static [i32] = &[      0,   153,   155,   154,   156,   157,   157,   157,   157,   158,
     158,   159,   160,   160,   161,   162,   162,   162,   162,   163,
     164,   163,   166,   165,   165,   165,   165,   165,   165,   165,
     165,   165,   165,   165,   165,   165,   165,   165,   165,   165,
     167,   167,   167,   167,   167,   167,   167,   167,   168,   168,
     168,   169,   169,   169,   169,   169,   170,   169,   171,   169,
     169,   172,   173,   175,   174,   176,   178,   177,   179,   179,
     180,   180,   182,   181,   183,   184,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   185,   185,   186,   186,
     187,   187,   187,   187,   187,   187,   187,   187,   187,   187,
     188,   188,   189,   189,   190,   190,   191,   191,   191,   191,
     191,   191,   191,   191,   191,   192,   192,   192,   192,   192,
     192,   192,   192,   192,   193,   193,   194,   194,   194,   195,
     195,   195,   195,   195,   196,   196,   197,   198,   197,   199,
     199,   199,   199,   199,   199,   199,   199,   199,   199,   199,
     199,   199,   199,   199,   199,   199,   199,   199,   199,   199,
     199,   199,   199,   199,   199,   199,   199,   199,   199,   200,
     200,   200,   200,   200,   200,   200,   200,   200,   200,   200,
     200,   200,   200,   200,   200,   200,   200,   200,   200,   200,
     200,   200,   200,   200,   200,   200,   200,   200,   200,   200,
     200,   200,   200,   200,   200,   200,   200,   200,   200,   200,
     201,   201,   201,   201,   201,   201,   201,   201,   201,   201,
     201,   201,   201,   201,   201,   201,   201,   201,   201,   201,
     201,   201,   201,   201,   201,   201,   201,   201,   201,   201,
     201,   201,   201,   201,   201,   201,   201,   201,   201,   201,
     201,   201,   201,   201,   201,   201,   201,   202,   202,   202,
     202,   203,   203,   204,   205,   205,   205,   205,   206,   206,
     207,   207,   207,   208,   208,   209,   209,   209,   209,   209,
     210,   210,   210,   210,   210,   212,   211,   213,   214,   214,
     215,   215,   215,   215,   216,   216,   217,   217,   217,   218,
     218,   218,   218,   218,   218,   218,   218,   218,   218,   218,
     219,   218,   220,   218,   221,   218,   218,   218,   218,   218,
     218,   218,   218,   218,   218,   218,   218,   218,   218,   218,
     218,   218,   218,   218,   218,   218,   222,   218,   223,   218,
     218,   218,   224,   218,   225,   218,   226,   218,   218,   218,
     218,   218,   218,   218,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   247,   247,   248,   248,   249,
     249,   250,   250,   251,   251,   252,   252,   253,   253,   254,
     254,   254,   254,   254,   255,   255,   256,   256,   257,   257,
     257,   257,   258,   258,   259,   260,   260,   260,   260,   260,
     260,   260,   260,   260,   260,   260,   260,   260,   260,   260,
     261,   261,   262,   262,   263,   263,   264,   264,   265,   265,
     267,   268,   266,   269,   269,   271,   270,   272,   270,   274,
     273,   275,   275,   275,   275,   276,   276,   276,   276,   276,
     276,   276,   276,   276,   278,   277,   279,   277,   281,   280,
     283,   282,   284,   284,   284,   284,   285,   286,   286,   288,
     289,   287,   290,   290,   291,   291,   291,   292,   292,   292,
     292,   292,   292,   293,   294,   294,   295,   295,   296,   297,
     298,   298,   298,   298,   298,   298,   298,   298,   298,   298,
     298,   298,   299,   298,   298,   300,   298,   301,   301,   301,
     301,   301,   301,   301,   301,   302,   302,   303,   303,   304,
     305,   305,   306,   306,   307,   308,   308,   308,   308,   309,
     309,   310,   310,   311,   311,   312,   312,   313,   314,   314,
     315,   315,   315,   315,   315,   315,   315,   315,   315,   315,
     316,   316,   316,   316,   316,   316,   316,   316,   316,   316,
     317,   318,   319,   319,   319,   320,   320,   321,   321,   321,
     322,   322,   323,   323,   324,   324,   325,   326,   326,   326,
     327,   328,   329,   330,   331,   331,   332,   332,   333,   334,
     334,   335,   336,   337,   337,   338,   338,   339,   339,   340,
     340,   341,   341,   342,   343,   342,   344,   345,   346,   347,
     348,   342,   349,   349,   349,   349,   350,   350,   351,   352,
     352,   352,   352,   353,   354,   354,   355,   355,   355,   355,
     356,   356,   356,   356,   356,   357,   357,   357,   357,   357,
     357,   357,   358,   358,   359,   359,   360,   360,   362,   361,
     361,   363,   363,   364,   364,   364,   365,   366,   365,   367,
     367,   367,   367,   368,   368,   369,   369,   369,   369,   369,
     369,   369,   369,   369,   369,   369,   369,   369,   369,   369,
     370,   371,   371,   371,   371,   372,   372,   373,   374,   374,
     375,   375,   376,   377,   377,   378,   378,   379,   379,   380,
     380,   381,   381,   382,   383,   383,   384,   385,   386,   386,
     387,   387,   388,   388,   389,   389,   390,   390,   391,   392,
     392,   393,   394,   393,   395,   395,   396,   396,   397,   397,
     397,   397,   398,   398,   398,   399,   399,   399,   399,   400,
     400,   400,   401,   401,   402,   402,   403,   403,   404,   404,
     405,   405,   406,   407,   408,   409,   409,   409,   410,   410,
     411,   411,   412 ];

/* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
  #[allow(non_upper_case_globals)]
const yyr2_: &'static [i32] = &[      0,     2,     0,     2,     2,     1,     1,     3,     2,     1,
       2,     3,     5,     3,     2,     1,     1,     3,     1,     1,
       0,     3,     0,     4,     3,     3,     3,     2,     3,     3,
       3,     3,     3,     4,     1,     3,     3,     5,     3,     1,
       3,     3,     6,     5,     5,     5,     5,     3,     1,     3,
       1,     1,     3,     3,     3,     2,     0,     4,     0,     4,
       1,     1,     2,     0,     5,     1,     0,     3,     1,     1,
       1,     4,     0,     4,     1,     2,     3,     4,     5,     4,
       5,     2,     2,     2,     2,     2,     1,     3,     1,     3,
       1,     2,     3,     5,     2,     4,     2,     4,     1,     3,
       1,     3,     2,     3,     1,     3,     1,     1,     4,     3,
       3,     3,     3,     2,     1,     1,     1,     4,     3,     3,
       3,     3,     2,     1,     1,     1,     2,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     4,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     6,     5,     5,     5,     5,     4,     3,     3,
       3,     2,     2,     2,     2,     3,     3,     3,     3,     3,
       3,     4,     2,     2,     3,     3,     3,     3,     1,     3,
       3,     3,     3,     3,     2,     2,     3,     3,     3,     3,
       3,     6,     4,     6,     4,     6,     1,     1,     1,     1,
       1,     3,     3,     1,     1,     2,     4,     2,     1,     3,
       3,     5,     3,     1,     1,     1,     1,     2,     4,     2,
       1,     2,     2,     4,     1,     0,     2,     2,     2,     1,
       1,     2,     3,     4,     1,     1,     3,     4,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     4,     0,     3,     0,     4,     3,     3,     2,     3,
       3,     1,     4,     3,     1,     5,     4,     3,     2,     1,
       2,     1,     6,     6,     4,     4,     0,     6,     0,     5,
       5,     6,     0,     6,     0,     7,     0,     5,     4,     4,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       5,     1,     2,     1,     1,     1,     3,     1,     3,     1,
       3,     5,     1,     3,     2,     1,     1,     1,     4,     2,
       2,     1,     2,     0,     1,     6,     8,     4,     6,     4,
       2,     6,     2,     4,     6,     2,     4,     2,     4,     1,
       1,     1,     3,     4,     1,     4,     1,     3,     1,     1,
       0,     0,     5,     4,     1,     0,     4,     0,     4,     0,
       4,     2,     4,     5,     5,     2,     4,     4,     3,     3,
       3,     2,     1,     4,     0,     4,     0,     4,     0,     3,
       0,     3,     1,     2,     3,     4,     5,     1,     1,     0,
       0,     7,     1,     1,     1,     3,     3,     1,     2,     3,
       1,     1,     1,     1,     3,     1,     3,     1,     1,     1,
       1,     4,     4,     4,     3,     4,     4,     4,     3,     3,
       3,     2,     0,     4,     2,     0,     4,     1,     1,     2,
       3,     5,     2,     4,     1,     2,     3,     1,     3,     5,
       2,     1,     1,     3,     1,     3,     1,     2,     1,     1,
       3,     2,     1,     1,     3,     2,     1,     2,     1,     1,
       1,     3,     3,     2,     2,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     3,     1,     6,     1,     1,     1,     1,
       2,     1,     2,     1,     1,     1,     1,     1,     1,     2,
       3,     3,     3,     4,     0,     3,     1,     2,     4,     0,
       3,     4,     4,     0,     3,     0,     3,     0,     2,     0,
       2,     0,     2,     1,     0,     3,     0,     0,     0,     0,
       0,     8,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     3,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     4,
       0,     1,     1,     3,     5,     3,     1,     0,     3,     4,
       2,     2,     1,     2,     0,     6,     8,     4,     6,     4,
       6,     2,     4,     6,     2,     4,     2,     4,     1,     0,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       1,     3,     1,     2,     1,     2,     1,     1,     3,     1,
       3,     1,     1,     2,     2,     1,     3,     3,     1,     3,
       1,     3,     1,     1,     2,     1,     1,     1,     2,     2,
       1,     1,     0,     4,     1,     2,     1,     3,     3,     2,
       4,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       0,     1,     2,     2,     2,     0,     1,     1,     1,     1,
       1,     2,     0 ];


/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
  #[allow(non_upper_case_globals)]
const yyrline_: &'static [i32] = &[      0,   370,   370,   370,   388,   397,   401,   405,   411,   417,
     421,   430,   442,   465,   484,   493,   497,   501,   507,   513,
     518,   517,   528,   527,   538,   548,   558,   562,   571,   582,
     593,   604,   615,   635,   650,   654,   667,   684,   713,   723,
     729,   739,   749,   764,   781,   798,   815,   832,   844,   850,
     873,   879,   883,   894,   905,   916,   928,   927,   956,   955,
     983,   989,  1000,  1014,  1013,  1034,  1042,  1042,  1060,  1064,
    1070,  1074,  1090,  1089,  1109,  1115,  1128,  1150,  1163,  1185,
    1198,  1220,  1232,  1244,  1256,  1268,  1282,  1292,  1304,  1314,
    1331,  1335,  1341,  1347,  1359,  1365,  1377,  1381,  1393,  1397,
    1411,  1415,  1427,  1431,  1439,  1443,  1451,  1457,  1463,  1474,
    1489,  1499,  1514,  1526,  1537,  1547,  1553,  1559,  1570,  1580,
    1590,  1600,  1612,  1623,  1633,  1637,  1643,  1649,  1655,  1667,
    1671,  1675,  1679,  1684,  1690,  1696,  1702,  1707,  1706,  1719,
    1720,  1721,  1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,
    1730,  1731,  1732,  1733,  1734,  1735,  1736,  1737,  1738,  1739,
    1740,  1741,  1742,  1743,  1744,  1745,  1746,  1747,  1748,  1751,
    1752,  1753,  1754,  1755,  1756,  1757,  1758,  1759,  1760,  1761,
    1762,  1763,  1764,  1765,  1766,  1767,  1768,  1769,  1770,  1771,
    1772,  1773,  1774,  1775,  1776,  1777,  1778,  1779,  1780,  1781,
    1782,  1783,  1784,  1785,  1786,  1787,  1788,  1789,  1790,  1791,
    1794,  1804,  1814,  1829,  1846,  1863,  1880,  1897,  1913,  1923,
    1939,  1955,  1968,  1981,  1994,  2007,  2013,  2019,  2025,  2031,
    2037,  2043,  2056,  2065,  2074,  2080,  2086,  2092,  2098,  2102,
    2108,  2114,  2120,  2126,  2136,  2147,  2156,  2162,  2168,  2179,
    2190,  2202,  2217,  2238,  2275,  2298,  2337,  2343,  2347,  2351,
    2355,  2361,  2371,  2388,  2396,  2400,  2404,  2412,  2422,  2428,
    2453,  2463,  2480,  2496,  2506,  2519,  2523,  2527,  2531,  2537,
    2547,  2553,  2560,  2572,  2584,  2590,  2590,  2618,  2629,  2633,
    2639,  2643,  2651,  2657,  2665,  2671,  2677,  2683,  2691,  2701,
    2705,  2709,  2713,  2717,  2721,  2725,  2729,  2733,  2737,  2741,
    2755,  2754,  2768,  2768,  2778,  2778,  2788,  2798,  2808,  2814,
    2824,  2834,  2846,  2858,  2870,  2882,  2894,  2905,  2916,  2938,
    2942,  2955,  2959,  2978,  2997,  3013,  3030,  3029,  3053,  3052,
    3075,  3093,  3111,  3110,  3144,  3143,  3171,  3170,  3197,  3220,
    3245,  3257,  3269,  3281,  3295,  3303,  3309,  3316,  3322,  3328,
    3334,  3340,  3346,  3352,  3358,  3364,  3370,  3376,  3382,  3388,
    3394,  3400,  3407,  3413,  3422,  3426,  3430,  3436,  3440,  3446,
    3451,  3478,  3482,  3490,  3494,  3500,  3506,  3518,  3522,  3530,
    3534,  3540,  3552,  3556,  3570,  3576,  3584,  3588,  3594,  3606,
    3613,  3620,  3627,  3632,  3637,  3643,  3657,  3673,  3685,  3699,
    3711,  3715,  3729,  3744,  3756,  3770,  3777,  3789,  3796,  3808,
    3814,  3820,  3827,  3840,  3859,  3863,  3869,  3873,  3881,  3889,
    3896,  3904,  3895,  3937,  3952,  3965,  3964,  3981,  3980,  3999,
    3998,  4018,  4031,  4045,  4068,  4092,  4107,  4122,  4137,  4150,
    4165,  4180,  4194,  4206,  4220,  4219,  4239,  4238,  4259,  4259,
    4284,  4284,  4308,  4312,  4320,  4326,  4334,  4349,  4353,  4361,
    4371,  4360,  4399,  4403,  4410,  4414,  4419,  4426,  4430,  4441,
    4453,  4459,  4465,  4473,  4479,  4489,  4495,  4505,  4511,  4518,
    4525,  4529,  4543,  4556,  4569,  4583,  4597,  4610,  4623,  4637,
    4649,  4659,  4671,  4670,  4688,  4699,  4698,  4716,  4725,  4729,
    4741,  4755,  4772,  4786,  4802,  4813,  4822,  4836,  4840,  4852,
    4866,  4872,  4880,  4884,  4892,  4898,  4905,  4909,  4913,  4919,
    4923,  4931,  4940,  4950,  4956,  4964,  4972,  4982,  4992,  4996,
    5002,  5006,  5022,  5038,  5051,  5064,  5068,  5072,  5076,  5089,
    5104,  5108,  5112,  5116,  5120,  5124,  5128,  5132,  5136,  5142,
    5148,  5156,  5172,  5178,  5188,  5194,  5223,  5229,  5233,  5237,
    5243,  5249,  5255,  5261,  5267,  5271,  5277,  5289,  5297,  5301,
    5309,  5319,  5329,  5344,  5357,  5361,  5371,  5375,  5383,  5396,
    5399,  5409,  5421,  5434,  5437,  5448,  5451,  5462,  5465,  5474,
    5477,  5486,  5489,  5497,  5504,  5503,  5514,  5519,  5522,  5526,
    5530,  5513,  5554,  5558,  5563,  5567,  5573,  5574,  5577,  5586,
    5587,  5588,  5589,  5592,  5601,  5605,  5616,  5622,  5628,  5634,
    5642,  5648,  5654,  5660,  5666,  5674,  5680,  5686,  5692,  5698,
    5704,  5710,  5718,  5776,  5784,  5790,  5798,  5804,  5813,  5812,
    5827,  5832,  5836,  5842,  5851,  5868,  5882,  5886,  5886,  5902,
    5914,  5921,  5928,  5934,  5939,  5944,  5958,  5974,  5986,  6000,
    6012,  6026,  6033,  6045,  6059,  6066,  6078,  6085,  6097,  6102,
    6107,  6113,  6117,  6121,  6125,  6131,  6135,  6145,  6154,  6161,
    6173,  6177,  6186,  6202,  6209,  6218,  6224,  6232,  6236,  6245,
    6249,  6257,  6261,  6267,  6277,  6287,  6297,  6310,  6323,  6327,
    6335,  6339,  6347,  6351,  6357,  6368,  6378,  6382,  6388,  6398,
    6402,  6408,  6414,  6414,  6444,  6448,  6454,  6458,  6466,  6476,
    6485,  6496,  6504,  6508,  6512,  6518,  6522,  6526,  6530,  6536,
    6540,  6544,  6550,  6554,  6560,  6564,  6570,  6574,  6581,  6584,
    6591,  6594,  6600,  6606,  6612,  6619,  6622,  6626,  6632,  6636,
    6642,  6646,  6653 ];


  // Report on the debug stream that the rule yyrule is going to be reduced.
  fn yy_reduce_print(&self, yyrule: i32, yystack: &YYStack) {
        if !self.yydebug {
            return;
        }

        let yylno = Self::yyrline_[i32_to_usize(yyrule)];
        let yynrhs = Self::yyr2_[i32_to_usize(yyrule)];
        // Print the symbols being reduced, and their result.
        self.yycdebug(&format!("Reducing stack by rule {} (line {}):", /* " fix */ yyrule - 1, yylno));

        // The symbols being reduced.
        for yyi in 0..yynrhs {
            let state: usize = i32_to_usize(yystack.state_at(i32_to_usize(yynrhs - (yyi + 1))));
            self.yy_symbol_print(
                &format!("   ${} =", yyi + 1),
                SymbolKind::get(Self::yystos_[state]),
                yystack.borrow_value_at(i32_to_usize(yynrhs - (yyi + 1))),
                yystack.location_at(i32_to_usize(yynrhs - (yyi + 1)))
            );
        }
  }

  /* YYTRANSLATE_(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
     as returned by yylex, with out-of-bounds checking.  */
  fn yytranslate_(t: i32) -> &'static SymbolKind
  {
        // Last valid token kind.
        let code_max: i32 = 407;
        if t <= 0 {
            SymbolKind::get(0)
        } else if t <= code_max {
            let t = i32_to_usize(t);
            SymbolKind::get(Self::yytranslate_table_[t])
        } else {
            SymbolKind::get(2)
        }
  }
  #[allow(non_upper_case_globals)]
const yytranslate_table_: &'static [i32] = &[      0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152 ];


const YYLAST_: i32 = 14528;
const YYEMPTY_: i32 = -2;
const YYFINAL_: i32 = 3;
const YYNTOKENS_: i32 = 153;


}

/* Unqualified %code blocks.  */
/* "src/parser.y":99  */

    // pre-code

/* "src/parser.rs":15081  */


/* "src/parser.y":6658  */


impl Parser {
    /// Constructs a parser with given `input` and `options`.
    ///
    /// Returns an error if given `input` is invalid.
    pub fn new<TInput>(input: TInput, options: ParserOptions) -> Self
    where
        TInput: Into<List<u8>>
    {
        let ParserOptions {
            buffer_name,
            debug,
            decoder,
            token_rewriter,
            record_tokens,
        } = options;

        let context = ParserContext::new();
        let current_arg_stack = CurrentArgStack::new();
        let max_numparam_stack = MaxNumparamStack::new();
        let pattern_variables = VariablesStack::new();
        let pattern_hash_keys = VariablesStack::new();
        let static_env = StaticEnvironment::new();
        let diagnostics = Diagnostics::new();

        let input: List<u8> = input.into();
        let buffer_name: StringPtr = buffer_name.into();

        let mut lexer = Lexer::new(input, buffer_name, decoder);
        lexer.context = context.clone();
        lexer.static_env = static_env.clone();
        lexer.diagnostics = diagnostics.clone();
        lexer.set_debug(debug);

        let builder = Builder::new(
            static_env.clone(),
            context.clone(),
            current_arg_stack.clone(),
            max_numparam_stack.clone(),
            pattern_variables.clone(),
            pattern_hash_keys.clone(),
            diagnostics.clone(),
        );

        let last_token_type = 0;

        Self {
            yy_error_verbose: true,
            yynerrs: 0,
            yydebug: debug_level::is_debug_parser(debug),
            yyerrstatus_: 0,
            result: MaybePtr::none(),

            builder,
            context,
            current_arg_stack,
            max_numparam_stack,
            pattern_variables,
            pattern_hash_keys,
            static_env,
            last_token_type,
            tokens: List::<Token>::new(),
            diagnostics,
            yylexer: lexer,
            token_rewriter,
            record_tokens,
        }
    }

    /// Parses given input and returns:
    ///
    /// 1. AST
    /// 2. tokens
    /// 3. diagnostics
    /// 4. coments
    /// 5. magic comments
    pub fn do_parse(mut self) -> ParserResult  {
        self.parse();

        ParserResult {
            ast: self.result,
            tokens: self.tokens,
            diagnostics: self.diagnostics.take_inner(),
            comments: self.yylexer.comments,
            magic_comments: self.yylexer.magic_comments,
            input: self.yylexer.buffer.input.decoded,
        }
    }

    #[doc(hidden)]
    pub fn do_parse_with_state_validation(mut self) -> ParserResult {
        self.parse();

        self.assert_state_is_final();

        ParserResult {
            ast: self.result,
            tokens: self.tokens,
            diagnostics: self.diagnostics.take_inner(),
            comments: self.yylexer.comments,
            magic_comments: self.yylexer.magic_comments,
            input: self.yylexer.buffer.input.decoded,
        }
    }

    fn warn(&mut self, loc: &Loc, message: DiagnosticMessage) {
        let diagnostic = Diagnostic::new(
            ErrorLevel::Warning,
            message,
            loc.clone(),
        );
        self.diagnostics.emit(diagnostic);
    }

    fn yylex(&mut self) -> Ptr<Token> {
        self.yylexer.yylex()
    }

    fn next_token(&mut self) -> Ptr<Token> {
        let mut token = self.yylex();

        if let Some(token_rewriter) = self.token_rewriter.as_option() {
            let TokenRewriterResult { rewritten_token, token_action, lex_state_action } =
                token_rewriter(token, self.yylexer.buffer.input.as_shared_bytes());

            match lex_state_action {
                LexStateAction::Set(new_state) => self.yylexer.lex_state.set(new_state),
                LexStateAction::Keep => {}
            }

            match token_action {
                RewriteAction::Drop => return self.next_token(),
                RewriteAction::Keep => token = rewritten_token
            }
        }

        self.last_token_type = token.token_type();

        if self.record_tokens {
            self.tokens.push(token.clone().unptr());
        }

        token
    }

    fn check_kwarg_name(&self, ident_t: &Token) -> Result<(), ()> {
        let name = clone_value(&ident_t);
        let first_char = name.chars().next().expect("kwarg name can't be empty");
        if first_char.is_lowercase() || first_char == '_' {
            Ok(())
        } else {
            let loc = ident_t.loc().clone();
            self.diagnostics.emit(
                Diagnostic::new(
                    ErrorLevel::Error,
                    DiagnosticMessage::ConstArgument,
                    loc
                )
            );
            Err(())
        }
    }

    fn validate_endless_method_name(&mut self, name_t: &Token) -> Result<(), ()> {
        let name = clone_value(&name_t);
        if name.ends_with('=') {
            self.yyerror(&name_t.loc(), DiagnosticMessage::EndlessSetterDefinition).map(|_| ())
        } else {
            Ok(())
        }
    }

    fn yyerror(&mut self, loc: &Loc, message: DiagnosticMessage) -> Result<i32, ()> {
        self.yyerror1(
            message,
            loc.clone()
        )
    }

    fn yyerror1(&mut self, message: DiagnosticMessage, loc: Loc) -> Result<i32, ()> {
        let diagnostic = Diagnostic::new(ErrorLevel::Error, message, loc);
        self.diagnostics.emit(diagnostic);
        Err(())
    }

    fn report_syntax_error(&mut self, ctx: &Context) {
        let id: usize = ctx.token().code().try_into().expect("failed to convert token code into i32, is it too big?");
        let diagnostic = Diagnostic::new(
            ErrorLevel::Error,
            DiagnosticMessage::UnexpectedToken { token_name: Lexer::TOKEN_NAMES[id].into() },
            ctx.location().clone(),
        );
        self.diagnostics.emit(diagnostic);
    }

    fn warn_eol(&mut self, loc: &Loc, tok: &str) {
        if self.yylexer.buffer.is_looking_at_eol() {
            self.warn(loc, DiagnosticMessage::TokAtEolWithoutExpression { token_name: tok.into() });
        }
    }

    fn value_expr(&self, node: &Node) -> Result<(), ()> {
        self.builder.value_expr(node)
    }

    #[doc(hidden)]
    fn assert_state_is_final(&self) {
        assert!(self.yylexer.cmdarg.is_empty());
        assert!(self.yylexer.cond.is_empty());
        assert!(self.yylexer.paren_nest == 0);

        assert!(self.static_env.is_empty());
        assert!(self.context.is_empty());
        assert!(self.max_numparam_stack.is_empty());
        assert!(self.current_arg_stack.is_empty());
        assert!(self.pattern_variables.is_empty());
        assert!(self.pattern_hash_keys.is_empty());
    }
}
