use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

#[cfg(feature = "compile-with-external-structures")]
use crate::containers::ExternalMaybeStringPtr;
#[cfg(feature = "compile-with-external-structures")]
type MaybeStringPtr = ExternalMaybeStringPtr;
#[cfg(not(feature = "compile-with-external-structures"))]
type MaybeStringPtr = Option<String>;


/// Represents flags of the regex literal (i.e. `mix` for `/foo/mix`)
///
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct RegOpt {
    /// A list of flags
    ///
    pub options: MaybeStringPtr,
    /// Location of the full expression
    ///
    /// ```text
    /// /foo/mix
    ///      ~~~
    /// ```
    ///
    pub expression_l: Loc,
}

impl InnerNode for RegOpt {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_chars(&self.options);
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "regopt"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expression_l.print("expression");
    }
}

