use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a special `...` argument that forwards positional/keyword/block arguments.
///
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct ForwardArg {
    /// Location of the `...`
    ///
    /// ```text
    /// def m(...); end
    ///       ~~~
    /// ```
    ///
    pub expression_l: Loc,
}

impl InnerNode for ForwardArg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "forward_arg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expression_l.print("expression");
    }
}

