// This file is auto-generated by codegen/rust/visitor.rs

use crate::nodes::*;
use crate::traverse::visitor::{Item, Visit, Visitor};
use crate::Node;

/// Trait that must be implement to observe actions
/// that are performed by `Visitor` while it traverses given `Node`.
pub trait Observer {
    /// Invoked by a `Visitor` on entering into `Alias` node.
    #[allow(unused_variables)]
    fn on_alias(&mut self, node: &Alias) {}
    /// Invoked by a `Visitor` on entering into `And` node.
    #[allow(unused_variables)]
    fn on_and(&mut self, node: &And) {}
    /// Invoked by a `Visitor` on entering into `AndAsgn` node.
    #[allow(unused_variables)]
    fn on_and_asgn(&mut self, node: &AndAsgn) {}
    /// Invoked by a `Visitor` on entering into `Arg` node.
    #[allow(unused_variables)]
    fn on_arg(&mut self, node: &Arg) {}
    /// Invoked by a `Visitor` on entering into `Args` node.
    #[allow(unused_variables)]
    fn on_args(&mut self, node: &Args) {}
    /// Invoked by a `Visitor` on entering into `Array` node.
    #[allow(unused_variables)]
    fn on_array(&mut self, node: &Array) {}
    /// Invoked by a `Visitor` on entering into `ArrayPattern` node.
    #[allow(unused_variables)]
    fn on_array_pattern(&mut self, node: &ArrayPattern) {}
    /// Invoked by a `Visitor` on entering into `ArrayPatternWithTail` node.
    #[allow(unused_variables)]
    fn on_array_pattern_with_tail(&mut self, node: &ArrayPatternWithTail) {}
    /// Invoked by a `Visitor` on entering into `BackRef` node.
    #[allow(unused_variables)]
    fn on_back_ref(&mut self, node: &BackRef) {}
    /// Invoked by a `Visitor` on entering into `Begin` node.
    #[allow(unused_variables)]
    fn on_begin(&mut self, node: &Begin) {}
    /// Invoked by a `Visitor` on entering into `Block` node.
    #[allow(unused_variables)]
    fn on_block(&mut self, node: &Block) {}
    /// Invoked by a `Visitor` on entering into `Blockarg` node.
    #[allow(unused_variables)]
    fn on_blockarg(&mut self, node: &Blockarg) {}
    /// Invoked by a `Visitor` on entering into `BlockPass` node.
    #[allow(unused_variables)]
    fn on_block_pass(&mut self, node: &BlockPass) {}
    /// Invoked by a `Visitor` on entering into `Break` node.
    #[allow(unused_variables)]
    fn on_break(&mut self, node: &Break) {}
    /// Invoked by a `Visitor` on entering into `Case` node.
    #[allow(unused_variables)]
    fn on_case(&mut self, node: &Case) {}
    /// Invoked by a `Visitor` on entering into `CaseMatch` node.
    #[allow(unused_variables)]
    fn on_case_match(&mut self, node: &CaseMatch) {}
    /// Invoked by a `Visitor` on entering into `Casgn` node.
    #[allow(unused_variables)]
    fn on_casgn(&mut self, node: &Casgn) {}
    /// Invoked by a `Visitor` on entering into `Cbase` node.
    #[allow(unused_variables)]
    fn on_cbase(&mut self, node: &Cbase) {}
    /// Invoked by a `Visitor` on entering into `Class` node.
    #[allow(unused_variables)]
    fn on_class(&mut self, node: &Class) {}
    /// Invoked by a `Visitor` on entering into `Complex` node.
    #[allow(unused_variables)]
    fn on_complex(&mut self, node: &Complex) {}
    /// Invoked by a `Visitor` on entering into `Const` node.
    #[allow(unused_variables)]
    fn on_const(&mut self, node: &Const) {}
    /// Invoked by a `Visitor` on entering into `ConstPattern` node.
    #[allow(unused_variables)]
    fn on_const_pattern(&mut self, node: &ConstPattern) {}
    /// Invoked by a `Visitor` on entering into `CSend` node.
    #[allow(unused_variables)]
    fn on_c_send(&mut self, node: &CSend) {}
    /// Invoked by a `Visitor` on entering into `Cvar` node.
    #[allow(unused_variables)]
    fn on_cvar(&mut self, node: &Cvar) {}
    /// Invoked by a `Visitor` on entering into `Cvasgn` node.
    #[allow(unused_variables)]
    fn on_cvasgn(&mut self, node: &Cvasgn) {}
    /// Invoked by a `Visitor` on entering into `Def` node.
    #[allow(unused_variables)]
    fn on_def(&mut self, node: &Def) {}
    /// Invoked by a `Visitor` on entering into `Defined` node.
    #[allow(unused_variables)]
    fn on_defined(&mut self, node: &Defined) {}
    /// Invoked by a `Visitor` on entering into `Defs` node.
    #[allow(unused_variables)]
    fn on_defs(&mut self, node: &Defs) {}
    /// Invoked by a `Visitor` on entering into `Dstr` node.
    #[allow(unused_variables)]
    fn on_dstr(&mut self, node: &Dstr) {}
    /// Invoked by a `Visitor` on entering into `Dsym` node.
    #[allow(unused_variables)]
    fn on_dsym(&mut self, node: &Dsym) {}
    /// Invoked by a `Visitor` on entering into `EFlipFlop` node.
    #[allow(unused_variables)]
    fn on_e_flip_flop(&mut self, node: &EFlipFlop) {}
    /// Invoked by a `Visitor` on entering into `EmptyElse` node.
    #[allow(unused_variables)]
    fn on_empty_else(&mut self, node: &EmptyElse) {}
    /// Invoked by a `Visitor` on entering into `Encoding` node.
    #[allow(unused_variables)]
    fn on_encoding(&mut self, node: &Encoding) {}
    /// Invoked by a `Visitor` on entering into `Ensure` node.
    #[allow(unused_variables)]
    fn on_ensure(&mut self, node: &Ensure) {}
    /// Invoked by a `Visitor` on entering into `Erange` node.
    #[allow(unused_variables)]
    fn on_erange(&mut self, node: &Erange) {}
    /// Invoked by a `Visitor` on entering into `False` node.
    #[allow(unused_variables)]
    fn on_false(&mut self, node: &False) {}
    /// Invoked by a `Visitor` on entering into `File` node.
    #[allow(unused_variables)]
    fn on_file(&mut self, node: &File) {}
    /// Invoked by a `Visitor` on entering into `FindPattern` node.
    #[allow(unused_variables)]
    fn on_find_pattern(&mut self, node: &FindPattern) {}
    /// Invoked by a `Visitor` on entering into `Float` node.
    #[allow(unused_variables)]
    fn on_float(&mut self, node: &Float) {}
    /// Invoked by a `Visitor` on entering into `For` node.
    #[allow(unused_variables)]
    fn on_for(&mut self, node: &For) {}
    /// Invoked by a `Visitor` on entering into `ForwardArg` node.
    #[allow(unused_variables)]
    fn on_forward_arg(&mut self, node: &ForwardArg) {}
    /// Invoked by a `Visitor` on entering into `ForwardedArgs` node.
    #[allow(unused_variables)]
    fn on_forwarded_args(&mut self, node: &ForwardedArgs) {}
    /// Invoked by a `Visitor` on entering into `Gvar` node.
    #[allow(unused_variables)]
    fn on_gvar(&mut self, node: &Gvar) {}
    /// Invoked by a `Visitor` on entering into `Gvasgn` node.
    #[allow(unused_variables)]
    fn on_gvasgn(&mut self, node: &Gvasgn) {}
    /// Invoked by a `Visitor` on entering into `Hash` node.
    #[allow(unused_variables)]
    fn on_hash(&mut self, node: &Hash) {}
    /// Invoked by a `Visitor` on entering into `HashPattern` node.
    #[allow(unused_variables)]
    fn on_hash_pattern(&mut self, node: &HashPattern) {}
    /// Invoked by a `Visitor` on entering into `Heredoc` node.
    #[allow(unused_variables)]
    fn on_heredoc(&mut self, node: &Heredoc) {}
    /// Invoked by a `Visitor` on entering into `If` node.
    #[allow(unused_variables)]
    fn on_if(&mut self, node: &If) {}
    /// Invoked by a `Visitor` on entering into `IfGuard` node.
    #[allow(unused_variables)]
    fn on_if_guard(&mut self, node: &IfGuard) {}
    /// Invoked by a `Visitor` on entering into `IFlipFlop` node.
    #[allow(unused_variables)]
    fn on_i_flip_flop(&mut self, node: &IFlipFlop) {}
    /// Invoked by a `Visitor` on entering into `IfMod` node.
    #[allow(unused_variables)]
    fn on_if_mod(&mut self, node: &IfMod) {}
    /// Invoked by a `Visitor` on entering into `IfTernary` node.
    #[allow(unused_variables)]
    fn on_if_ternary(&mut self, node: &IfTernary) {}
    /// Invoked by a `Visitor` on entering into `Index` node.
    #[allow(unused_variables)]
    fn on_index(&mut self, node: &Index) {}
    /// Invoked by a `Visitor` on entering into `IndexAsgn` node.
    #[allow(unused_variables)]
    fn on_index_asgn(&mut self, node: &IndexAsgn) {}
    /// Invoked by a `Visitor` on entering into `InPattern` node.
    #[allow(unused_variables)]
    fn on_in_pattern(&mut self, node: &InPattern) {}
    /// Invoked by a `Visitor` on entering into `Int` node.
    #[allow(unused_variables)]
    fn on_int(&mut self, node: &Int) {}
    /// Invoked by a `Visitor` on entering into `Irange` node.
    #[allow(unused_variables)]
    fn on_irange(&mut self, node: &Irange) {}
    /// Invoked by a `Visitor` on entering into `Ivar` node.
    #[allow(unused_variables)]
    fn on_ivar(&mut self, node: &Ivar) {}
    /// Invoked by a `Visitor` on entering into `Ivasgn` node.
    #[allow(unused_variables)]
    fn on_ivasgn(&mut self, node: &Ivasgn) {}
    /// Invoked by a `Visitor` on entering into `Kwarg` node.
    #[allow(unused_variables)]
    fn on_kwarg(&mut self, node: &Kwarg) {}
    /// Invoked by a `Visitor` on entering into `Kwargs` node.
    #[allow(unused_variables)]
    fn on_kwargs(&mut self, node: &Kwargs) {}
    /// Invoked by a `Visitor` on entering into `KwBegin` node.
    #[allow(unused_variables)]
    fn on_kw_begin(&mut self, node: &KwBegin) {}
    /// Invoked by a `Visitor` on entering into `Kwnilarg` node.
    #[allow(unused_variables)]
    fn on_kwnilarg(&mut self, node: &Kwnilarg) {}
    /// Invoked by a `Visitor` on entering into `Kwoptarg` node.
    #[allow(unused_variables)]
    fn on_kwoptarg(&mut self, node: &Kwoptarg) {}
    /// Invoked by a `Visitor` on entering into `Kwrestarg` node.
    #[allow(unused_variables)]
    fn on_kwrestarg(&mut self, node: &Kwrestarg) {}
    /// Invoked by a `Visitor` on entering into `Kwsplat` node.
    #[allow(unused_variables)]
    fn on_kwsplat(&mut self, node: &Kwsplat) {}
    /// Invoked by a `Visitor` on entering into `Lambda` node.
    #[allow(unused_variables)]
    fn on_lambda(&mut self, node: &Lambda) {}
    /// Invoked by a `Visitor` on entering into `Line` node.
    #[allow(unused_variables)]
    fn on_line(&mut self, node: &Line) {}
    /// Invoked by a `Visitor` on entering into `Lvar` node.
    #[allow(unused_variables)]
    fn on_lvar(&mut self, node: &Lvar) {}
    /// Invoked by a `Visitor` on entering into `Lvasgn` node.
    #[allow(unused_variables)]
    fn on_lvasgn(&mut self, node: &Lvasgn) {}
    /// Invoked by a `Visitor` on entering into `Masgn` node.
    #[allow(unused_variables)]
    fn on_masgn(&mut self, node: &Masgn) {}
    /// Invoked by a `Visitor` on entering into `MatchAlt` node.
    #[allow(unused_variables)]
    fn on_match_alt(&mut self, node: &MatchAlt) {}
    /// Invoked by a `Visitor` on entering into `MatchAs` node.
    #[allow(unused_variables)]
    fn on_match_as(&mut self, node: &MatchAs) {}
    /// Invoked by a `Visitor` on entering into `MatchCurrentLine` node.
    #[allow(unused_variables)]
    fn on_match_current_line(&mut self, node: &MatchCurrentLine) {}
    /// Invoked by a `Visitor` on entering into `MatchNilPattern` node.
    #[allow(unused_variables)]
    fn on_match_nil_pattern(&mut self, node: &MatchNilPattern) {}
    /// Invoked by a `Visitor` on entering into `MatchPattern` node.
    #[allow(unused_variables)]
    fn on_match_pattern(&mut self, node: &MatchPattern) {}
    /// Invoked by a `Visitor` on entering into `MatchPatternP` node.
    #[allow(unused_variables)]
    fn on_match_pattern_p(&mut self, node: &MatchPatternP) {}
    /// Invoked by a `Visitor` on entering into `MatchRest` node.
    #[allow(unused_variables)]
    fn on_match_rest(&mut self, node: &MatchRest) {}
    /// Invoked by a `Visitor` on entering into `MatchVar` node.
    #[allow(unused_variables)]
    fn on_match_var(&mut self, node: &MatchVar) {}
    /// Invoked by a `Visitor` on entering into `MatchWithLvasgn` node.
    #[allow(unused_variables)]
    fn on_match_with_lvasgn(&mut self, node: &MatchWithLvasgn) {}
    /// Invoked by a `Visitor` on entering into `Mlhs` node.
    #[allow(unused_variables)]
    fn on_mlhs(&mut self, node: &Mlhs) {}
    /// Invoked by a `Visitor` on entering into `Module` node.
    #[allow(unused_variables)]
    fn on_module(&mut self, node: &Module) {}
    /// Invoked by a `Visitor` on entering into `Next` node.
    #[allow(unused_variables)]
    fn on_next(&mut self, node: &Next) {}
    /// Invoked by a `Visitor` on entering into `Nil` node.
    #[allow(unused_variables)]
    fn on_nil(&mut self, node: &Nil) {}
    /// Invoked by a `Visitor` on entering into `NthRef` node.
    #[allow(unused_variables)]
    fn on_nth_ref(&mut self, node: &NthRef) {}
    /// Invoked by a `Visitor` on entering into `Numblock` node.
    #[allow(unused_variables)]
    fn on_numblock(&mut self, node: &Numblock) {}
    /// Invoked by a `Visitor` on entering into `OpAsgn` node.
    #[allow(unused_variables)]
    fn on_op_asgn(&mut self, node: &OpAsgn) {}
    /// Invoked by a `Visitor` on entering into `Optarg` node.
    #[allow(unused_variables)]
    fn on_optarg(&mut self, node: &Optarg) {}
    /// Invoked by a `Visitor` on entering into `Or` node.
    #[allow(unused_variables)]
    fn on_or(&mut self, node: &Or) {}
    /// Invoked by a `Visitor` on entering into `OrAsgn` node.
    #[allow(unused_variables)]
    fn on_or_asgn(&mut self, node: &OrAsgn) {}
    /// Invoked by a `Visitor` on entering into `Pair` node.
    #[allow(unused_variables)]
    fn on_pair(&mut self, node: &Pair) {}
    /// Invoked by a `Visitor` on entering into `Pin` node.
    #[allow(unused_variables)]
    fn on_pin(&mut self, node: &Pin) {}
    /// Invoked by a `Visitor` on entering into `Postexe` node.
    #[allow(unused_variables)]
    fn on_postexe(&mut self, node: &Postexe) {}
    /// Invoked by a `Visitor` on entering into `Preexe` node.
    #[allow(unused_variables)]
    fn on_preexe(&mut self, node: &Preexe) {}
    /// Invoked by a `Visitor` on entering into `Procarg0` node.
    #[allow(unused_variables)]
    fn on_procarg0(&mut self, node: &Procarg0) {}
    /// Invoked by a `Visitor` on entering into `Rational` node.
    #[allow(unused_variables)]
    fn on_rational(&mut self, node: &Rational) {}
    /// Invoked by a `Visitor` on entering into `Redo` node.
    #[allow(unused_variables)]
    fn on_redo(&mut self, node: &Redo) {}
    /// Invoked by a `Visitor` on entering into `Regexp` node.
    #[allow(unused_variables)]
    fn on_regexp(&mut self, node: &Regexp) {}
    /// Invoked by a `Visitor` on entering into `RegOpt` node.
    #[allow(unused_variables)]
    fn on_reg_opt(&mut self, node: &RegOpt) {}
    /// Invoked by a `Visitor` on entering into `Rescue` node.
    #[allow(unused_variables)]
    fn on_rescue(&mut self, node: &Rescue) {}
    /// Invoked by a `Visitor` on entering into `RescueBody` node.
    #[allow(unused_variables)]
    fn on_rescue_body(&mut self, node: &RescueBody) {}
    /// Invoked by a `Visitor` on entering into `Restarg` node.
    #[allow(unused_variables)]
    fn on_restarg(&mut self, node: &Restarg) {}
    /// Invoked by a `Visitor` on entering into `Retry` node.
    #[allow(unused_variables)]
    fn on_retry(&mut self, node: &Retry) {}
    /// Invoked by a `Visitor` on entering into `Return` node.
    #[allow(unused_variables)]
    fn on_return(&mut self, node: &Return) {}
    /// Invoked by a `Visitor` on entering into `SClass` node.
    #[allow(unused_variables)]
    fn on_s_class(&mut self, node: &SClass) {}
    /// Invoked by a `Visitor` on entering into `Self_` node.
    #[allow(unused_variables)]
    fn on_self_(&mut self, node: &Self_) {}
    /// Invoked by a `Visitor` on entering into `Send` node.
    #[allow(unused_variables)]
    fn on_send(&mut self, node: &Send) {}
    /// Invoked by a `Visitor` on entering into `Shadowarg` node.
    #[allow(unused_variables)]
    fn on_shadowarg(&mut self, node: &Shadowarg) {}
    /// Invoked by a `Visitor` on entering into `Splat` node.
    #[allow(unused_variables)]
    fn on_splat(&mut self, node: &Splat) {}
    /// Invoked by a `Visitor` on entering into `Str` node.
    #[allow(unused_variables)]
    fn on_str(&mut self, node: &Str) {}
    /// Invoked by a `Visitor` on entering into `Super` node.
    #[allow(unused_variables)]
    fn on_super(&mut self, node: &Super) {}
    /// Invoked by a `Visitor` on entering into `Sym` node.
    #[allow(unused_variables)]
    fn on_sym(&mut self, node: &Sym) {}
    /// Invoked by a `Visitor` on entering into `True` node.
    #[allow(unused_variables)]
    fn on_true(&mut self, node: &True) {}
    /// Invoked by a `Visitor` on entering into `Undef` node.
    #[allow(unused_variables)]
    fn on_undef(&mut self, node: &Undef) {}
    /// Invoked by a `Visitor` on entering into `UnlessGuard` node.
    #[allow(unused_variables)]
    fn on_unless_guard(&mut self, node: &UnlessGuard) {}
    /// Invoked by a `Visitor` on entering into `Until` node.
    #[allow(unused_variables)]
    fn on_until(&mut self, node: &Until) {}
    /// Invoked by a `Visitor` on entering into `UntilPost` node.
    #[allow(unused_variables)]
    fn on_until_post(&mut self, node: &UntilPost) {}
    /// Invoked by a `Visitor` on entering into `When` node.
    #[allow(unused_variables)]
    fn on_when(&mut self, node: &When) {}
    /// Invoked by a `Visitor` on entering into `While` node.
    #[allow(unused_variables)]
    fn on_while(&mut self, node: &While) {}
    /// Invoked by a `Visitor` on entering into `WhilePost` node.
    #[allow(unused_variables)]
    fn on_while_post(&mut self, node: &WhilePost) {}
    /// Invoked by a `Visitor` on entering into `XHeredoc` node.
    #[allow(unused_variables)]
    fn on_x_heredoc(&mut self, node: &XHeredoc) {}
    /// Invoked by a `Visitor` on entering into `Xstr` node.
    #[allow(unused_variables)]
    fn on_xstr(&mut self, node: &Xstr) {}
    /// Invoked by a `Visitor` on entering into `Yield` node.
    #[allow(unused_variables)]
    fn on_yield(&mut self, node: &Yield) {}
    /// Invoked by a `Visitor` on entering into `ZSuper` node.
    #[allow(unused_variables)]
    fn on_z_super(&mut self, node: &ZSuper) {}


    /// Caled when entering any `Node`
    #[allow(unused_variables)]
    fn on_node(&mut self, node: &Node) {}

    /// Called when exiting any `Node`
    #[allow(unused_variables)]
    fn on_node_moving_up(&mut self, node: &Node) {}

    /// Called when entering any optional `Node`
    #[allow(unused_variables)]
    fn on_option_node(&mut self, node: &Option<Box<Node>>) {}

    /// Called when entering any `Vec<Node>`
    #[allow(unused_variables)]
    fn on_node_list(&mut self, nodes: &[Node]) {}

    /// Called when entering any AST node,
    /// `subitem` is different for different `Node` fields,
    /// check documentation of `traverse::visitor::Item`
    #[allow(unused_variables)]
    fn on_subitem(&mut self, subitem: Item) {}

    /// Called when exiting any AST node,
    /// `subitem` is different for different `Node` fields,
    /// check documentation of `traverse::visitor::Item`
    #[allow(unused_variables)]
    fn on_subitem_moving_up(&mut self, subitem: Item) {}
}

impl<TObserver: Observer> Visit<&Node> for Visitor<TObserver> {
    fn visit(&mut self, node: &Node, visit_as: Item) {
        self.observer.on_subitem(visit_as);
        self.observer.on_node(node);

        match node {
            Node::Alias(inner) => {
                self.visit_alias(inner)
            }
            Node::And(inner) => {
                self.visit_and(inner)
            }
            Node::AndAsgn(inner) => {
                self.visit_and_asgn(inner)
            }
            Node::Arg(inner) => {
                self.visit_arg(inner)
            }
            Node::Args(inner) => {
                self.visit_args(inner)
            }
            Node::Array(inner) => {
                self.visit_array(inner)
            }
            Node::ArrayPattern(inner) => {
                self.visit_array_pattern(inner)
            }
            Node::ArrayPatternWithTail(inner) => {
                self.visit_array_pattern_with_tail(inner)
            }
            Node::BackRef(inner) => {
                self.visit_back_ref(inner)
            }
            Node::Begin(inner) => {
                self.visit_begin(inner)
            }
            Node::Block(inner) => {
                self.visit_block(inner)
            }
            Node::Blockarg(inner) => {
                self.visit_blockarg(inner)
            }
            Node::BlockPass(inner) => {
                self.visit_block_pass(inner)
            }
            Node::Break(inner) => {
                self.visit_break(inner)
            }
            Node::Case(inner) => {
                self.visit_case(inner)
            }
            Node::CaseMatch(inner) => {
                self.visit_case_match(inner)
            }
            Node::Casgn(inner) => {
                self.visit_casgn(inner)
            }
            Node::Cbase(inner) => {
                self.visit_cbase(inner)
            }
            Node::Class(inner) => {
                self.visit_class(inner)
            }
            Node::Complex(inner) => {
                self.visit_complex(inner)
            }
            Node::Const(inner) => {
                self.visit_const(inner)
            }
            Node::ConstPattern(inner) => {
                self.visit_const_pattern(inner)
            }
            Node::CSend(inner) => {
                self.visit_c_send(inner)
            }
            Node::Cvar(inner) => {
                self.visit_cvar(inner)
            }
            Node::Cvasgn(inner) => {
                self.visit_cvasgn(inner)
            }
            Node::Def(inner) => {
                self.visit_def(inner)
            }
            Node::Defined(inner) => {
                self.visit_defined(inner)
            }
            Node::Defs(inner) => {
                self.visit_defs(inner)
            }
            Node::Dstr(inner) => {
                self.visit_dstr(inner)
            }
            Node::Dsym(inner) => {
                self.visit_dsym(inner)
            }
            Node::EFlipFlop(inner) => {
                self.visit_e_flip_flop(inner)
            }
            Node::EmptyElse(inner) => {
                self.visit_empty_else(inner)
            }
            Node::Encoding(inner) => {
                self.visit_encoding(inner)
            }
            Node::Ensure(inner) => {
                self.visit_ensure(inner)
            }
            Node::Erange(inner) => {
                self.visit_erange(inner)
            }
            Node::False(inner) => {
                self.visit_false(inner)
            }
            Node::File(inner) => {
                self.visit_file(inner)
            }
            Node::FindPattern(inner) => {
                self.visit_find_pattern(inner)
            }
            Node::Float(inner) => {
                self.visit_float(inner)
            }
            Node::For(inner) => {
                self.visit_for(inner)
            }
            Node::ForwardArg(inner) => {
                self.visit_forward_arg(inner)
            }
            Node::ForwardedArgs(inner) => {
                self.visit_forwarded_args(inner)
            }
            Node::Gvar(inner) => {
                self.visit_gvar(inner)
            }
            Node::Gvasgn(inner) => {
                self.visit_gvasgn(inner)
            }
            Node::Hash(inner) => {
                self.visit_hash(inner)
            }
            Node::HashPattern(inner) => {
                self.visit_hash_pattern(inner)
            }
            Node::Heredoc(inner) => {
                self.visit_heredoc(inner)
            }
            Node::If(inner) => {
                self.visit_if(inner)
            }
            Node::IfGuard(inner) => {
                self.visit_if_guard(inner)
            }
            Node::IFlipFlop(inner) => {
                self.visit_i_flip_flop(inner)
            }
            Node::IfMod(inner) => {
                self.visit_if_mod(inner)
            }
            Node::IfTernary(inner) => {
                self.visit_if_ternary(inner)
            }
            Node::Index(inner) => {
                self.visit_index(inner)
            }
            Node::IndexAsgn(inner) => {
                self.visit_index_asgn(inner)
            }
            Node::InPattern(inner) => {
                self.visit_in_pattern(inner)
            }
            Node::Int(inner) => {
                self.visit_int(inner)
            }
            Node::Irange(inner) => {
                self.visit_irange(inner)
            }
            Node::Ivar(inner) => {
                self.visit_ivar(inner)
            }
            Node::Ivasgn(inner) => {
                self.visit_ivasgn(inner)
            }
            Node::Kwarg(inner) => {
                self.visit_kwarg(inner)
            }
            Node::Kwargs(inner) => {
                self.visit_kwargs(inner)
            }
            Node::KwBegin(inner) => {
                self.visit_kw_begin(inner)
            }
            Node::Kwnilarg(inner) => {
                self.visit_kwnilarg(inner)
            }
            Node::Kwoptarg(inner) => {
                self.visit_kwoptarg(inner)
            }
            Node::Kwrestarg(inner) => {
                self.visit_kwrestarg(inner)
            }
            Node::Kwsplat(inner) => {
                self.visit_kwsplat(inner)
            }
            Node::Lambda(inner) => {
                self.visit_lambda(inner)
            }
            Node::Line(inner) => {
                self.visit_line(inner)
            }
            Node::Lvar(inner) => {
                self.visit_lvar(inner)
            }
            Node::Lvasgn(inner) => {
                self.visit_lvasgn(inner)
            }
            Node::Masgn(inner) => {
                self.visit_masgn(inner)
            }
            Node::MatchAlt(inner) => {
                self.visit_match_alt(inner)
            }
            Node::MatchAs(inner) => {
                self.visit_match_as(inner)
            }
            Node::MatchCurrentLine(inner) => {
                self.visit_match_current_line(inner)
            }
            Node::MatchNilPattern(inner) => {
                self.visit_match_nil_pattern(inner)
            }
            Node::MatchPattern(inner) => {
                self.visit_match_pattern(inner)
            }
            Node::MatchPatternP(inner) => {
                self.visit_match_pattern_p(inner)
            }
            Node::MatchRest(inner) => {
                self.visit_match_rest(inner)
            }
            Node::MatchVar(inner) => {
                self.visit_match_var(inner)
            }
            Node::MatchWithLvasgn(inner) => {
                self.visit_match_with_lvasgn(inner)
            }
            Node::Mlhs(inner) => {
                self.visit_mlhs(inner)
            }
            Node::Module(inner) => {
                self.visit_module(inner)
            }
            Node::Next(inner) => {
                self.visit_next(inner)
            }
            Node::Nil(inner) => {
                self.visit_nil(inner)
            }
            Node::NthRef(inner) => {
                self.visit_nth_ref(inner)
            }
            Node::Numblock(inner) => {
                self.visit_numblock(inner)
            }
            Node::OpAsgn(inner) => {
                self.visit_op_asgn(inner)
            }
            Node::Optarg(inner) => {
                self.visit_optarg(inner)
            }
            Node::Or(inner) => {
                self.visit_or(inner)
            }
            Node::OrAsgn(inner) => {
                self.visit_or_asgn(inner)
            }
            Node::Pair(inner) => {
                self.visit_pair(inner)
            }
            Node::Pin(inner) => {
                self.visit_pin(inner)
            }
            Node::Postexe(inner) => {
                self.visit_postexe(inner)
            }
            Node::Preexe(inner) => {
                self.visit_preexe(inner)
            }
            Node::Procarg0(inner) => {
                self.visit_procarg0(inner)
            }
            Node::Rational(inner) => {
                self.visit_rational(inner)
            }
            Node::Redo(inner) => {
                self.visit_redo(inner)
            }
            Node::Regexp(inner) => {
                self.visit_regexp(inner)
            }
            Node::RegOpt(inner) => {
                self.visit_reg_opt(inner)
            }
            Node::Rescue(inner) => {
                self.visit_rescue(inner)
            }
            Node::RescueBody(inner) => {
                self.visit_rescue_body(inner)
            }
            Node::Restarg(inner) => {
                self.visit_restarg(inner)
            }
            Node::Retry(inner) => {
                self.visit_retry(inner)
            }
            Node::Return(inner) => {
                self.visit_return(inner)
            }
            Node::SClass(inner) => {
                self.visit_s_class(inner)
            }
            Node::Self_(inner) => {
                self.visit_self_(inner)
            }
            Node::Send(inner) => {
                self.visit_send(inner)
            }
            Node::Shadowarg(inner) => {
                self.visit_shadowarg(inner)
            }
            Node::Splat(inner) => {
                self.visit_splat(inner)
            }
            Node::Str(inner) => {
                self.visit_str(inner)
            }
            Node::Super(inner) => {
                self.visit_super(inner)
            }
            Node::Sym(inner) => {
                self.visit_sym(inner)
            }
            Node::True(inner) => {
                self.visit_true(inner)
            }
            Node::Undef(inner) => {
                self.visit_undef(inner)
            }
            Node::UnlessGuard(inner) => {
                self.visit_unless_guard(inner)
            }
            Node::Until(inner) => {
                self.visit_until(inner)
            }
            Node::UntilPost(inner) => {
                self.visit_until_post(inner)
            }
            Node::When(inner) => {
                self.visit_when(inner)
            }
            Node::While(inner) => {
                self.visit_while(inner)
            }
            Node::WhilePost(inner) => {
                self.visit_while_post(inner)
            }
            Node::XHeredoc(inner) => {
                self.visit_x_heredoc(inner)
            }
            Node::Xstr(inner) => {
                self.visit_xstr(inner)
            }
            Node::Yield(inner) => {
                self.visit_yield(inner)
            }
            Node::ZSuper(inner) => {
                self.visit_z_super(inner)
            }

        }

        self.observer.on_node_moving_up(node);
        self.observer.on_subitem_moving_up(visit_as);
    }
}

impl<T> Visitor<T>
where
    T: Observer,
{
    fn visit_alias(&mut self, node: &Alias) {
        self.observer.on_alias(node);

        self.visit(&node.to, Item::To);
        self.visit(&node.from, Item::From);
        // skip keyword_l
        // skip expression_l
    }
    fn visit_and(&mut self, node: &And) {
        self.observer.on_and(node);

        self.visit(&node.lhs, Item::Lhs);
        self.visit(&node.rhs, Item::Rhs);
        // skip operator_l
        // skip expression_l
    }
    fn visit_and_asgn(&mut self, node: &AndAsgn) {
        self.observer.on_and_asgn(node);

        self.visit(&node.recv, Item::Recv);
        self.visit(&node.value, Item::Value);
        // skip operator_l
        // skip expression_l
    }
    fn visit_arg(&mut self, node: &Arg) {
        self.observer.on_arg(node);

        // skip name
        // skip expression_l
    }
    fn visit_args(&mut self, node: &Args) {
        self.observer.on_args(node);

        self.visit(&node.args, Item::Arglist);
        // skip expression_l
        // skip begin_l
        // skip end_l
    }
    fn visit_array(&mut self, node: &Array) {
        self.observer.on_array(node);

        self.visit(&node.elements, Item::Elements);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_array_pattern(&mut self, node: &ArrayPattern) {
        self.observer.on_array_pattern(node);

        self.visit(&node.elements, Item::Elements);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_array_pattern_with_tail(&mut self, node: &ArrayPatternWithTail) {
        self.observer.on_array_pattern_with_tail(node);

        self.visit(&node.elements, Item::Elements);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_back_ref(&mut self, node: &BackRef) {
        self.observer.on_back_ref(node);

        // skip name
        // skip expression_l
    }
    fn visit_begin(&mut self, node: &Begin) {
        self.observer.on_begin(node);

        self.visit(&node.statements, Item::Stmts);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_block(&mut self, node: &Block) {
        self.observer.on_block(node);

        self.visit(&node.call, Item::MethodCall);
        self.visit(&node.args, Item::Args);
        self.visit(&node.body, Item::Body);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_blockarg(&mut self, node: &Blockarg) {
        self.observer.on_blockarg(node);

        // skip name
        // skip operator_l
        // skip name_l
        // skip expression_l
    }
    fn visit_block_pass(&mut self, node: &BlockPass) {
        self.observer.on_block_pass(node);

        self.visit(&node.value, Item::Value);
        // skip operator_l
        // skip expression_l
    }
    fn visit_break(&mut self, node: &Break) {
        self.observer.on_break(node);

        self.visit(&node.args, Item::Args);
        // skip keyword_l
        // skip expression_l
    }
    fn visit_case(&mut self, node: &Case) {
        self.observer.on_case(node);

        self.visit(&node.expr, Item::Expr);
        self.visit(&node.when_bodies, Item::WhenBodies);
        self.visit(&node.else_body, Item::ElseBody);
        // skip keyword_l
        // skip else_l
        // skip end_l
        // skip expression_l
    }
    fn visit_case_match(&mut self, node: &CaseMatch) {
        self.observer.on_case_match(node);

        self.visit(&node.expr, Item::Expr);
        self.visit(&node.in_bodies, Item::InBodies);
        self.visit(&node.else_body, Item::ElseBody);
        // skip keyword_l
        // skip else_l
        // skip end_l
        // skip expression_l
    }
    fn visit_casgn(&mut self, node: &Casgn) {
        self.observer.on_casgn(node);

        self.visit(&node.scope, Item::Scope);
        // skip name
        self.visit(&node.value, Item::Value);
        // skip double_colon_l
        // skip name_l
        // skip operator_l
        // skip expression_l
    }
    fn visit_cbase(&mut self, node: &Cbase) {
        self.observer.on_cbase(node);

        // skip expression_l
    }
    fn visit_class(&mut self, node: &Class) {
        self.observer.on_class(node);

        self.visit(&node.name, Item::Name);
        self.visit(&node.superclass, Item::Superclass);
        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip operator_l
        // skip end_l
        // skip expression_l
    }
    fn visit_complex(&mut self, node: &Complex) {
        self.observer.on_complex(node);

        // skip value
        // skip operator_l
        // skip expression_l
    }
    fn visit_const(&mut self, node: &Const) {
        self.observer.on_const(node);

        self.visit(&node.scope, Item::Scope);
        // skip name
        // skip double_colon_l
        // skip name_l
        // skip expression_l
    }
    fn visit_const_pattern(&mut self, node: &ConstPattern) {
        self.observer.on_const_pattern(node);

        self.visit(&node.const_, Item::Const);
        self.visit(&node.pattern, Item::Pattern);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_c_send(&mut self, node: &CSend) {
        self.observer.on_c_send(node);

        self.visit(&node.recv, Item::Recv);
        // skip method_name
        self.visit(&node.args, Item::Args);
        // skip dot_l
        // skip selector_l
        // skip begin_l
        // skip end_l
        // skip operator_l
        // skip expression_l
    }
    fn visit_cvar(&mut self, node: &Cvar) {
        self.observer.on_cvar(node);

        // skip name
        // skip expression_l
    }
    fn visit_cvasgn(&mut self, node: &Cvasgn) {
        self.observer.on_cvasgn(node);

        // skip name
        self.visit(&node.value, Item::Value);
        // skip name_l
        // skip operator_l
        // skip expression_l
    }
    fn visit_def(&mut self, node: &Def) {
        self.observer.on_def(node);

        // skip name
        self.visit(&node.args, Item::Args);
        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip name_l
        // skip end_l
        // skip assignment_l
        // skip expression_l
    }
    fn visit_defined(&mut self, node: &Defined) {
        self.observer.on_defined(node);

        self.visit(&node.value, Item::Value);
        // skip keyword_l
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_defs(&mut self, node: &Defs) {
        self.observer.on_defs(node);

        self.visit(&node.definee, Item::Definee);
        // skip name
        self.visit(&node.args, Item::Args);
        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip operator_l
        // skip name_l
        // skip assignment_l
        // skip end_l
        // skip expression_l
    }
    fn visit_dstr(&mut self, node: &Dstr) {
        self.observer.on_dstr(node);

        self.visit(&node.parts, Item::Parts);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_dsym(&mut self, node: &Dsym) {
        self.observer.on_dsym(node);

        self.visit(&node.parts, Item::Parts);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_e_flip_flop(&mut self, node: &EFlipFlop) {
        self.observer.on_e_flip_flop(node);

        self.visit(&node.left, Item::Left);
        self.visit(&node.right, Item::Right);
        // skip operator_l
        // skip expression_l
    }
    fn visit_empty_else(&mut self, node: &EmptyElse) {
        self.observer.on_empty_else(node);

        // skip expression_l
    }
    fn visit_encoding(&mut self, node: &Encoding) {
        self.observer.on_encoding(node);

        // skip expression_l
    }
    fn visit_ensure(&mut self, node: &Ensure) {
        self.observer.on_ensure(node);

        self.visit(&node.body, Item::Body);
        self.visit(&node.ensure, Item::Ensure);
        // skip keyword_l
        // skip expression_l
    }
    fn visit_erange(&mut self, node: &Erange) {
        self.observer.on_erange(node);

        self.visit(&node.left, Item::Left);
        self.visit(&node.right, Item::Right);
        // skip operator_l
        // skip expression_l
    }
    fn visit_false(&mut self, node: &False) {
        self.observer.on_false(node);

        // skip expression_l
    }
    fn visit_file(&mut self, node: &File) {
        self.observer.on_file(node);

        // skip expression_l
    }
    fn visit_find_pattern(&mut self, node: &FindPattern) {
        self.observer.on_find_pattern(node);

        self.visit(&node.elements, Item::Elements);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_float(&mut self, node: &Float) {
        self.observer.on_float(node);

        // skip value
        // skip operator_l
        // skip expression_l
    }
    fn visit_for(&mut self, node: &For) {
        self.observer.on_for(node);

        self.visit(&node.iterator, Item::Iterator);
        self.visit(&node.iteratee, Item::Iteratee);
        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip operator_l
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_forward_arg(&mut self, node: &ForwardArg) {
        self.observer.on_forward_arg(node);

        // skip expression_l
    }
    fn visit_forwarded_args(&mut self, node: &ForwardedArgs) {
        self.observer.on_forwarded_args(node);

        // skip expression_l
    }
    fn visit_gvar(&mut self, node: &Gvar) {
        self.observer.on_gvar(node);

        // skip name
        // skip expression_l
    }
    fn visit_gvasgn(&mut self, node: &Gvasgn) {
        self.observer.on_gvasgn(node);

        // skip name
        self.visit(&node.value, Item::Value);
        // skip name_l
        // skip operator_l
        // skip expression_l
    }
    fn visit_hash(&mut self, node: &Hash) {
        self.observer.on_hash(node);

        self.visit(&node.pairs, Item::Pairs);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_hash_pattern(&mut self, node: &HashPattern) {
        self.observer.on_hash_pattern(node);

        self.visit(&node.elements, Item::Elements);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_heredoc(&mut self, node: &Heredoc) {
        self.observer.on_heredoc(node);

        self.visit(&node.parts, Item::Parts);
        // skip heredoc_body_l
        // skip heredoc_end_l
        // skip expression_l
    }
    fn visit_if(&mut self, node: &If) {
        self.observer.on_if(node);

        self.visit(&node.cond, Item::Cond);
        self.visit(&node.if_true, Item::IfTrue);
        self.visit(&node.if_false, Item::IfFalse);
        // skip keyword_l
        // skip begin_l
        // skip else_l
        // skip end_l
        // skip expression_l
    }
    fn visit_if_guard(&mut self, node: &IfGuard) {
        self.observer.on_if_guard(node);

        self.visit(&node.cond, Item::Cond);
        // skip keyword_l
        // skip expression_l
    }
    fn visit_i_flip_flop(&mut self, node: &IFlipFlop) {
        self.observer.on_i_flip_flop(node);

        self.visit(&node.left, Item::Left);
        self.visit(&node.right, Item::Right);
        // skip operator_l
        // skip expression_l
    }
    fn visit_if_mod(&mut self, node: &IfMod) {
        self.observer.on_if_mod(node);

        self.visit(&node.cond, Item::Cond);
        self.visit(&node.if_true, Item::IfTrue);
        self.visit(&node.if_false, Item::IfFalse);
        // skip keyword_l
        // skip expression_l
    }
    fn visit_if_ternary(&mut self, node: &IfTernary) {
        self.observer.on_if_ternary(node);

        self.visit(&node.cond, Item::Cond);
        self.visit(&node.if_true, Item::IfTrue);
        self.visit(&node.if_false, Item::IfFalse);
        // skip question_l
        // skip colon_l
        // skip expression_l
    }
    fn visit_index(&mut self, node: &Index) {
        self.observer.on_index(node);

        self.visit(&node.recv, Item::Recv);
        self.visit(&node.indexes, Item::Indexes);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_index_asgn(&mut self, node: &IndexAsgn) {
        self.observer.on_index_asgn(node);

        self.visit(&node.recv, Item::Recv);
        self.visit(&node.indexes, Item::Indexes);
        self.visit(&node.value, Item::Value);
        // skip begin_l
        // skip end_l
        // skip operator_l
        // skip expression_l
    }
    fn visit_in_pattern(&mut self, node: &InPattern) {
        self.observer.on_in_pattern(node);

        self.visit(&node.pattern, Item::Pattern);
        self.visit(&node.guard, Item::Guard);
        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip begin_l
        // skip expression_l
    }
    fn visit_int(&mut self, node: &Int) {
        self.observer.on_int(node);

        // skip value
        // skip operator_l
        // skip expression_l
    }
    fn visit_irange(&mut self, node: &Irange) {
        self.observer.on_irange(node);

        self.visit(&node.left, Item::Left);
        self.visit(&node.right, Item::Right);
        // skip operator_l
        // skip expression_l
    }
    fn visit_ivar(&mut self, node: &Ivar) {
        self.observer.on_ivar(node);

        // skip name
        // skip expression_l
    }
    fn visit_ivasgn(&mut self, node: &Ivasgn) {
        self.observer.on_ivasgn(node);

        // skip name
        self.visit(&node.value, Item::Value);
        // skip name_l
        // skip operator_l
        // skip expression_l
    }
    fn visit_kwarg(&mut self, node: &Kwarg) {
        self.observer.on_kwarg(node);

        // skip name
        // skip name_l
        // skip expression_l
    }
    fn visit_kwargs(&mut self, node: &Kwargs) {
        self.observer.on_kwargs(node);

        self.visit(&node.pairs, Item::Pairs);
        // skip expression_l
    }
    fn visit_kw_begin(&mut self, node: &KwBegin) {
        self.observer.on_kw_begin(node);

        self.visit(&node.statements, Item::Stmts);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_kwnilarg(&mut self, node: &Kwnilarg) {
        self.observer.on_kwnilarg(node);

        // skip name_l
        // skip expression_l
    }
    fn visit_kwoptarg(&mut self, node: &Kwoptarg) {
        self.observer.on_kwoptarg(node);

        // skip name
        self.visit(&node.default, Item::DefaultValue);
        // skip name_l
        // skip expression_l
    }
    fn visit_kwrestarg(&mut self, node: &Kwrestarg) {
        self.observer.on_kwrestarg(node);

        // skip name
        // skip operator_l
        // skip name_l
        // skip expression_l
    }
    fn visit_kwsplat(&mut self, node: &Kwsplat) {
        self.observer.on_kwsplat(node);

        self.visit(&node.value, Item::Value);
        // skip operator_l
        // skip expression_l
    }
    fn visit_lambda(&mut self, node: &Lambda) {
        self.observer.on_lambda(node);

        // skip expression_l
    }
    fn visit_line(&mut self, node: &Line) {
        self.observer.on_line(node);

        // skip expression_l
    }
    fn visit_lvar(&mut self, node: &Lvar) {
        self.observer.on_lvar(node);

        // skip name
        // skip expression_l
    }
    fn visit_lvasgn(&mut self, node: &Lvasgn) {
        self.observer.on_lvasgn(node);

        // skip name
        self.visit(&node.value, Item::Value);
        // skip name_l
        // skip operator_l
        // skip expression_l
    }
    fn visit_masgn(&mut self, node: &Masgn) {
        self.observer.on_masgn(node);

        self.visit(&node.lhs, Item::Lhs);
        self.visit(&node.rhs, Item::Rhs);
        // skip operator_l
        // skip expression_l
    }
    fn visit_match_alt(&mut self, node: &MatchAlt) {
        self.observer.on_match_alt(node);

        self.visit(&node.lhs, Item::Lhs);
        self.visit(&node.rhs, Item::Rhs);
        // skip operator_l
        // skip expression_l
    }
    fn visit_match_as(&mut self, node: &MatchAs) {
        self.observer.on_match_as(node);

        self.visit(&node.value, Item::Value);
        self.visit(&node.as_, Item::As);
        // skip operator_l
        // skip expression_l
    }
    fn visit_match_current_line(&mut self, node: &MatchCurrentLine) {
        self.observer.on_match_current_line(node);

        self.visit(&node.re, Item::Re);
        // skip expression_l
    }
    fn visit_match_nil_pattern(&mut self, node: &MatchNilPattern) {
        self.observer.on_match_nil_pattern(node);

        // skip operator_l
        // skip name_l
        // skip expression_l
    }
    fn visit_match_pattern(&mut self, node: &MatchPattern) {
        self.observer.on_match_pattern(node);

        self.visit(&node.value, Item::Value);
        self.visit(&node.pattern, Item::Pattern);
        // skip operator_l
        // skip expression_l
    }
    fn visit_match_pattern_p(&mut self, node: &MatchPatternP) {
        self.observer.on_match_pattern_p(node);

        self.visit(&node.value, Item::Value);
        self.visit(&node.pattern, Item::Pattern);
        // skip operator_l
        // skip expression_l
    }
    fn visit_match_rest(&mut self, node: &MatchRest) {
        self.observer.on_match_rest(node);

        self.visit(&node.name, Item::Name);
        // skip operator_l
        // skip expression_l
    }
    fn visit_match_var(&mut self, node: &MatchVar) {
        self.observer.on_match_var(node);

        // skip name
        // skip name_l
        // skip expression_l
    }
    fn visit_match_with_lvasgn(&mut self, node: &MatchWithLvasgn) {
        self.observer.on_match_with_lvasgn(node);

        self.visit(&node.re, Item::Re);
        self.visit(&node.value, Item::Value);
        // skip operator_l
        // skip expression_l
    }
    fn visit_mlhs(&mut self, node: &Mlhs) {
        self.observer.on_mlhs(node);

        self.visit(&node.items, Item::MlhsItems);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_module(&mut self, node: &Module) {
        self.observer.on_module(node);

        self.visit(&node.name, Item::Name);
        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip end_l
        // skip expression_l
    }
    fn visit_next(&mut self, node: &Next) {
        self.observer.on_next(node);

        self.visit(&node.args, Item::Args);
        // skip keyword_l
        // skip expression_l
    }
    fn visit_nil(&mut self, node: &Nil) {
        self.observer.on_nil(node);

        // skip expression_l
    }
    fn visit_nth_ref(&mut self, node: &NthRef) {
        self.observer.on_nth_ref(node);

        // skip name
        // skip expression_l
    }
    fn visit_numblock(&mut self, node: &Numblock) {
        self.observer.on_numblock(node);

        self.visit(&node.call, Item::MethodCall);
        // skip numargs
        self.visit(&node.body, Item::Body);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_op_asgn(&mut self, node: &OpAsgn) {
        self.observer.on_op_asgn(node);

        self.visit(&node.recv, Item::Recv);
        // skip operator
        self.visit(&node.value, Item::Value);
        // skip operator_l
        // skip expression_l
    }
    fn visit_optarg(&mut self, node: &Optarg) {
        self.observer.on_optarg(node);

        // skip name
        self.visit(&node.default, Item::DefaultValue);
        // skip name_l
        // skip operator_l
        // skip expression_l
    }
    fn visit_or(&mut self, node: &Or) {
        self.observer.on_or(node);

        self.visit(&node.lhs, Item::Lhs);
        self.visit(&node.rhs, Item::Rhs);
        // skip operator_l
        // skip expression_l
    }
    fn visit_or_asgn(&mut self, node: &OrAsgn) {
        self.observer.on_or_asgn(node);

        self.visit(&node.recv, Item::Recv);
        self.visit(&node.value, Item::Value);
        // skip operator_l
        // skip expression_l
    }
    fn visit_pair(&mut self, node: &Pair) {
        self.observer.on_pair(node);

        self.visit(&node.key, Item::Key);
        self.visit(&node.value, Item::Value);
        // skip operator_l
        // skip expression_l
    }
    fn visit_pin(&mut self, node: &Pin) {
        self.observer.on_pin(node);

        self.visit(&node.var, Item::Var);
        // skip selector_l
        // skip expression_l
    }
    fn visit_postexe(&mut self, node: &Postexe) {
        self.observer.on_postexe(node);

        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_preexe(&mut self, node: &Preexe) {
        self.observer.on_preexe(node);

        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_procarg0(&mut self, node: &Procarg0) {
        self.observer.on_procarg0(node);

        self.visit(&node.args, Item::Arglist);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_rational(&mut self, node: &Rational) {
        self.observer.on_rational(node);

        // skip value
        // skip operator_l
        // skip expression_l
    }
    fn visit_redo(&mut self, node: &Redo) {
        self.observer.on_redo(node);

        // skip expression_l
    }
    fn visit_regexp(&mut self, node: &Regexp) {
        self.observer.on_regexp(node);

        self.visit(&node.parts, Item::Parts);
        self.visit(&node.options, Item::Options);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_reg_opt(&mut self, node: &RegOpt) {
        self.observer.on_reg_opt(node);

        // skip options
        // skip expression_l
    }
    fn visit_rescue(&mut self, node: &Rescue) {
        self.observer.on_rescue(node);

        self.visit(&node.body, Item::Body);
        self.visit(&node.rescue_bodies, Item::RescueBodies);
        self.visit(&node.else_, Item::ElseBody);
        // skip else_l
        // skip expression_l
    }
    fn visit_rescue_body(&mut self, node: &RescueBody) {
        self.observer.on_rescue_body(node);

        self.visit(&node.exc_list, Item::ExcList);
        self.visit(&node.exc_var, Item::ExcVar);
        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip assoc_l
        // skip begin_l
        // skip expression_l
    }
    fn visit_restarg(&mut self, node: &Restarg) {
        self.observer.on_restarg(node);

        // skip name
        // skip operator_l
        // skip name_l
        // skip expression_l
    }
    fn visit_retry(&mut self, node: &Retry) {
        self.observer.on_retry(node);

        // skip expression_l
    }
    fn visit_return(&mut self, node: &Return) {
        self.observer.on_return(node);

        self.visit(&node.args, Item::Args);
        // skip keyword_l
        // skip expression_l
    }
    fn visit_s_class(&mut self, node: &SClass) {
        self.observer.on_s_class(node);

        self.visit(&node.expr, Item::Expr);
        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip operator_l
        // skip end_l
        // skip expression_l
    }
    fn visit_self_(&mut self, node: &Self_) {
        self.observer.on_self_(node);

        // skip expression_l
    }
    fn visit_send(&mut self, node: &Send) {
        self.observer.on_send(node);

        self.visit(&node.recv, Item::Recv);
        // skip method_name
        self.visit(&node.args, Item::Args);
        // skip dot_l
        // skip selector_l
        // skip begin_l
        // skip end_l
        // skip operator_l
        // skip expression_l
    }
    fn visit_shadowarg(&mut self, node: &Shadowarg) {
        self.observer.on_shadowarg(node);

        // skip name
        // skip expression_l
    }
    fn visit_splat(&mut self, node: &Splat) {
        self.observer.on_splat(node);

        self.visit(&node.value, Item::Value);
        // skip operator_l
        // skip expression_l
    }
    fn visit_str(&mut self, node: &Str) {
        self.observer.on_str(node);

        // skip value
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_super(&mut self, node: &Super) {
        self.observer.on_super(node);

        self.visit(&node.args, Item::Args);
        // skip keyword_l
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_sym(&mut self, node: &Sym) {
        self.observer.on_sym(node);

        // skip name
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_true(&mut self, node: &True) {
        self.observer.on_true(node);

        // skip expression_l
    }
    fn visit_undef(&mut self, node: &Undef) {
        self.observer.on_undef(node);

        self.visit(&node.names, Item::Args);
        // skip keyword_l
        // skip expression_l
    }
    fn visit_unless_guard(&mut self, node: &UnlessGuard) {
        self.observer.on_unless_guard(node);

        self.visit(&node.cond, Item::Cond);
        // skip keyword_l
        // skip expression_l
    }
    fn visit_until(&mut self, node: &Until) {
        self.observer.on_until(node);

        self.visit(&node.cond, Item::Cond);
        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_until_post(&mut self, node: &UntilPost) {
        self.observer.on_until_post(node);

        self.visit(&node.cond, Item::Cond);
        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip expression_l
    }
    fn visit_when(&mut self, node: &When) {
        self.observer.on_when(node);

        self.visit(&node.patterns, Item::Args);
        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip begin_l
        // skip expression_l
    }
    fn visit_while(&mut self, node: &While) {
        self.observer.on_while(node);

        self.visit(&node.cond, Item::Cond);
        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_while_post(&mut self, node: &WhilePost) {
        self.observer.on_while_post(node);

        self.visit(&node.cond, Item::Cond);
        self.visit(&node.body, Item::Body);
        // skip keyword_l
        // skip expression_l
    }
    fn visit_x_heredoc(&mut self, node: &XHeredoc) {
        self.observer.on_x_heredoc(node);

        self.visit(&node.parts, Item::Parts);
        // skip heredoc_body_l
        // skip heredoc_end_l
        // skip expression_l
    }
    fn visit_xstr(&mut self, node: &Xstr) {
        self.observer.on_xstr(node);

        self.visit(&node.parts, Item::Parts);
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_yield(&mut self, node: &Yield) {
        self.observer.on_yield(node);

        self.visit(&node.args, Item::Args);
        // skip keyword_l
        // skip begin_l
        // skip end_l
        // skip expression_l
    }
    fn visit_z_super(&mut self, node: &ZSuper) {
        self.observer.on_z_super(node);

        // skip expression_l
    }

}
